/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.security;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nodeapps.VIP;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.nodeapps.VirtualIPException;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.security.NullSecurityManager;
import oracle.ops.mgmt.trace.Trace;

public class SecurityHelper {
    private String m_myHostName = null;
    private String m_myHostAddress = null;
    private Vector m_myKnownHosts = null;
    private String[] m_oracleHomes = null;
    private String[] m_javaHomes = null;
    private String m_gsdOracleHome = null;
    private boolean m_bEnabledSecurityAccess = false;

    public SecurityHelper(String oracleHome) {
        this.m_gsdOracleHome = oracleHome;
        this.updateOracleHomes();
        this.updateHostDetails();
    }

    public boolean isValidFile(String file) {
        boolean bValid = false;
        Trace.out("Validating file:" + file);
        String fileSep = System.getProperty("file.separator");
        int slashIndex = file.lastIndexOf(fileSep);
        String name = file.substring(slashIndex + 1);
        Trace.out("name = " + name);
        if (this.isValidPath(file)) {
            bValid = true;
        } else if (name.equalsIgnoreCase("osdbagrp")) {
            bValid = true;
        } else {
            this.updateOracleHomes();
            bValid = this.isValidPath(file);
        }
        return bValid;
    }

    private boolean isValidPath(String file) {
        int index;
        int i;
        if (this.m_oracleHomes == null && this.m_javaHomes == null) {
            return false;
        }
        boolean bValid = false;
        for (i = 0; i < this.m_oracleHomes.length; ++i) {
            index = file.indexOf(this.m_oracleHomes[i]);
            Trace.out("index = " + index);
            if (index < 0) continue;
            Trace.out(file + " validated with " + this.m_oracleHomes[i]);
            bValid = true;
            break;
        }
        if (bValid) {
            return true;
        }
        for (i = 0; i < this.m_javaHomes.length; ++i) {
            index = file.indexOf(this.m_javaHomes[i]);
            Trace.out("index = " + index);
            if (index < 0) continue;
            Trace.out(file + " validated with " + this.m_javaHomes[i]);
            bValid = true;
            break;
        }
        return bValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOracleHomes() {
        String[] oracleHomes = null;
        SecurityManager securityManager = null;
        Trace.out("Updating security helper with list of OHs from OCR");
        securityManager = System.getSecurityManager();
        Trace.out("My SecurityManager = " + securityManager);
        try {
            this.setEnabledSecurityAccess(true);
            System.setSecurityManager(new NullSecurityManager());
            this.setEnabledSecurityAccess(false);
            oracleHomes = Cluster.listOracleHomes(Version.get92Version());
        }
        catch (OCRException e) {
            Trace.out(e.getMessage());
        }
        finally {
            if (securityManager != null) {
                Trace.out("Resetting security Manager");
                this.setEnabledSecurityAccess(true);
                System.setSecurityManager(securityManager);
                this.setEnabledSecurityAccess(false);
            }
        }
        Vector<String> ohs = null;
        Vector<String> jhs = null;
        String jrePath = null;
        if (oracleHomes != null) {
            ohs = new Vector(oracleHomes.length + 1);
            jhs = new Vector(oracleHomes.length + 1);
        } else {
            ohs = new Vector<String>(1);
            jhs = new Vector<String>(1);
        }
        if (this.m_gsdOracleHome != null) {
            ohs.addElement(this.m_gsdOracleHome);
            jrePath = this.getCanonicalJREPath(this.m_gsdOracleHome);
            if (jrePath != null) {
                jhs.addElement(jrePath);
            }
        }
        if (oracleHomes != null) {
            Trace.out("oracleHomes from OCR = " + oracleHomes.length);
            for (int i = 0; i < oracleHomes.length; ++i) {
                if (ohs.contains(oracleHomes[i])) continue;
                Trace.out("Adding oracleHomes[" + i + "] = " + oracleHomes[i]);
                ohs.addElement(oracleHomes[i]);
                jrePath = this.getCanonicalJREPath(oracleHomes[i]);
                if (jrePath == null || jhs.contains(jrePath)) continue;
                Trace.out("Adding JREPath = " + jrePath);
                jhs.addElement(jrePath);
            }
        }
        Trace.out("Oracle homes vector size = " + ohs.size());
        this.m_oracleHomes = new String[ohs.size()];
        ohs.copyInto(this.m_oracleHomes);
        Trace.out("m_oracleHomes.length = " + this.m_oracleHomes.length);
        Trace.out("Java homes vector size = " + jhs.size());
        this.m_javaHomes = new String[jhs.size()];
        jhs.copyInto(this.m_javaHomes);
        Trace.out("m_javaHomes.length = " + this.m_javaHomes.length);
    }

    private String getCanonicalJREPath(String oh) {
        String jrePath = null;
        String fileSep = System.getProperty("file.separator");
        String javaHome = System.getProperty("java.home");
        String jreHome = oh + fileSep + "JRE";
        try {
            File jreFile = new File(jreHome);
            jrePath = jreFile.exists() ? jreFile.getCanonicalFile().getAbsolutePath() : javaHome;
        }
        catch (IOException e) {
            jrePath = javaHome;
        }
        return jrePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHostDetails() {
        block23: {
            InetAddress localINet = null;
            try {
                localINet = InetAddress.getLocalHost();
                if (localINet != null) {
                    this.m_myHostName = localINet.getHostName();
                    this.m_myHostAddress = localINet.getHostAddress();
                }
            }
            catch (UnknownHostException e) {
                Trace.out(e.getMessage());
            }
            String[] nodeNames = null;
            SecurityManager securityManager = null;
            Trace.out("Retrieving the list of cluster node/host names");
            securityManager = System.getSecurityManager();
            Trace.out("My SecurityManager = " + securityManager);
            try {
                this.setEnabledSecurityAccess(true);
                System.setSecurityManager(new NullSecurityManager());
                this.setEnabledSecurityAccess(false);
                String oraCRSHome = null;
                try {
                    Util hasUtl = new Util();
                    oraCRSHome = hasUtl.getCRSHome();
                }
                catch (UtilException ue) {
                    Trace.out(ue.getMessage());
                }
                Trace.out("Oracle CRS home = " + oraCRSHome);
                nodeNames = Cluster.getNodes();
                if (nodeNames == null) break block23;
                if (this.m_myKnownHosts == null) {
                    this.m_myKnownHosts = new Vector(5 * nodeNames.length);
                }
                for (int i = 0; i < nodeNames.length; ++i) {
                    String myHostName;
                    if (!this.m_myKnownHosts.contains(nodeNames[i])) {
                        this.m_myKnownHosts.addElement(nodeNames[i]);
                    }
                    if ((myHostName = Cluster.getHostName(nodeNames[i])) != null && !this.m_myKnownHosts.contains(myHostName)) {
                        this.m_myKnownHosts.addElement(myHostName);
                    }
                    if (myHostName != null) {
                        try {
                            String myHostAddress = InetAddress.getByName(myHostName).getHostAddress();
                            if (myHostAddress != null && !this.m_myKnownHosts.contains(myHostAddress)) {
                                this.m_myKnownHosts.addElement(myHostAddress);
                            }
                        }
                        catch (UnknownHostException e) {
                            Trace.out(e.getMessage());
                        }
                    }
                    if (oraCRSHome == null) continue;
                    try {
                        VIP nodeVIP = new VIP(nodeNames[i], oraCRSHome);
                        VIPAddress vipAddr = nodeVIP.getVIPAddress();
                        String vipName = null;
                        String vipAddress = null;
                        if (vipAddr != null) {
                            vipName = vipAddr.getVIPName();
                            vipAddress = vipAddr.getAddressAsString();
                            Trace.out("VIP name = " + vipName);
                            Trace.out("VIP Address = " + vipAddress);
                        }
                        if (vipName != null) {
                            this.m_myKnownHosts.addElement(vipName);
                        }
                        if (vipAddress == null) continue;
                        this.m_myKnownHosts.addElement(vipAddress);
                        continue;
                    }
                    catch (VirtualIPException vipe) {
                        Trace.out(vipe.getMessage());
                    }
                }
            }
            catch (ClusterException e) {
                Trace.out(e.getMessage());
            }
            finally {
                if (securityManager != null) {
                    Trace.out("Resetting security Manager");
                    this.setEnabledSecurityAccess(true);
                    System.setSecurityManager(securityManager);
                    this.setEnabledSecurityAccess(false);
                }
            }
        }
    }

    public boolean isValidHost(String host, boolean bRefresh) {
        if (bRefresh) {
            this.updateHostDetails();
        }
        return this.isValidHost(host);
    }

    public boolean isValidHost(String host) {
        boolean bValid = false;
        String hostName = host;
        int colonIndex = host.lastIndexOf(":");
        if (colonIndex != -1) {
            hostName = host.substring(0, colonIndex);
        }
        Trace.out("hostName = " + hostName);
        if (hostName.indexOf("localhost") != -1) {
            Trace.out("Validated with localhost");
            bValid = true;
        } else if (this.m_myHostName.equalsIgnoreCase(hostName)) {
            Trace.out("Validated with my host name");
            bValid = true;
        } else if (this.m_myHostAddress.equals(hostName)) {
            Trace.out("Validated with my host address");
            bValid = true;
        } else if (this.m_myKnownHosts != null && this.m_myKnownHosts.contains(hostName)) {
            Trace.out("Validated with my known hosts");
            bValid = true;
        } else if (this.m_myKnownHosts != null) {
            for (int i = 0; i < this.m_myKnownHosts.size(); ++i) {
                String knownHost = (String)this.m_myKnownHosts.elementAt(i);
                Trace.out("knownHost(" + i + ")= " + knownHost);
                if (!knownHost.equalsIgnoreCase(hostName)) continue;
                Trace.out("Validated with host = " + knownHost);
                bValid = true;
                break;
            }
        }
        if (!bValid) {
            bValid = this.checkSubnet(host);
        }
        Trace.out("Validated = " + bValid);
        return bValid;
    }

    private boolean checkSubnet(String host) {
        try {
            String myNode = Cluster.getLocalNode();
            VIPAddress myVipAddr = new VIP(myNode).getVIPAddress();
            String mask = myVipAddr.getNetmask();
            return SecurityHelper.hasSameSubnets(myVipAddr.getAddressAsString(), mask, host);
        }
        catch (Exception e) {
            Trace.out("cannot check subnet because of " + e);
            Trace.out(e);
            return false;
        }
    }

    public static boolean hasSameSubnets(String host1, String mask, String host2) throws UnknownHostException {
        String addr1 = InetAddress.getByName(host1).getHostAddress();
        String addr2 = InetAddress.getByName(host2).getHostAddress();
        Trace.out("Host1 " + addr1 + ", host2 " + addr2 + ", mask " + mask);
        String subnet1 = SecurityHelper.getSubnet(addr1, mask);
        String subnet2 = SecurityHelper.getSubnet(addr2, mask);
        Trace.out("subnet1 " + subnet1 + ", subnet2 " + subnet2);
        return subnet1.equals(subnet2);
    }

    private static String getSubnet(String addr, String mask) {
        String[] ipParts = addr.split("\\.");
        String[] nmParts = mask.split("\\.");
        StringBuffer subnet = new StringBuffer();
        for (int i = 0; i < ipParts.length; ++i) {
            if (i < nmParts.length) {
                subnet.append(Integer.parseInt(ipParts[i]) & Integer.parseInt(nmParts[i]));
            } else {
                subnet.append(Integer.parseInt(ipParts[i]) & 0);
            }
            if (i >= ipParts.length - 1) continue;
            subnet.append(".");
        }
        return subnet.toString();
    }

    public boolean isValidKey(String key) {
        return key.equals("srvm.cluster") || key.equals("srvm.daemon.groupname");
    }

    public void setEnabledSecurityAccess(boolean bEnable) {
        this.m_bEnabledSecurityAccess = bEnable;
    }

    public boolean isEnabledSecurityAccess() {
        return this.m_bEnabledSecurityAccess;
    }
}

