/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.security;

import java.io.FilePermission;
import java.io.SerializablePermission;
import java.net.SocketPermission;
import java.rmi.RMISecurityManager;
import java.security.Permission;
import java.util.PropertyPermission;
import oracle.ops.mgmt.security.SecurityHelper;
import oracle.ops.mgmt.trace.Trace;

public class DaemonSecurityManager
extends RMISecurityManager {
    private SecurityHelper m_securityHelper;
    private boolean m_bLoadLibrary = false;

    public void setSecurityHelper(SecurityHelper securityHelper) {
        this.m_securityHelper = securityHelper;
    }

    @Override
    public void checkRead(String file) throws SecurityException {
    }

    @Override
    public void checkRead(String file, Object context) throws SecurityException {
    }

    @Override
    public void checkWrite(String file) throws SecurityException {
        if (!this.m_securityHelper.isValidFile(file)) {
            super.checkWrite(file);
        }
    }

    @Override
    public void checkExec(String cmd) throws SecurityException {
        if (!this.m_securityHelper.isValidFile(cmd)) {
            super.checkExec(cmd);
        }
    }

    @Override
    public void checkDelete(String file) throws SecurityException {
        if (!this.m_securityHelper.isValidFile(file)) {
            super.checkDelete(file);
        }
    }

    @Override
    public void checkLink(String lib) throws SecurityException {
        super.checkLink(lib);
    }

    @Override
    public void checkAccept(String host, int port) throws SecurityException {
        if (!this.m_securityHelper.isValidHost(host)) {
            super.checkAccept(host, port);
        }
    }

    @Override
    public void checkConnect(String host, int port) throws SecurityException {
        if (!this.m_securityHelper.isValidHost(host)) {
            super.checkConnect(host, port);
        }
    }

    @Override
    public void checkPropertyAccess(String key) throws SecurityException {
    }

    @Override
    public void checkPermission(Permission perm) throws SecurityException {
        if (!this.isOkToPermit(perm)) {
            Trace.out("I can't allow you to do this. Lets ask JVM if it allows");
            super.checkPermission(perm);
        }
    }

    @Override
    public void checkPermission(Permission perm, Object context) throws SecurityException {
        if (!this.isOkToPermit(perm)) {
            Trace.out("I can't allow you to do this. Lets ask JVM if it allows");
            super.checkPermission(perm, context);
        }
    }

    private boolean isOkToPermit(Permission perm) {
        String actionsString;
        String name = perm.getName();
        String actions = actionsString = perm.getActions();
        String target = null;
        int dotIndex = actionsString.indexOf(".", 0);
        if (dotIndex != -1) {
            actions = actionsString.substring(0, dotIndex);
            target = actionsString.substring(dotIndex);
        }
        if (!this.m_bLoadLibrary) {
            if (!(perm instanceof FilePermission)) {
                if (perm instanceof SocketPermission) {
                    if (!this.m_securityHelper.isValidHost(name, true)) {
                        return false;
                    }
                } else if (!(perm instanceof PropertyPermission) && !(perm instanceof SerializablePermission) && perm instanceof RuntimePermission) {
                    if (actions.equals("createSecurityManager")) {
                        if (this.m_securityHelper.isEnabledSecurityAccess()) {
                            this.m_securityHelper.setEnabledSecurityAccess(false);
                            return true;
                        }
                        Trace.out("Intruder is trying to create a Security Manager");
                        return false;
                    }
                    if (actions.equals("setSecurityManager")) {
                        if (this.m_securityHelper.isEnabledSecurityAccess()) {
                            this.m_securityHelper.setEnabledSecurityAccess(false);
                            return true;
                        }
                        Trace.out("Intruder is trying to set a Security Manager");
                        return false;
                    }
                    if (actions.equals("accessClassinPackage")) {
                        return target != null && target.indexOf("oracle.ops.mgmt") != -1;
                    }
                    if (actions.equals("loadLibrary")) {
                        this.m_bLoadLibrary = true;
                    }
                }
            }
        } else {
            this.m_bLoadLibrary = false;
            if (!this.m_securityHelper.isValidFile(perm.getName())) {
                return false;
            }
        }
        return true;
    }
}

