/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.rawdevice;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.GetActiveNodes;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.Instance;
import oracle.ops.mgmt.database.ParallelServerConfig;
import oracle.ops.mgmt.database.ServiceComposite;
import oracle.ops.mgmt.database.config.DatabaseConfigConverter;
import oracle.ops.mgmt.database.config.ServiceInstance;
import oracle.ops.mgmt.has.GroupMembership;
import oracle.ops.mgmt.has.GroupMembershipException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.nodeapps.VirtualIPException;
import oracle.ops.mgmt.nodeapps.config.NodeConfiguration;
import oracle.ops.mgmt.rawdevice.OCR;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.rawdevice.OCRKeyLiterals;
import oracle.ops.mgmt.rawdevice.OCRTree;
import oracle.ops.mgmt.rawdevice.RawDeviceConstants;
import oracle.ops.mgmt.rawdevice.RawDeviceException;
import oracle.ops.mgmt.rawdevice.sConstants;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.mgmt.viprange.Binary;
import oracle.ops.mgmt.viprange.DottedDecimalBinaryConverter;
import oracle.ops.mgmt.viprange.VIPRangeConfiguration;

public class RawDeviceUtil
implements sConstants,
OCRKeyLiterals,
RawDeviceConstants {
    static MessageBundle s_msgBundle = MessageBundle.getMessageBundle("Prkr");
    static MessageBundle n_msgBundle = MessageBundle.getMessageBundle("Prkn");
    private OCRTree m_ocrTree;
    private static boolean toPrintStackTrace = Trace.isLevelEnabled(5);
    private Version s_version = new Version();

    public RawDeviceUtil() throws RawDeviceException {
    }

    public RawDeviceUtil(int ocrInitLevel) throws RawDeviceException {
        this();
        try {
            Trace.out("Initializing OCRTree");
            this.m_ocrTree = OCRTree.init(this.s_version, ocrInitLevel);
        }
        catch (OCRException e) {
            Trace.out(e);
            throw new RawDeviceException(e.getMessage());
        }
    }

    public static void help() {
        System.out.println(s_msgBundle.getMessage("1029", false));
        System.out.println(s_msgBundle.getMessage("1030", false));
        System.out.println(s_msgBundle.getMessage("1031", false));
        System.out.println(s_msgBundle.getMessage("1032", false));
        System.out.println(s_msgBundle.getMessage("1033", false));
        System.out.println(s_msgBundle.getMessage("1034", false));
        System.out.println(s_msgBundle.getMessage("1035", false));
        System.out.println(n_msgBundle.getMessage("1029", false));
        System.out.println(n_msgBundle.getMessage("1030", false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(boolean bForce) throws RawDeviceException {
        block20: {
            GroupMembership grpmem = null;
            try {
                grpmem = new GroupMembership();
            }
            catch (GroupMembershipException e) {
                Trace.out("GroupMembershipException caught while instantiating GroupMembership object" + e.getMessage());
            }
            finally {
                if (grpmem == null) break block20;
                Trace.out("Checking existence of ocr_<clustername> CSS group");
                grpmem.checkOCRgroup();
                toPrintStackTrace = false;
                throw new RawDeviceException(s_msgBundle.getMessage("1076", true));
            }
        }
        if (System.getProperty("oracle.srvm.privilege.check", "true").equals("true")) {
            Util hasUtil = null;
            try {
                hasUtil = new Util();
                if (!hasUtil.hasHAPrivilege()) {
                    String msg = s_msgBundle.getMessage("1075", true);
                    throw new RawDeviceException(msg);
                }
            }
            catch (UtilException e) {
                Trace.out("UtilException caught");
                Trace.out((Exception)((Object)e));
                throw new RawDeviceException(e.getMessage());
            }
            finally {
                try {
                    hasUtil.destroy();
                }
                catch (UtilException e) {
                    Trace.out("UtilException caught");
                    Trace.out((Exception)((Object)e));
                    throw new RawDeviceException(e.getMessage());
                }
            }
        }
        try {
            if (!bForce) {
                Trace.out("Initializing OCR in INSTALL_LEVEL");
                OCR.init(0, this.s_version);
            } else {
                Trace.out("Initializing OCR in FORMAT_LEVEL");
                OCR.init(4, this.s_version);
            }
        }
        catch (OCRException e) {
            Trace.out("Could not initialize OCR");
            Trace.out("OCR error code = " + e.getErrorCode());
            Trace.out(e);
            throw new RawDeviceException(e.getMessage());
        }
        System.out.println(s_msgBundle.getMessage("1041", false));
        Trace.out("Successfully initialized OCR repository ");
    }

    private void exportDatabase(PrintWriter writer, ParallelServerConfig psConfig) {
        VIPAddress vip;
        String spfile;
        String dbName = psConfig.getName();
        Trace.out("dbName = " + dbName + " :");
        String dbPrefix = dbName + ".";
        Object[] arg = new Object[]{dbName};
        writer.println(s_msgBundle.getMessage("1049", false, arg));
        Trace.out(dbPrefix + "ORACLE_HOME" + " = " + psConfig.getOracleHome());
        writer.println(dbPrefix + "ORACLE_HOME" + " = " + psConfig.getOracleHome());
        String domain = psConfig.getDomain();
        if (domain != null) {
            Trace.out(dbPrefix + "DOMAIN" + " = " + domain);
            writer.println(dbPrefix + "DOMAIN" + " = " + domain);
        }
        if ((spfile = psConfig.getSPFile()) != null) {
            Trace.out(dbPrefix + "SPFILE" + " = " + spfile);
            writer.println(dbPrefix + "SPFILE" + " = " + spfile);
        }
        String enabled = "false";
        if (psConfig.isEnabled()) {
            enabled = "true";
        }
        Trace.out(dbPrefix + "ENABLED" + " = " + enabled);
        writer.println(dbPrefix + "ENABLED" + " = " + enabled);
        String[] envList = psConfig.getEnvironment();
        String environ = this.getStringFromList(envList);
        if (environ != null) {
            Trace.out(dbPrefix + "ENVIRONMENT" + " = " + environ);
            writer.println(dbPrefix + "ENVIRONMENT" + " = " + environ);
        }
        if ((vip = psConfig.getVIPAddress()) != null) {
            String vipName = vip.getVIPName();
            String netmask = vip.getNetmask();
            String[] interfaces = vip.getInterfaces();
            String interfaceStr = this.getStringFromList(interfaces);
            String dbCluAlias = vipName + ":" + netmask + ":" + interfaceStr;
            Trace.out(dbPrefix + "DB_CLU_ALIAS" + " = " + dbCluAlias);
            writer.println(dbPrefix + "DB_CLU_ALIAS" + " = " + dbCluAlias);
        }
    }

    private void exportInstances(PrintWriter writer, ParallelServerConfig psConfig) {
        String dbName = psConfig.getName();
        String dbPrefix = dbName + ".";
        String[] instanceNames = psConfig.enumerateInstances();
        String instanceStr = this.getStringFromList(instanceNames);
        if (instanceStr == null) {
            Trace.out("No instances to export for database " + dbName);
            return;
        }
        Trace.out(dbPrefix + "INSTANCE" + " = " + instanceStr);
        writer.println(dbPrefix + "INSTANCE" + " = " + instanceStr);
        Vector instances = psConfig.getInstances();
        String enabled = "false";
        for (int i = 0; i < instances.size(); ++i) {
            Instance inst = (Instance)instances.elementAt(i);
            String name = inst.getName();
            String node = inst.getNode();
            String[] envList = inst.getEnv();
            if (inst.isEnabled()) {
                enabled = "true";
            }
            String instPrefix = dbPrefix + name + ".";
            Trace.out(instPrefix + "NODE" + " = " + node);
            writer.println(instPrefix + "NODE" + " = " + node);
            Trace.out(instPrefix + "ENABLED" + " = " + enabled);
            writer.println(instPrefix + "ENABLED" + " = " + enabled);
            envList = psConfig.getEnvironment();
            String envStr = this.getStringFromList(envList);
            if (envStr == null) continue;
            Trace.out(instPrefix + "ENVIRONMENT" + " = " + envStr);
            writer.println(instPrefix + "ENVIRONMENT" + " = " + envStr);
        }
    }

    private void exportServices(PrintWriter writer, ParallelServerConfig psConfig) {
        String dbName = psConfig.getName();
        String dbPrefix = dbName + ".";
        String[] serviceNames = psConfig.enumerateServices();
        String serviceStr = this.getStringFromList(serviceNames);
        if (serviceStr == null) {
            Trace.out("No services to export for database " + dbName);
            return;
        }
        Trace.out(dbPrefix + "SERVICE" + " = " + serviceStr);
        writer.println(dbPrefix + "SERVICE" + " = " + serviceStr);
        Vector services = psConfig.getServices();
        Trace.out("Number of Services = " + services.size());
        for (int i = 0; i < services.size(); ++i) {
            ServiceComposite serv = (ServiceComposite)services.elementAt(i);
            String servName = serv.getName();
            Vector servInstances = serv.getServiceInstances();
            String servPrefix = dbPrefix + servName + ".";
            StringBuffer sb = new StringBuffer();
            Trace.out("Number of ServiceInstances = " + servInstances.size());
            for (int j = 0; j < servInstances.size(); ++j) {
                ServiceInstance servInst = (ServiceInstance)servInstances.elementAt(j);
                String servInstName = servInst.getInstanceName();
                String servInstType = servInst.getType();
                String servInstEnabled = "false";
                if (servInst.getEnabled()) {
                    servInstEnabled = "true";
                }
                String instStr = String.valueOf('(') + servInstName + ":" + servInstType + ":" + servInstEnabled + String.valueOf(')');
                Trace.out(servPrefix + " ServiceInstance = " + instStr);
                sb.append(instStr);
                if (j >= servInstances.size() - 1) continue;
                sb.append(",");
            }
            String servInstStr = sb.toString();
            Trace.out(servPrefix + "INSTANCES" + " = " + servInstStr);
            writer.println(servPrefix + "INSTANCES" + " = " + servInstStr);
            String servEnabled = "false";
            if (serv.isEnabled()) {
                servEnabled = "true";
            }
            Trace.out(servPrefix + "ENABLED" + " = " + servEnabled);
            writer.println(servPrefix + "ENABLED" + " = " + servEnabled);
            String tafpolicy = serv.getTAFPolicy();
            Trace.out(servPrefix + "TAFPOLICY" + " = " + tafpolicy);
            writer.println(servPrefix + "TAFPOLICY" + " = " + tafpolicy);
            String[] envList = serv.getEnv();
            String envStr = this.getStringFromList(envList);
            if (envStr == null) continue;
            Trace.out(servPrefix + "ENVIRONMENT" + " = " + envStr);
            writer.println(servPrefix + "ENVIRONMENT" + " = " + envStr);
        }
    }

    private void exportNodeApps(PrintWriter writer, NodeConfiguration nodeConfig) {
        String node = nodeConfig.getName();
        String oracleHome = nodeConfig.getOracleHome();
        VIPAddress vip = nodeConfig.getVIPAddress();
        String ip = vip.getIPAddress().getHostAddress();
        String netmask = vip.getNetmask();
        String[] interfaces = vip.getInterfaces();
        String interfaceStr = this.getStringFromList(interfaces);
        String vipStr = ip + ":" + netmask + ":" + interfaceStr;
        Trace.out(node + "." + "VIP" + " = " + vipStr);
        writer.println(node + "." + "VIP" + " = " + vipStr);
        String[] envList = nodeConfig.getEnv();
        String envStr = this.getStringFromList(envList);
        if (envStr != null) {
            Trace.out(node + "." + "ENVIRONMENT" + " = " + envStr);
            writer.println(node + "." + "ENVIRONMENT" + " = " + envStr);
        }
        Trace.out(node + "." + "ORACLE_HOME" + " = " + oracleHome);
        writer.println(node + "." + "ORACLE_HOME" + " = " + oracleHome);
    }

    private void exportVIPRange(PrintWriter writer, VIPRangeConfiguration vipRangeConfig) {
        DottedDecimalBinaryConverter decimalObj = new DottedDecimalBinaryConverter(vipRangeConfig.getNetmask());
        String netmask = decimalObj.getDottedDecimal();
        Binary[] ipAddrBin = vipRangeConfig.getIPAddresses();
        String[] ipAddrStr = new String[ipAddrBin.length];
        for (int i = 0; i < ipAddrBin.length; ++i) {
            decimalObj = new DottedDecimalBinaryConverter(ipAddrBin[i]);
            ipAddrStr[i] = decimalObj.getDottedDecimal();
        }
        String ipStr = this.getStringFromList(ipAddrStr);
        Trace.out(netmask + "." + "IP" + " = " + ipStr);
        writer.println(netmask + "." + "IP" + " = " + ipStr);
    }

    public void export(String fileName) throws RawDeviceException {
        File configFile = new File(fileName);
        if (configFile.exists()) {
            if (!configFile.canWrite()) {
                Object[] args = new Object[]{fileName, "write"};
                String msg = s_msgBundle.getMessage("1024", true, args);
                throw new RawDeviceException(msg);
            }
        } else {
            String parent = configFile.getParent();
            if (parent != null && !new File(parent).canWrite()) {
                Object[] args = new Object[]{fileName, parent};
                String msg = s_msgBundle.getMessage("1050", true, args);
                throw new RawDeviceException(msg);
            }
        }
        try {
            FileOutputStream outputStream = new FileOutputStream(configFile);
            PrintWriter writer = new PrintWriter(outputStream);
            writer.println(s_msgBundle.getMessage("1048", false));
            writer.println();
            String[] opsList = this.m_ocrTree.listDatabases();
            String databaseStr = this.getStringFromList(opsList);
            if (databaseStr != null) {
                Trace.out("DATABASES = " + databaseStr);
                writer.println("DATABASES = " + databaseStr);
                Trace.out("OPS count = " + opsList.length);
                for (int i = 0; i < opsList.length; ++i) {
                    ParallelServerConfig psConfig = this.m_ocrTree.getDatabaseConfiguration(opsList[i]);
                    this.exportDatabase(writer, psConfig);
                    this.exportInstances(writer, psConfig);
                    this.exportServices(writer, psConfig);
                }
            } else {
                Trace.out("No database configuration to export");
            }
            String[] nodes = this.m_ocrTree.listNodes();
            if (nodes != null) {
                String nodeAppsStr = this.getStringFromList(nodes);
                writer.println(s_msgBundle.getMessage("1073", false));
                Trace.out("NODEAPPS = " + nodeAppsStr);
                writer.println("NODEAPPS = " + nodeAppsStr);
                for (int i = 0; i < nodes.length; ++i) {
                    NodeConfiguration nodeConfig = this.m_ocrTree.getNodeConfiguration(nodes[i]);
                    this.exportNodeApps(writer, nodeConfig);
                }
            } else {
                Trace.out("No nodeapps configuration to export");
            }
            VIPRangeConfiguration[] vipRanges = this.m_ocrTree.getVIPRangeConfigurations();
            if (vipRanges != null) {
                String[] netmasks = new String[vipRanges.length];
                for (int i = 0; i < vipRanges.length; ++i) {
                    Binary netmaskBin = vipRanges[i].getNetmask();
                    DottedDecimalBinaryConverter decimalObj = new DottedDecimalBinaryConverter(netmaskBin);
                    netmasks[i] = decimalObj.getDottedDecimal();
                }
                String netmaskStr = this.getStringFromList(netmasks);
                writer.println(s_msgBundle.getMessage("1074", false));
                Trace.out("VIP_RANGE = " + netmaskStr);
                writer.println("VIP_RANGE = " + netmaskStr);
                for (int i = 0; i < vipRanges.length; ++i) {
                    this.exportVIPRange(writer, vipRanges[i]);
                }
            } else {
                Trace.out("No vip_range configuration to export");
            }
            writer.flush();
            writer.close();
            Object[] arg = new Object[]{fileName};
            System.out.println(s_msgBundle.getMessage("1043", false, arg));
        }
        catch (Exception e) {
            Trace.out(e);
            throw new RawDeviceException(e.getMessage());
        }
    }

    public void imp(String fileName) throws RawDeviceException {
        File configFile = new File(fileName);
        if (!configFile.exists()) {
            Object[] args = new Object[]{fileName};
            String msg = s_msgBundle.getMessage("1023", true, args);
            throw new RawDeviceException(msg);
        }
        if (!configFile.canRead()) {
            Object[] args = new Object[]{fileName, "read"};
            String msg = s_msgBundle.getMessage("1024", true, args);
            throw new RawDeviceException(msg);
        }
        Properties properties = new Properties();
        try {
            FileInputStream fis = new FileInputStream(configFile);
            properties.load(fis);
        }
        catch (Exception e) {
            Trace.out(e);
            throw new RawDeviceException(e.getMessage());
        }
        Trace.out("Loaded properties from the config file");
        String databases = properties.getProperty("DATABASES");
        String[] opsList = this.getListFromStr(databases, ",");
        ParallelServerConfig psConfig = null;
        try {
            for (int i = 0; i < opsList.length; ++i) {
                psConfig = new ParallelServerConfig(opsList[i], null, null, null);
                Trace.out("importing database " + opsList[i]);
                this.importDatabase(fileName, properties, psConfig);
                this.m_ocrTree.setDatabaseConfiguration(psConfig);
                Trace.out("returned from setDatabaseConfiguration");
            }
            String nodeapps = properties.getProperty("NODEAPPS");
            String[] nodes = this.getListFromStr(nodeapps, ",");
            NodeConfiguration nodeConfig = null;
            for (int i = 0; i < nodes.length; ++i) {
                Trace.out("importing nodeapps " + nodes[i]);
                nodeConfig = this.importNodeapps(fileName, properties, nodes[i]);
                this.m_ocrTree.setNodeConfiguration(nodeConfig);
            }
            String vipRange = properties.getProperty("VIP_RANGE");
            String[] netmasks = this.getListFromStr(vipRange, ",");
            VIPRangeConfiguration[] vipRangeConfigs = new VIPRangeConfiguration[netmasks.length];
            for (int i = 0; i < netmasks.length; ++i) {
                Trace.out("importing vip range for netmask " + netmasks[i]);
                vipRangeConfigs[i] = this.importVipRange(fileName, properties, netmasks[i]);
            }
            this.m_ocrTree.setVIPRangeConfigurations(vipRangeConfigs);
        }
        catch (OCRException e) {
            Trace.out(e);
            throw new RawDeviceException(e.getMessage());
        }
        Object[] args = new Object[]{fileName, databases};
        System.out.println(s_msgBundle.getMessage("1042", false, args));
    }

    private void importDatabase(String filename, Properties properties, ParallelServerConfig psConfig) throws RawDeviceException {
        String dbPrefix = psConfig.getName() + ".";
        String oracleHome = properties.getProperty(dbPrefix + "ORACLE_HOME");
        Trace.out(dbPrefix + "ORACLE_HOME" + " = " + oracleHome);
        if (oracleHome == null) {
            Object[] args = new Object[]{filename, dbPrefix + "ORACLE_HOME"};
            String msg = s_msgBundle.getMessage("1025", true, args);
            throw new RawDeviceException(msg);
        }
        psConfig.setOracleHome(oracleHome);
        String spfile = properties.getProperty(dbPrefix + "SPFILE");
        Trace.out(dbPrefix + "SPFILE" + " = " + spfile);
        if (spfile != null) {
            psConfig.setSPFile(spfile);
        }
        String domain = properties.getProperty(dbPrefix + "DOMAIN");
        Trace.out(dbPrefix + "DOMAIN" + " = " + domain);
        if (domain != null) {
            psConfig.setDomain(domain);
        }
        String enabled = properties.getProperty(dbPrefix + "ENABLED");
        Trace.out(dbPrefix + "ENABLED" + " = " + enabled);
        if (enabled != null) {
            psConfig.setEnabled(enabled.equals("true"));
        }
        String[] envList = null;
        String environ = properties.getProperty(dbPrefix + "ENVIRONMENT");
        if (environ != null && (environ = environ.trim()).length() > 0) {
            Trace.out(dbPrefix + "ENVIRONMENT" + " = " + environ);
            envList = this.getListFromStr(environ, ",");
            psConfig.setEnv(envList);
        }
        String dbCluAlias = properties.getProperty(dbPrefix + "DB_CLU_ALIAS");
        Trace.out(dbPrefix + "DB_CLU_ALIAS" + " = " + dbCluAlias);
        if (dbCluAlias != null) {
            StringTokenizer st = new StringTokenizer(dbCluAlias, ":");
            String ipName = st.nextToken();
            String netmask = st.nextToken();
            String interfaceList = st.nextToken();
            String[] interfaces = this.getListFromStr(interfaceList, ",");
            VIPAddress vip = null;
            try {
                vip = new VIPAddress(ipName, netmask, interfaces);
            }
            catch (VirtualIPException e) {
                Trace.out(e);
                throw new RawDeviceException(e.getMessage());
            }
            psConfig.setVIPAddress(vip);
        }
        String instances = properties.getProperty(dbPrefix + "INSTANCE");
        Trace.out(dbPrefix + "INSTANCE" + " = " + instances);
        String[] instanceList = this.getListFromStr(instances, ",");
        Vector<Instance> instVect = new Vector<Instance>();
        for (int i = 0; i < instanceList.length; ++i) {
            Instance inst = this.importInstance(filename, properties, psConfig, instanceList[i]);
            instVect.addElement(inst);
        }
        if (instanceList != null) {
            Trace.out("Setting instances in psConfig");
            psConfig.setInstances(instVect);
        } else {
            Trace.out("Instance list is null");
        }
        String services = properties.getProperty(dbPrefix + "SERVICE");
        Trace.out(dbPrefix + "SERVICE" + " = " + services);
        String[] serviceList = this.getListFromStr(services, ",");
        Vector<ServiceComposite> servVect = new Vector<ServiceComposite>();
        for (int i = 0; i < serviceList.length; ++i) {
            ServiceComposite serv = this.importService(filename, properties, psConfig, serviceList[i]);
            servVect.addElement(serv);
        }
        if (serviceList != null) {
            Trace.out("Setting services in psConfig");
            psConfig.setServices(servVect);
        } else {
            Trace.out("Service list is null");
        }
    }

    private Instance importInstance(String filename, Properties properties, ParallelServerConfig psConfig, String instName) {
        String instPrefix = psConfig.getName() + "." + instName + ".";
        String node = properties.getProperty(instPrefix + "NODE");
        Trace.out(instPrefix + "NODE" + " = " + node);
        String enabled = properties.getProperty(instPrefix + "ENABLED");
        Trace.out(instPrefix + "ENABLED" + " = " + enabled);
        String[] envList = null;
        String environ = properties.getProperty(instPrefix + "ENVIRONMENT");
        if (environ != null && (environ = environ.trim()).length() > 0) {
            Trace.out(instPrefix + "ENVIRONMENT" + " = " + environ);
            envList = this.getListFromStr(environ, ",");
        }
        Instance instance = new Instance(instName, node, envList, enabled.equals("true"));
        return instance;
    }

    private ServiceComposite importService(String filename, Properties properties, ParallelServerConfig psConfig, String servName) {
        String servPrefix = psConfig.getName() + "." + servName + ".";
        String servEnabled = properties.getProperty(servPrefix + "ENABLED");
        Trace.out(servPrefix + "ENABLED" + " = " + servEnabled);
        String tafpolicy = properties.getProperty(servPrefix + "TAFPOLICY");
        Trace.out(servPrefix + "TAFPOLICY" + " = " + tafpolicy);
        String[] envList = null;
        String environ = properties.getProperty(servPrefix + "ENVIRONMENT");
        if (environ != null && (environ = environ.trim()).length() > 0) {
            Trace.out(servPrefix + "ENVIRONMENT" + " = " + environ);
            envList = this.getListFromStr(environ, ",");
        }
        String instances = properties.getProperty(servPrefix + "INSTANCES");
        Trace.out(servPrefix + "INSTANCES" + " = " + instances);
        String[] instList = this.getListFromStr(instances, ",");
        boolean enabled = false;
        Vector<ServiceInstance> servInstances = new Vector<ServiceInstance>();
        for (int i = 0; i < instList.length; ++i) {
            Trace.out("instList[" + i + "] = " + instList[i]);
            StringTokenizer st = new StringTokenizer(instList[i], ":");
            String instName = st.nextToken();
            String type = st.nextToken();
            String enabledStr = st.nextToken();
            if (enabledStr.equals("true")) {
                enabled = true;
            }
            Trace.out("ServiceInstance instName = " + instName);
            Trace.out("ServiceInstance type = " + type);
            Trace.out("ServiceInstance enabled = " + enabled);
            ServiceInstance si = new ServiceInstance(servName, instName, type, enabled);
            servInstances.addElement(si);
        }
        Object[] servInstArr = new ServiceInstance[servInstances.size()];
        servInstances.copyInto(servInstArr);
        ServiceComposite sc = new ServiceComposite(servName, (ServiceInstance[])servInstArr, tafpolicy, envList, servEnabled.equals("true"), psConfig.getName());
        return sc;
    }

    private NodeConfiguration importNodeapps(String filename, Properties properties, String nodeName) throws RawDeviceException {
        VIPAddress vipAddress;
        String nodePrefix = nodeName + ".";
        String oracleHome = properties.getProperty(nodePrefix + "ORACLE_HOME");
        Trace.out(nodePrefix + "ORACLE_HOME" + " = " + oracleHome);
        if (oracleHome == null) {
            Object[] args = new Object[]{filename, nodePrefix + "ORACLE_HOME"};
            String msg = s_msgBundle.getMessage("1025", true, args);
            throw new RawDeviceException(msg);
        }
        String vip = properties.getProperty(nodePrefix + "VIP");
        Trace.out(nodePrefix + "VIP" + " = " + vip);
        StringTokenizer st = new StringTokenizer(vip, ":");
        String ip = st.nextToken();
        String netmask = st.nextToken();
        String interfaceStr = st.nextToken();
        String[] interfaces = this.getListFromStr(interfaceStr, ",");
        try {
            vipAddress = new VIPAddress(ip, netmask, interfaces);
        }
        catch (VirtualIPException e) {
            Trace.out(e);
            throw new RawDeviceException(e.getMessage());
        }
        String[] envList = null;
        String environ = properties.getProperty(nodePrefix + "ENVIRONMENT");
        if (environ != null && (environ = environ.trim()).length() > 0) {
            Trace.out(nodePrefix + "ENVIRONMENT" + " = " + environ);
            envList = this.getListFromStr(environ, ",");
        }
        NodeConfiguration nodeConfig = new NodeConfiguration(nodeName, oracleHome, vipAddress, envList);
        return nodeConfig;
    }

    private VIPRangeConfiguration importVipRange(String filename, Properties properties, String netmask) throws RawDeviceException {
        VIPRangeConfiguration vipRangeConfig;
        String netmaskPrefix = netmask + ".";
        String ips = properties.getProperty(netmaskPrefix + "IP");
        Trace.out(netmaskPrefix + "IP" + " = " + ips);
        String[] ipList = this.getListFromStr(ips, ",");
        Binary[] ipListBin = new Binary[ipList.length];
        for (int i = 0; i < ipList.length; ++i) {
            Trace.out("ipList[" + i + "] = " + ipList[i]);
            ipListBin[i] = new DottedDecimalBinaryConverter(ipList[i]).getBinary();
        }
        Trace.out("netmask = " + netmask);
        Binary netmaskBin = new DottedDecimalBinaryConverter(netmask).getBinary();
        try {
            vipRangeConfig = new VIPRangeConfiguration(netmaskBin, ipListBin);
        }
        catch (VirtualIPException e) {
            Trace.out(e);
            throw new RawDeviceException(e.getMessage());
        }
        return vipRangeConfig;
    }

    private String[] getListFromStr(String str, String delim) {
        String[] list = new String[]{};
        if (str == null) {
            Trace.out("Returning empty list");
            return list;
        }
        StringTokenizer st = new StringTokenizer(str, delim);
        list = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            String item = st.nextToken();
            if (item.indexOf(40) >= 0) {
                item = item.replace('(', ' ');
            }
            if (item.indexOf(41) >= 0) {
                item = item.replace(')', ' ');
            }
            list[i] = item.trim();
            ++i;
        }
        return list;
    }

    private String getStringFromList(String[] list) {
        StringBuffer sb = new StringBuffer();
        if (list != null && list.length > 0) {
            for (int i = 0; i < list.length; ++i) {
                sb.append(list[i]);
                if (i >= list.length - 1) continue;
                sb.append(",");
            }
        } else {
            return null;
        }
        String retString = String.valueOf('(') + sb.toString() + String.valueOf(')');
        Trace.out("retString = " + retString);
        return retString;
    }

    private String[] getActiveDaemonNodes() {
        try {
            GetActiveNodes getActiveNodes = GetActiveNodes.create();
            String[] nodeList = getActiveNodes.getNodeList();
            Vector<String> nodeVector = new Vector<String>();
            for (int i = 0; i < nodeList.length; ++i) {
                Trace.out("active node = " + nodeList[i]);
                if (!getActiveNodes.isDaemonRunning(nodeList[i])) continue;
                nodeVector.addElement(nodeList[i]);
            }
            String[] nodes = new String[nodeVector.size()];
            Enumeration e = nodeVector.elements();
            int index = 0;
            while (e.hasMoreElements()) {
                nodes[index++] = (String)e.nextElement();
                Trace.out("nodes = " + nodes[index - 1]);
            }
            return nodes;
        }
        catch (ClusterException e) {
            Trace.out("Ignoring Cluster Exception: " + e);
            return new String[0];
        }
    }

    private static void setupTracing() {
        boolean tracingOn = Boolean.getBoolean("TRACING.ENABLED");
        int tracingLvl = Integer.parseInt(System.getProperty("TRACING.LEVEL", String.valueOf(16)), 10);
        String traceFileName = System.getProperty("srvm.srvconfig.tracefile");
        Trace.traceEnabled(tracingOn);
        Trace.setTraceLevel(tracingLvl);
        if (tracingOn && traceFileName != null) {
            boolean succ = Trace.enableLogging(traceFileName);
            Trace.out("Trace.enableLogging returns " + succ);
        }
        Trace.out("tracing is " + tracingOn + " at level " + tracingLvl + " to file " + traceFileName);
    }

    public static void main(String[] args) {
        block33: {
            RawDeviceUtil.setupTracing();
            try {
                if (args.length == 0 || args.length > 7) {
                    if (args.length > 7) {
                        StringBuffer sb = new StringBuffer();
                        int extra = args[0].equalsIgnoreCase("-help") || args[0].compareTo("-?") == 0 ? 1 : 2;
                        for (int i = extra; i < args.length; ++i) {
                            sb.append(args[i]);
                            if (i >= args.length - 1) continue;
                            sb.append(" ");
                        }
                        Object[] argList = new Object[]{sb.toString(), args[0]};
                        System.out.println(s_msgBundle.getMessage("1055", false, argList));
                    }
                    RawDeviceUtil.help();
                } else if (args[0].equalsIgnoreCase("-init")) {
                    if (args.length == 1) {
                        RawDeviceUtil util = new RawDeviceUtil();
                        util.init(false);
                    } else if (args.length == 2 && args[1].equalsIgnoreCase("-f")) {
                        RawDeviceUtil util = new RawDeviceUtil();
                        util.init(true);
                    } else {
                        Object[] argList = new Object[]{args[1]};
                        System.out.println(s_msgBundle.getMessage("1038", false, argList));
                        RawDeviceUtil.help();
                    }
                } else if (args[0].equalsIgnoreCase("-exp")) {
                    if (args.length < 2) {
                        Object[] argList = new Object[]{"-exp"};
                        System.out.println(s_msgBundle.getMessage("1040", false, argList));
                        Trace.out("Missing file name argument for -exp option");
                        RawDeviceUtil.help();
                    } else if (args.length == 2) {
                        Trace.out("fileName=" + args[1]);
                        Trace.out("Initialising OCR in REBOOT LEVEL");
                        RawDeviceUtil util = new RawDeviceUtil(2);
                        util.export(args[1]);
                    } else {
                        Object[] argList = new Object[]{"-exp"};
                        System.out.println(s_msgBundle.getMessage("1039", false, argList));
                        RawDeviceUtil.help();
                    }
                } else if (args[0].equalsIgnoreCase("-imp")) {
                    if (args.length != 2) {
                        Object[] argList = new Object[]{"-imp"};
                        System.out.println(s_msgBundle.getMessage("1040", false, argList));
                        RawDeviceUtil.help();
                    } else if (args.length == 2) {
                        Trace.out("fileName=" + args[1]);
                        Trace.out("Initialising OCR in DEFAULT MT LEVEL");
                        RawDeviceUtil util = new RawDeviceUtil(7);
                        util.imp(args[1]);
                    } else {
                        Object[] argList = new Object[]{"-imp"};
                        System.out.println(s_msgBundle.getMessage("1039", false, argList));
                        RawDeviceUtil.help();
                    }
                } else if (args[0].equalsIgnoreCase("-help") || args[0].compareTo("-?") == 0) {
                    if (args.length > 1) {
                        StringBuffer sb = new StringBuffer();
                        for (int i = 1; i < args.length; ++i) {
                            sb.append(args[i]);
                            if (i >= args.length - 1) continue;
                            sb.append(" ");
                        }
                        Object[] argList = new Object[]{sb.toString(), args[0]};
                        System.out.println(s_msgBundle.getMessage("1055", false, argList));
                    }
                    RawDeviceUtil.help();
                } else if (args[0].equalsIgnoreCase("-upgrade") || args[0].equalsIgnoreCase("-downgrade")) {
                    for (int i = 1; i < args.length; ++i) {
                        if (!args[i].equalsIgnoreCase("-upgrade") && !args[i].equalsIgnoreCase("-downgrade")) continue;
                        Object[] argList = new Object[]{args[i], args[0]};
                        String errorMsg = s_msgBundle.getMessage("1055", false, argList);
                        Trace.out("\"-upgrade\" cannot be used at the same time as \"-downgrade\".");
                        System.err.println(errorMsg);
                        RawDeviceUtil.help();
                        return;
                    }
                    DatabaseConfigConverter dbConfigConverter = new DatabaseConfigConverter();
                    try {
                        dbConfigConverter.databaseConfigMain(args);
                    }
                    catch (RawDeviceException e) {
                        Trace.out(e);
                        System.err.println(e.getMessage());
                        RawDeviceUtil.help();
                    }
                } else {
                    Object[] argList = new Object[]{args[0]};
                    System.out.println(s_msgBundle.getMessage("1039", false, argList));
                    RawDeviceUtil.help();
                }
            }
            catch (RawDeviceException e) {
                System.out.println(e.getMessage());
                if (!toPrintStackTrace) break block33;
                e.printStackTrace();
            }
        }
    }
}

