/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.rawdevice;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Vector;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.Instance;
import oracle.ops.mgmt.database.ParallelServerConfig;
import oracle.ops.mgmt.database.ServiceComposite;
import oracle.ops.mgmt.database.config.ServiceInstance;
import oracle.ops.mgmt.has.ClusterLockException;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.nodeapps.VirtualIPException;
import oracle.ops.mgmt.nodeapps.config.NodeConfiguration;
import oracle.ops.mgmt.operation.ha.HALiterals;
import oracle.ops.mgmt.rawdevice.NetworkInterface;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.rawdevice.OCRKeyLiterals;
import oracle.ops.mgmt.rawdevice.OCRTree;
import oracle.ops.mgmt.rawdevice.OCRTreeDefinition;
import oracle.ops.mgmt.rawdevice.OCRTreeDefinitionHA;
import oracle.ops.mgmt.rawdevice.RawDeviceConstants;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.mgmt.viprange.Binary;
import oracle.ops.mgmt.viprange.VIPRangeConfiguration;

public class OCRTreeHA
extends OCRTree
implements Constants,
OCRKeyLiterals,
HALiterals,
RawDeviceConstants {
    private OCRTreeDefinitionHA m_ocrTreeDef = new OCRTreeDefinitionHA();

    protected OCRTreeHA(Version v) throws OCRException {
        this(v, 7);
    }

    protected OCRTreeHA(Version v, int ocrInitLevel) throws OCRException {
        super(v, ocrInitLevel);
    }

    @Override
    public OCRTreeDefinition getTreeDefinition() {
        return this.m_ocrTreeDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ParallelServerConfig getDatabaseConfiguration(String spName) throws OCRException {
        String startOpt;
        String role;
        String dbName;
        String spfile;
        String domain;
        String[] envs;
        Vector services;
        Vector instances;
        String ohome;
        String cpDBName;
        String dbKey = this.m_ocrTreeDef.getDBKey(spName);
        Trace.out("Acquiring shared CSS lock SRVM." + dbKey);
        try {
            this.m_clusterLock.acquireShared("SRVM." + dbKey);
        }
        catch (ClusterLockException e) {
            throw new OCRException(e.getMessage());
        }
        String versionString = null;
        VIPAddress clua = null;
        boolean enabled = true;
        String policy = "AUTOMATIC";
        String oldPolicy = "AUTOMATIC";
        try {
            if (!this.m_ocr.keyExists(dbKey)) {
                Trace.out(dbKey + " does not exist");
                Object[] args = new String[]{spName};
                throw new OCRException(s_rawMsgBundle.getMessage("1001", true, args));
            }
            Trace.out("found the db key " + dbKey);
            cpDBName = this.m_ocr.getKeyValue(dbKey);
            Trace.out("case preserving db name is " + cpDBName);
            ohome = this.m_ocr.getKeyValue(this.m_ocrTreeDef.getDBOHomeKey(spName));
            versionString = this.m_ocr.keyExists(this.m_ocrTreeDef.getDBVersionKey(spName)) ? this.m_ocr.getKeyValue(this.m_ocrTreeDef.getDBVersionKey(spName)) : null;
            if (versionString == null || versionString.compareTo(this.m_version.toString()) != 0) {
                Trace.out(dbKey + " incompatible version");
                Object[] args = new String[]{spName, versionString, ohome};
                throw new OCRException(s_rawMsgBundle.getMessage("1078", true, args));
            }
            instances = this.getDatabaseInstances(spName);
            services = this.getDatabaseServices(spName);
            envs = this.m_ocr.getKeyValues(this.m_ocrTreeDef.getDBEnvKey(spName));
            domain = this.m_ocr.getKeyValue(this.m_ocrTreeDef.getDBDomainKey(spName));
            spfile = this.m_ocr.getKeyValue(this.m_ocrTreeDef.getDBSPFileKey(spName));
            dbName = this.m_ocr.getKeyValue(this.m_ocrTreeDef.getDBNameKey(spName));
            role = this.m_ocr.getKeyValue(this.m_ocrTreeDef.getDBRoleKey(spName));
            startOpt = this.m_ocr.getKeyValue(this.m_ocrTreeDef.getDBStartOptKey(spName));
            String ip_or_name = this.m_ocr.getKeyValue(this.m_ocrTreeDef.getDBCluaIPKey(spName));
            if (ip_or_name != null) {
                InetAddress addr;
                try {
                    addr = InetAddress.getByName(ip_or_name);
                }
                catch (UnknownHostException e) {
                    throw new OCRException(e.getMessage());
                }
                String name = addr.getHostName();
                String ip = addr.getHostAddress();
                String netmask = this.m_ocr.getKeyValue(this.m_ocrTreeDef.getDBCluaNetMaskKey(spName));
                String[] interfaces = this.m_ocr.getKeyValues(this.m_ocrTreeDef.getDBCluaInterfacesKey(spName));
                try {
                    clua = new VIPAddress(name, ip, netmask, interfaces);
                }
                catch (VirtualIPException e) {
                    throw new OCRException(e.getMessage());
                }
            }
            enabled = new Boolean(this.m_ocr.getKeyValue(this.m_ocrTreeDef.getDBEnabledKey(spName)));
            try {
                policy = this.m_ocr.getKeyValue(this.m_ocrTreeDef.getDBPolicyKey(spName));
                oldPolicy = this.m_ocr.getKeyValue(this.m_ocrTreeDef.getDBPriorPolicyKey(spName));
            }
            catch (OCRException ex) {
                Trace.out("got exception " + ex + " while attempting to get OCR policy. Ignoring\n  using AUTOMATIC as policy");
                policy = "AUTOMATIC";
                oldPolicy = "AUTOMATIC";
            }
            if (policy == null) {
                Trace.out("policy not available in OCR tree using Automatic");
                policy = "AUTOMATIC";
            }
            if (oldPolicy == null) {
                Trace.out("policy not available in OCR tree using Automatic");
                oldPolicy = "AUTOMATIC";
            }
        }
        finally {
            Trace.out("Releasing shared CSS lock SRVM." + dbKey);
            try {
                this.m_clusterLock.release("SRVM." + dbKey);
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
        }
        ParallelServerConfig config = new ParallelServerConfig(cpDBName, domain, instances, services, clua, envs, ohome, spfile, dbName, role, startOpt, enabled, policy, oldPolicy);
        this.printParallelServerConfig(config);
        return config;
    }

    private synchronized Vector getDatabaseInstances(String dbName) throws OCRException {
        Vector<Instance> instances = new Vector<Instance>();
        boolean instEnabled = true;
        if (!this.m_ocr.keyExists(this.m_ocrTreeDef.getDBInstanceKey(dbName))) {
            return instances;
        }
        String[] instanceArray = this.m_ocr.listSubKeys(this.m_ocrTreeDef.getDBInstanceKey(dbName));
        for (int i = 0; i < instanceArray.length; ++i) {
            String instKey = this.m_ocrTreeDef.getDBInstanceNameKey(dbName, instanceArray[i]);
            String nodeName = this.m_ocr.getKeyValue(this.m_ocrTreeDef.getInstanceNodeKey(dbName, instanceArray[i]));
            String[] instEnvs = this.m_ocr.getKeyValues(this.m_ocrTreeDef.getInstanceEnvKey(dbName, instanceArray[i]));
            instEnabled = new Boolean(this.m_ocr.getKeyValue(this.m_ocrTreeDef.getInstanceEnabledKey(dbName, instanceArray[i])));
            Instance inst = new Instance(instanceArray[i], nodeName, instEnvs, instEnabled);
            instances.addElement(inst);
        }
        return instances;
    }

    private synchronized Vector getDatabaseServices(String dbName) throws OCRException {
        Vector<ServiceComposite> services = new Vector<ServiceComposite>();
        if (!this.m_ocr.keyExists(this.m_ocrTreeDef.getDBServiceKey(dbName))) {
            return services;
        }
        String cpDBName = this.m_ocr.getKeyValue(this.m_ocrTreeDef.getDBKey(dbName));
        String[] serviceArray = this.m_ocr.listSubKeys(this.m_ocrTreeDef.getDBServiceKey(dbName));
        for (int i = 0; i < serviceArray.length; ++i) {
            String cvtdServName = this.convertServiceName(serviceArray[i]);
            String[] allInstances = this.m_ocr.listSubKeys(this.m_ocrTreeDef.getDBServiceInstancesKey(dbName, cvtdServName));
            ServiceInstance[] serviceInstances = new ServiceInstance[allInstances.length];
            for (int j = 0; j < allInstances.length; ++j) {
                String instType = this.m_ocr.getKeyValue(this.m_ocrTreeDef.getDBServiceInstTypeKey(dbName, cvtdServName, allInstances[j]));
                boolean instEnabled = new Boolean(this.m_ocr.getKeyValue(this.m_ocrTreeDef.getDBServiceInstEnabledKey(dbName, cvtdServName, allInstances[j])));
                serviceInstances[j] = new ServiceInstance(serviceArray[i], allInstances[j], instType, instEnabled);
            }
            String[] servEnvs = this.m_ocr.getKeyValues(this.m_ocrTreeDef.getDBServiceEnvKey(dbName, cvtdServName));
            String tafPolicy = this.m_ocr.getKeyValue(this.m_ocrTreeDef.getDBServiceTAFKey(dbName, cvtdServName));
            boolean enabled = new Boolean(this.m_ocr.getKeyValue(this.m_ocrTreeDef.getDBServiceEnabledKey(dbName, cvtdServName)));
            ServiceComposite sc = new ServiceComposite(serviceArray[i], serviceInstances, tafPolicy, servEnvs, enabled, cpDBName);
            services.addElement(sc);
        }
        return services;
    }

    private String convertServiceName(String servName) {
        if (servName == null) {
            return null;
        }
        int strLength = servName.length();
        StringBuffer strBuf = new StringBuffer(strLength);
        for (int i = 0; i < strLength; ++i) {
            char c = servName.charAt(i);
            if (c == '.') {
                strBuf.append('*');
                continue;
            }
            strBuf.append(c);
        }
        return strBuf.toString();
    }

    @Override
    protected synchronized void writeDatabaseConfiguration(ParallelServerConfig config, boolean purge) throws OCRException {
        boolean bLog = true;
        String dbName = config.getName();
        this.m_ocr.deleteKey(this.m_ocrTreeDef.getDBKey(dbName, bLog), true);
        try {
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBKey(dbName, bLog), dbName, 1, null, config.getOracleHome());
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBOHomeKey(dbName, bLog), config.getOracleHome(), 2, this.m_ocrTreeDef.getDBKey(dbName, bLog), config.getOracleHome());
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBDomainKey(dbName, bLog), config.getDomain(), 2, this.m_ocrTreeDef.getDBKey(dbName, bLog), config.getOracleHome());
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBSPFileKey(dbName, bLog), config.getSPFile(), 2, this.m_ocrTreeDef.getDBKey(dbName, bLog), config.getOracleHome());
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBNameKey(dbName, bLog), config.getDBName(), 2, this.m_ocrTreeDef.getDBKey(dbName, bLog), config.getOracleHome());
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBRoleKey(dbName, bLog), config.getRole(), 2, this.m_ocrTreeDef.getDBKey(dbName, bLog), config.getOracleHome());
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBStartOptKey(dbName, bLog), config.getStartOpt(), 2, this.m_ocrTreeDef.getDBKey(dbName, bLog), config.getOracleHome());
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBEnabledKey(dbName, bLog), new Boolean(config.isEnabled()).toString(), 2, this.m_ocrTreeDef.getDBKey(dbName, bLog), config.getOracleHome());
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBPolicyKey(dbName, bLog), config.getManagementPolicy(), 2, this.m_ocrTreeDef.getDBKey(dbName, bLog), config.getOracleHome());
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBPriorPolicyKey(dbName, bLog), config.getPriorManagementPolicy(), 2, this.m_ocrTreeDef.getDBKey(dbName, bLog), config.getOracleHome());
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBServiceKey(dbName, bLog), null, 1, this.m_ocrTreeDef.getDBKey(dbName, bLog), config.getOracleHome());
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBVersionKey(dbName, bLog), this.m_version.toString(), 2, this.m_ocrTreeDef.getDBKey(dbName, bLog), config.getOracleHome());
            this.setDatabaseInstances(config, bLog);
            Vector services = config.getServices();
            for (int i = 0; i < services.size(); ++i) {
                ServiceComposite sc = (ServiceComposite)services.elementAt(i);
                this.setDatabaseServiceConfig(config, sc, bLog);
            }
            this.m_ocr.setKeyValues(this.m_ocrTreeDef.getDBEnvKey(dbName, bLog), config.getEnvironment(), 2, this.m_ocrTreeDef.getDBKey(dbName, bLog), config.getOracleHome());
            Trace.out("OCRTreeHA.setDatabaseConfiguration: getting VIP address");
            VIPAddress vipAddr = config.getVIPAddress();
            Trace.out("OCRTreeHA.setDatabaseConfiguration: got VIP address");
            if (vipAddr != null) {
                Trace.out("vip address is not null");
                this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBCluaIPKey(dbName, bLog), vipAddr.getIPAddress().getHostAddress(), 2, this.m_ocrTreeDef.getDBKey(dbName, bLog), config.getOracleHome());
                this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBCluaNetMaskKey(dbName, bLog), vipAddr.getNetmask(), 2, this.m_ocrTreeDef.getDBKey(dbName, bLog), config.getOracleHome());
                this.m_ocr.setKeyValues(this.m_ocrTreeDef.getDBCluaInterfacesKey(dbName, bLog), vipAddr.getInterfaces(), 2, this.m_ocrTreeDef.getDBKey(dbName, bLog), config.getOracleHome());
            } else {
                Trace.out("no vip address available");
            }
            this.m_ocr.moveKey(this.m_ocrTreeDef.getDBKey(dbName, bLog), this.m_ocrTreeDef.getDBRootKey(), this.m_ocrTreeDef.getDBKey(dbName).substring(this.m_ocrTreeDef.getDBRootKey().length() + 1), 1);
            Trace.out("OCRTreeHA.writeDatabaseConfiguration: returning");
        }
        catch (OCRException e) {
            this.m_ocr.deleteKey(this.m_ocrTreeDef.getDBKey(dbName, bLog), true);
            throw e;
        }
    }

    @Override
    protected synchronized void setDatabaseInstances(ParallelServerConfig config, boolean bLog) throws OCRException {
        String dbName = config.getName();
        String dbKey = this.m_ocrTreeDef.getDBKey(dbName, bLog);
        Vector instances = config.getInstances();
        for (int i = 0; i < instances.size(); ++i) {
            Instance inst = (Instance)instances.elementAt(i);
            String instName = inst.getName();
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBInstanceNameKey(dbName, instName, bLog), instName, 2, dbKey, config.getOracleHome());
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getInstanceNodeKey(dbName, instName, bLog), inst.getNode(), 2, dbKey, config.getOracleHome());
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getInstanceEnabledKey(dbName, instName, bLog), new Boolean(inst.isEnabled()).toString(), 2, dbKey, config.getOracleHome());
            this.m_ocr.setKeyValues(this.m_ocrTreeDef.getInstanceEnvKey(dbName, instName, bLog), inst.getEnv(), 2, dbKey, config.getOracleHome());
        }
    }

    @Override
    public void setDatabaseService(ParallelServerConfig config, ServiceComposite sc, boolean log) throws OCRException {
        String dbName = config.getName();
        String servName = sc.getModifiedName();
        boolean bLog = true;
        this.m_ocr.deleteKey(this.m_ocrTreeDef.getDBServiceNameKey(dbName, servName, bLog), true);
        this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBKey(dbName, bLog), dbName, 1, null, config.getOracleHome());
        try {
            this.setDatabaseServiceConfig(config, sc, bLog);
            this.m_ocr.moveKey(this.m_ocrTreeDef.getDBServiceNameKey(dbName, servName, bLog), this.m_ocrTreeDef.getDBServiceKey(dbName), this.m_ocrTreeDef.getDBServiceNameKey(dbName, servName).substring(this.m_ocrTreeDef.getDBServiceKey(dbName).length() + 1), 1);
        }
        catch (OCRException e) {
            this.m_ocr.deleteKey(this.m_ocrTreeDef.getDBServiceNameKey(dbName, servName, bLog), true);
            throw e;
        }
    }

    private void setDatabaseServiceConfig(ParallelServerConfig config, ServiceComposite sc, boolean bLog) throws OCRException {
        String dbName = config.getName();
        String dbKey = this.m_ocrTreeDef.getDBKey(dbName, bLog);
        String servName = sc.getModifiedName();
        String servOrigName = sc.getName();
        Trace.out("re-writing single service config: " + servOrigName);
        String scKey = this.m_ocrTreeDef.getDBServiceNameKey(dbName, servName, bLog);
        this.m_ocr.setKeyValue(scKey, servOrigName, 2, dbKey, config.getOracleHome());
        Vector sis = sc.getServiceInstances();
        for (int j = 0; j < sis.size(); ++j) {
            ServiceInstance si = (ServiceInstance)sis.elementAt(j);
            String servInstName = si.getInstanceName();
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBServiceInstNameKey(dbName, servName, servInstName, bLog), servInstName, 2, dbKey, config.getOracleHome());
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBServiceInstTypeKey(dbName, servName, servInstName, bLog), si.getType(), 2, dbKey, config.getOracleHome());
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBServiceInstEnabledKey(dbName, servName, servInstName, bLog), new Boolean(si.getEnabled()).toString(), 2, dbKey, config.getOracleHome());
        }
        this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBServiceTAFKey(dbName, servName, bLog), sc.getTAFPolicy(), 2, dbKey, config.getOracleHome());
        this.m_ocr.setKeyValues(this.m_ocrTreeDef.getDBServiceEnvKey(dbName, servName, bLog), sc.getEnv(), 2, dbKey, config.getOracleHome());
        this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBServiceEnabledKey(dbName, servName, bLog), new Boolean(sc.isEnabled()).toString(), 2, dbKey, config.getOracleHome());
    }

    @Override
    public void enableDisableDatabaseService(ParallelServerConfig config, ServiceComposite sc, boolean log) throws OCRException {
        String dbName = config.getName();
        boolean bLog = true;
        String servName = sc.getModifiedName();
        String scKey = this.m_ocrTreeDef.getDBServiceNameKey(dbName, servName);
        this.m_ocr.deleteKey(this.m_ocrTreeDef.getDBServiceNameKey(dbName, servName, bLog), true);
        if (bLog) {
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBServiceNameKey(dbName, servName, bLog), servName, 1, null, config.getOracleHome());
        }
        try {
            this.m_ocr.copyRecurse(scKey, this.m_ocrTreeDef.getDBServiceNameKey(dbName, servName, bLog), 2);
            Vector sis = sc.getServiceInstances();
            for (int j = 0; j < sis.size(); ++j) {
                ServiceInstance si = (ServiceInstance)sis.elementAt(j);
                String servInstName = si.getInstanceName();
                this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBServiceInstEnabledKey(dbName, servName, servInstName, bLog), new Boolean(si.getEnabled()).toString(), 2, this.m_ocrTreeDef.getDBKey(dbName, bLog), config.getOracleHome());
            }
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBServiceEnabledKey(dbName, servName, bLog), new Boolean(sc.isEnabled()).toString(), 2, this.m_ocrTreeDef.getDBKey(dbName, bLog), config.getOracleHome());
            this.m_ocr.moveKey(this.m_ocrTreeDef.getDBServiceNameKey(dbName, servName, bLog), this.m_ocrTreeDef.getDBServiceKey(dbName), this.m_ocrTreeDef.getDBServiceNameKey(dbName, servName).substring(this.m_ocrTreeDef.getDBServiceKey(dbName).length() + 1), 1);
        }
        catch (OCRException e) {
            this.m_ocr.deleteKey(this.m_ocrTreeDef.getDBServiceNameKey(dbName, servName, bLog), true);
            throw e;
        }
    }

    @Override
    public void enableDisableDatabaseServiceInstance(ParallelServerConfig config, ServiceComposite sc, ServiceInstance servInst, boolean log) throws OCRException {
        String dbName = config.getName();
        String dbKey = this.m_ocrTreeDef.getDBKey(dbName);
        String servName = sc.getModifiedName();
        String servInstName = servInst.getInstanceName();
        String scKey = this.m_ocrTreeDef.getDBServiceInstEnabledKey(dbName, servName, servInstName);
        this.m_ocr.setKeyValue(scKey, new Boolean(servInst.getEnabled()).toString(), 2, dbKey, config.getOracleHome());
    }

    @Override
    public void removeDatabaseService(ParallelServerConfig config, ServiceComposite sc) throws OCRException {
        String dbName = config.getName();
        String servName = sc.getModifiedName();
        String scKey = this.m_ocrTreeDef.getDBServiceNameKey(dbName, servName);
        Trace.out("removing single service config: " + scKey);
        this.m_ocr.deleteKey(scKey, true);
    }

    @Override
    public synchronized VIPRangeConfiguration[] getVIPRangeConfigurations() throws OCRException {
        if (!this.m_ocr.keyExists(this.m_ocrTreeDef.getVRangeRootKey())) {
            return null;
        }
        String vipKey = this.m_ocrTreeDef.getVRangeRootKey();
        String[] netmasks = this.m_ocr.listSubKeys(this.m_ocrTreeDef.getVRangeRootKey());
        VIPRangeConfiguration[] configs = new VIPRangeConfiguration[netmasks.length];
        for (int i = 0; i < netmasks.length; ++i) {
            configs[i] = this.getVIPRangeConfiguration(netmasks[i]);
        }
        return configs;
    }

    @Override
    public synchronized VIPRangeConfiguration getVIPRangeConfiguration(String netmask) throws OCRException {
        VIPRangeConfiguration vrConfig;
        String netmaskKey = this.m_ocrTreeDef.getVRangeNetMaskKey(netmask);
        if (!this.m_ocr.keyExists(netmaskKey)) {
            Trace.out("key " + netmaskKey + " doesn't exist. returning null");
            return null;
        }
        String vipKey = this.m_ocrTreeDef.getVRangeRootKey();
        String[] ips = this.m_ocr.listSubKeys(netmaskKey);
        if (ips == null || ips.length == 0) {
            return null;
        }
        Binary netmaskBinary = new Binary(netmask);
        Binary[] ipsBinary = new Binary[ips.length];
        for (int i = 0; i < ips.length; ++i) {
            ipsBinary[i] = new Binary(ips[i]);
        }
        try {
            vrConfig = new VIPRangeConfiguration(netmaskBinary, ipsBinary);
        }
        catch (VirtualIPException e) {
            throw new OCRException(e.getMessage());
        }
        return vrConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setVIPRangeConfigurations(VIPRangeConfiguration[] vrConfigs) throws OCRException {
        String vipKey = this.m_ocrTreeDef.getVRangeRootKey();
        Trace.out("Acquiring exclusive CSS lock SRVM." + vipKey);
        try {
            this.m_clusterLock.acquire("SRVM." + vipKey);
        }
        catch (ClusterLockException e) {
            throw new OCRException(e.getMessage());
        }
        try {
            this.removeVIPRangeConfiguration(false);
            for (int i = 0; i < vrConfigs.length; ++i) {
                this.setVIPRangeConfiguration(vrConfigs[i], false);
            }
        }
        finally {
            Trace.out("Releasing exclusive CSS lock SRVM." + vipKey);
            try {
                this.m_clusterLock.release("SRVM." + vipKey);
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
        }
    }

    @Override
    public synchronized void setVIPRangeConfiguration(VIPRangeConfiguration vrConfig) throws OCRException {
        this.setVIPRangeConfiguration(vrConfig, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVIPRangeConfiguration(VIPRangeConfiguration vrConfig, boolean log) throws OCRException {
        String netmask = vrConfig.getNetmask().toString();
        String netmaskKey = this.m_ocrTreeDef.getVRangeNetMaskKey(netmask);
        String vipKey = this.m_ocrTreeDef.getVRangeRootKey();
        if (log) {
            Trace.out("Acquiring exclusive CSS lock SRVM." + vipKey);
            try {
                this.m_clusterLock.acquire("SRVM." + vipKey);
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
        }
        try {
            this.m_ocr.createKey(netmaskKey, 4, this.m_ocrTreeDef.getVRangeRootKey(), null);
            Trace.out("created key " + netmaskKey);
            Binary[] ips = vrConfig.getIPAddresses();
            for (int i = 0; i < ips.length; ++i) {
                String ip = ips[i].toString();
                this.m_ocr.createKey(this.m_ocrTreeDef.getVRangeIPKey(netmask, ip), 4, this.m_ocrTreeDef.getVRangeRootKey(), null);
            }
        }
        finally {
            if (log) {
                Trace.out("Releasing exclusive CSS lock SRVM." + vipKey);
                try {
                    this.m_clusterLock.release("SRVM." + vipKey);
                }
                catch (ClusterLockException e) {
                    throw new OCRException(e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeVIPRangeConfiguration(boolean flag) throws OCRException {
        String vipKey = this.m_ocrTreeDef.getVRangeRootKey();
        if (flag) {
            Trace.out("Acquiring exclusive CSS lock SRVM." + vipKey);
            try {
                this.m_clusterLock.acquire("SRVM." + vipKey);
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
        }
        try {
            String[] netmasks = this.m_ocr.listSubKeys(vipKey);
            for (int i = 0; i < netmasks.length; ++i) {
                String netmaskKey = this.m_ocrTreeDef.getVRangeNetMaskKey(netmasks[i]);
                this.m_ocr.deleteKey(netmaskKey, true);
            }
        }
        finally {
            if (flag) {
                Trace.out("Releasing exclusive CSS lock SRVM." + vipKey);
                try {
                    this.m_clusterLock.release("SRVM." + vipKey);
                }
                catch (ClusterLockException e) {
                    throw new OCRException(e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized NodeConfiguration getNodeConfiguration(String nodeName) throws OCRException {
        String ohome;
        String cpNodeName;
        String[] envs;
        VIPAddress vipAddr;
        block17: {
            String nodeKey = this.m_ocrTreeDef.getNodeKey(nodeName);
            if (!this.m_ocr.keyExists(nodeKey)) {
                return null;
            }
            Trace.out("Acquiring shared CSS lock SRVM." + nodeKey);
            try {
                this.m_clusterLock.acquireShared("SRVM." + nodeKey);
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
            vipAddr = null;
            envs = null;
            try {
                InetAddress addr;
                String vipName;
                cpNodeName = this.m_ocr.getKeyValue(nodeKey);
                ohome = this.m_ocr.getKeyValue(this.m_ocrTreeDef.getNodeOHomeKey(nodeName));
                if (this.m_ocr.keyExists(this.m_ocrTreeDef.getNodeEnvKey(nodeName))) {
                    envs = this.m_ocr.getKeyValues(this.m_ocrTreeDef.getNodeEnvKey(nodeName));
                }
                if (!this.m_ocr.keyExists(this.m_ocrTreeDef.getNodeVIPKey(nodeName))) break block17;
                String name = vipName = this.m_ocr.getKeyValue(this.m_ocrTreeDef.getNodeVIPKey(nodeName));
                if (vipName == null) {
                    vipName = this.m_ocr.getKeyValue(this.m_ocrTreeDef.getNodeVIPIPKey(nodeName));
                }
                try {
                    addr = InetAddress.getByName(vipName);
                }
                catch (UnknownHostException e) {
                    throw new OCRException(e.getMessage());
                }
                if (name == null) {
                    name = addr.getHostName();
                }
                String ip = addr.getHostAddress();
                String netmask = this.m_ocr.getKeyValue(this.m_ocrTreeDef.getNodeVIPNetMaskKey(nodeName));
                String[] interfaces = this.m_ocr.getKeyValues(this.m_ocrTreeDef.getNodeVIPInterfacesKey(nodeName));
                try {
                    vipAddr = new VIPAddress(name, ip, netmask, interfaces);
                }
                catch (VirtualIPException e) {
                    throw new OCRException(e.getMessage());
                }
            }
            finally {
                Trace.out("Releasing shared CSS lock SRVM." + nodeKey);
                try {
                    this.m_clusterLock.release("SRVM." + nodeKey);
                }
                catch (ClusterLockException e) {
                    throw new OCRException(e.getMessage());
                }
            }
        }
        return new NodeConfiguration(cpNodeName, ohome, vipAddr, envs);
    }

    @Override
    public synchronized void setNodeConfiguration(NodeConfiguration nodeConfig) throws OCRException {
        String nodeName = nodeConfig.getName();
        String nodeKey = this.m_ocrTreeDef.getNodeKey(nodeName);
        String nodeRootKey = this.m_ocrTreeDef.getNodeRootKey();
        boolean bLog = true;
        Trace.out("Acquiring exclusive CSS lock SRVM." + nodeRootKey);
        try {
            this.m_clusterLock.acquire("SRVM." + nodeRootKey);
        }
        catch (ClusterLockException e) {
            throw new OCRException(e.getMessage());
        }
        this.m_ocr.deleteKey(this.m_ocrTreeDef.getNodeKey(nodeName, bLog), true);
        try {
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getNodeKey(nodeName, bLog), nodeName, 3, this.m_ocrTreeDef.getNodeRootKey(bLog), null);
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getNodeOHomeKey(nodeName, bLog), nodeConfig.getOracleHome(), 3, this.m_ocrTreeDef.getNodeKey(nodeName, bLog), null);
            VIPAddress vipAddr = nodeConfig.getVIPAddress();
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getNodeVIPKey(nodeName, bLog), vipAddr.getIPAddress().getHostName(), 3, this.m_ocrTreeDef.getNodeKey(nodeName, bLog), null);
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getNodeVIPIPKey(nodeName, bLog), vipAddr.getIPAddress().getHostName(), 3, this.m_ocrTreeDef.getNodeVIPKey(nodeName, bLog), null);
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getNodeVIPNetMaskKey(nodeName, bLog), vipAddr.getNetmask(), 3, this.m_ocrTreeDef.getNodeVIPKey(nodeName, bLog), null);
            this.m_ocr.setKeyValues(this.m_ocrTreeDef.getNodeVIPInterfacesKey(nodeName, bLog), vipAddr.getInterfaces(), 3, this.m_ocrTreeDef.getNodeVIPKey(nodeName, bLog), null);
            this.m_ocr.setKeyValues(this.m_ocrTreeDef.getNodeEnvKey(nodeName, bLog), nodeConfig.getEnv(), 3, this.m_ocrTreeDef.getNodeKey(nodeName, bLog), null);
            this.m_ocr.moveKey(this.m_ocrTreeDef.getNodeKey(nodeName, bLog), this.m_ocrTreeDef.getNodeRootKey(), this.m_ocrTreeDef.getNodeKey(nodeName).substring(this.m_ocrTreeDef.getNodeRootKey().length() + 1), 1);
        }
        catch (OCRException e) {
            this.m_ocr.deleteKey(this.m_ocrTreeDef.getNodeKey(nodeName, bLog), true);
            throw e;
        }
        finally {
            Trace.out("Releasing exclusive CSS lock SRVM." + nodeRootKey);
            try {
                this.m_clusterLock.release("SRVM." + nodeRootKey);
            }
            catch (ClusterLockException e) {
                Trace.out((Exception)((Object)e));
                throw new OCRException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeNodeConfiguration(String nodeName, boolean flag) throws OCRException {
        String nodeRootKey = this.m_ocrTreeDef.getNodeRootKey();
        String nodeKey = this.m_ocrTreeDef.getNodeKey(nodeName);
        if (flag) {
            Trace.out("Acquiring exclusive CSS lock SRVM." + nodeRootKey);
            try {
                this.m_clusterLock.acquire("SRVM." + nodeRootKey);
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
        }
        try {
            this.m_ocr.deleteKey(nodeKey, true);
        }
        finally {
            if (flag) {
                Trace.out("Releasing exclusive CSS lock SRVM." + nodeRootKey);
                try {
                    this.m_clusterLock.release("SRVM." + nodeRootKey);
                }
                catch (ClusterLockException e) {
                    throw new OCRException(e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String[] listNodes() throws OCRException {
        String nodeRootKey = this.m_ocrTreeDef.getNodeRootKey();
        Trace.out("Acquiring shared CSS lock SRVM." + nodeRootKey);
        try {
            this.m_clusterLock.acquireShared("SRVM." + nodeRootKey);
        }
        catch (ClusterLockException e) {
            throw new OCRException(e.getMessage());
        }
        try {
            if (this.m_ocr.keyExists(this.m_ocrTreeDef.getNodeRootKey())) {
                String[] stringArray = this.m_ocr.listSubKeys(this.m_ocrTreeDef.getNodeRootKey());
                return stringArray;
            }
            String[] stringArray = new String[]{};
            return stringArray;
        }
        finally {
            Trace.out("Releasing shared CSS lock SRVM." + nodeRootKey);
            try {
                this.m_clusterLock.release("SRVM." + nodeRootKey);
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
        }
    }

    @Override
    public void addInstance(String dbName, String instName, String nodeName) throws OCRException {
        boolean bLog = true;
        String dbKey = this.getTreeDefinition().getDBKey(dbName);
        boolean instKeyCreated = false;
        try {
            this.m_clusterLock.acquire("SRVM." + dbKey);
        }
        catch (ClusterLockException e) {
            throw new OCRException(e.getMessage());
        }
        try {
            String oHome = this.m_ocr.getKeyValue(this.getTreeDefinition().getDBOHomeKey(dbName));
            this.m_ocr.deleteKey(this.m_ocrTreeDef.getDBInstanceNameKey(dbName, instName, bLog), true);
            Trace.out("addInstance: Creating INSTANCE XXX name key oHome= " + oHome);
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBInstanceNameKey(dbName, instName, bLog), instName, 2, this.m_ocrTreeDef.getLogRootKey(), oHome);
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getInstanceNodeKey(dbName, instName, bLog), nodeName, 2, this.m_ocrTreeDef.getDBKey(dbName, bLog), oHome);
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getInstanceEnabledKey(dbName, instName, bLog), new Boolean(true).toString(), 2, this.m_ocrTreeDef.getDBKey(dbName, bLog), oHome);
            this.m_ocr.createKey(this.m_ocrTreeDef.getInstanceEnvKey(dbName, instName, bLog), 2, this.m_ocrTreeDef.getDBKey(dbName, bLog), oHome);
            if (!this.m_ocr.keyExists(this.m_ocrTreeDef.getDBInstanceKey(dbName))) {
                this.m_ocr.createKey(this.m_ocrTreeDef.getDBInstanceKey(dbName), 2, this.m_ocrTreeDef.getDBKey(dbName), oHome);
                instKeyCreated = true;
            }
            this.m_ocr.moveKey(this.m_ocrTreeDef.getDBInstanceNameKey(dbName, instName, bLog), this.m_ocrTreeDef.getDBInstanceKey(dbName), this.m_ocrTreeDef.getDBInstanceNameKey(dbName, instName).substring(this.m_ocrTreeDef.getDBInstanceKey(dbName).length() + 1), 1);
        }
        catch (OCRException e) {
            if (instKeyCreated) {
                try {
                    this.m_ocr.deleteKey(this.m_ocrTreeDef.getDBInstanceKey(dbName), false);
                }
                catch (OCRException e2) {
                    Trace.out(e2);
                }
            }
            this.m_ocr.deleteKey(this.m_ocrTreeDef.getDBInstanceNameKey(dbName, instName, bLog), true);
            throw e;
        }
        finally {
            Trace.out("Releasing shared CSS lock SRVM." + dbKey);
            try {
                this.m_clusterLock.release("SRVM." + dbKey);
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
        }
    }

    @Override
    public void setDBEnableDisable(String dbName, Boolean enableDisable) throws OCRException {
        this.setDBEnableDisable(dbName, enableDisable, "AUTOMATIC", "AUTOMATIC");
    }

    @Override
    public void setDBEnableDisable(String dbName, Boolean enableDisable, String policy, String priorPolicy) throws OCRException {
        boolean bLog = true;
        String dbKey = this.m_ocrTreeDef.getDBKey(dbName);
        try {
            this.m_clusterLock.acquire("SRVM." + dbKey);
        }
        catch (ClusterLockException e) {
            throw new OCRException(e.getMessage());
        }
        try {
            String oHome = this.m_ocr.getKeyValue(this.m_ocrTreeDef.getDBOHomeKey(dbName));
            this.m_ocr.deleteKey(this.m_ocrTreeDef.getDBKey(dbName, bLog), true);
            if (bLog) {
                this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBKey(dbName, bLog), dbName, 1, null, oHome);
            }
            this.m_ocr.copyRecurse(this.m_ocrTreeDef.getDBKey(dbName), this.m_ocrTreeDef.getDBKey(dbName, bLog), 2);
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBEnabledKey(dbName, bLog), enableDisable.toString(), 2, this.m_ocrTreeDef.getDBKey(dbName, bLog), oHome);
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBPolicyKey(dbName, bLog), policy, 2, this.m_ocrTreeDef.getDBKey(dbName, bLog), oHome);
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getDBPriorPolicyKey(dbName, bLog), priorPolicy, 2, this.m_ocrTreeDef.getDBKey(dbName, bLog), oHome);
            String[] instNames = this.m_ocr.listSubKeys(this.m_ocrTreeDef.getDBInstanceKey(dbName, bLog));
            for (int i = 0; i < instNames.length; ++i) {
                this.m_ocr.setKeyValue(this.m_ocrTreeDef.getInstanceEnabledKey(dbName, instNames[i], bLog), enableDisable.toString(), 2, this.m_ocrTreeDef.getDBKey(dbName, bLog), oHome);
            }
            this.m_ocr.moveKey(this.m_ocrTreeDef.getDBKey(dbName, bLog), this.m_ocrTreeDef.getDBRootKey(), this.m_ocrTreeDef.getDBKey(dbName).substring(this.m_ocrTreeDef.getDBRootKey().length() + 1), 1);
        }
        catch (OCRException e) {
            this.m_ocr.deleteKey(this.m_ocrTreeDef.getDBKey(dbName, bLog), true);
            throw e;
        }
        finally {
            Trace.out("Releasing shared CSS lock SRVM." + dbKey);
            try {
                this.m_clusterLock.release("SRVM." + dbKey);
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
        }
    }

    @Override
    public void setInstanceEnableDisable(String dbName, String instName, Boolean enableDisable) throws OCRException {
        this.setInstanceEnableDisable(dbName, instName, enableDisable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInstanceEnableDisable(String dbName, String instName, Boolean enableDisable, boolean needLock) throws OCRException {
        String dbKey = this.m_ocrTreeDef.getDBKey(dbName);
        if (needLock) {
            try {
                this.m_clusterLock.acquire("SRVM." + dbKey);
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
        }
        try {
            String oHome = this.m_ocr.getKeyValue(this.getTreeDefinition().getDBOHomeKey(dbName));
            this.m_ocr.setKeyValue(this.m_ocrTreeDef.getInstanceEnabledKey(dbName, instName), enableDisable.toString(), 2, dbKey, oHome);
        }
        finally {
            if (needLock) {
                Trace.out("Releasing shared CSS lock SRVM." + dbKey);
                try {
                    this.m_clusterLock.release("SRVM." + dbKey);
                }
                catch (ClusterLockException e) {
                    throw new OCRException(e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String[] listOracleHomes() throws OCRException {
        String[] databases = this.listDatabases();
        Object[] oracleHomes = null;
        if (databases != null) {
            String dbRootKey = this.getTreeDefinition().getDBRootKey();
            Trace.out("Acquiring shared CSS lock SRVM." + dbRootKey);
            try {
                this.m_clusterLock.acquireShared("SRVM." + dbRootKey);
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
            try {
                Vector<String> oHomes = new Vector<String>(databases.length);
                String oHome = null;
                for (int i = 0; i < databases.length; ++i) {
                    oHome = this.m_ocr.getKeyValue(this.getTreeDefinition().getDBOHomeKey(databases[i]));
                    if (oHome == null) continue;
                    String dbVer = this.m_ocr.getKeyValue(this.getTreeDefinition().getDBVersionKey(databases[i]));
                    Trace.out("HA dbVER = " + dbVer);
                    Trace.out("version string = " + this.m_version.toString());
                    if (dbVer == null || !this.m_version.toString().equals(dbVer.trim())) continue;
                    oHomes.addElement(oHome);
                }
                if (oHomes.size() > 0) {
                    oracleHomes = new String[oHomes.size()];
                    oHomes.copyInto(oracleHomes);
                }
            }
            finally {
                Trace.out("Releasing shared CSS lock SRVM." + dbRootKey);
                try {
                    this.m_clusterLock.release("SRVM." + dbRootKey);
                }
                catch (ClusterLockException e) {
                    throw new OCRException(e.getMessage());
                }
            }
        }
        return oracleHomes;
    }

    public synchronized String getLocalOnlyKeyValue() throws OCRException {
        String localOnly = this.m_ocr.getKeyValue(this.m_ocrTreeDef.getLocalOnlyKey());
        Trace.out("OCRTreeHA localOnly string = " + localOnly);
        return localOnly;
    }

    public synchronized String[] getVoteDiskKeyValue() throws OCRException {
        Vector<String> votedisks = new Vector<String>(31);
        String votediskKey = this.m_ocrTreeDef.getCSSVoteDiskKey();
        String votedisk = this.m_ocr.getKeyValue(votediskKey);
        Trace.out("OCRTreeHA votedisk value = " + votedisk);
        votedisks.addElement(votedisk);
        for (int i = 1; i < 31; ++i) {
            String vdiskKey = votediskKey + i;
            if (!this.m_ocr.keyExists(vdiskKey)) continue;
            Trace.out("Getting value set in votedisk key: " + vdiskKey);
            votedisks.addElement(this.m_ocr.getKeyValue(vdiskKey));
        }
        Object[] vdisks = new String[votedisks.size()];
        votedisks.copyInto(vdisks);
        return vdisks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String[] listInterfaceNames() throws OCRException {
        OCRTreeDefinitionHA ocrHATreeDef = (OCRTreeDefinitionHA)this.getTreeDefinition();
        String CSSIFsKey = ocrHATreeDef.getIFRootKey();
        String CSSGlobalIFsKey = ocrHATreeDef.getGlobalIFsKey();
        Trace.out("Acquiring shared CSS lock SRVM." + CSSIFsKey);
        try {
            this.m_clusterLock.acquireShared("SRVM." + CSSIFsKey);
        }
        catch (ClusterLockException e) {
            throw new OCRException(e.getMessage());
        }
        Object ifs = null;
        try {
            if (this.m_ocr.keyExists(CSSIFsKey) && this.m_ocr.keyExists(CSSGlobalIFsKey)) {
                Trace.out("Retrieving list of interfaces from OCR");
                String[] stringArray = this.m_ocr.listSubKeys(CSSGlobalIFsKey);
                return stringArray;
            }
            Trace.out("OCR does not have any global interfaces set");
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            Trace.out("Releasing shared CSS lock SRVM." + CSSIFsKey);
            try {
                this.m_clusterLock.release("SRVM." + CSSIFsKey);
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
        }
    }

    public synchronized NetworkInterface[] listInterfaces() throws OCRException {
        Trace.out("Retrieving list of all the interfaces from OCR");
        String[] ifs = this.listInterfaceNames();
        if (ifs == null || ifs.length == 0) {
            return null;
        }
        OCRTreeDefinitionHA ocrHATreeDef = (OCRTreeDefinitionHA)this.getTreeDefinition();
        String IFsGlobalKey = ocrHATreeDef.getGlobalIFsKey();
        ArrayList<NetworkInterface> ifListV = new ArrayList<NetworkInterface>(ifs.length);
        for (int i = 0; i < ifs.length; ++i) {
            Trace.out("interface : " + ifs[i]);
            String ifNameKey = IFsGlobalKey + "." + ifs[i];
            String[] ifSubnets = this.m_ocr.listSubKeys(ifNameKey, false);
            if (ifSubnets == null) continue;
            Trace.out("Found " + ifSubnets.length + " subnets configured for interface:" + ifs[i]);
            for (int j = 0; j < ifSubnets.length; ++j) {
                Trace.out("interface subnet : " + ifSubnets[j]);
                NetworkInterface netIF = new NetworkInterface(ifs[i], ifSubnets[j]);
                String ifSubnetKey = ifNameKey + "." + ifSubnets[j];
                String[] ipTypes = this.m_ocr.listSubKeys(ifSubnetKey, false);
                if (ipTypes == null) continue;
                for (int k = 0; k < ipTypes.length; ++k) {
                    Trace.out("OCR(ipTypeKey)=" + ipTypes[k]);
                    int ipType = Integer.parseInt(ipTypes[k]);
                    String ipTypeOCRKey = ifSubnetKey + "." + ipTypes[0];
                    String ifType = this.m_ocr.getKeyValue(ipTypeOCRKey);
                    Trace.out("OCR(ifType) =" + ifType);
                    Trace.out("Adding interface: " + ifs[i] + " to the list");
                    if (ifType.equalsIgnoreCase("cluster_interconnect")) {
                        netIF.setType(8);
                    } else {
                        netIF.setType(4);
                    }
                    netIF.setIPType(ipType);
                    ifListV.add(netIF);
                }
            }
        }
        NetworkInterface[] netIFs = new NetworkInterface[ifListV.size()];
        netIFs = ifListV.toArray(netIFs);
        return netIFs;
    }
}

