/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.rawdevice;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.Instance;
import oracle.ops.mgmt.database.ParallelServerConfig;
import oracle.ops.mgmt.database.ServiceComposite;
import oracle.ops.mgmt.database.config.ServiceInstance;
import oracle.ops.mgmt.has.ClusterLock;
import oracle.ops.mgmt.has.ClusterLockException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.nodeapps.config.NodeConfiguration;
import oracle.ops.mgmt.rawdevice.OCR;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.rawdevice.OCRKeyLiterals;
import oracle.ops.mgmt.rawdevice.OCRTreeDefinition;
import oracle.ops.mgmt.rawdevice.OCRTreeDefinitionHA;
import oracle.ops.mgmt.rawdevice.OCRTreeHA;
import oracle.ops.mgmt.rawdevice.RawDeviceConstants;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.mgmt.viprange.VIPRangeConfiguration;

public class OCRTree
implements Constants,
OCRKeyLiterals,
RawDeviceConstants {
    protected static MessageBundle s_rawMsgBundle;
    protected OCR m_ocr = null;
    private OCRTreeDefinition m_ocrTreeDef = null;
    protected static Hashtable s_instanceTable;
    protected ClusterLock m_clusterLock;
    protected static Version s_version;
    protected Version m_version;

    protected OCRTree(Version v) throws OCRException {
        this(v, 7);
    }

    protected OCRTree(Version v, int initializeLevel) throws OCRException {
        Trace.out("calling OCR.init at level " + initializeLevel);
        this.m_ocr = OCR.init(initializeLevel, v);
        s_rawMsgBundle = MessageBundle.getMessageBundle("Prkr");
        this.m_ocrTreeDef = new OCRTreeDefinition();
        if (initializeLevel == 7) {
            try {
                this.m_clusterLock = new ClusterLock();
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
        }
        this.m_version = v;
    }

    public static synchronized OCRTree init(Version v) throws OCRException {
        Trace.out("in OCRTree.init, version = " + v.toString());
        OCRTree instance = null;
        instance = (OCRTree)s_instanceTable.get(v);
        if (instance == null) {
            instance = !Version.isPre10i(v) ? new OCRTreeHA(v) : new OCRTree(v);
            s_instanceTable.put(v, instance);
        }
        return instance;
    }

    public static synchronized OCRTree init(Version v, int initLevel) throws OCRException {
        Trace.out("calling OCRTree.init");
        OCRTree instance = null;
        instance = (OCRTree)s_instanceTable.get(v);
        if (instance == null) {
            instance = !Version.isPre10i(v) ? new OCRTreeHA(v, initLevel) : new OCRTree(v, initLevel);
            s_instanceTable.put(v, instance);
        }
        return instance;
    }

    public OCRTreeDefinition getTreeDefinition() {
        return this.m_ocrTreeDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ParallelServerConfig getDatabaseConfiguration(String dbName) throws OCRException {
        String spfile;
        String domain;
        String[] envs;
        Vector services;
        Vector instances;
        String ohome;
        String dbKey = this.getTreeDefinition().getDBKey(dbName);
        Trace.out("Acquiring shared CSS lock SRVM." + dbKey);
        try {
            this.m_clusterLock.acquireShared("SRVM." + dbKey);
        }
        catch (ClusterLockException e) {
            throw new OCRException(e.getMessage());
        }
        VIPAddress vip = null;
        boolean enabled = true;
        try {
            if (!this.m_ocr.keyExists(dbKey)) {
                Trace.out(dbKey + " does not exist");
                Object[] args = new String[]{dbName};
                throw new OCRException(s_rawMsgBundle.getMessage("1001", true, args));
            }
            Trace.out("found the db key " + dbKey);
            ohome = this.m_ocr.getKeyValue(this.getTreeDefinition().getDBOHomeKey(dbName));
            if (this.m_ocr.keyExists(this.getTreeDefinition().getDBVersionKey(dbName))) {
                Trace.out(dbKey + " incompatible version");
                Object[] args = new String[]{dbName, this.m_ocr.getKeyValue(this.getTreeDefinition().getDBVersionKey(dbName)), ohome};
                throw new OCRException(s_rawMsgBundle.getMessage("1078", true, args));
            }
            instances = this.getDatabaseInstances(dbName);
            services = null;
            envs = this.m_ocr.getKeyValues(this.getTreeDefinition().getDBEnvKey(dbName));
            domain = this.m_ocr.getKeyValue(this.getTreeDefinition().getDBDomainKey(dbName));
            spfile = this.m_ocr.getKeyValue(this.getTreeDefinition().getDBSPFileKey(dbName));
        }
        finally {
            Trace.out("Releasing shared CSS lock SRVM." + dbKey);
            try {
                this.m_clusterLock.release("SRVM." + dbKey);
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
        }
        ParallelServerConfig config = new ParallelServerConfig(dbName, domain, instances, services, vip, envs, ohome, spfile, enabled);
        this.printParallelServerConfig(config);
        return config;
    }

    private synchronized Vector getDatabaseInstances(String dbName) throws OCRException {
        Vector<Instance> instances = new Vector<Instance>();
        boolean instEnabled = true;
        if (!this.m_ocr.keyExists(this.getTreeDefinition().getDBInstanceKey(dbName))) {
            return instances;
        }
        String[] instanceArray = this.m_ocr.listSubKeys(this.getTreeDefinition().getDBInstanceKey(dbName));
        for (int i = 0; i < instanceArray.length; ++i) {
            String instKey = this.getTreeDefinition().getDBInstanceNameKey(dbName, instanceArray[i]);
            String nodeName = this.m_ocr.getKeyValue(this.getTreeDefinition().getInstanceNodeKey(dbName, instanceArray[i]));
            String[] instEnvs = this.m_ocr.getKeyValues(this.getTreeDefinition().getInstanceEnvKey(dbName, instanceArray[i]));
            Instance inst = new Instance(instanceArray[i], nodeName, instEnvs, instEnabled);
            instances.addElement(inst);
        }
        return instances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addDatabaseConfiguration(ParallelServerConfig config) throws OCRException {
        String dbName = config.getName();
        String dbRootKey = this.getTreeDefinition().getDBRootKey();
        Trace.out("Adding database " + dbName);
        Trace.out("Acquiring exclusive CSS lock SRVM." + dbRootKey);
        try {
            this.m_clusterLock.acquire("SRVM." + dbRootKey);
        }
        catch (ClusterLockException e) {
            throw new OCRException(e.getMessage());
        }
        try {
            this.writeDatabaseConfiguration(config, false);
        }
        finally {
            Trace.out("Releasing exclusive CSS lock SRVM." + dbRootKey);
            try {
                this.m_clusterLock.release("SRVM." + dbRootKey);
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
        }
        Trace.out("returning from addDatabaseConfiguration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDatabaseConfiguration(ParallelServerConfig config) throws OCRException {
        String dbName = config.getName();
        String dbKey = this.getTreeDefinition().getDBKey(dbName);
        Trace.out(this.getClass().getName() + ".setDatabaseConfiguration: Came in for " + dbKey);
        Trace.out("Acquiring exclusive CSS lock SRVM." + dbKey);
        try {
            this.m_clusterLock.acquire("SRVM." + dbKey);
        }
        catch (ClusterLockException e) {
            throw new OCRException(e.getMessage());
        }
        try {
            this.writeDatabaseConfiguration(config, true);
        }
        finally {
            Trace.out("Releasing exclusive CSS lock SRVM." + dbKey);
            try {
                this.m_clusterLock.release("SRVM." + dbKey);
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
        }
    }

    protected synchronized void writeDatabaseConfiguration(ParallelServerConfig config, boolean purge) throws OCRException {
        boolean bLog = true;
        String dbName = config.getName();
        String dbKey = this.getTreeDefinition().getDBKey(dbName);
        String logDbKey = this.getTreeDefinition().getDBKey(dbName, bLog);
        Trace.out("OCRTree.writeDatabaseConfiguration: Came in for " + dbKey);
        if (purge && !bLog) {
            this.m_ocr.deleteKey(dbKey, true);
        }
        this.m_ocr.deleteKey(logDbKey, true);
        try {
            Trace.out("creating db key " + dbKey);
            this.m_ocr.setKeyValue(logDbKey, dbName, 1, null, config.getOracleHome());
            this.m_ocr.setKeyValue(this.getTreeDefinition().getDBOHomeKey(dbName, bLog), config.getOracleHome(), 2, logDbKey, config.getOracleHome());
            this.m_ocr.setKeyValue(this.getTreeDefinition().getDBDomainKey(dbName, bLog), config.getDomain(), 2, logDbKey, config.getOracleHome());
            this.m_ocr.setKeyValue(this.getTreeDefinition().getDBSPFileKey(dbName, bLog), config.getSPFile(), 2, logDbKey, config.getOracleHome());
            this.setDatabaseInstances(config, bLog);
            this.m_ocr.setKeyValues(this.getTreeDefinition().getDBEnvKey(dbName, bLog), config.getEnvironment(), 2, logDbKey, config.getOracleHome());
            this.m_ocr.moveKey(logDbKey, this.getTreeDefinition().getDBRootKey(), this.getTreeDefinition().getDBKey(dbName).substring(this.getTreeDefinition().getDBRootKey().length() + 1), 1);
            Trace.out("OCRTreeHA.writeDatabaseConfiguration done");
        }
        catch (OCRException e) {
            this.m_ocr.deleteKey(logDbKey, true);
            throw e;
        }
    }

    protected synchronized void setDatabaseInstances(ParallelServerConfig config, boolean bLog) throws OCRException {
        String dbName = config.getName();
        Vector instances = config.getInstances();
        for (int i = 0; i < instances.size(); ++i) {
            Instance inst = (Instance)instances.elementAt(i);
            String instName = inst.getName();
            this.m_ocr.setKeyValue(this.getTreeDefinition().getInstanceNodeKey(dbName, instName, bLog), inst.getNode(), 2, this.getTreeDefinition().getDBKey(dbName, bLog), config.getOracleHome());
            this.m_ocr.setKeyValues(this.getTreeDefinition().getInstanceEnvKey(dbName, instName, bLog), inst.getEnv(), 2, this.getTreeDefinition().getDBKey(dbName, bLog), config.getOracleHome());
        }
    }

    public synchronized void removeDatabaseConfiguration(String dbName) throws OCRException {
        this.removeDatabaseConfiguration(dbName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void removeDatabaseConfiguration(String dbName, boolean log) throws OCRException {
        String dbKey = this.getTreeDefinition().getDBKey(dbName);
        String dbRootKey = this.getTreeDefinition().getDBRootKey();
        Trace.out("in removeDatabaseConfiguration");
        if (log) {
            Trace.out("Acquiring exclusive CSS lock " + dbRootKey);
            try {
                this.m_clusterLock.acquire("SRVM." + dbRootKey);
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
        }
        try {
            Trace.out("deleting db key " + dbKey);
            this.m_ocr.deleteKey(dbKey, true);
        }
        finally {
            if (log) {
                Trace.out("Releasing exclusive CSS lock SRVM." + dbRootKey);
                try {
                    this.m_clusterLock.release("SRVM." + dbRootKey);
                }
                catch (ClusterLockException e) {
                    throw new OCRException(e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String[] listDatabases() throws OCRException {
        String dbRootKey = this.getTreeDefinition().getDBRootKey();
        Trace.out("Acquiring shared CSS lock SRVM." + dbRootKey);
        try {
            this.m_clusterLock.acquireShared("SRVM." + dbRootKey);
        }
        catch (ClusterLockException e) {
            throw new OCRException(e.getMessage());
        }
        try {
            if (this.m_ocr.keyExists(this.getTreeDefinition().getDBRootKey())) {
                String[] stringArray = this.m_ocr.listSubKeys(this.getTreeDefinition().getDBRootKey());
                return stringArray;
            }
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            Trace.out("Releasing shared CSS lock SRVM." + dbRootKey);
            try {
                this.m_clusterLock.release("SRVM." + dbRootKey);
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String[] listOracleHomes() throws OCRException {
        Object[] oracleHomes = null;
        String[] databases = this.listDatabases();
        if (databases != null) {
            String dbRootKey = this.getTreeDefinition().getDBRootKey();
            Trace.out("Acquiring shared CSS lock SRVM." + dbRootKey);
            try {
                this.m_clusterLock.acquireShared("SRVM." + dbRootKey);
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
            try {
                Vector<String> oHomes = new Vector<String>(databases.length);
                String oHome = null;
                for (int i = 0; i < databases.length; ++i) {
                    oHome = this.m_ocr.getKeyValue(this.getTreeDefinition().getDBOHomeKey(databases[i]));
                    if (oHome == null) continue;
                    String dbVer = this.m_ocr.getKeyValue(this.getTreeDefinition().getDBVersionKey(databases[i]));
                    Trace.out("non-HA dbVER = " + dbVer);
                    if (dbVer != null) continue;
                    oHomes.addElement(oHome);
                }
                if (oHomes.size() > 0) {
                    oracleHomes = new String[oHomes.size()];
                    oHomes.copyInto(oracleHomes);
                }
            }
            finally {
                Trace.out("Releasing shared CSS lock SRVM." + dbRootKey);
                try {
                    this.m_clusterLock.release("SRVM." + dbRootKey);
                }
                catch (ClusterLockException e) {
                    throw new OCRException(e.getMessage());
                }
            }
        }
        return oracleHomes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDatabaseConfigured(String dbName, String dbDomain) throws OCRException {
        String dbRootKey = this.getTreeDefinition().getDBRootKey();
        Trace.out("Acquiring shared CSS lock SRVM." + dbRootKey);
        try {
            this.m_clusterLock.acquireShared("SRVM." + dbRootKey);
        }
        catch (ClusterLockException e) {
            throw new OCRException(e.getMessage());
        }
        OCRTreeDefinition ocrTreeDef = new OCRTreeDefinition();
        try {
            if (this.m_ocr.keyExists(this.getTreeDefinition().getDBKey(dbName))) {
                if (dbDomain == null) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = dbDomain.equalsIgnoreCase(this.m_ocr.getKeyValue(this.getTreeDefinition().getDBDomainKey(dbName)));
                return bl;
            }
            if (this.m_ocr.keyExists(ocrTreeDef.getDBKey(dbName))) {
                if (dbDomain == null) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = dbDomain.equalsIgnoreCase(this.m_ocr.getKeyValue(ocrTreeDef.getDBDomainKey(dbName)));
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Trace.out("Releasing shared CSS lock SRVM." + dbRootKey);
            try {
                this.m_clusterLock.release("SRVM." + dbRootKey);
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
        }
    }

    protected synchronized void printParallelServerConfig(ParallelServerConfig config) {
        String name = config.getName();
        Trace.out("Printing content of database name=" + name);
        Trace.out("domain=" + config.getDomain());
        Trace.out("oraclehome=" + config.getOracleHome());
        Trace.out("spfile=" + config.getSPFile());
        Trace.out("enabled=" + config.isEnabled());
        String[] envs = config.getEnvironment();
        if (envs != null) {
            for (int i = 0; i < envs.length; ++i) {
                Trace.out("envs: " + envs[i]);
            }
        }
        Trace.out("Finishing printing content of database name=" + name);
    }

    private synchronized Vector getDatabaseServices(String dbKey) throws OCRException {
        Trace.out("**WARNING** Running EMPTY OCRTree method");
        return null;
    }

    protected synchronized void setDatabaseServices(ParallelServerConfig config) throws OCRException {
        Trace.out("**WARNING** Running EMPTY OCRTree method");
    }

    public void enableDisableDatabaseService(ParallelServerConfig config, ServiceComposite sc, boolean log) throws OCRException {
    }

    public void enableDisableDatabaseServiceInstance(ParallelServerConfig config, ServiceComposite sc, ServiceInstance servInst, boolean log) throws OCRException {
    }

    public synchronized VIPRangeConfiguration[] getVIPRangeConfigurations() throws OCRException {
        Trace.out("**WARNING** Running EMPTY OCRTree method");
        return null;
    }

    public synchronized VIPRangeConfiguration getVIPRangeConfiguration(String type) throws OCRException {
        Trace.out("**WARNING** Running EMPTY OCRTree method");
        return null;
    }

    public synchronized void setVIPRangeConfigurations(VIPRangeConfiguration[] vrConfigs) throws OCRException {
        Trace.out("**WARNING** Running EMPTY OCRTree method");
    }

    public synchronized void setVIPRangeConfiguration(VIPRangeConfiguration vrConfig) throws OCRException {
        Trace.out("**WARNING** Running EMPTY OCRTree method");
    }

    public synchronized void removeVIPRangeConfiguration(boolean flag) throws OCRException {
        Trace.out("**WARNING** Running EMPTY OCRTree method");
    }

    public synchronized NodeConfiguration getNodeConfiguration(String nodeName) throws OCRException {
        Trace.out("**WARNING** Running EMPTY OCRTree method");
        return null;
    }

    public synchronized void setNodeConfiguration(NodeConfiguration nodeConfig) throws OCRException {
        Trace.out("**WARNING** Running EMPTY OCRTree method");
    }

    public synchronized void removeNodeConfiguration(String nodeName, boolean flag) throws OCRException {
        Trace.out("**WARNING** Running EMPTY OCRTree method");
    }

    public synchronized String[] listNodes() throws OCRException {
        Trace.out("**WARNING** Running EMPTY OCRTree method");
        return null;
    }

    public void addInstance(String dbName, String instName, String nodeName) throws OCRException {
        boolean bLog = true;
        String dbKey = this.getTreeDefinition().getDBKey(dbName);
        boolean instKeyCreated = false;
        try {
            this.m_clusterLock.acquire("SRVM." + dbKey);
        }
        catch (ClusterLockException e) {
            throw new OCRException(e.getMessage());
        }
        try {
            String oHome = this.m_ocr.getKeyValue(this.getTreeDefinition().getDBOHomeKey(dbName));
            this.m_ocr.deleteKey(this.getTreeDefinition().getDBInstanceNameKey(dbName, instName, bLog), true);
            this.m_ocr.setKeyValue(this.getTreeDefinition().getInstanceNodeKey(dbName, instName, bLog), nodeName, 2, this.getTreeDefinition().getLogRootKey(), oHome);
            this.m_ocr.createKey(this.getTreeDefinition().getInstanceEnvKey(dbName, instName, bLog), 2, this.getTreeDefinition().getDBKey(dbName, bLog), oHome);
            if (!this.m_ocr.keyExists(this.getTreeDefinition().getDBInstanceKey(dbName))) {
                this.m_ocr.createKey(this.getTreeDefinition().getDBInstanceKey(dbName), 2, this.getTreeDefinition().getDBKey(dbName), oHome);
                instKeyCreated = true;
            }
            this.m_ocr.moveKey(this.getTreeDefinition().getDBInstanceNameKey(dbName, instName, bLog), this.getTreeDefinition().getDBInstanceKey(dbName), this.getTreeDefinition().getDBInstanceNameKey(dbName, instName).substring(this.getTreeDefinition().getDBInstanceKey(dbName).length() + 1), 1);
        }
        catch (OCRException e) {
            if (instKeyCreated) {
                try {
                    this.m_ocr.deleteKey(this.getTreeDefinition().getDBInstanceKey(dbName), false);
                }
                catch (OCRException e2) {
                    Trace.out(e2);
                }
            }
            this.m_ocr.deleteKey(this.getTreeDefinition().getDBInstanceNameKey(dbName, instName, bLog), true);
            throw e;
        }
        finally {
            Trace.out("Releasing shared CSS lock SRVM." + dbKey);
            try {
                this.m_clusterLock.release("SRVM." + dbKey);
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstance(String dbName, String instName) throws OCRException {
        String dbKey = this.getTreeDefinition().getDBKey(dbName);
        try {
            this.m_clusterLock.acquire("SRVM." + dbKey);
        }
        catch (ClusterLockException e) {
            throw new OCRException(e.getMessage());
        }
        try {
            this.m_ocr.deleteKey(this.getTreeDefinition().getDBInstanceNameKey(dbName, instName), true);
        }
        finally {
            Trace.out("Releasing shared CSS lock SRVM." + dbKey);
            try {
                this.m_clusterLock.release("SRVM." + dbKey);
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
        }
    }

    public void renameInstance(String dbName, String oldInstName, String newInstName) throws OCRException {
        String dbKey = this.getTreeDefinition().getDBKey(dbName);
        boolean bMoved = false;
        boolean bUpdated = false;
        try {
            this.m_clusterLock.acquire("SRVM." + dbKey);
        }
        catch (ClusterLockException e) {
            throw new OCRException(e.getMessage());
        }
        try {
            String oHome = this.m_ocr.getKeyValue(this.getTreeDefinition().getDBOHomeKey(dbName));
            this.m_ocr.moveKey(this.getTreeDefinition().getDBInstanceNameKey(dbName, oldInstName), this.getTreeDefinition().getDBInstanceKey(dbName), this.getTreeDefinition().getDBInstanceNameKey(dbName, newInstName).substring(this.getTreeDefinition().getDBInstanceKey(dbName).length() + 1), 1);
            bMoved = true;
            if (this.getTreeDefinition() instanceof OCRTreeDefinitionHA) {
                this.m_ocr.setKeyValue(this.getTreeDefinition().getDBInstanceNameKey(dbName, newInstName), newInstName, 1, null, oHome);
            }
            bUpdated = true;
        }
        catch (OCRException e) {
            if (bMoved && !bUpdated) {
                this.m_ocr.moveKey(this.getTreeDefinition().getDBInstanceNameKey(dbName, newInstName), this.getTreeDefinition().getDBInstanceKey(dbName), this.getTreeDefinition().getDBInstanceNameKey(dbName, oldInstName).substring(this.getTreeDefinition().getDBInstanceKey(dbName).length() + 1), 1);
            }
            throw e;
        }
        finally {
            Trace.out("Releasing shared CSS lock SRVM." + dbKey);
            try {
                this.m_clusterLock.release("SRVM." + dbKey);
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveInstance(String dbName, String instName, String nodeName) throws OCRException {
        String dbKey = this.getTreeDefinition().getDBKey(dbName);
        String oHome = this.m_ocr.getKeyValue(this.getTreeDefinition().getDBOHomeKey(dbName));
        try {
            this.m_clusterLock.acquire("SRVM." + dbKey);
        }
        catch (ClusterLockException e) {
            throw new OCRException(e.getMessage());
        }
        try {
            this.m_ocr.setKeyValue(this.getTreeDefinition().getInstanceNodeKey(dbName, instName), nodeName, 2, dbKey, oHome);
        }
        finally {
            Trace.out("Releasing shared CSS lock SRVM." + dbKey);
            try {
                this.m_clusterLock.release("SRVM." + dbKey);
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDBConfiguration(String dbName) throws OCRException {
        String dbRootKey = this.getTreeDefinition().getDBRootKey();
        String dbKey = this.getTreeDefinition().getDBKey(dbName);
        try {
            this.m_clusterLock.acquire("SRVM." + dbRootKey);
        }
        catch (ClusterLockException e) {
            throw new OCRException(e.getMessage());
        }
        try {
            this.m_ocr.deleteKey(dbKey, true);
        }
        finally {
            Trace.out("Releasing shared CSS lock SRVM." + dbRootKey);
            try {
                this.m_clusterLock.release("SRVM." + dbRootKey);
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
        }
    }

    public void setDBEnvironment(String dbName, String[] envName, String[] envValue) throws OCRException {
        ParallelServerConfig opsConfig;
        if (envName != null) {
            for (int i = 0; i < envName.length; ++i) {
                Trace.out("env[" + i + "]: " + envName[i] + "=" + envValue[i]);
            }
        }
        if ((opsConfig = this.getDatabaseConfiguration(dbName)) == null) {
            Object[] args = new Object[]{dbName};
            String msg = s_rawMsgBundle.getMessage("1001", true, args);
            throw new OCRException(msg);
        }
        String[] oraEnv = opsConfig.getEnvironment();
        boolean[] bExists = new boolean[envName.length];
        Vector<String> envVector = new Vector<String>();
        if (oraEnv != null) {
            Trace.out("setEnv: oraEnv length=" + oraEnv.length);
            for (int i = 0; i < oraEnv.length; ++i) {
                StringTokenizer st = new StringTokenizer(oraEnv[i], "=");
                if (st == null || !st.hasMoreTokens()) continue;
                String environName = st.nextToken();
                for (int j = 0; j < envName.length; ++j) {
                    if (envName[j].compareTo(environName) != 0) continue;
                    oraEnv[i] = environName + "=" + envValue[j];
                    Trace.out("setEnv: oraEnv[" + i + "] =" + oraEnv[i]);
                    bExists[j] = true;
                    break;
                }
                envVector.addElement(oraEnv[i]);
            }
        }
        for (int k = 0; k < envName.length; ++k) {
            if (bExists[k]) continue;
            envVector.addElement(envName[k] + "=" + envValue[k]);
        }
        envVector.trimToSize();
        String[] newOraEnv = new String[envVector.size()];
        for (int i = 0; i < envVector.size(); ++i) {
            newOraEnv[i] = (String)envVector.elementAt(i);
        }
        opsConfig.setEnvironment(newOraEnv);
        this.setDBEnvironment(dbName, opsConfig);
    }

    public void unsetDBEnvironment(String dbName, String[] envName) throws OCRException {
        String[] newOraEnv;
        int i;
        ParallelServerConfig opsConfig = this.getDatabaseConfiguration(dbName);
        if (opsConfig == null) {
            Object[] args = new Object[]{dbName};
            String msg = s_rawMsgBundle.getMessage("1001", true, args);
            throw new OCRException(msg);
        }
        String[] oraEnv = opsConfig.getEnvironment();
        boolean bExists = false;
        Vector<String> envVector = new Vector<String>();
        if (oraEnv != null) {
            Trace.out("unsetEnv: oraEnv length=" + oraEnv.length);
            for (i = 0; i < oraEnv.length; ++i) {
                bExists = false;
                StringTokenizer st = new StringTokenizer(oraEnv[i], "=");
                if (st == null || !st.hasMoreTokens()) continue;
                String environName = st.nextToken();
                Trace.out("unsetEnv: existing env name: " + environName);
                for (int j = 0; j < envName.length; ++j) {
                    if (environName.compareTo(envName[j]) != 0) continue;
                    bExists = true;
                    break;
                }
                if (bExists) continue;
                envVector.addElement(oraEnv[i]);
            }
        }
        envVector.trimToSize();
        for (i = 0; i < envVector.size(); ++i) {
            Trace.out("envVector.elementAt(" + i + ")=" + envVector.elementAt(i));
        }
        if (envVector.size() != oraEnv.length) {
            newOraEnv = new String[envVector.size()];
            for (int i2 = 0; i2 < envVector.size(); ++i2) {
                newOraEnv[i2] = (String)envVector.elementAt(i2);
            }
        } else {
            String msg = s_rawMsgBundle.getMessage("1057", true);
            throw new OCRException(msg);
        }
        opsConfig.setEnvironment(newOraEnv);
        this.setDBEnvironment(dbName, opsConfig);
    }

    public void setInstanceEnvironment(String dbName, String instName, String[] envName, String[] envValue) throws OCRException {
        ParallelServerConfig opsConfig;
        if (envName != null) {
            for (int i = 0; i < envName.length; ++i) {
                Trace.out("env[" + i + "]: " + envName[i] + "=" + envValue[i]);
            }
        }
        if ((opsConfig = this.getDatabaseConfiguration(dbName)) == null) {
            Object[] args = new Object[]{dbName};
            String msg = s_rawMsgBundle.getMessage("1001", true, args);
            throw new OCRException(msg);
        }
        Instance instance = opsConfig.getInstance(instName);
        if (instance == null) {
            Object[] args = new Object[]{instName, dbName};
            String msg = s_rawMsgBundle.getMessage("1003", true, args);
            throw new OCRException(msg);
        }
        String[] instEnv = instance.getEnv();
        boolean[] bExists = new boolean[envName.length];
        Vector<String> envVector = new Vector<String>();
        if (instEnv != null) {
            Trace.out("setEnv: instEnv length=" + instEnv.length);
            for (int i = 0; i < instEnv.length; ++i) {
                Trace.out("setEnv: instEnv[" + i + "] = " + instEnv[i]);
                StringTokenizer st = new StringTokenizer(instEnv[i], "=");
                if (st == null || !st.hasMoreTokens()) continue;
                String environName = st.nextToken();
                Trace.out("setEnv: environName = " + environName);
                for (int j = 0; j < envName.length; ++j) {
                    if (envName[j].compareTo(environName) != 0) continue;
                    instEnv[i] = environName + "=" + envValue[j];
                    Trace.out("setEnv: instEnv[" + i + "] =" + instEnv[i]);
                    bExists[j] = true;
                    break;
                }
                envVector.addElement(instEnv[i]);
                Trace.out("setEnv: instEnv[" + i + "] =" + instEnv[i]);
            }
        }
        for (int k = 0; k < envName.length; ++k) {
            if (bExists[k]) continue;
            envVector.addElement(envName[k] + "=" + envValue[k]);
        }
        envVector.trimToSize();
        String[] newEnv = new String[envVector.size()];
        for (int i = 0; i < envVector.size(); ++i) {
            newEnv[i] = (String)envVector.elementAt(i);
        }
        instance.setEnv(newEnv);
        opsConfig.setInstance(instance);
        this.setInstanceEnvironment(dbName, instName, instance, opsConfig.getOracleHome());
    }

    public void unsetInstanceEnvironment(String dbName, String instName, String[] envName) throws OCRException {
        String[] newEnv;
        ParallelServerConfig opsConfig = this.getDatabaseConfiguration(dbName);
        if (opsConfig == null) {
            Object[] args = new Object[]{dbName};
            String msg = s_rawMsgBundle.getMessage("1001", true, args);
            throw new OCRException(msg);
        }
        Instance instance = opsConfig.getInstance(instName);
        if (instance == null) {
            Object[] args = new Object[]{instName, dbName};
            String msg = s_rawMsgBundle.getMessage("1003", true, args);
            throw new OCRException(msg);
        }
        String[] instEnv = instance.getEnv();
        boolean bExists = false;
        boolean envChanged = false;
        Vector<String> envVector = new Vector<String>();
        if (instEnv != null) {
            Trace.out("unsetEnv: instEnv length=" + instEnv.length);
            for (int i = 0; i < instEnv.length; ++i) {
                bExists = false;
                StringTokenizer st = new StringTokenizer(instEnv[i], "=");
                if (st == null || !st.hasMoreTokens()) continue;
                String environName = st.nextToken();
                for (int j = 0; j < envName.length; ++j) {
                    if (environName.compareTo(envName[j]) != 0) continue;
                    bExists = true;
                    envChanged = true;
                    break;
                }
                if (bExists) continue;
                envVector.addElement(instEnv[i]);
            }
        }
        if (envChanged) {
            Trace.out("envVector =" + envVector.toString());
            envVector.trimToSize();
            Trace.out("envVector size=" + envVector.size());
            newEnv = new String[envVector.size()];
            for (int i = 0; i < envVector.size(); ++i) {
                newEnv[i] = (String)envVector.elementAt(i);
            }
        } else {
            String msg = s_rawMsgBundle.getMessage("1057", true);
            throw new OCRException(msg);
        }
        instance.setEnv(newEnv);
        opsConfig.setInstance(instance);
        this.setInstanceEnvironment(dbName, instName, instance, opsConfig.getOracleHome());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInstanceEnvironment(String dbName, String instName, Instance instance, String oHome) throws OCRException {
        String dbKey = this.getTreeDefinition().getDBKey(dbName);
        try {
            this.m_clusterLock.acquire("SRVM." + dbKey);
        }
        catch (ClusterLockException e) {
            throw new OCRException(e.getMessage());
        }
        try {
            this.m_ocr.setKeyValues(this.getTreeDefinition().getInstanceEnvKey(dbName, instName), instance.getEnv(), 2, dbKey, oHome);
        }
        finally {
            Trace.out("Releasing shared CSS lock SRVM." + dbKey);
            try {
                this.m_clusterLock.release("SRVM." + dbKey);
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDBEnvironment(String dbName, ParallelServerConfig opsConfig) throws OCRException {
        String dbKey = this.getTreeDefinition().getDBKey(dbName);
        try {
            this.m_clusterLock.acquire("SRVM." + dbKey);
        }
        catch (ClusterLockException e) {
            throw new OCRException(e.getMessage());
        }
        try {
            this.m_ocr.setKeyValues(this.getTreeDefinition().getDBEnvKey(dbName), opsConfig.getEnvironment(), 2, dbKey, opsConfig.getOracleHome());
        }
        finally {
            Trace.out("Releasing shared CSS lock SRVM." + dbKey);
            try {
                this.m_clusterLock.release("SRVM." + dbKey);
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
        }
    }

    public void setDBEnableDisable(String dbName, Boolean enableDisable) throws OCRException {
    }

    public void setDBEnableDisable(String dbName, Boolean enableDisable, String policy, String priorPolicy) throws OCRException {
    }

    public void setInstanceEnableDisable(String dbName, String instName, Boolean enableDisable) throws OCRException {
    }

    public void setDatabaseService(ParallelServerConfig config, ServiceComposite sc, boolean log) throws OCRException {
    }

    public void removeDatabaseService(ParallelServerConfig config, ServiceComposite sc) throws OCRException {
    }

    public String getKeyValue(String keyName) throws OCRException {
        return this.m_ocr.getKeyValue(keyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDBOracleHome(String dbUniqueName, String ohome) throws OCRException {
        String dbKey = this.getTreeDefinition().getDBKey(dbUniqueName);
        try {
            this.m_clusterLock.acquire("SRVM." + dbKey);
        }
        catch (ClusterLockException e) {
            throw new OCRException(e.getMessage());
        }
        try {
            String dbVersion = this.m_ocr.keyExists(this.getTreeDefinition().getDBVersionKey(dbUniqueName)) ? this.m_ocr.getKeyValue(this.getTreeDefinition().getDBVersionKey(dbUniqueName)) : null;
            if (!this.m_version.toString().equals(dbVersion)) {
                Trace.out(dbKey + " incompatible version");
                Object[] args = new String[]{dbUniqueName, dbVersion, ohome};
                throw new OCRException(s_rawMsgBundle.getMessage("1078", true, args));
            }
            this.m_ocr.setKeyValue(this.getTreeDefinition().getDBOHomeKey(dbUniqueName), ohome, 2, dbKey, ohome);
        }
        finally {
            Trace.out("Releasing exclusive lock SRVM." + dbKey);
            try {
                this.m_clusterLock.release("SRVM." + dbKey);
            }
            catch (ClusterLockException e) {
                throw new OCRException(e.getMessage());
            }
        }
    }

    public String[] getKeyValues(String keyName) throws OCRException {
        return this.m_ocr.getKeyValues(keyName);
    }

    public boolean keyExists(String keyName) throws OCRException {
        return this.m_ocr.keyExists(keyName);
    }

    public String getUserName(String key) throws OCRException {
        return this.m_ocr.getUserName(key);
    }

    static {
        s_instanceTable = new Hashtable();
        s_version = new Version();
    }
}

