/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.rawdevice;

import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.cluster.util.SRVMContext;
import oracle.cluster.util.SRVMContextException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.OCRNative;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.rawdevice.OCRKeyLiterals;
import oracle.ops.mgmt.rawdevice.OCRResult;
import oracle.ops.mgmt.rawdevice.RawDeviceConstants;
import oracle.ops.mgmt.trace.Trace;

public class OCR
implements RawDeviceConstants,
OCRKeyLiterals {
    public static final int OCRJ_PROCR_INSTALL_LEVEL = 0;
    public static final int OCRJ_PROCR_CACHING_LEVEL = 1;
    public static final int OCRJ_PROCR_REBOOT_LEVEL = 2;
    public static final int OCRJ_PROCR_DEFAULT_LEVEL = 3;
    public static final int OCRJ_PROCR_FORMAT_LEVEL = 4;
    public static final int OCRJ_PROCR_UPGRADE_LEVEL = 5;
    public static final int OCRJ_PROCR_DEFAULT_MT_LEVEL = 7;
    public static final int OCRJ_PROCR_SUCCESS = 0;
    public static final int OCRJ_PROCR_INVALID_LEVEL = 1;
    public static final int OCRJ_PROCR_INCONSISTENT_LEVEL = 2;
    public static final int OCRJ_PROCR_INVALID_CONTEXT = 3;
    public static final int OCRJ_PROCR_KEY_NOT_EXISTING = 4;
    public static final int OCRJ_PROCR_NO_PERMISSION = 5;
    public static final int OCRJ_PROCR_UNAUTHORIZED_USER = 6;
    public static final int OCRJ_PROCR_INVALID_HANDLE = 7;
    public static final int OCRJ_PROCR_INVALID_PARAMETER = 8;
    public static final int OCRJ_PROCR_BUF_TOO_SMALL = 9;
    public static final int OCRJ_PROCR_SUBKEY_EXISTS = 10;
    public static final int OCRJ_PROCR_NULL_KEY_NAME = 11;
    public static final int OCRJ_PROCR_NO_MEM = 12;
    public static final int OCRJ_PROCR_NULL_PARAMATER = 13;
    public static final int OCRJ_PROCR_UNKNOWN_ERROR = 14;
    public static final int OCRJ_PROCR_INIT_ERROR = 15;
    public static final int OCRJ_PROCR_NO_MORE_KEYS = 16;
    public static final int OCRJ_PROCR_NOT_IMPLEMENTED = 17;
    public static final int OCRJ_PROCR_VALUE_TOO_LARGE = 18;
    public static final int OCRJ_PROCR_MAX_SUBKEYS_EXIST = 19;
    public static final int OCRJ_PROCR_NO_ORACLE_HOME = 20;
    public static final int OCRJ_PROCR_MAX_KEY_DEPTH_REACHED = 21;
    public static final int OCRJ_PROCR_INVALID_FORMAT = 22;
    public static final int OCRJ_PROCR_CSS_ERROR = 23;
    public static final int OCRJ_PROCR_CLSC_ERROR = 24;
    public static final int OCRJ_PROCR_NLS_ERROR = 25;
    public static final int OCRJ_PROCR_IO_ERROR = 26;
    public static final int OCRJ_PROCR_SCLS_ERROR = 27;
    public static final int OCRJ_PROCR_CURRENT_VERSION = 28;
    public static final int OCRJ_PROCR_CLSD_ERROR = 29;
    public static final int OCRJ_PROCR_LOC_MISCONFIG_ERROR = 30;
    public static final int OCRJ_PROCR_STORAGE_TOO_SMALL = 31;
    public static final int OCRJ_PROCR_NO_LOCAL_SERVER = 32;
    public static final int OCRJ_PROCR_NO_CONFIG = 33;
    public static final int OCRJ_PROCR_INCOMPATIBLE_CONFIG = 34;
    public static final int OCRJ_PROCR_INVALID_VERSION = 35;
    public static final int OCRJ_PROCR_NO_FREE_SPACE = 36;
    public static final int OCRJ_PROCR_UB4_DTYPE = 1;
    public static final int OCRJ_PROCR_UBIG_ORA_DTYPE = 2;
    public static final int OCRJ_PROCR_STRING_DTYPE = 3;
    public static final int OCRJ_PROCR_MULTI_STRING_DTYPE = 4;
    public static final int OCRJ_PROCR_BINARY_DTYPE = 5;
    public static final int OCRJ_PROCR_FLAGS_NONE = 0;
    public static final int OCRJ_PROCR_FLAGS_DELETE_TGT = 1;
    public static final String OCRJ_PROCR_KEY_EXISTS = "OCR_KEY_ALREADY_EXISTS";
    public static final String OCRJ_PROCR_KEY_NONEXIST = "OCR_KEY_NONEXISTENCE";
    public static final int OCRJ_DATABASES_SECURITY = 1;
    public static final int OCRJ_DATABASES_DB_SECURITY = 2;
    public static final int OCRJ_NODEAPPS_SECURITY = 3;
    public static final int OCRJ_WLM_SECURITY = 3;
    public static final int OCRJ_VIPRANGE_SECURITY = 4;
    public static final int OCRJ_DEFAULT_SECURITY = 5;
    public static final int OCRJ_LOG_SECURITY = 6;
    private int m_ocrError = 0;
    private String m_openedKeyName = null;
    private static OCR s_instance = null;
    private String m_groupName = null;
    private String m_oraGrpName = null;
    private Util m_util = null;
    private Version m_version;
    private static MessageBundle s_rawMsgBundle = MessageBundle.getMessageBundle("Prkr");

    private OCR(int initializeLevel, Version version) throws OCRException {
        Trace.out("Called into OCR.java Constructor: level =" + initializeLevel);
        OCR.loadLibrary();
        try {
            SRVMContext ctx = SRVMContext.getInstance();
            ctx.init();
        }
        catch (SRVMContextException sce) {
            Trace.out(sce.getMessage());
            throw new OCRException(sce.getMessage());
        }
        OCRResult result = new OCRResult();
        if (Trace.isNativeDebug()) {
            result.setNativeDebugFlag(true);
        } else {
            result.setNativeDebugFlag(false);
        }
        Trace.out("Calling Native function");
        OCRNative.initializeOCRLevel(initializeLevel, result);
        Trace.out("Returned after initializing OCR");
        if (!result.getStatus()) {
            this.m_ocrError = result.getOCRErrCode();
            Trace.out("ocr Error code = " + this.m_ocrError);
            throw new OCRException(result.getNativeResultString(), this.m_ocrError);
        }
        this.m_version = version;
        try {
            this.m_util = new Util();
            this.m_groupName = this.m_util.getCurrentUserPrimaryGroup();
            Trace.out("Primary Group of Current User: " + this.m_groupName);
        }
        catch (UtilException ue) {
            Trace.out("OCR.java: Could not get the groupname ");
        }
    }

    public static synchronized OCR init(int initializeLevel) throws OCRException {
        return OCR.init(initializeLevel, new Version());
    }

    public static synchronized OCR init(int initializeLevel, Version version) throws OCRException {
        if (s_instance == null) {
            Trace.out("OCR instance is not present");
            s_instance = new OCR(initializeLevel, version);
        } else {
            Trace.out("Resetting OCR access version");
            s_instance.setVersion(version);
        }
        return s_instance;
    }

    private void setVersion(Version v) {
        this.m_version = v;
    }

    private static void loadLibrary() throws OCRException {
        Trace.out("\n Inside constructor of OCR");
        NativeSystem system = new SystemFactory().CreateSystem();
        try {
            if (!system.isOCRLibraryLoaded()) {
                Trace.out("Going to load the ocr library");
                system.loadOCRNativeLibrary();
                Trace.out("loaded ocr libraries");
            }
        }
        catch (NativeException ne) {
            Trace.out(ne);
            throw new OCRException(ne.getMessage());
        }
    }

    public void setOracleGrpName(String oracleHome) throws OCRException {
        this.m_oraGrpName = this.getOracleGroupName(oracleHome);
    }

    public void createKey(String key, int secType, String ancestorKeyName, String oracleHomeName) throws OCRException {
        Trace.out("OCR.createKey(" + key + ")");
        this.validateParams(key, secType, ancestorKeyName, oracleHomeName);
        String oracleUserName = null;
        String groupName = null;
        if (oracleHomeName != null) {
            oracleUserName = this.getOracleUserName(oracleHomeName);
            groupName = this.getOracleGroupName(oracleHomeName);
        }
        this.openTopLevelKey(key);
        OCRResult result = new OCRResult();
        OCRNative.createKey(key, secType, ancestorKeyName, oracleUserName, groupName, result);
        Trace.out("End of call to createkey");
        if (!result.getStatus()) {
            throw new OCRException(result.getNativeResultString());
        }
    }

    public void moveKey(String srcKey, String parentTargetKey, String targetKey, int flags) throws OCRException {
        Trace.out("OCR.moveKey srcKey=" + srcKey);
        Trace.out("OCR.moveKey parentTgtKey=" + parentTargetKey);
        Trace.out("OCR.moveKey tgtKey=" + targetKey);
        this.validateParams(srcKey);
        this.validateParams(parentTargetKey);
        this.validateParams(targetKey);
        OCRResult result = new OCRResult();
        OCRNative.moveKey(srcKey, parentTargetKey, targetKey, flags, result);
        Trace.out("moveKey status=" + result.getStatus());
        if (!result.getStatus()) {
            throw new OCRException(result.getNativeResultString());
        }
    }

    public void openKey(String key) throws OCRException {
        Trace.out("OCR.openKey(" + key + ")");
        this.validateParams(key);
        if (key.equals(this.m_openedKeyName)) {
            Trace.out("key [" + key + "] already opened");
            return;
        }
        if (this.m_openedKeyName != null) {
            this.closeKey();
        }
        OCRResult result = new OCRResult();
        OCRNative.openKey(key, result);
        Trace.out("End of call to openkey");
        if (!result.getStatus()) {
            throw new OCRException(result.getNativeResultString());
        }
        this.m_openedKeyName = key;
    }

    public String getOpenedKeyName() {
        return this.m_openedKeyName;
    }

    public void closeKey() throws OCRException {
        if (this.m_openedKeyName == null) {
            return;
        }
        Trace.out("OCR.closeKey(" + this.m_openedKeyName + ")");
        OCRResult result = new OCRResult();
        OCRNative.closeKey(result);
        Trace.out("End of call to closekey");
        if (!result.getStatus()) {
            throw new OCRException(result.getNativeResultString());
        }
        this.m_openedKeyName = null;
    }

    public String getKeyValue(String key) throws OCRException {
        Trace.out("OCR.getKeyValue(" + key + ")");
        this.validateParams(key);
        OCRResult result = new OCRResult();
        String value = OCRNative.getKeyValue(key, result);
        if (!result.getStatus()) {
            throw new OCRException(result.getNativeResultString());
        }
        return value;
    }

    public String[] getKeyValues(String key) throws OCRException {
        Trace.out("OCR.getKeyValues(" + key + ")");
        this.validateParams(key);
        Vector<String> valueVec = new Vector<String>();
        OCRResult result = new OCRResult();
        String[] values = OCRNative.getKeyValues(key, result);
        if (!result.getStatus()) {
            throw new OCRException(result.getNativeResultString());
        }
        if (values == null) {
            return null;
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            Trace.out("value[" + i + "]=[" + values[i] + "]");
            valueVec.addElement(values[i]);
        }
        Object[] retValuesArray = new String[valueVec.size()];
        valueVec.copyInto(retValuesArray);
        for (int i = 0; i < retValuesArray.length; ++i) {
            Trace.out("retValuesArray[" + i + "]=[" + (String)retValuesArray[i] + "]");
        }
        return retValuesArray;
    }

    public void setKeyValue(String key, String value, int secType, String ancestorKeyName, String oracleHomeName) throws OCRException {
        Trace.out("Creating key " + key);
        this.validateParams(key, secType, ancestorKeyName, oracleHomeName);
        String oracleUserName = null;
        String groupName = null;
        if (oracleHomeName != null) {
            oracleUserName = this.getOracleUserName(oracleHomeName);
            groupName = this.getOracleGroupName(oracleHomeName);
        }
        this.openTopLevelKey(key);
        OCRResult result = new OCRResult();
        String keyValue = value == null || value.length() == 0 ? "" : value;
        Trace.out("OCR.setKeyValue: calling OCRNative.setKeyValue");
        OCRNative.setKeyValue(key, keyValue, secType, ancestorKeyName, oracleUserName, groupName, result);
        if (!result.getStatus()) {
            throw new OCRException(result.getNativeResultString());
        }
        Trace.out("OCR.setKeyValue: returning from setKeyValue");
    }

    public void createAndSetKeyValue(String key, String value, int dataType, int secType, String ancestorKeyName, String oracleHomeName) throws OCRException {
        Trace.out("OCR.createAndSetKeyValue(" + key + ", " + value + ", " + dataType + ")");
        this.validateParams(key, secType, ancestorKeyName, oracleHomeName);
        String oracleUserName = null;
        String groupName = null;
        if (oracleHomeName != null) {
            oracleUserName = this.getOracleUserName(oracleHomeName);
            groupName = this.getOracleGroupName(oracleHomeName);
        }
        this.openTopLevelKey(key);
        if (dataType != 1 && dataType != 3 && dataType != 5) {
            Trace.out("\n Invalid datatype parameter passed to createAndSetKeyValue function");
            Object[] args = new String[]{"dataType=" + dataType, "createAndSetKeyValue"};
            throw new OCRException(s_rawMsgBundle.getMessage("1077", false, args));
        }
        OCRResult result = new OCRResult();
        String keyValue = value == null || value.length() == 0 ? "" : value;
        Trace.out("Call native createAndSetKeyValue(" + key + ", " + keyValue + ", " + dataType + ")");
        OCRNative.createAndSetKeyValue(key, keyValue, dataType, secType, ancestorKeyName, oracleUserName, groupName, result);
        if (!result.getStatus()) {
            throw new OCRException(result.getNativeResultString());
        }
        Trace.out("OCR.createAndSetKeyValue(" + key + ", " + keyValue + ") returning without errors");
    }

    public void setKeyValue(String key, String value, int dataType, int secType, String ancestorKeyName, String oracleHomeName) throws OCRException {
        Trace.out("OCR.setKeyValue(" + key + ", " + value + ", " + dataType + ")");
        this.validateParams(key, secType, ancestorKeyName, oracleHomeName);
        String oracleUserName = null;
        String groupName = null;
        if (oracleHomeName != null) {
            oracleUserName = this.getOracleUserName(oracleHomeName);
            groupName = this.getOracleGroupName(oracleHomeName);
        }
        this.openTopLevelKey(key);
        if (dataType != 1 && dataType != 3 && dataType != 5) {
            Trace.out("\n Invalid datatype parameter passed to  setKeyValue function");
            Object[] args = new String[]{"dataType=" + dataType, "setKeyValue"};
            throw new OCRException(s_rawMsgBundle.getMessage("1077", false, args));
        }
        OCRResult result = new OCRResult();
        String keyValue = value == null || value.length() == 0 ? "" : value;
        Trace.out("OCR.setKeyValue(" + key + ", " + keyValue + ", " + dataType + ")");
        OCRNative.setTypeKeyValue(key, keyValue, dataType, secType, ancestorKeyName, oracleUserName, groupName, result);
        if (!result.getStatus()) {
            throw new OCRException(result.getNativeResultString());
        }
        Trace.out("OCR.setKeyValue: returning from setKeyValue with datatype");
    }

    public void setKeyValues(String key, String[] values, int secType, String ancestorKeyName, String oracleHomeName) throws OCRException {
        Trace.out("OCR.setKeyValues(" + key + ", " + values + ")");
        this.validateParams(key, secType, ancestorKeyName, oracleHomeName);
        String oracleUserName = null;
        String groupName = null;
        if (oracleHomeName != null) {
            oracleUserName = this.getOracleUserName(oracleHomeName);
            groupName = this.getOracleGroupName(oracleHomeName);
        }
        this.openTopLevelKey(key);
        OCRResult result = new OCRResult();
        String[] keyValues = values == null ? new String[]{} : values;
        for (int i = 0; i < keyValues.length; ++i) {
            Trace.out("OCR.setKeyValues: keyValues[" + i + "]=[" + keyValues[i] + "]");
        }
        Trace.out("OCR.setKeyValues: calling OCRNative.setKeyValues");
        OCRNative.setKeyValues(key, keyValues, secType, ancestorKeyName, oracleUserName, groupName, result);
        if (!result.getStatus()) {
            throw new OCRException(result.getNativeResultString());
        }
        Trace.out("OCR.setKeyValues: returning from setKeyValues");
    }

    public void deleteKey(String key, boolean recursive) throws OCRException {
        Trace.out("OCR.deleteKey(" + key + ", " + recursive + ")");
        this.validateParams(key);
        OCRResult result = new OCRResult();
        OCRNative.deleteKey(key, recursive, result);
        if (!result.getStatus()) {
            throw new OCRException(result.getNativeResultString());
        }
    }

    public void linkKey(String key, String link) throws OCRException {
        Trace.out("OCR.linkKey(" + key + ", " + link + ")");
        this.validateParams(key);
        OCRResult result = new OCRResult();
        OCRNative.linkKey(key, link, result);
        if (!result.getStatus()) {
            throw new OCRException(result.getNativeResultString());
        }
    }

    public String[] listSubKeys(String key) throws OCRException {
        return this.listSubKeys(key, true);
    }

    public String[] listSubKeys(String key, boolean bListCP) throws OCRException {
        String[] subKeyVals;
        Trace.out("OCR.listSubKeys(" + key + ")");
        this.validateParams(key);
        OCRResult result = new OCRResult();
        String[] subKeys = OCRNative.listSubKeys(key, result);
        if (!result.getStatus()) {
            throw new OCRException(result.getNativeResultString());
        }
        if (!bListCP) {
            Trace.out("Returning with just the subkey names");
            return subKeys;
        }
        if (subKeys == null) {
            Trace.out("got null subKeys");
            subKeyVals = new String[]{};
        } else {
            Trace.out("got " + subKeys.length + " subKeys");
            subKeyVals = new String[subKeys.length];
            for (int i = 0; i < subKeys.length; ++i) {
                String keyVal = this.getKeyValue(key + "." + subKeys[i]);
                Trace.out("subKeys[" + i + "]=[" + subKeys[i] + "], val=[" + keyVal + "]");
                subKeyVals[i] = keyVal == null || keyVal.length() == 0 ? subKeys[i] : keyVal;
            }
        }
        return subKeyVals;
    }

    public boolean keyExists(String key) throws OCRException {
        this.validateParams(key);
        Trace.out("OCR.keyExists(" + key + ")");
        OCRResult result = new OCRResult();
        boolean exists = OCRNative.keyExists(key, result);
        if (!result.getStatus()) {
            throw new OCRException(result.getNativeResultString());
        }
        return exists;
    }

    public void copyRecurse(String sourceKey, String destKey, int secType) throws OCRException {
        Trace.out("OCR.copyRecurse(" + sourceKey + " , " + destKey);
        this.validateParams(sourceKey);
        OCRResult result = new OCRResult();
        OCRNative.copyRecurse(sourceKey, destKey, secType, result);
        Trace.out("End of call to copyRecurse");
        if (!result.getStatus()) {
            throw new OCRException(result.getNativeResultString());
        }
    }

    public static int checkOCRStorageType(String path) throws OCRException {
        OCR.loadLibrary();
        OCRResult result = new OCRResult();
        int retval = OCRNative.checkOCRStorageType(path, result);
        if (!result.getStatus()) {
            throw new OCRException(result.getNativeResultString());
        }
        return retval;
    }

    public String getUserName(String key) throws OCRException {
        Trace.out("OCR.getUserName(" + key + ")");
        this.validateParams(key);
        OCRResult result = new OCRResult();
        String userName = OCRNative.getUserName(key, result);
        Trace.out("End of call to getUserName");
        if (!result.getStatus()) {
            throw new OCRException(result.getNativeResultString());
        }
        return userName;
    }

    public String getGroupName(String key) throws OCRException {
        Trace.out("OCR.getGroupName(" + key + ")");
        this.validateParams(key);
        OCRResult result = new OCRResult();
        String groupName = OCRNative.getGroupName(key, result);
        Trace.out("End of call to getUserName");
        if (!result.getStatus()) {
            throw new OCRException(result.getNativeResultString());
        }
        return groupName;
    }

    public void destroy() throws OCRException {
        OCRResult result = new OCRResult();
        OCRNative.terminateOCR(result);
        if (!result.getStatus()) {
            throw new OCRException(result.getNativeResultString());
        }
        s_instance = null;
        try {
            SRVMContext ctx = SRVMContext.getInstance();
            ctx.term();
        }
        catch (SRVMContextException sce) {
            Trace.out(sce.getMessage());
            throw new OCRException(sce.getMessage());
        }
    }

    private void openTopLevelKey(String key) throws OCRException {
        this.validateParams(key);
        StringTokenizer toks = new StringTokenizer(key, ".");
        Trace.out("# tokens in key = " + toks.countTokens());
        if (toks.countTokens() > 0) {
            String topKey = toks.nextToken();
            Trace.out("topKey = " + topKey);
            this.openKey(topKey);
        }
    }

    private String getOracleUserName(String oracleHomeName) throws OCRException {
        String userName = null;
        try {
            userName = this.m_util.getOracleUser(oracleHomeName, null);
        }
        catch (UtilException ue) {
            throw new OCRException(ue.getMessage());
        }
        return userName;
    }

    private String getOracleGroupName(String oracleHomeName) throws OCRException {
        if (this.m_oraGrpName != null) {
            return this.m_oraGrpName;
        }
        String groupName = null;
        try {
            groupName = this.m_util.getOracleGroup(oracleHomeName);
            if (groupName == null) {
                groupName = this.m_groupName;
            }
        }
        catch (UtilException ue) {
            throw new OCRException(ue.getMessage());
        }
        Trace.out("DBA group name=%s for ORACLE_HOME=%s", groupName, oracleHomeName);
        return groupName;
    }

    private void validateParams(String keyName, int secType, String ancestorKeyName, String oracleHomeName) throws OCRException {
        if (keyName == null) {
            Trace.out("ValidateParams: NULL keyName");
            Object[] args = new String[]{"keyName=" + keyName, "validateParams"};
            throw new OCRException(s_rawMsgBundle.getMessage("1077", false, args));
        }
        switch (secType) {
            case 1: {
                if (oracleHomeName != null) break;
                Trace.out("oracleHomeName passed was NULL for secType " + secType + " " + oracleHomeName);
                Object[] args = new String[]{"oracleHomeName=" + oracleHomeName, "validateParams"};
                throw new OCRException(s_rawMsgBundle.getMessage("1077", false, args));
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                if (ancestorKeyName == null) {
                    Trace.out("ancestorKeyName passed was NULL for secType " + secType);
                    Object[] args = new String[]{"ancestorKeyName=" + ancestorKeyName, "validateParams"};
                    throw new OCRException(s_rawMsgBundle.getMessage("1077", false, args));
                }
                if (keyName.startsWith(ancestorKeyName)) break;
                Trace.out("OCR.validateParams:bad ancestorKeyName:" + ancestorKeyName + " for keyname:" + keyName);
                Object[] args = new String[]{"ancestorKeyName=" + ancestorKeyName, "validateParams"};
                throw new OCRException(s_rawMsgBundle.getMessage("1077", false, args));
            }
            case 5: {
                Trace.out("validateParams: DEFAULT SECURITY");
                break;
            }
            default: {
                Trace.out("Unkown sectype " + secType + " passed");
                Object[] args = new String[]{"secType=" + secType, "validateParams"};
                throw new OCRException(s_rawMsgBundle.getMessage("1077", false, args));
            }
        }
    }

    private void validateParams(String key) throws OCRException {
        if (key == null) {
            Object[] args = new String[]{"key=" + key, "validateParams"};
            throw new OCRException(s_rawMsgBundle.getMessage("1077", false, args));
        }
    }

    public static boolean isCluster() throws OCRException {
        OCR.loadLibrary();
        try {
            SRVMContext ctx = SRVMContext.getInstance();
            ctx.init();
        }
        catch (SRVMContextException sce) {
            Trace.out(sce.getMessage());
            throw new OCRException(sce.getMessage());
        }
        Trace.out("Calling OCRNative for isCluster()");
        OCRResult ocrResult = new OCRResult();
        OCRNative.isCluster(ocrResult);
        Trace.out("OCR Result status = " + ocrResult.getStatus());
        if (!ocrResult.getStatus()) {
            Object[] errMsg = new String[]{ocrResult.getNativeResultString()};
            Trace.out("error Message = " + errMsg);
            throw new OCRException(s_rawMsgBundle.getMessage("1081", false, errMsg));
        }
        Trace.out("Bolean result = " + ocrResult.getBooleanResult());
        return ocrResult.getBooleanResult();
    }

    public static String[] getOCRLocations() throws OCRException {
        OCR.loadLibrary();
        try {
            SRVMContext ctx = SRVMContext.getInstance();
            ctx.init();
        }
        catch (SRVMContextException sce) {
            Trace.out(sce.getMessage());
            throw new OCRException(sce.getMessage());
        }
        Trace.out("Calling OCRNative for getOCRLocations()");
        OCRResult ocrResult = new OCRResult();
        Object[] ocrLocs = OCRNative.getOCRLocations(ocrResult);
        if (!ocrResult.getStatus() || ocrLocs == null || ocrLocs.length == 0) {
            Object[] errMsg = new String[]{ocrResult.getNativeResultString()};
            Trace.out("error Message = " + errMsg);
            throw new OCRException(s_rawMsgBundle.getMessage("1082", false, errMsg));
        }
        Trace.out("OCR Locations: " + Arrays.toString(ocrLocs));
        return ocrLocs;
    }
}

