/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.rawdevice;

public class NetworkInterface {
    public static final int ALL = 1;
    public static final int PUBLIC = 4;
    public static final int PRIVATE = 8;
    public static final int IPALL = 0;
    public static final int IPv4 = 1;
    public static final int IPv6 = 2;
    public static final String INTERFACE_PUBLIC = "public";
    public static final String INTERFACE_PRIVATE = "cluster_interconnect";
    String m_name;
    String m_subnet;
    int m_type;
    String m_ipAddress;
    int m_ipType;
    String m_gatewayAddr;
    String m_netmask;

    NetworkInterface(String ifName) {
        this(ifName, null);
    }

    NetworkInterface(String ifName, String subnet) {
        this.m_name = ifName;
        this.m_subnet = subnet;
    }

    public String getName() {
        return this.m_name;
    }

    void setSubnet(String subnet) {
        this.m_subnet = subnet;
    }

    public String getSubnet() {
        return this.m_subnet;
    }

    void setNetmask(String netmask) {
        this.m_netmask = netmask;
    }

    public String getNetmask() {
        return this.m_netmask;
    }

    void setType(int type) {
        this.m_type = type;
    }

    public int getType() {
        return this.m_type;
    }

    public String getInterfaceType() {
        return this.m_type == 4 ? INTERFACE_PUBLIC : INTERFACE_PRIVATE;
    }

    void setIPType(int ipType) {
        this.m_ipType = ipType;
    }

    public int getIPType() {
        return this.m_ipType;
    }

    public String getIPVersionType() {
        return this.m_ipType == 1 ? "IP4 Version" : "IP6 Version";
    }

    public static boolean assertInterfaceType(int ifType) {
        return ifType == 1 || ifType == 4 || ifType == 8;
    }

    public static boolean assertIPType(int ipType) {
        return ipType == 0 || ipType == 1 || ipType == 2;
    }
}

