/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation.ha;

import java.io.Serializable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.Credentials;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.operation.ha.HAOperation;
import oracle.ops.mgmt.operation.ha.HAOperationException;
import oracle.ops.mgmt.operation.ha.HAOperationImpl;
import oracle.ops.mgmt.operation.ha.HAOperationResult;
import oracle.ops.mgmt.trace.Trace;

public class HAStopOperation
extends HAOperation
implements Serializable {
    static final long serialVersionUID = 8025830119548957015L;
    String m_stopMode;
    Credentials m_credentials;
    String m_node;
    boolean m_disconnect = false;

    public HAStopOperation(String resourceName, String stopMode, Credentials credentials, Version version) throws HAOperationException {
        super("crs_stop", resourceName, version);
        this.m_stopMode = stopMode;
        this.m_credentials = credentials;
    }

    public HAStopOperation(String[] resourceNames, String stopMode, Credentials credentials, Version version) throws HAOperationException {
        super("crs_stop", resourceNames, version);
        this.m_stopMode = stopMode;
        this.m_credentials = credentials;
    }

    public HAStopOperation(String resourceName, Version version) throws HAOperationException {
        super("crs_stop", resourceName, version);
    }

    public HAStopOperation(String[] resourceNames, Version version) throws HAOperationException {
        super("crs_stop", resourceNames, version);
    }

    public void setNode(String node) {
        this.m_node = node;
    }

    public String getNode() {
        return this.m_node;
    }

    String getStopMode() {
        return this.m_stopMode;
    }

    Credentials getCredentials() {
        return this.m_credentials;
    }

    public void setServiceDisconnect(boolean disconnect) {
        this.m_disconnect = disconnect;
    }

    public boolean getServiceDisconnect() {
        return this.m_disconnect;
    }

    @Override
    public OperationResult run() {
        HAOperationResult result = HAOperationImpl.stop(this);
        Trace.out("Returned from executing the HA Operation");
        String[] output = result.getOutput();
        if (output != null) {
            for (int i = 0; i < output.length; ++i) {
                Trace.out("OUTPUT> " + output[i]);
            }
        } else {
            Trace.out("No output from the HA Operation");
        }
        String error = result.getError();
        if (error != null) {
            Trace.out("ERROR> " + error);
        } else {
            Trace.out("No error from the HA Operation");
        }
        return result;
    }
}

