/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation.ha;

import java.io.Serializable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.operation.ha.HAOperation;
import oracle.ops.mgmt.operation.ha.HAOperationException;
import oracle.ops.mgmt.operation.ha.HAOperationImpl;
import oracle.ops.mgmt.operation.ha.HAOperationResult;
import oracle.ops.mgmt.trace.Trace;

public class HASetPermOperation
extends HAOperation
implements Serializable {
    static final long serialVersionUID = 8025830119548957015L;
    String m_mode = null;
    String m_id = null;
    int m_aclType;

    public HASetPermOperation(String resourceName, String mode, String id, Version version) throws HAOperationException {
        this(resourceName, 1, mode, id, version);
    }

    public HASetPermOperation(String resourceName, int aclType, String mode, String id, Version version) throws HAOperationException {
        super("crs_setperm", resourceName, version);
        this.m_aclType = aclType;
        this.m_mode = mode;
        this.m_id = id;
    }

    public String getMode() {
        return this.m_mode;
    }

    public String getAclString() {
        if (this.m_mode == "-u") {
            if (this.m_aclType == 1) {
                return "user:" + this.m_id + ":r-x";
            }
            return "group:" + this.m_id + ":r-x";
        }
        return this.m_id;
    }

    @Override
    public OperationResult run() {
        Trace.out("Executing the HA operation " + this.m_verb + " " + this.m_resourceName);
        HAOperationResult result = HAOperationImpl.setperm(this);
        Trace.out("Returned from executing the HA Operation");
        String[] output = result.getOutput();
        if (output != null) {
            for (int i = 0; i < output.length; ++i) {
                Trace.out("OUTPUT> " + output[i]);
            }
        } else {
            Trace.out("No output from the HA Operation");
        }
        String error = result.getError();
        if (error != null) {
            Trace.out("ERROR> " + error);
        } else {
            Trace.out("No error from the HA Operation");
        }
        return result;
    }
}

