/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation.ha;

import java.io.Serializable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.operation.ha.HAOperation;
import oracle.ops.mgmt.operation.ha.HAOperationException;
import oracle.ops.mgmt.operation.ha.HAOperationImpl;
import oracle.ops.mgmt.operation.ha.HAOperationResult;
import oracle.ops.mgmt.trace.Trace;

public class HARelocateOperation
extends HAOperation
implements Serializable {
    static final long serialVersionUID = 8025830119548957015L;
    String m_targetNode;
    boolean m_disconnect = false;

    public HARelocateOperation(String resourceName, String targetNode, Version version) throws HAOperationException {
        super("crs_relocate", resourceName, version);
        this.m_targetNode = targetNode;
    }

    public HARelocateOperation(String[] resourceNames, String targetNode, Version version) throws HAOperationException {
        super("crs_relocate", resourceNames, version);
        this.m_targetNode = targetNode;
    }

    public HARelocateOperation(String[] resourceNames, Version version) throws HAOperationException {
        super("crs_relocate", resourceNames, version);
        this.m_targetNode = null;
    }

    public String getTargetNode() {
        return this.m_targetNode;
    }

    public void setServiceDisconnect(boolean disconnect) {
        this.m_disconnect = disconnect;
    }

    public boolean getServiceDisconnect() {
        return this.m_disconnect;
    }

    @Override
    public OperationResult run() {
        HAOperationResult result = HAOperationImpl.relocate(this);
        Trace.out("Returned from executing the HA Operation");
        String[] output = result.getOutput();
        if (output != null) {
            for (int i = 0; i < output.length; ++i) {
                Trace.out("OUTPUT> " + output[i]);
            }
        } else {
            Trace.out("No output from the HA Operation");
        }
        String error = result.getError();
        if (error != null) {
            Trace.out("ERROR> " + error);
        } else {
            Trace.out("No error from the HA Operation");
        }
        return result;
    }
}

