/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation.ha;

import java.io.Serializable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.operation.ha.HAOperation;
import oracle.ops.mgmt.operation.ha.HAOperationException;
import oracle.ops.mgmt.operation.ha.HAOperationImpl;
import oracle.ops.mgmt.operation.ha.HAOperationResult;
import oracle.ops.mgmt.trace.Trace;

public class HARegisterOperation
extends HAOperation
implements Serializable {
    static final long serialVersionUID = 8025830119548957015L;
    private boolean m_update = false;

    public HARegisterOperation(String resourceName, Version version) throws HAOperationException {
        super("crs_register", resourceName, version);
    }

    public HARegisterOperation(String resourceName, boolean update, Version version) throws HAOperationException {
        super("crs_register", resourceName, version);
        this.m_update = update;
    }

    public boolean isUpdate() {
        return this.m_update;
    }

    @Override
    public OperationResult run() {
        Trace.out("Executing the HA operation " + this.m_verb + " " + this.m_resourceName);
        HAOperationResult result = HAOperationImpl.register(this);
        Trace.out("Returned from executing the HA Operation");
        String[] output = result.getOutput();
        if (output != null) {
            for (int i = 0; i < output.length; ++i) {
                Trace.out("OUTPUT> " + output[i]);
            }
        } else {
            Trace.out("No output from the HA Operation");
        }
        String error = result.getError();
        if (error != null) {
            Trace.out("ERROR> " + error);
        } else {
            Trace.out("No error from the HA Operation");
        }
        return result;
    }
}

