/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation.ha;

import java.io.Serializable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.operation.ha.HAOperation;
import oracle.ops.mgmt.operation.ha.HAOperationException;
import oracle.ops.mgmt.operation.ha.HAOperationImpl;
import oracle.ops.mgmt.operation.ha.HAOperationResult;
import oracle.ops.mgmt.trace.Trace;

public class HAPolicyOperation
extends HAOperation
implements Serializable {
    static final long serialVersionUID = 8025830119548957015L;
    private boolean m_oracleHomeUpdate = false;
    private boolean m_policyUpdate = false;
    private String m_startPolicy = "AUTOMATIC";
    private String m_resourceType;
    private String m_oracleHome;

    public HAPolicyOperation(String resourceName, String resourceType, Version version) throws HAOperationException {
        super("crs_register", resourceName, version);
        this.m_resourceType = resourceType;
    }

    public boolean isOHomeUpdate() {
        return this.m_oracleHomeUpdate;
    }

    public boolean isPolicyUpdate() {
        return this.m_policyUpdate;
    }

    public String getManagementPolicy() {
        return this.m_startPolicy;
    }

    public void setManagementPolicy(String policy) {
        this.m_policyUpdate = true;
        this.m_startPolicy = policy;
    }

    public void setOracleHome(String oHome) {
        this.m_oracleHomeUpdate = true;
        this.m_oracleHome = oHome;
    }

    public String getOracleHome() {
        return this.m_oracleHome;
    }

    public String getResourceType() {
        return this.m_resourceType;
    }

    @Override
    public OperationResult run() {
        Trace.out("Executing the HA operation " + this.m_verb + " " + this.m_resourceName);
        HAOperationResult result = HAOperationImpl.updatePolicy(this);
        Trace.out("Returned from executing the HA Operation");
        String[] output = result.getOutput();
        if (output != null) {
            for (int i = 0; i < output.length; ++i) {
                Trace.out("OUTPUT> " + output[i]);
            }
        } else {
            Trace.out("No output from the HA Operation");
        }
        String error = result.getError();
        if (error != null) {
            Trace.out("ERROR> " + error);
        } else {
            Trace.out("No error from the HA Operation");
        }
        return result;
    }
}

