/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation.ha;

import java.io.Serializable;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.trace.Trace;

public class HAOperationResult
extends OperationResult
implements Serializable {
    static final long serialVersionUID = 5874155268849245170L;
    private String[] m_output = null;
    private String[] m_error = null;

    public HAOperationResult(int status, String[] output, String[] error) {
        super(status);
        int i;
        if (output != null) {
            this.m_output = new String[output.length];
            for (i = 0; i < output.length; ++i) {
                this.m_output[i] = output[i];
            }
        }
        if (error != null) {
            this.m_error = new String[error.length];
            for (i = 0; i < error.length; ++i) {
                this.m_error[i] = error[i];
            }
        }
    }

    public String[] getOutput() {
        return this.m_output;
    }

    public String[] getErrorRaw() {
        return this.m_error;
    }

    public String getOutputSingle() {
        if (this.m_output == null) {
            return null;
        }
        String mesg = "";
        for (int j = 0; j < this.m_output.length; ++j) {
            if (!this.isOracleMessage(this.m_output[j])) continue;
            mesg = mesg + this.m_output[j].trim() + System.getProperty("line.separator");
        }
        return mesg.trim();
    }

    public String getError() {
        if (this.m_error == null) {
            return null;
        }
        String mesg = "";
        for (int j = 0; j < this.m_error.length; ++j) {
            if (!this.isOracleMessage(this.m_error[j])) continue;
            mesg = mesg + this.m_error[j].trim() + System.getProperty("line.separator");
        }
        return mesg.trim();
    }

    public String getOutputAll() {
        String outLine = this.getOutputSingle();
        String errLine = this.getError();
        Trace.out("outLine is [" + outLine + "]");
        Trace.out("errLine is [" + errLine + "]");
        String retval = outLine != null && errLine != null ? outLine + System.getProperty("line.separator") + errLine : (outLine != null && errLine == null ? outLine : (outLine == null && errLine != null ? errLine : ""));
        return retval.trim();
    }

    private boolean isOracleMessage(String line) {
        int i;
        if (line == null) {
            return false;
        }
        if (line.indexOf(":ora.") != -1) {
            return true;
        }
        for (i = 0; i < line.length() && Character.isUpperCase(line.charAt(i)); ++i) {
        }
        return i > 0 && line.charAt(i) == '-';
    }
}

