/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation.ha;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.Credentials;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.RuntimeExec;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nodeapps.VIP;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.nodeapps.VirtualIPException;
import oracle.ops.mgmt.operation.ha.HAGetPermOperation;
import oracle.ops.mgmt.operation.ha.HALiterals;
import oracle.ops.mgmt.operation.ha.HAOperation;
import oracle.ops.mgmt.operation.ha.HAOperationException;
import oracle.ops.mgmt.operation.ha.HAOperationResult;
import oracle.ops.mgmt.operation.ha.HAPolicyOperation;
import oracle.ops.mgmt.operation.ha.HAProfileOperation;
import oracle.ops.mgmt.operation.ha.HARacgWrapOperation;
import oracle.ops.mgmt.operation.ha.HARegisterOperation;
import oracle.ops.mgmt.operation.ha.HARelocateOperation;
import oracle.ops.mgmt.operation.ha.HASetPermOperation;
import oracle.ops.mgmt.operation.ha.HAStartOperation;
import oracle.ops.mgmt.operation.ha.HAStatusOperation;
import oracle.ops.mgmt.operation.ha.HAStopOperation;
import oracle.ops.mgmt.operation.ha.HAUnregisterOperation;
import oracle.ops.mgmt.trace.Trace;

public class HAOperationImpl
implements HALiterals {
    public static HAOperationResult start(HAStartOperation op) {
        int count = 7;
        if (op.getOpenMode() == null) {
            --count;
        }
        if (op.getpfileName() == null) {
            --count;
        }
        if (op.getNode() == null) {
            --count;
            --count;
        }
        String[] cmd = new String[count];
        count = 0;
        cmd[count++] = op.getVerb();
        if (op.getOpenMode() != null) {
            cmd[count++] = "USR_ORA_OPEN_MODE=" + op.getOpenMode();
        }
        if (op.getpfileName() != null) {
            cmd[count++] = "USR_ORA_PFILE=" + op.getpfileName();
        }
        cmd[count++] = op.getResourceName();
        cmd[count++] = "-f";
        if (op.getNode() != null) {
            cmd[count++] = "-c";
            cmd[count++] = op.getNode();
        }
        HAOperationResult result = HAOperationImpl.runCommand(cmd);
        return result;
    }

    public static HAOperationResult stop(HAStopOperation op) {
        int count = 4;
        if (op.getStopMode() == null) {
            --count;
        }
        if (!op.getServiceDisconnect()) {
            --count;
        }
        String[] resNames = op.getResourceNames();
        String[] cmd = new String[count + resNames.length];
        count = 0;
        cmd[count++] = op.getVerb();
        if (op.getStopMode() != null) {
            cmd[count++] = "USR_ORA_STOP_MODE=" + op.getStopMode();
        }
        if (op.getServiceDisconnect()) {
            cmd[count++] = "USR_ORA_DISCONNECT=" + op.getServiceDisconnect();
        }
        for (int i = 0; i < resNames.length; ++i) {
            cmd[count++] = resNames[i];
        }
        cmd[count++] = "-f";
        HAOperationResult result = HAOperationImpl.runCommand(cmd);
        return result;
    }

    public static HAOperationResult updatePolicy(HAPolicyOperation op) {
        HAOperationResult result;
        String resourceName = op.getResourceName();
        int index = 0;
        boolean oHomeChanged = op.isOHomeUpdate();
        boolean policyChanged = op.isPolicyUpdate();
        String[] cmd = oHomeChanged && policyChanged ? new String[7] : new String[5];
        cmd[index++] = op.getVerb();
        cmd[index++] = "-update";
        cmd[index++] = resourceName;
        if (oHomeChanged) {
            cmd[index++] = "-a";
            NativeSystem nativeSystem = new SystemFactory().CreateSystem();
            if (op.getResourceType().equals("vip") || op.getResourceType().equals("db") || op.getResourceType().equals("gsd") || op.getResourceType().equals("ons")) {
                String actionScriptCRS = op.getCrsHome() + File.separator + "bin" + File.separator + "racgwrap";
                actionScriptCRS = nativeSystem.getScriptFileName(actionScriptCRS);
                cmd[index++] = actionScriptCRS;
            } else {
                String actionScript = op.getOracleHome() + File.separator + "bin" + File.separator + "racgwrap";
                actionScript = nativeSystem.getScriptFileName(actionScript);
                cmd[index++] = actionScript;
            }
        }
        if (policyChanged) {
            Properties properties = HAOperationImpl.loadProfileProperties();
            StringBuffer oraOptions = new StringBuffer();
            cmd[index++] = "-o";
            Trace.out("modifying profile properties for resourcetype " + op.getResourceType());
            if (op.getManagementPolicy() == null || op.getManagementPolicy().equalsIgnoreCase("AUTOMATIC")) {
                if (op.getResourceType().equals("inst")) {
                    HAOperationImpl.addOraOption(oraOptions, "INST", "as", properties);
                    HAOperationImpl.addOraOption(oraOptions, "INST", "ra", properties, false);
                } else if (op.getResourceType().equals("srv") || op.getResourceType().equals("cs") || op.getResourceType().equals("db")) {
                    Trace.out("adding ra and as attributes ");
                    HAOperationImpl.addOraOption(oraOptions, "SRV", "as", properties);
                    HAOperationImpl.addOraOption(oraOptions, "SRV", "ra", properties, false);
                } else {
                    Trace.out("adding as attributes ");
                    HAOperationImpl.addOraOption(oraOptions, "LSNR", "as", properties, false);
                }
            } else if (op.getResourceType().equals("inst")) {
                HAOperationImpl.addOraOption(oraOptions, "INST.MANUAL", "ra", properties);
                HAOperationImpl.addOraOption(oraOptions, "INST.MANUAL", "as", properties, false);
            } else {
                HAOperationImpl.addOraOption(oraOptions, "LSNR.MANUAL", "ra", properties);
                HAOperationImpl.addOraOption(oraOptions, "LSNR.MANUAL", "as", properties, false);
            }
            cmd[index++] = oraOptions.toString();
        }
        if ((result = HAOperationImpl.runCommand(cmd)).getStatus() == 0 && !new SystemFactory().CreateSystem().isUnixSystem()) {
            Trace.out("Windows: Registration is done.. Setting ownership");
            HASetPermOperation setpermOp = null;
            String oUser = null;
            try {
                Util hasUtl = new Util();
                oUser = hasUtl.getOracleUser(op.getCrsHome(), null);
                Trace.out("oracle user is " + oUser);
                Trace.out("Setting ownership to : " + oUser);
                setpermOp = new HASetPermOperation(op.getResourceName(), "-o", oUser, new Version());
                result = HAOperationImpl.setperm(setpermOp);
                Trace.out("Ownership is set successfully");
            }
            catch (UtilException e) {
                result.setStatus(2);
                result.setException((Exception)((Object)e));
            }
            catch (HAOperationException hae) {
                result.setStatus(2);
                result.setException(hae);
            }
        }
        return result;
    }

    public static HAOperationResult register(HARegisterOperation op) {
        HAOperationResult result;
        String resourceName = op.getResourceName();
        if (op.isUpdate()) {
            String[] cmd = new String[]{op.getVerb(), "-u", resourceName};
            result = HAOperationImpl.runCommand(cmd);
        } else {
            String[] cmd = new String[]{op.getVerb(), resourceName};
            result = HAOperationImpl.runCommand(cmd);
            Trace.out("register command result is " + result.getStatus());
            if (result.getStatus() == 211) {
                Trace.out("trying register -u");
                cmd = new String[]{op.getVerb(), "-u", resourceName};
                result = HAOperationImpl.runCommand(cmd);
            }
        }
        if (result.getStatus() == 0 && !new SystemFactory().CreateSystem().isUnixSystem()) {
            Trace.out("Windows: Registration is done.. Setting ownership");
            HASetPermOperation setpermOp = null;
            String oUser = null;
            try {
                Util hasUtl = new Util();
                oUser = hasUtl.getOracleUser(op.getCrsHome(), null);
                Trace.out("oracle user is " + oUser);
                Trace.out("Setting ownership to : " + oUser);
                setpermOp = new HASetPermOperation(op.getResourceName(), "-o", oUser, new Version());
                result = HAOperationImpl.setperm(setpermOp);
                Trace.out("Ownership is set successfully");
            }
            catch (UtilException e) {
                result.setStatus(2);
                result.setException((Exception)((Object)e));
            }
            catch (HAOperationException hae) {
                result.setStatus(2);
                result.setException(hae);
            }
        }
        HAOperationImpl.deleteProfileOnDisk(op);
        return result;
    }

    public static HAOperationResult unregister(HAUnregisterOperation op) {
        String[] resNames = op.getResourceNames();
        String opVerb = op.getVerb();
        boolean force = op.isForce();
        boolean useUnsupported = op.useUnsupported();
        ArrayList<String> list = new ArrayList<String>(resNames.length + 1 + (force ? 3 : 0) + (useUnsupported ? 1 : 0));
        list.add(opVerb);
        if (force) {
            list.add("delete");
            list.add("resource");
        }
        for (String res : resNames) {
            list.add(res);
        }
        if (force) {
            list.add("-f");
        }
        if (useUnsupported) {
            list.add("-unsupported");
        }
        String[] cmd = new String[list.size()];
        list.toArray(cmd);
        HAOperationResult result = HAOperationImpl.runCommand(cmd);
        if (result.getStatus() == 212) {
            Trace.out("swallowing resource not registered error 212");
            HAOperationResult newResult = new HAOperationResult(0, result.getOutput(), result.getErrorRaw());
            return newResult;
        }
        return result;
    }

    public static HAOperationResult status(HAStatusOperation op) {
        String[] resourceNames = op.getResourceNames();
        ArrayList<String> list = new ArrayList<String>(resourceNames != null ? 4 + resourceNames.length : 4);
        list.add(op.getVerb());
        if (op.isUsePFlag()) {
            list.add("-p");
        }
        if (resourceNames != null) {
            for (String res : resourceNames) {
                list.add(res);
            }
        }
        if (op.getNodeName() != null) {
            list.add("-c");
            list.add(op.getNodeName());
        }
        String[] cmd = new String[list.size()];
        list.toArray(cmd);
        HAOperationResult result = HAOperationImpl.runCommand(cmd);
        return result;
    }

    public static HAOperationResult relocate(HARelocateOperation op) {
        String[] resNames = op.getResourceNames();
        ArrayList<String> list = new ArrayList<String>(5 + resNames.length);
        list.add(op.getVerb());
        if (op.getServiceDisconnect()) {
            list.add("USR_ORA_DISCONNECT=" + op.getServiceDisconnect());
        }
        for (int i = 0; i < resNames.length; ++i) {
            list.add(resNames[i]);
        }
        if (op.getTargetNode() != null) {
            list.add("-c");
            list.add(op.getTargetNode());
        }
        list.add("-f");
        String[] cmd = new String[list.size()];
        list.toArray(cmd);
        HAOperationResult result = HAOperationImpl.runCommand(cmd);
        return result;
    }

    public static HAOperationResult profile(HAProfileOperation op) {
        int i;
        StringBuffer sb;
        String[] cmd = null;
        String[] hostingNodes = null;
        int numCommonOptions = 8;
        StringBuffer oraOptions = new StringBuffer();
        String resourceName = op.getResourceName();
        String actionScript = op.getOracleHome() + File.separator + "bin" + File.separator + "racgwrap";
        String actionScriptCRS = op.getCrsHome() + File.separator + "bin" + File.separator + "racgwrap";
        String actionScriptASM = op.getCrsHome() + File.separator + "bin" + File.separator + "asmproxy";
        Trace.out("actionScriptASM=" + actionScriptASM);
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        actionScript = nativeSystem.getScriptFileName(actionScript);
        actionScriptCRS = nativeSystem.getScriptFileName(actionScriptCRS);
        actionScriptASM = nativeSystem.getScriptFileName(actionScriptASM);
        Trace.out("From Native: actionScriptASM=" + actionScriptASM);
        String profileOption = op.getProfileOption();
        hostingNodes = op.getHostingNodes();
        if (profileOption.equals("-delete")) {
            int index = 0;
            cmd = new String[3];
            cmd[index++] = op.getVerb();
            cmd[index++] = "-delete";
            cmd[index++] = resourceName;
            HAOperationResult result = HAOperationImpl.runCommand(cmd);
            return result;
        }
        if (profileOption.equals("-update -h")) {
            int index = 0;
            cmd = new String[5];
            cmd[index++] = op.getVerb();
            cmd[index++] = "-update";
            cmd[index++] = resourceName;
            cmd[index++] = "-h";
            StringBuffer sb2 = new StringBuffer();
            for (int i2 = 0; i2 < hostingNodes.length; ++i2) {
                sb2.append(hostingNodes[i2]);
                sb2.append(" ");
            }
            cmd[index++] = sb2.toString();
            try {
                HAOperationImpl.writeProfileOnDisk(op);
            }
            catch (IOException e) {
                Trace.out("profile: IOException caught");
                Trace.out(e);
                HAOperationResult result = new HAOperationResult(1, null, null);
                return result;
            }
            HAOperationResult result = HAOperationImpl.runCommand(cmd);
            return result;
        }
        if (profileOption.equals("-update -a")) {
            int index = 0;
            cmd = new String[5];
            cmd[index++] = op.getVerb();
            cmd[index++] = "-update";
            cmd[index++] = resourceName;
            cmd[index++] = "-a";
            if (op.getProfileType().equals("vip") || op.getProfileType().equals("db") || op.getProfileType().equals("gsd") || op.getProfileType().equals("ons")) {
                cmd[index++] = actionScriptCRS;
            } else if (op.getProfileType().equals("asm") && Version.isPre112(op.getVersion()) && op.getOracleHome().equals(op.getCrsHome())) {
                Trace.out("Setting ASM proxy action scripts=" + actionScriptASM);
                cmd[index++] = actionScriptASM;
            } else {
                cmd[index++] = actionScript;
            }
            try {
                HAOperationImpl.writeProfileOnDisk(op);
            }
            catch (IOException e) {
                Trace.out("profile: IOException caught");
                Trace.out(e);
                HAOperationResult result = new HAOperationResult(1, null, null);
                return result;
            }
            HAOperationResult result = HAOperationImpl.runCommand(cmd);
            return result;
        }
        if (profileOption.equals("-update -l")) {
            int index = 0;
            cmd = new String[5];
            cmd[index++] = op.getVerb();
            cmd[index++] = "-update";
            cmd[index++] = resourceName;
            cmd[index++] = "-l";
            cmd[index++] = "";
            try {
                HAOperationImpl.writeProfileOnDisk(op);
            }
            catch (IOException e) {
                Trace.out("profile: IOException caught");
                Trace.out(e);
                HAOperationResult result = new HAOperationResult(1, null, null);
                return result;
            }
            HAOperationResult result = HAOperationImpl.runCommand(cmd);
            return result;
        }
        if (op.getProfileType().equals("srv")) {
            cmd = new String[numCommonOptions + 8];
        }
        if (op.getProfileType().equals("cs")) {
            cmd = new String[numCommonOptions + 8];
        }
        if (op.getProfileType().equals("vip")) {
            cmd = new String[numCommonOptions + 8];
        }
        if (op.getProfileType().equals("gsd")) {
            cmd = new String[numCommonOptions + 8];
        }
        if (op.getProfileType().equals("lsnr")) {
            cmd = new String[numCommonOptions + 10];
        }
        if (op.getProfileType().equals("oem")) {
            cmd = new String[numCommonOptions + 10];
        }
        if (op.getProfileType().equals("inst")) {
            cmd = new String[numCommonOptions + 8];
        }
        if (op.getProfileType().equals("asm")) {
            cmd = new String[numCommonOptions + 8];
        }
        if (op.getProfileType().equals("db")) {
            cmd = new String[numCommonOptions + 6];
        }
        if (op.getProfileType().equals("ons")) {
            cmd = new String[numCommonOptions + 8];
        }
        int index = 0;
        Trace.out("loading profile attributes from profile.properties");
        Properties properties = HAOperationImpl.loadProfileProperties();
        Trace.out("Finished loading profile");
        cmd[index++] = op.getVerb();
        cmd[index++] = "-create";
        cmd[index++] = resourceName;
        cmd[index++] = "-f";
        cmd[index++] = "-t";
        cmd[index++] = "application";
        cmd[index++] = "-a";
        if (op.getProfileType().equals("vip") || op.getProfileType().equals("db") || op.getProfileType().equals("gsd") || op.getProfileType().equals("ons")) {
            cmd[index++] = actionScriptCRS;
        } else if (op.getProfileType().equals("asm") && Version.isPre112(op.getVersion()) && op.getOracleHome().equals(op.getCrsHome())) {
            Trace.out("ASM proxy action script is =" + actionScriptASM);
            cmd[index++] = actionScriptASM;
        } else {
            cmd[index++] = actionScript;
        }
        HAOperationImpl.addOraOption(oraOptions, "COMMON", "od", properties);
        HAOperationImpl.addOraOption(oraOptions, "COMMON", "ol", properties);
        String policy = op.getManagementPolicy();
        if (op.getProfileType().equals("srv")) {
            cmd[index++] = "-d";
            cmd[index++] = "CRS application for Service Member";
            cmd[index++] = "-p";
            cmd[index++] = "restricted";
            cmd[index++] = "-h";
            sb = new StringBuffer();
            for (i = 0; i < hostingNodes.length; ++i) {
                sb.append(hostingNodes[i]);
                sb.append(" ");
            }
            cmd[index++] = sb.toString();
            if (policy != null && policy.equalsIgnoreCase("MANUAL")) {
                HAOperationImpl.addOraOption(oraOptions, "SRV.MANUAL", "ra", properties);
                HAOperationImpl.addOraOption(oraOptions, "SRV.MANUAL", "as", properties);
            } else {
                HAOperationImpl.addOraOption(oraOptions, "SRV", "ra", properties);
            }
            HAOperationImpl.addOraOption(oraOptions, "SRV", "st", properties);
            HAOperationImpl.addOraOption(oraOptions, "SRV", "ci", properties);
            HAOperationImpl.addOraOption(oraOptions, "SRV", "rt", properties);
            HAOperationImpl.addOraOption(oraOptions, "SRV", "pt", properties, false);
            cmd[index++] = "-o";
            cmd[index++] = oraOptions.toString();
        }
        if (op.getProfileType().equals("cs")) {
            cmd[index++] = "-d";
            cmd[index++] = "CRS application for Composite Service";
            cmd[index++] = "-p";
            cmd[index++] = "restricted";
            cmd[index++] = "-h";
            sb = new StringBuffer();
            for (i = 0; i < hostingNodes.length; ++i) {
                sb.append(hostingNodes[i]);
                sb.append(" ");
            }
            cmd[index++] = sb.toString();
            if (policy != null && policy.equalsIgnoreCase("MANUAL")) {
                HAOperationImpl.addOraOption(oraOptions, "CS.MANUAL", "ra", properties);
                HAOperationImpl.addOraOption(oraOptions, "CS.MANUAL", "as", properties);
            } else {
                HAOperationImpl.addOraOption(oraOptions, "CS", "ra", properties);
            }
            HAOperationImpl.addOraOption(oraOptions, "CS", "st", properties);
            HAOperationImpl.addOraOption(oraOptions, "CS", "ci", properties);
            HAOperationImpl.addOraOption(oraOptions, "CS", "ft", properties);
            HAOperationImpl.addOraOption(oraOptions, "CS", "fi", properties);
            HAOperationImpl.addOraOption(oraOptions, "CS", "rt", properties);
            HAOperationImpl.addOraOption(oraOptions, "CS", "pt", properties);
            String taf = op.getTAFPolicy();
            if (taf == null) {
                HAOperationImpl.addOraOption(oraOptions, "CS", "op", properties, false);
            } else {
                oraOptions.append("op=");
                oraOptions.append(taf);
            }
            cmd[index++] = "-o";
            cmd[index++] = oraOptions.toString();
        }
        if (op.getProfileType().equals("vip")) {
            cmd[index++] = "-d";
            cmd[index++] = "CRS application for VIP on a node";
            cmd[index++] = "-p";
            cmd[index++] = "favored";
            cmd[index++] = "-h";
            cmd[index++] = op.getHostNode();
            HAOperationImpl.addOraOption(oraOptions, "VIP", "st", properties);
            HAOperationImpl.addOraOption(oraOptions, "VIP", "ci", properties);
            HAOperationImpl.addOraOption(oraOptions, "VIP", "ra", properties);
            HAOperationImpl.addOraOption(oraOptions, "VIP", "ap", properties);
            HAOperationImpl.addOraOption(oraOptions, "VIP", "as", properties);
            VIPAddress vipAddr = op.getVIPAddress();
            String vipNumber = vipAddr.getIPAddress().getHostAddress();
            String netmask = vipAddr.getNetmask();
            String[] interfaces = vipAddr.getInterfaces();
            oraOptions.append("ov=");
            oraOptions.append(vipNumber);
            oraOptions.append(",on=");
            oraOptions.append(netmask);
            if (interfaces != null && interfaces.length > 0) {
                oraOptions.append(",oi=");
                for (int j = 0; j < interfaces.length; ++j) {
                    String vipInterface = interfaces[j];
                    if (interfaces[j].startsWith("\"") && interfaces[j].endsWith("\"")) {
                        Trace.out("interfaces[" + j + "] = " + interfaces[j]);
                        int len = interfaces[j].length();
                        vipInterface = interfaces[j].substring(1, len - 1);
                        Trace.out("Parsed interfaces[" + j + "] = " + vipInterface);
                    }
                    oraOptions.append(vipInterface);
                    Trace.out("oraOptions = " + oraOptions);
                    if (j >= interfaces.length - 1) continue;
                    oraOptions.append("|");
                }
            }
            cmd[index++] = "-o";
            cmd[index++] = oraOptions.toString();
        }
        if (op.getProfileType().equals("gsd")) {
            cmd[index++] = "-d";
            cmd[index++] = "CRS application for GSD on node";
            cmd[index++] = "-p";
            cmd[index++] = "restricted";
            cmd[index++] = "-h";
            cmd[index++] = op.getHostNode();
            HAOperationImpl.addOraOption(oraOptions, "GSD", "st", properties);
            HAOperationImpl.addOraOption(oraOptions, "GSD", "ci", properties);
            HAOperationImpl.addOraOption(oraOptions, "GSD", "ra", properties);
            HAOperationImpl.addOraOption(oraOptions, "GSD", "as", properties);
            HAOperationImpl.addOraOption(oraOptions, "GSD", "rt", properties);
            HAOperationImpl.addOraOption(oraOptions, "GSD", "pt", properties, false);
            cmd[index++] = "-o";
            cmd[index++] = oraOptions.toString();
        }
        if (op.getProfileType().equals("lsnr") || op.getProfileType().equals("oem")) {
            String vipResourceName;
            try {
                vipResourceName = new VIP(op.getHostNode(), op.getOracleHome()).getResourceName();
            }
            catch (VirtualIPException vipe) {
                vipResourceName = "ora." + op.getHostNode().toLowerCase() + ".vip";
            }
            Trace.out("vipResourceName=" + vipResourceName);
            if (op.getProfileType().equals("lsnr")) {
                cmd[index++] = "-d";
                cmd[index++] = "CRS application for listener on node";
                cmd[index++] = "-p";
                cmd[index++] = "restricted";
                cmd[index++] = "-h";
                cmd[index++] = op.getHostNode();
                cmd[index++] = "-r";
                cmd[index++] = vipResourceName;
                HAOperationImpl.addOraOption(oraOptions, "LSNR", "st", properties);
                HAOperationImpl.addOraOption(oraOptions, "LSNR", "ci", properties);
                HAOperationImpl.addOraOption(oraOptions, "LSNR", "ra", properties);
                HAOperationImpl.addOraOption(oraOptions, "LSNR", "as", properties);
                HAOperationImpl.addOraOption(oraOptions, "LSNR", "rt", properties);
                HAOperationImpl.addOraOption(oraOptions, "LSNR", "pt", properties, false);
                cmd[index++] = "-o";
                cmd[index++] = oraOptions.toString();
            }
            if (op.getProfileType().equals("oem")) {
                cmd[index++] = "-d";
                cmd[index++] = "CRS application for OEM Agent on node";
                cmd[index++] = "-p";
                cmd[index++] = "restricted";
                cmd[index++] = "-h";
                cmd[index++] = op.getHostNode();
                cmd[index++] = "-r";
                cmd[index++] = vipResourceName;
                HAOperationImpl.addOraOption(oraOptions, "OEM", "st", properties);
                HAOperationImpl.addOraOption(oraOptions, "OEM", "ci", properties);
                HAOperationImpl.addOraOption(oraOptions, "OEM", "ra", properties);
                HAOperationImpl.addOraOption(oraOptions, "OEM", "as", properties);
                HAOperationImpl.addOraOption(oraOptions, "OEM", "rt", properties);
                HAOperationImpl.addOraOption(oraOptions, "OEM", "pt", properties, false);
                cmd[index++] = "-o";
                cmd[index++] = oraOptions.toString();
            }
        }
        if (op.getProfileType().equals("inst")) {
            cmd[index++] = "-d";
            cmd[index++] = "CRS application for Instance";
            cmd[index++] = "-p";
            cmd[index++] = "restricted";
            cmd[index++] = "-h";
            cmd[index++] = op.getHostNode();
            HAOperationImpl.addOraOption(oraOptions, "INST", "st", properties);
            HAOperationImpl.addOraOption(oraOptions, "INST", "ci", properties);
            if (op.getManagementPolicy() == null || op.getManagementPolicy().equalsIgnoreCase("AUTOMATIC")) {
                HAOperationImpl.addOraOption(oraOptions, "INST", "ra", properties);
                HAOperationImpl.addOraOption(oraOptions, "INST", "as", properties);
            } else {
                HAOperationImpl.addOraOption(oraOptions, "INST.MANUAL", "ra", properties);
                HAOperationImpl.addOraOption(oraOptions, "INST.MANUAL", "as", properties);
            }
            HAOperationImpl.addOraOption(oraOptions, "INST", "rt", properties);
            HAOperationImpl.addOraOption(oraOptions, "INST", "pt", properties);
            HAOperationImpl.addOraOption(oraOptions, "INST", "oc", properties);
            HAOperationImpl.addOraOption(oraOptions, "INST", "oo", properties);
            HAOperationImpl.addOraOption(oraOptions, "INST", "os", properties);
            HAOperationImpl.addOraOption(oraOptions, "INST", "of", properties, false);
            cmd[index++] = "-o";
            cmd[index++] = oraOptions.toString();
        }
        if (op.getProfileType().equals("asm")) {
            cmd[index++] = "-d";
            cmd[index++] = "CRS application for ASM instance";
            cmd[index++] = "-p";
            cmd[index++] = "restricted";
            cmd[index++] = "-h";
            cmd[index++] = op.getHostNode();
            HAOperationImpl.addOraOption(oraOptions, "ASM", "st", properties);
            HAOperationImpl.addOraOption(oraOptions, "ASM", "ci", properties);
            HAOperationImpl.addOraOption(oraOptions, "ASM", "ra", properties);
            HAOperationImpl.addOraOption(oraOptions, "ASM", "as", properties);
            HAOperationImpl.addOraOption(oraOptions, "ASM", "rt", properties);
            HAOperationImpl.addOraOption(oraOptions, "ASM", "pt", properties);
            Version version = Version.get102Version();
            if (op.getVersion().getMajorVersion().compareTo(version.getMajorVersion()) > 0) {
                HAOperationImpl.addOraOption(oraOptions, "ASM", "oc", properties);
            } else {
                oraOptions.append("oc=" + new Credentials().getConnectString() + ",");
            }
            HAOperationImpl.addOraOption(oraOptions, "ASM", "oo", properties);
            HAOperationImpl.addOraOption(oraOptions, "ASM", "os", properties);
            HAOperationImpl.addOraOption(oraOptions, "ASM", "of", properties, false);
            cmd[index++] = "-o";
            cmd[index++] = oraOptions.toString();
        }
        if (op.getProfileType().equals("db")) {
            Trace.out("Adding database profile");
            cmd[index++] = "-d";
            cmd[index++] = "CRS application for the Database";
            cmd[index++] = "-p";
            cmd[index++] = "balanced";
            policy = op.getManagementPolicy();
            if (policy != null && policy.equalsIgnoreCase("MANUAL")) {
                HAOperationImpl.addOraOption(oraOptions, "DB.MANUAL", "ra", properties);
                HAOperationImpl.addOraOption(oraOptions, "DB.MANUAL", "as", properties);
            } else {
                HAOperationImpl.addOraOption(oraOptions, "DB", "ra", properties);
            }
            HAOperationImpl.addOraOption(oraOptions, "DB", "st", properties);
            HAOperationImpl.addOraOption(oraOptions, "DB", "ci", properties);
            HAOperationImpl.addOraOption(oraOptions, "DB", "ft", properties);
            HAOperationImpl.addOraOption(oraOptions, "DB", "fi", properties);
            HAOperationImpl.addOraOption(oraOptions, "DB", "rt", properties);
            HAOperationImpl.addOraOption(oraOptions, "DB", "pt", properties, false);
            cmd[index++] = "-o";
            cmd[index++] = oraOptions.toString();
        }
        if (op.getProfileType().equals("ons")) {
            cmd[index++] = "-d";
            cmd[index++] = "CRS application for ONS on node";
            cmd[index++] = "-p";
            cmd[index++] = "restricted";
            cmd[index++] = "-h";
            cmd[index++] = op.getHostNode();
            HAOperationImpl.addOraOption(oraOptions, "ONS", "st", properties);
            HAOperationImpl.addOraOption(oraOptions, "ONS", "ci", properties);
            HAOperationImpl.addOraOption(oraOptions, "ONS", "ra", properties);
            HAOperationImpl.addOraOption(oraOptions, "ONS", "as", properties);
            HAOperationImpl.addOraOption(oraOptions, "ONS", "rt", properties);
            HAOperationImpl.addOraOption(oraOptions, "ONS", "pt", properties, false);
            cmd[index++] = "-o";
            cmd[index++] = oraOptions.toString();
        }
        HAOperationResult result = HAOperationImpl.runCommand(cmd);
        return result;
    }

    public static HAOperationResult setperm(HASetPermOperation op) {
        int count = 4;
        String[] cmd = new String[count];
        count = 0;
        cmd[count++] = op.getVerb();
        cmd[count++] = op.getResourceName();
        cmd[count++] = op.getMode();
        if (op.getMode().equals("-u") || op.getMode().equals("-o") || op.getMode().equals("-g")) {
            cmd[count++] = op.getAclString();
        }
        HAOperationResult result = HAOperationImpl.runCommand(cmd);
        return result;
    }

    public static HAOperationResult getperm(HAGetPermOperation op) {
        String[] cmd = new String[]{op.getVerb(), op.getResourceName()};
        return HAOperationImpl.runCommand(cmd);
    }

    public static HAOperationResult racgwrap(HARacgWrapOperation op) {
        int count = 5;
        String[] cmd = new String[count];
        count = 0;
        cmd[count++] = op.getVerb();
        cmd[count++] = op.getOpType();
        cmd[count++] = op.getDatabaseName();
        cmd[count++] = op.getInstanceName();
        cmd[count++] = op.getServiceName();
        HAOperationResult result = HAOperationImpl.runCommand(cmd);
        return result;
    }

    protected static void writeProfileOnDisk(HAOperation op) throws IOException {
        String resourceName = op.getResourceName();
        String[] cmd = new String[]{op.getCrsStatusVerb(), "-p", resourceName};
        Trace.out("Writing the profile on disk for " + resourceName);
        Trace.out("Running " + cmd[0] + " for " + cmd[2]);
        HAOperationResult result = HAOperationImpl.runCommand(cmd);
        String[] output = result.getOutput();
        String profileFileName = op.getProfileHome() + File.separator + resourceName + ".cap";
        Trace.out("Writing profile on disk at " + profileFileName);
        FileOutputStream outputFile = new FileOutputStream(profileFileName);
        for (int i = 0; i < output.length; ++i) {
            outputFile.write(output[i].getBytes());
            outputFile.write(10);
        }
        outputFile.close();
    }

    private static void deleteProfileOnDisk(HAOperation op) {
        String resourceName = op.getResourceName();
        String profileFileName = op.getProfileHome() + File.separator + resourceName + ".cap";
        File profileFile = new File(profileFileName);
        profileFile.delete();
    }

    public static String getHasHome() {
        String hasHome = null;
        try {
            Util hasUtil = new Util();
            hasHome = hasUtil.getCRSHome();
        }
        catch (UtilException ue) {
            Trace.out("UtilException caught in getHasHome");
            Trace.out("CRS_HOME not defined");
        }
        Trace.out("CRS_HOME: " + hasHome);
        return hasHome;
    }

    public static HAOperationResult runCommand(String[] cmd) {
        return HAOperationImpl.runCommand(cmd, null, null);
    }

    static HAOperationResult runCommand(String[] cmd, String[] input, String[] env) {
        int status;
        int signedret;
        if (Trace.isLevelEnabled(16)) {
            StringBuffer cmdline = new StringBuffer();
            for (int i = 0; i < cmd.length; ++i) {
                cmdline.append(cmd[i] + " ");
            }
            Trace.out("CRS cmd is: " + cmdline.toString());
        }
        RuntimeExec rtExec = new RuntimeExec(cmd, input, env);
        int ret = signedret = rtExec.runCommand();
        Trace.out("signed exit value = " + signedret);
        if (signedret < 0) {
            ret = signedret & 0xFF;
            Trace.out("Unsigned return code = " + ret);
        }
        if (ret == 0) {
            Trace.out("set status OK");
            status = 0;
        } else if (ret == 210) {
            Trace.out("set status HA_RES_NOT_EXIST_ERR");
            status = 210;
        } else if (ret == 211) {
            Trace.out("set status HA_RES_ALREADY_REGISTERED");
            status = 211;
        } else if (ret == 212) {
            Trace.out("set status HA_RES_NOT_REGISTERED");
            status = 212;
        } else if (ret == 216) {
            Trace.out("set status HA_CANNOT_STOP_RES");
            status = 216;
        } else if (ret == 123) {
            Trace.out("set status HA_RES_RELOCATE_ERR");
            status = 123;
        } else {
            Trace.out("set status FAILED");
            status = 1;
        }
        HAOperationResult result = new HAOperationResult(status, rtExec.getOutput(), rtExec.getError());
        return result;
    }

    public static Properties loadProfileProperties() {
        InputStream in = null;
        Properties properties = new Properties();
        Trace.out("loading profile properties from profile.properties");
        try {
            in = HAOperationImpl.class.getResourceAsStream("profile.properties");
            if (in == null) {
                Trace.out("Could not find the input resource");
            } else {
                properties.load(in);
                Trace.out("loaded properties from profile.properties");
            }
        }
        catch (IOException e) {
            Trace.out("Can't read properties file:" + e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                in = null;
            }
        }
        return properties;
    }

    private static void addOraOption(StringBuffer optBuffer, String type, String key, Properties properties) {
        HAOperationImpl.addOraOption(optBuffer, type, key, properties, true);
    }

    private static void addOraOption(StringBuffer optBuffer, String type, String key, Properties properties, boolean appendComma) {
        String propertyName = "ha.profile." + type + "." + key;
        String val = properties.getProperty(propertyName, "");
        Trace.out("read property " + propertyName + " = [" + val + "]");
        optBuffer.append(key + "=");
        optBuffer.append(val);
        if (appendComma) {
            optBuffer.append(",");
        }
    }

    private static String replaceSuffix(String inStr, String newSuffix) {
        String base = inStr.substring(0, inStr.lastIndexOf("."));
        return base + "." + newSuffix;
    }

    protected static HAOperationResult handleException(HAOperationException haoe) {
        return HAOperationImpl.handleException(1, null, haoe);
    }

    protected static HAOperationResult handleException(int status, String[] output, Exception haoe) {
        String[] stringArray;
        if (haoe != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = haoe.getMessage();
        } else {
            stringArray = null;
        }
        return new HAOperationResult(status, output, stringArray);
    }
}

