/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation.ha;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.operation.ha.HAOperation;
import oracle.ops.mgmt.operation.ha.HAOperationException;
import oracle.ops.mgmt.operation.ha.HAOperationImpl;
import oracle.ops.mgmt.operation.ha.HAOperationResult;
import oracle.ops.mgmt.operation.ha.HAStatusOperation;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class HAGetOracleHomeOperation
extends HAOperation
implements Serializable {
    static final long serialVersionUID = 8025830119548957015L;

    public HAGetOracleHomeOperation(String resourceName, Version version) throws HAOperationException {
        super("crs_stat", resourceName, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult run() {
        String actionScriptFile;
        HAStatusOperation statusOp;
        try {
            statusOp = new HAStatusOperation(this.getResourceName(), this.getVersion());
        }
        catch (HAOperationException e) {
            Trace.out(e);
            return HAOperationImpl.handleException(1, null, e);
        }
        HAOperationResult result = HAOperationImpl.status(statusOp);
        Trace.out("Returned from executing the HA Operation");
        String[] output = result.getOutput();
        for (int i = 0; i < output.length; ++i) {
            Trace.out("OUTPUT> " + output[i]);
        }
        String error = result.getError();
        Trace.out("ERROR> " + error);
        if (result.getStatus() != 0) {
            return result;
        }
        String oracleHome = null;
        String profileFileName = this.getProfileHome() + File.separator + this.getResourceName() + ".cap";
        try {
            HAOperationImpl.writeProfileOnDisk(this);
            Trace.out("Wrote profile in " + profileFileName);
            actionScriptFile = Utils.getPropertyValue(profileFileName, "ACTION_SCRIPT", true);
            if (actionScriptFile != null) {
                oracleHome = new SystemFactory().CreateSystem().isUnixSystem() ? Utils.getPropertyValue(actionScriptFile, "ORACLE_HOME", true) : Utils.getPropertyValue(actionScriptFile, "set ORACLE_HOME", true);
            }
        }
        catch (FileNotFoundException e) {
            Trace.out(e);
            HAOperationResult hAOperationResult = HAOperationImpl.handleException(1, null, e);
            return hAOperationResult;
        }
        catch (IOException e) {
            Trace.out(e);
            HAOperationResult hAOperationResult = HAOperationImpl.handleException(1, null, e);
            return hAOperationResult;
        }
        finally {
            new File(profileFileName).delete();
        }
        if (oracleHome == null) {
            Object[] args = new Object[]{"ORACLE_HOME", actionScriptFile, oracleHome};
            HAOperationException e = new HAOperationException("1078", args, null);
            return HAOperationImpl.handleException(1, null, e);
        }
        Trace.out("oracleHome=" + oracleHome + " for resource=" + this.getResourceName());
        output = new String[]{oracleHome};
        return HAOperationImpl.handleException(0, output, null);
    }
}

