/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation;

import java.io.Serializable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.operation.InstanceResult;
import oracle.ops.mgmt.operation.Operation;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.rawdevice.RawDeviceConfig;
import oracle.ops.mgmt.rawdevice.RawDeviceException;

public class RenameInstanceOperation
extends Operation
implements Serializable {
    static final long serialVersionUID = -4569236844020591435L;
    private String m_opsName;
    private String m_srcInstName;
    private String m_dstInstName;

    public RenameInstanceOperation(String ops, String src, String dst, Version v) {
        super(true, v);
        this.m_opsName = ops;
        this.m_srcInstName = src;
        this.m_dstInstName = dst;
    }

    public String getOpsName() {
        return this.m_opsName;
    }

    public String getSrcInstanceName() {
        return this.m_srcInstName;
    }

    public String getDstInstanceName() {
        return this.m_dstInstName;
    }

    @Override
    public OperationResult run() {
        InstanceResult result = null;
        try {
            RawDeviceConfig rawdeviceConfig = RawDeviceConfig.init(this.m_myVersion);
            rawdeviceConfig.renameInstance(this.m_opsName, this.m_srcInstName, this.m_dstInstName);
            result = new InstanceResult(0);
        }
        catch (RawDeviceException e) {
            result = new InstanceResult(1, e.getMessage());
        }
        return result;
    }
}

