/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation;

import java.io.Serializable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.operation.GetVIPRangeConfigurationResult;
import oracle.ops.mgmt.operation.Operation;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.rawdevice.RawDeviceConfig;
import oracle.ops.mgmt.rawdevice.RawDeviceException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.mgmt.viprange.VIPRangeConfiguration;

public class GetVIPRangeConfigurationOperation
extends Operation
implements Serializable {
    static final long serialVersionUID = -7298492198926649893L;

    public GetVIPRangeConfigurationOperation(Version v) {
        super(true, v);
    }

    @Override
    public OperationResult run() {
        VIPRangeConfiguration[] vipRangeConfig = null;
        GetVIPRangeConfigurationResult result = null;
        try {
            Trace.out("in GetVIPRangeConfigurationOperation.run()");
            RawDeviceConfig rawdeviceConfig = RawDeviceConfig.init(this.m_myVersion);
            Trace.out("initialized raw device config");
            vipRangeConfig = rawdeviceConfig.getVIPRangeConfigurations();
            Trace.out("got vip range configuration");
            result = new GetVIPRangeConfigurationResult(0, vipRangeConfig);
        }
        catch (RawDeviceException e) {
            Trace.out(e);
            result = new GetVIPRangeConfigurationResult(1, e.getMessage());
        }
        if (result == null) {
            Trace.out("result is null!");
        } else {
            Trace.out("result says " + result.getStatus());
        }
        return result;
    }
}

