/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation;

import java.io.Serializable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ParallelServerConfig;
import oracle.ops.mgmt.operation.GetConfigurationResult;
import oracle.ops.mgmt.operation.Operation;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.rawdevice.RawDeviceConfig;
import oracle.ops.mgmt.rawdevice.RawDeviceException;
import oracle.ops.mgmt.trace.Trace;

public class GetConfigurationOperation
extends Operation
implements Serializable {
    static final long serialVersionUID = -7298492198926649893L;
    private String m_opsName;

    public GetConfigurationOperation(String ops, Version v) {
        super(true, v);
        this.m_opsName = ops;
    }

    public String getOpsName() {
        return this.m_opsName;
    }

    @Override
    public OperationResult run() {
        ParallelServerConfig opsConfig = null;
        GetConfigurationResult result = null;
        try {
            Trace.out("in GetConfigurationOperation.run()");
            RawDeviceConfig rawdeviceConfig = RawDeviceConfig.init(this.m_myVersion);
            Trace.out("initialized raw device config");
            opsConfig = rawdeviceConfig.getConfiguration(this.m_opsName);
            Trace.out("got configuration for ops " + this.m_opsName);
            result = new GetConfigurationResult(0, opsConfig);
        }
        catch (RawDeviceException e) {
            Trace.out(e);
            result = new GetConfigurationResult(1, e.getMessage());
            result.setException(e);
        }
        if (result == null) {
            Trace.out("result is null!");
        } else {
            Trace.out("result says " + result.getStatus());
        }
        return result;
    }
}

