/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation;

import java.io.File;
import java.io.Serializable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.RuntimeExec;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.operation.DeleteOracleServiceResult;
import oracle.ops.mgmt.operation.Operation;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.operation.ParallelServerImpl;
import oracle.ops.mgmt.trace.Trace;

public class DeleteOracleServiceOperation
extends Operation
implements Serializable {
    static final long serialVersionUID = -2722434215634867233L;
    private String m_sidName;
    private String m_oracleHome;
    private String m_nodeName;

    public DeleteOracleServiceOperation(String oracleHome, String sid) {
        this.m_oracleHome = oracleHome;
        this.m_sidName = sid;
    }

    public DeleteOracleServiceOperation(String oracleHome, String sid, String node, Version version) {
        this(oracleHome, sid);
        this.m_myVersion = version;
        this.m_nodeName = node;
    }

    public String getInstanceName() {
        return this.m_sidName;
    }

    public void setInstanceName(String inst) {
        this.m_sidName = inst;
    }

    public String getOracleHome() {
        return this.m_oracleHome;
    }

    public void setOracleHome(String oracleHome) {
        this.m_oracleHome = oracleHome;
    }

    @Override
    public OperationResult run() {
        DeleteOracleServiceResult result;
        if (Version.isPre10i(this.m_myVersion)) {
            result = ParallelServerImpl.deleteOracleService(this);
        } else {
            String cmd = this.m_oracleHome + File.separator + "bin" + File.separator + "oradim.exe -delete -host " + this.m_nodeName + " -ORACLE_HOME " + this.m_oracleHome + " -sid " + this.m_sidName.toUpperCase();
            Trace.out("createOracleService cmd=" + cmd);
            NativeSystem nativeSystem = new SystemFactory().CreateSystem();
            RuntimeExec rt = new RuntimeExec(NativeSystem.getCmdArr(cmd), null, null);
            int exitStat = rt.runCommand();
            String[] output = rt.getOutput();
            String[] error = rt.getError();
            int status = exitStat == 0 ? 0 : 1;
            String[] newout = new String[output.length + error.length];
            for (int i = 0; i < output.length; ++i) {
                newout[i] = output[i];
            }
            result = new DeleteOracleServiceResult(status, newout);
        }
        return result;
    }
}

