/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation;

import java.io.Serializable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.operation.ConfigurationResult;
import oracle.ops.mgmt.operation.Operation;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.rawdevice.OCRTree;
import oracle.ops.mgmt.viprange.VIPRangeConfiguration;

public class AddVIPRangeConfigurationOperation
extends Operation
implements Serializable {
    static final long serialVersionUID = 5425551853606829172L;
    private VIPRangeConfiguration[] m_vipRangeConfigs;

    public AddVIPRangeConfigurationOperation(VIPRangeConfiguration[] vipRangeConfigs, Version v) {
        super(true, v);
        this.m_vipRangeConfigs = vipRangeConfigs;
    }

    public VIPRangeConfiguration[] getConfiguration() {
        return this.m_vipRangeConfigs;
    }

    @Override
    public OperationResult run() {
        ConfigurationResult result = null;
        try {
            OCRTree ocrTree = OCRTree.init(this.m_myVersion);
            ocrTree.setVIPRangeConfigurations(this.m_vipRangeConfigs);
            result = new ConfigurationResult(0);
        }
        catch (OCRException e) {
            e.printStackTrace();
            result = new ConfigurationResult(1, e.getMessage());
        }
        return result;
    }
}

