/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.nodeapps.config;

import java.util.Vector;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.LocalCommand;
import oracle.ops.mgmt.database.HAResourceStatus;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.operation.GetEnvOperation;
import oracle.ops.mgmt.operation.GetEnvResult;
import oracle.ops.mgmt.operation.SetEnvOperation;
import oracle.ops.mgmt.operation.SetEnvResult;
import oracle.ops.mgmt.operation.UnsetEnvOperation;
import oracle.ops.mgmt.operation.UnsetEnvResult;
import oracle.ops.mgmt.operation.ha.HAGetOracleHomeOperation;
import oracle.ops.mgmt.operation.ha.HALiterals;
import oracle.ops.mgmt.operation.ha.HAOperationException;
import oracle.ops.mgmt.operation.ha.HAOperationResult;
import oracle.ops.mgmt.operation.ha.HAProfileOperation;
import oracle.ops.mgmt.operation.ha.HARegisterOperation;
import oracle.ops.mgmt.operation.ha.HASetPermOperation;
import oracle.ops.mgmt.operation.ha.HAStartOperation;
import oracle.ops.mgmt.operation.ha.HAStatusOperation;
import oracle.ops.mgmt.operation.ha.HAStopOperation;
import oracle.ops.mgmt.operation.ha.HAUnregisterOperation;
import oracle.ops.mgmt.rawdevice.OCR;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.rawdevice.OCRTreeDefinitionHA;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class NodeApps
implements Constants,
HALiterals {
    private String m_nodeName;
    private Version m_version;

    public NodeApps(String nodeName) {
        this(nodeName, new Version());
    }

    public NodeApps(String nodeName, Version version) {
        this.m_nodeName = nodeName;
        this.m_version = version;
        Trace.out("in constructor with " + this.m_nodeName);
    }

    public void setEnv(String name, String value) throws NodeException {
        String[] envName = new String[]{name};
        String[] envValue = new String[]{value};
        this.setEnv(envName, envValue);
    }

    public void setEnv(String[] names, String[] values) throws NodeException {
        String opsName = null;
        String entityName = this.m_nodeName;
        SetEnvOperation setEnvOp = new SetEnvOperation(opsName, entityName, 103, names, values, this.m_version);
        SetEnvResult result = null;
        LocalCommand localCommand = new LocalCommand(setEnvOp);
        localCommand.execute();
        result = (SetEnvResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            String errMsg = result.getErrorMessage();
            throw new NodeException(errMsg);
        }
    }

    public void unsetEnv(String name) throws NodeException {
        String[] envName = new String[]{name};
        String opsName = null;
        String entityName = this.m_nodeName;
        Trace.out("Unsetting environment " + name);
        UnsetEnvOperation unsetEnvOp = new UnsetEnvOperation(opsName, entityName, 103, envName, this.m_version);
        UnsetEnvResult result = null;
        LocalCommand localCommand = new LocalCommand(unsetEnvOp);
        localCommand.execute();
        result = (UnsetEnvResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            String errMsg = result.getErrorMessage();
            throw new NodeException(errMsg);
        }
    }

    public String[] getEnv(String[] envName) throws NodeException {
        String opsName = null;
        String entityName = this.m_nodeName;
        GetEnvOperation getEnvOp = new GetEnvOperation(opsName, entityName, 103, envName, this.m_version);
        GetEnvResult result = null;
        LocalCommand localCommand = new LocalCommand(getEnvOp);
        localCommand.execute();
        result = (GetEnvResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            String errMsg = result.getErrorMessage();
            throw new NodeException(errMsg);
        }
        return result.getEnvValue();
    }

    public String[] getEnv() throws NodeException {
        String opsName = null;
        String entityName = this.m_nodeName;
        GetEnvOperation getEnvOp = new GetEnvOperation(opsName, entityName, 103, this.m_version);
        GetEnvResult result = null;
        LocalCommand localCommand = new LocalCommand(getEnvOp);
        localCommand.execute();
        result = (GetEnvResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            String errMsg = result.getErrorMessage();
            throw new NodeException(errMsg);
        }
        String[] envValues = result.getEnvValue();
        return envValues;
    }

    public boolean isExists(String resourceName) throws NodeException {
        HAStatusOperation statusOp = null;
        try {
            statusOp = new HAStatusOperation(resourceName, this.m_version);
        }
        catch (HAOperationException e) {
            Trace.out("Failed to get the status of resource: " + resourceName);
            throw new NodeException(e.getMessage());
        }
        HAOperationResult result = null;
        LocalCommand localCommand = new LocalCommand(statusOp);
        localCommand.execute();
        result = (HAOperationResult)localCommand.getOperationResult();
        int retVal = result.getStatus();
        if (retVal == 0) {
            return true;
        }
        if (retVal == 210) {
            return false;
        }
        throw new NodeException(result.getOutputAll());
    }

    public boolean isRunning(String resourceName) throws NodeException {
        return this.nodeRunning(resourceName) != null;
    }

    public String nodeRunning(String resourceName) throws NodeException {
        HAStatusOperation statOp;
        try {
            statOp = new HAStatusOperation(resourceName, this.m_version);
        }
        catch (HAOperationException haoe) {
            throw new NodeException(haoe.getMessage());
        }
        Trace.out("Finding the status of " + statOp.getResourceName() + " on " + this.m_nodeName);
        HAOperationResult result = null;
        LocalCommand localCommand = new LocalCommand(statOp);
        localCommand.execute();
        result = (HAOperationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            throw new NodeException(result.getOutputAll());
        }
        String[] statOutput = result.getOutput();
        Vector stats = HAResourceStatus.parseHAStatusOutput(statOutput);
        HAResourceStatus stat = (HAResourceStatus)stats.elementAt(0);
        if (stat.isOnline()) {
            return stat.getHost();
        }
        return null;
    }

    public void start(String resourceName) throws NodeException {
        HAStartOperation startOp;
        try {
            startOp = new HAStartOperation(resourceName, this.m_version);
        }
        catch (HAOperationException haoe) {
            throw new NodeException(haoe.getMessage());
        }
        Trace.out("Starting service for " + startOp.getResourceName() + " on " + this.m_nodeName);
        HAOperationResult result = null;
        LocalCommand localCommand = new LocalCommand(startOp);
        localCommand.execute();
        result = (HAOperationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            throw new NodeException(result.getOutputAll());
        }
    }

    public void stop(String resourceName, boolean bForce) throws NodeException {
        this.stop(new String[]{resourceName}, bForce);
    }

    public void stop(String[] resourceNames, boolean bForce) throws NodeException {
        HAStopOperation stopOp;
        String forceStop = bForce ? "-f" : null;
        try {
            stopOp = new HAStopOperation(resourceNames, forceStop, null, this.m_version);
            Trace.out("Stopping service for " + stopOp.getResourceName() + " on " + this.m_nodeName);
        }
        catch (HAOperationException haoe) {
            throw new NodeException(haoe.getMessage());
        }
        HAOperationResult result = null;
        LocalCommand localCommand = new LocalCommand(stopOp);
        localCommand.execute();
        result = (HAOperationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            throw new NodeException(result.getOutputAll());
        }
    }

    public void generateProfile(String resourceName, String oracleHome, String profileType) throws NodeException {
        HAProfileOperation profileOp = null;
        try {
            profileOp = new HAProfileOperation(resourceName, oracleHome, profileType, this.m_nodeName, this.m_version);
        }
        catch (HAOperationException haoe) {
            Trace.out("Error generating profile for resource: " + resourceName);
            throw new NodeException(haoe.getMessage());
        }
        LocalCommand localCommand = null;
        localCommand = new LocalCommand(profileOp);
        localCommand.execute();
        HAOperationResult result = null;
        result = (HAOperationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Trace.out(profileType + ": profile operation failed");
            throw new NodeException(result.getOutputAll());
        }
    }

    public void register(String resourceName, boolean bUpdate) throws NodeException {
        HARegisterOperation registerOp;
        try {
            registerOp = new HARegisterOperation(resourceName, bUpdate, this.m_version);
        }
        catch (HAOperationException haoe) {
            throw new NodeException(haoe.getMessage());
        }
        HAOperationResult result = null;
        LocalCommand localCommand = new LocalCommand(registerOp);
        Trace.out("Registering application for " + registerOp.getResourceName() + " on " + this.m_nodeName);
        localCommand.execute();
        result = (HAOperationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            throw new NodeException(result.getOutputAll());
        }
    }

    public void unregister(String resourceName) throws NodeException {
        HAUnregisterOperation unregisterOp;
        LocalCommand lCommand = null;
        try {
            unregisterOp = new HAUnregisterOperation(resourceName, this.m_version);
            Trace.out("Unregistering service for " + unregisterOp.getResourceName() + " on " + this.m_nodeName);
        }
        catch (HAOperationException haoe) {
            throw new NodeException(haoe.getMessage());
        }
        HAOperationResult result = null;
        lCommand = new LocalCommand(unregisterOp);
        lCommand.execute();
        result = (HAOperationResult)lCommand.getOperationResult();
        if (result.getStatus() != 0) {
            throw new NodeException(result.getOutputAll());
        }
    }

    public void setPermUpdate(String resourceName, int permType, String id) throws NodeException {
        HASetPermOperation setPermOp = null;
        try {
            setPermOp = new HASetPermOperation(resourceName, permType, "-u", id, this.m_version);
        }
        catch (HAOperationException haoe) {
            throw new NodeException(haoe.getMessage());
        }
        Trace.out("setperm user for " + setPermOp.getResourceName());
        LocalCommand localCommand = new LocalCommand(setPermOp);
        localCommand.execute();
        HAOperationResult result = (HAOperationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            throw new NodeException(result.getOutputAll());
        }
    }

    public void setPermOwner(String resourceName, String id) throws NodeException {
        this.setPermID(resourceName, 1, id);
    }

    public void setPermGroup(String resourceName, String id) throws NodeException {
        this.setPermID(resourceName, 2, id);
    }

    void setPermID(String resourceName, int permType, String id) throws NodeException {
        HASetPermOperation setPermOp = null;
        try {
            setPermOp = new HASetPermOperation(resourceName, permType == 1 ? HA_PERM_OWNER_OPTION : HA_PERM_GROUP_OPTION, id, this.m_version);
        }
        catch (HAOperationException haoe) {
            throw new NodeException(haoe.getMessage());
        }
        Trace.out("setperm ID for " + setPermOp.getResourceName());
        LocalCommand localCommand = new LocalCommand(setPermOp);
        localCommand.execute();
        HAOperationResult result = (HAOperationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            throw new NodeException(result.getOutputAll());
        }
    }

    public String getOracleHome(String resourceName) throws NodeException {
        String oracleHome;
        try {
            HAGetOracleHomeOperation op = new HAGetOracleHomeOperation(resourceName, this.m_version);
            LocalCommand lc = new LocalCommand(op);
            lc.execute();
            HAOperationResult result = (HAOperationResult)lc.getOperationResult();
            if (result.getStatus() != 0) {
                throw new NodeException(result.getOutputAll());
            }
            oracleHome = Utils.getString(result.getOutput(), "");
        }
        catch (HAOperationException haoe) {
            throw new NodeException(haoe.getMessage());
        }
        Trace.out("oracleHome = " + oracleHome);
        return oracleHome;
    }

    public String getUserName() throws NodeException {
        OCR ocr = null;
        String oUser = null;
        try {
            ocr = OCR.init(3, this.m_version);
            OCRTreeDefinitionHA ocrTreeDefHA = new OCRTreeDefinitionHA();
            oUser = ocr.getUserName(ocrTreeDefHA.getDBRootKey());
            Trace.out("CRS user is " + oUser);
        }
        catch (OCRException oe) {
            throw new NodeException(oe.getMessage());
        }
        return oUser;
    }

    public String getGroupName() throws NodeException {
        OCR ocr = null;
        String oGroup = null;
        try {
            ocr = OCR.init(3, this.m_version);
            OCRTreeDefinitionHA ocrTreeDefHA = new OCRTreeDefinitionHA();
            oGroup = ocr.getGroupName(ocrTreeDefHA.getDBRootKey());
            Trace.out("CRS user group is " + oGroup);
        }
        catch (OCRException oe) {
            throw new NodeException(oe.getMessage());
        }
        return oGroup;
    }
}

