/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.nodeapps;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Pattern;
import oracle.cluster.resources.PrCcMsgID;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.RemoteDirException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.LocalCommand;
import oracle.ops.mgmt.database.HAResourceStatus;
import oracle.ops.mgmt.has.AlreadyExistsException;
import oracle.ops.mgmt.has.NodeNotFoundException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.has.VIPException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.IPAddressException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.nodeapps.VirtualIPException;
import oracle.ops.mgmt.nodeapps.config.NodeApps;
import oracle.ops.mgmt.nodeapps.config.NodeConfiguration;
import oracle.ops.mgmt.operation.AddNodeConfigurationOperation;
import oracle.ops.mgmt.operation.GetNodeConfigurationOperation;
import oracle.ops.mgmt.operation.GetNodeConfigurationResult;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.operation.RemoveNodeConfigurationOperation;
import oracle.ops.mgmt.operation.ha.HALiterals;
import oracle.ops.mgmt.operation.ha.HAOperationException;
import oracle.ops.mgmt.operation.ha.HAOperationResult;
import oracle.ops.mgmt.operation.ha.HAProfileOperation;
import oracle.ops.mgmt.operation.ha.HARelocateOperation;
import oracle.ops.mgmt.operation.ha.HAStatusOperation;
import oracle.ops.mgmt.trace.Trace;

public class VIP
implements HALiterals {
    private String m_nodeName;
    private String m_oracleHome;
    private String m_resName;
    private VIPAddress m_vipAddress;
    private NodeApps m_nodeApp;
    private MessageBundle m_rawMesgBdle = MessageBundle.getMessageBundle("Prkr");
    private MessageBundle m_aMesgBdle = MessageBundle.getMessageBundle("Prka");
    private Version m_version;

    public VIP(String node, String crshome) throws VirtualIPException {
        if (node == null || node.trim().length() == 0) {
            throw new VirtualIPException(MessageBundle.getMessageBundle("Prkc").getMessage("1045", true));
        }
        this.m_version = new Version();
        this.m_nodeName = node;
        this.m_oracleHome = crshome;
        this.m_resName = "ora." + this.m_nodeName.toLowerCase() + ".vip";
        this.m_nodeApp = new NodeApps(this.m_nodeName, this.m_version);
    }

    public VIP(String node) throws VirtualIPException {
        this(node, null);
    }

    public boolean isRunning() throws VirtualIPException {
        try {
            return this.m_nodeApp.isRunning(this.m_resName);
        }
        catch (NodeException ne) {
            throw new VirtualIPException(ne.getMessage());
        }
    }

    public String nodeRunning() throws VirtualIPException {
        try {
            return this.m_nodeApp.nodeRunning(this.m_resName);
        }
        catch (NodeException ne) {
            throw new VirtualIPException(ne.getMessage(), ne);
        }
    }

    public boolean exists() throws VirtualIPException {
        return this.getVIPAddress() != null;
    }

    public VIPAddress getVIPAddress() throws VirtualIPException {
        NodeConfiguration nodeConfig = this.getNodeConfig();
        if (nodeConfig == null) {
            return null;
        }
        return nodeConfig.getVIPAddress();
    }

    public String getOracleHome() throws VirtualIPException {
        if (this.m_oracleHome == null) {
            try {
                this.m_oracleHome = this.m_nodeApp.getOracleHome(this.m_resName);
            }
            catch (NodeException e) {
                throw new VirtualIPException(e.getMessage(), e);
            }
        }
        return this.m_oracleHome;
    }

    private NodeConfiguration getNodeConfig() throws VirtualIPException {
        GetNodeConfigurationOperation nodeConfigOp = new GetNodeConfigurationOperation(this.m_nodeName, this.m_version);
        GetNodeConfigurationResult result = null;
        LocalCommand lCommand = new LocalCommand(nodeConfigOp);
        lCommand.execute();
        result = (GetNodeConfigurationResult)lCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Trace.out("Failed to find node configuration for node:" + this.m_nodeName);
            Object[] args = new String[]{this.m_nodeName};
            throw new VirtualIPException(this.m_rawMesgBdle.getMessage("1062", true, args));
        }
        return result.getResult();
    }

    public void start() throws VirtualIPException {
        try {
            this.m_nodeApp.start(this.m_resName);
        }
        catch (NodeException ne) {
            throw new VirtualIPException(ne.getMessage());
        }
    }

    public void stopForce() throws VirtualIPException {
        try {
            this.m_nodeApp.stop(this.m_resName, true);
        }
        catch (NodeException ne) {
            throw new VirtualIPException(ne.getMessage());
        }
    }

    public void stop() throws VirtualIPException {
        this.stop(false);
    }

    public void stop(boolean bAll) throws VirtualIPException {
        try {
            String[] stringArray;
            if (bAll) {
                stringArray = this.getRunningResourceNames();
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.m_resName;
            }
            String[] resNames = stringArray;
            if (resNames.length == 0) {
                resNames = new String[]{this.m_resName};
            }
            this.m_nodeApp.stop(resNames, false);
        }
        catch (NodeException ne) {
            throw new VirtualIPException(ne.getMessage());
        }
    }

    public boolean relocate(boolean bAll) throws VirtualIPException {
        return this.performRelocate(null, bAll);
    }

    public boolean relocate(String node) throws VirtualIPException {
        try {
            VIP.assertNodeName(node);
        }
        catch (NodeException ne) {
            throw new VirtualIPException(ne.getMessage(), ne);
        }
        return this.performRelocate(node, false);
    }

    private boolean performRelocate(String node, boolean bAll) throws VirtualIPException {
        String[] stringArray;
        if (bAll) {
            stringArray = this.getRunningResourceNames();
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.m_resName;
        }
        String[] resNames = stringArray;
        if (resNames.length == 0) {
            resNames = new String[]{this.m_resName};
        }
        HARelocateOperation relocateOp = null;
        try {
            relocateOp = node != null ? new HARelocateOperation(resNames, node, this.m_version) : new HARelocateOperation(resNames, this.m_version);
        }
        catch (HAOperationException haoe) {
            throw new VirtualIPException(haoe.getMessage(), haoe);
        }
        LocalCommand localCommand = new LocalCommand(relocateOp);
        localCommand.execute();
        HAOperationResult result = (HAOperationResult)localCommand.getOperationResult();
        int status = result.getStatus();
        if (status == 0) {
            return true;
        }
        if (status == 123) {
            return false;
        }
        Trace.out("VIP: relocate operation failed");
        throw new VirtualIPException(result.getOutputAll());
    }

    public synchronized void create(VIPAddress vipAddr) throws VirtualIPException {
        try {
            VIP.assertNodeName(this.m_nodeName);
            VIP.assertCRSHome(this.m_nodeName, this.m_oracleHome);
        }
        catch (NodeException e) {
            throw new VirtualIPException(e.getMessage(), e);
        }
        this.assertInterfaces(vipAddr);
        boolean checkRoot = !Boolean.getBoolean("srvm.vip.no_root_check");
        Util hasUtl = null;
        String primaryGroup = null;
        String oUser = null;
        String oGroup = null;
        if (checkRoot) {
            try {
                hasUtl = new Util();
                if (!hasUtl.hasHAPrivilege()) {
                    throw new VirtualIPException(this.m_aMesgBdle.getMessage("2018", true));
                }
            }
            catch (UtilException e) {
                throw new VirtualIPException(e.getMessage());
            }
            if (new SystemFactory().CreateSystem().isUnixSystem()) {
                try {
                    Trace.out("Getting the current user primary group");
                    primaryGroup = hasUtl.getCurrentUserPrimaryGroup();
                    Trace.out("primaryGroup =" + primaryGroup);
                }
                catch (UtilException e) {
                    throw new VirtualIPException(e.getMessage());
                }
                try {
                    oUser = this.m_nodeApp.getUserName();
                    oGroup = this.m_nodeApp.getGroupName();
                    Trace.out("oracle user is " + oUser);
                    Trace.out("oracle group is " + oGroup);
                }
                catch (NodeException ne) {
                    throw new VirtualIPException(ne.getMessage());
                }
            }
        }
        boolean update = this.exists();
        this.m_vipAddress = vipAddr;
        Trace.out("Generating profile");
        this.generateProfile();
        try {
            this.m_nodeApp.register(this.m_resName, update);
        }
        catch (NodeException ne) {
            throw new VirtualIPException(ne.getMessage());
        }
        if (checkRoot && new SystemFactory().CreateSystem().isUnixSystem()) {
            try {
                this.m_nodeApp.setPermUpdate(this.m_resName, 1, oUser);
                if (primaryGroup != null && !primaryGroup.equals(oGroup)) {
                    Trace.out("Adding OINSTALL group to VIP resource");
                    this.m_nodeApp.setPermGroup(this.m_resName, oGroup);
                }
            }
            catch (NodeException ne) {
                throw new VirtualIPException(ne.getMessage());
            }
            Trace.out("VIP resource ownership changed successfully to user:" + oUser);
            Trace.out("VIP resource group changed successfully to group:" + oGroup);
        }
        oracle.ops.mgmt.has.VIP vip = null;
        try {
            vip = new oracle.ops.mgmt.has.VIP();
            if (this.m_vipAddress.getInterfaces() == null) {
                vip.create(this.m_vipAddress.getVIPName(), this.m_vipAddress.getIPAddress().getHostAddress(), this.m_nodeName, this.m_vipAddress.getNetmask());
            } else {
                vip.create(this.m_vipAddress.getVIPName(), this.m_vipAddress.getIPAddress().getHostAddress(), this.m_nodeName, this.m_vipAddress.getNetmask(), this.m_vipAddress.getInterfaces());
            }
        }
        catch (VIPException e) {
            throw new VirtualIPException(e.getMessage());
        }
        catch (NodeNotFoundException e) {
            throw new VirtualIPException(e.getMessage());
        }
        catch (AlreadyExistsException e) {
            throw new VirtualIPException(e.getMessage());
        }
        finally {
            if (vip != null) {
                try {
                    vip.destroy();
                }
                catch (VIPException vIPException) {}
            }
        }
        NodeConfiguration nodeConfig = new NodeConfiguration(this.m_nodeName, this.m_oracleHome, this.m_vipAddress, null);
        AddNodeConfigurationOperation addOp = new AddNodeConfigurationOperation(nodeConfig, this.m_version);
        LocalCommand lCommand = new LocalCommand(addOp);
        lCommand.execute();
        OperationResult opResult = lCommand.getOperationResult();
        if (opResult.getStatus() != 0) {
            Object[] args = new Object[]{this.m_nodeName};
            throw new VirtualIPException(this.m_rawMesgBdle.getMessage("1060", true, args));
        }
    }

    public void remove() throws VirtualIPException {
        this.remove(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(boolean force) throws VirtualIPException {
        StringBuffer stagedExceptionMesgs;
        block25: {
            Trace.out("Removing VIP " + this.m_resName);
            boolean checkRoot = !Boolean.getBoolean("srvm.vip.no_root_check");
            stagedExceptionMesgs = new StringBuffer();
            Util hasUtl = null;
            if (checkRoot) {
                try {
                    hasUtl = new Util();
                    if (!hasUtl.hasHAPrivilege()) {
                        throw new VirtualIPException(this.m_aMesgBdle.getMessage("2018", true));
                    }
                }
                catch (UtilException e) {
                    throw new VirtualIPException(e.getMessage());
                }
            }
            try {
                this.m_nodeApp.unregister(this.m_resName);
            }
            catch (NodeException ne) {
                if (force) {
                    stagedExceptionMesgs.append(ne.getMessage());
                }
                throw new VirtualIPException(ne.getMessage());
            }
            Trace.out("Removing with navive has.VIP");
            this.m_vipAddress = this.getVIPAddress();
            if (this.m_vipAddress != null) {
                oracle.ops.mgmt.has.VIP vip = null;
                try {
                    vip = new oracle.ops.mgmt.has.VIP();
                    vip.delete(this.m_vipAddress.getVIPName());
                }
                catch (VIPException e) {
                    if (force) {
                        stagedExceptionMesgs.append(System.getProperty("line.separator"));
                        stagedExceptionMesgs.append(e.getMessage());
                        break block25;
                    }
                    throw new VirtualIPException(e.getMessage());
                }
                finally {
                    if (vip != null) {
                        try {
                            vip.destroy();
                        }
                        catch (VIPException e) {}
                    }
                }
            }
        }
        Trace.out("Delete from OCR");
        RemoveNodeConfigurationOperation removeOp = new RemoveNodeConfigurationOperation(this.m_nodeName, this.m_version);
        LocalCommand lCommand = new LocalCommand(removeOp);
        lCommand.execute();
        OperationResult opResult = lCommand.getOperationResult();
        if (opResult.getStatus() != 0) {
            String mesg = opResult.getException().getMessage();
            if (force) {
                stagedExceptionMesgs.append(System.getProperty("line.separator"));
                stagedExceptionMesgs.append(mesg);
            } else {
                throw new VirtualIPException(mesg);
            }
        }
        if (stagedExceptionMesgs.length() > 0) {
            throw new VirtualIPException(stagedExceptionMesgs.toString());
        }
    }

    public void modifyHome(String crsHome) throws VirtualIPException {
        try {
            VIP.assertCRSHome(this.m_nodeName, crsHome);
        }
        catch (NodeException e) {
            throw new VirtualIPException(e.getMessage(), e);
        }
        boolean checkRoot = !Boolean.getBoolean("srvm.vip.no_root_check");
        Util hasUtl = null;
        if (checkRoot) {
            try {
                hasUtl = new Util();
                if (!hasUtl.hasHAPrivilege()) {
                    throw new VirtualIPException(this.m_aMesgBdle.getMessage("2018", true));
                }
            }
            catch (UtilException e) {
                throw new VirtualIPException(e.getMessage());
            }
        }
        NodeConfiguration nodeConfig = this.getNodeConfig();
        nodeConfig.setOracleHome(crsHome);
        AddNodeConfigurationOperation addOp = new AddNodeConfigurationOperation(nodeConfig, this.m_version);
        LocalCommand lCommand = new LocalCommand(addOp);
        lCommand.execute();
        OperationResult opResult = lCommand.getOperationResult();
        if (opResult.getStatus() != 0) {
            Object[] args = new Object[]{this.m_nodeName};
            throw new VirtualIPException(this.m_rawMesgBdle.getMessage("1060", true, args));
        }
        this.m_oracleHome = crsHome;
    }

    public void modifyAddress(VIPAddress newAddr) throws VirtualIPException {
        this.modifyAddress(newAddr, false);
    }

    public void modifyAddress(VIPAddress newAddr, boolean skipVIPReachabilityCheck) throws VirtualIPException {
        InetAddress inAddress = newAddr.getIPAddress();
        if (!skipVIPReachabilityCheck) {
            try {
                if (IPAddressUtil.isPingable(inAddress)) {
                    throw new VirtualIPException(MessageBundle.getMessage(PrCcMsgID.VIP_ADDRESS_REACHABILITY_ERROR, true, inAddress.getHostAddress()));
                }
            }
            catch (IPAddressException ipAddressException) {
                throw new VirtualIPException(ipAddressException.getMessage());
            }
        }
        boolean checkRoot = !Boolean.getBoolean("srvm.vip.no_root_check");
        Util hasUtl = null;
        if (checkRoot) {
            try {
                hasUtl = new Util();
                if (!hasUtl.hasHAPrivilege()) {
                    throw new VirtualIPException(this.m_aMesgBdle.getMessage("2018", true));
                }
            }
            catch (UtilException e) {
                throw new VirtualIPException(e.getMessage());
            }
        }
        NodeConfiguration nodeConfig = this.getNodeConfig();
        if (newAddr.getInterfaces() == null) {
            try {
                this.m_vipAddress = (VIPAddress)newAddr.clone();
                this.m_vipAddress.setInterfaces(nodeConfig.getVIPAddress().getInterfaces());
            }
            catch (CloneNotSupportedException ne) {
                throw new VirtualIPException(ne.getMessage());
            }
        } else {
            this.m_vipAddress = newAddr;
            this.assertInterfaces(this.m_vipAddress);
        }
        Trace.out("Generating profile");
        this.generateProfile();
        try {
            this.m_nodeApp.register(this.m_resName, true);
        }
        catch (NodeException ne) {
            throw new VirtualIPException(ne.getMessage());
        }
        oracle.ops.mgmt.has.VIP vip = null;
        try {
            vip = new oracle.ops.mgmt.has.VIP();
            if (this.m_vipAddress.getInterfaces() == null) {
                vip.create(this.m_vipAddress.getVIPName(), this.m_vipAddress.getIPAddress().getHostAddress(), this.m_nodeName, this.m_vipAddress.getNetmask());
            } else {
                vip.create(this.m_vipAddress.getVIPName(), this.m_vipAddress.getIPAddress().getHostAddress(), this.m_nodeName, this.m_vipAddress.getNetmask(), this.m_vipAddress.getInterfaces());
            }
        }
        catch (VIPException e) {
            throw new VirtualIPException(e.getMessage());
        }
        catch (NodeNotFoundException e) {
            throw new VirtualIPException(e.getMessage());
        }
        catch (AlreadyExistsException e) {
            throw new VirtualIPException(e.getMessage());
        }
        finally {
            if (vip != null) {
                try {
                    vip.destroy();
                }
                catch (VIPException vIPException) {}
            }
        }
        nodeConfig.setVIPAddress(this.m_vipAddress);
        AddNodeConfigurationOperation addOp = new AddNodeConfigurationOperation(nodeConfig, this.m_version);
        LocalCommand lCommand = new LocalCommand(addOp);
        lCommand.execute();
        OperationResult opResult = lCommand.getOperationResult();
        if (opResult.getStatus() != 0) {
            Object[] args = new Object[]{this.m_nodeName};
            throw new VirtualIPException(this.m_rawMesgBdle.getMessage("1060", true, args));
        }
    }

    private void generateProfile() throws VirtualIPException {
        HAProfileOperation profileOp = null;
        try {
            profileOp = new HAProfileOperation(this.m_resName, this.m_oracleHome, "vip", this.m_nodeName, this.m_version);
        }
        catch (HAOperationException haoe) {
            throw new VirtualIPException(haoe.getMessage());
        }
        Trace.out("m_vipAddress is " + this.m_vipAddress);
        profileOp.setVIPAddress(this.m_vipAddress);
        LocalCommand localCommand = null;
        localCommand = new LocalCommand(profileOp);
        localCommand.execute();
        HAOperationResult result = (HAOperationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Trace.out("VIP: profile operation failed");
            throw new VirtualIPException(result.getOutputAll());
        }
    }

    public String getResourceName() {
        return this.m_resName;
    }

    private String[] getRunningResourceNames() throws VirtualIPException {
        HAStatusOperation statOp;
        try {
            statOp = new HAStatusOperation(this.m_version, this.m_nodeName);
        }
        catch (HAOperationException haoe) {
            throw new VirtualIPException(haoe.getMessage(), haoe);
        }
        LocalCommand localCommand = new LocalCommand(statOp);
        localCommand.execute();
        HAOperationResult result = (HAOperationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            throw new VirtualIPException(result.getOutputAll());
        }
        String[] statOutput = result.getOutput();
        Vector vResourceStats = HAResourceStatus.parseHAStatusOutput(result.getOutput());
        ArrayList<String> list = new ArrayList<String>(vResourceStats.size());
        Pattern pattern = Pattern.compile("ora.*.vip");
        for (int i = 0; i < vResourceStats.size(); ++i) {
            HAResourceStatus stat = (HAResourceStatus)vResourceStats.elementAt(i);
            String resourceName = stat.getResourceName();
            if (!pattern.matcher(resourceName).matches() || !stat.isOnline()) continue;
            list.add(resourceName);
        }
        Trace.out("online vipres=" + list.toString());
        String[] resNames = new String[list.size()];
        list.toArray(resNames);
        return resNames;
    }

    static final void assertNodeName(String nodeName) throws NodeException {
        try {
            Cluster.getHostName(nodeName);
        }
        catch (ClusterException e) {
            throw new NodeException(e.getMessage());
        }
    }

    private void assertInterfaces(VIPAddress vipAddr) throws VirtualIPException {
        MessageBundle msgBundle = MessageBundle.getMessageBundle("Prka");
        if (vipAddr == null) {
            throw new VirtualIPException(msgBundle.getMessage("2020", true, new String[]{null}));
        }
        String[] ifs = vipAddr.getInterfaces();
        if (ifs == null || ifs.length == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ifs.length; ++i) {
            String ifname;
            String string = ifname = ifs[i] != null ? ifs[i].trim() : ifs[i];
            if (ifname != null && ifname.length() != 0) continue;
            sb.append("ifs[" + i + "]=" + ifname);
        }
        if (sb.length() > 0) {
            throw new VirtualIPException(msgBundle.getMessage("2021", true, new String[]{sb.toString()}));
        }
    }

    static final void assertCRSHome(String node, String crsHome) throws NodeException {
        MessageBundle msgBundle = MessageBundle.getMessageBundle("Prkc");
        if (crsHome == null || crsHome.trim().length() == 0) {
            throw new NodeException(msgBundle.getMessage("1036", false));
        }
        NativeSystem system = new SystemFactory().CreateSystem();
        try {
            if ((system.isUnixSystem() && !new Util().hasHAPrivilege() || !system.isUnixSystem()) && !system.pathExists(node, crsHome, 1)) {
                Object[] args = new String[]{crsHome, node};
                throw new NodeException(msgBundle.getMessage("1113", false, args));
            }
        }
        catch (RemoteDirException e) {
            throw new NodeException(e.getMessage(), e);
        }
        catch (UtilException e) {
            throw new NodeException(e.getMessage(), e);
        }
    }
}

