/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.nodeapps;

import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.nodeapps.ONSException;
import oracle.ops.mgmt.nodeapps.VIP;
import oracle.ops.mgmt.nodeapps.config.NodeApps;
import oracle.ops.mgmt.operation.ha.HALiterals;
import oracle.ops.mgmt.trace.Trace;

public class ONS
implements HALiterals {
    private String m_nodeName;
    private String m_oracleCRSHome;
    private String m_resName;
    private Version m_version;
    private NodeApps m_nodeApp;
    private MessageBundle m_appMsgBdl;

    public ONS(String node, String crsHome) throws ONSException {
        if (node == null || node.trim().length() == 0) {
            throw new ONSException(MessageBundle.getMessageBundle("Prkc").getMessage("1045", true));
        }
        this.m_oracleCRSHome = crsHome;
        this.m_version = new Version();
        this.m_appMsgBdl = MessageBundle.getMessageBundle("Prka");
        this.m_nodeName = node;
        this.m_resName = "ora." + this.m_nodeName.toLowerCase() + ".ons";
        Trace.out("ONS resource name is " + this.m_resName);
        this.m_nodeApp = new NodeApps(this.m_nodeName, this.m_version);
    }

    public ONS(String node) throws ONSException {
        this(node, null);
    }

    public boolean exists() throws ONSException {
        Trace.out("Checking the existence of ONS resource on node: " + this.m_nodeName);
        try {
            return this.m_nodeApp.isExists(this.m_resName);
        }
        catch (NodeException ne) {
            throw new ONSException(ne.getMessage());
        }
    }

    public boolean isRunning() throws ONSException {
        Trace.out("Checking the status of ONS resource on node: " + this.m_nodeName);
        boolean bStatus = false;
        try {
            bStatus = this.m_nodeApp.isRunning(this.m_resName);
        }
        catch (NodeException ne) {
            throw new ONSException(ne.getMessage());
        }
        Trace.out("Status of " + this.m_resName + " on " + this.m_nodeName + " is " + bStatus);
        return bStatus;
    }

    public void start() throws ONSException {
        Trace.out("Starting ONS resource on node: " + this.m_nodeName);
        try {
            this.m_nodeApp.start(this.m_resName);
        }
        catch (NodeException ne) {
            Trace.out("Failed to start the resource: " + this.m_resName);
            throw new ONSException(ne.getMessage());
        }
        Trace.out("ONS resource started successfully");
    }

    public void stop() throws ONSException {
        Trace.out("Stopping ONS resource on node: " + this.m_nodeName);
        try {
            this.m_nodeApp.stop(this.m_resName, true);
        }
        catch (NodeException ne) {
            Trace.out("Failed to stop the resource: " + this.m_resName);
            throw new ONSException(ne.getMessage());
        }
        Trace.out("ONS resource stopped successfully");
    }

    public void create() throws ONSException {
        try {
            VIP.assertNodeName(this.m_nodeName);
            VIP.assertCRSHome(this.m_nodeName, this.m_oracleCRSHome);
        }
        catch (NodeException e) {
            throw new ONSException(e.getMessage(), e);
        }
        Trace.out("Creating & resgistering ONS resource for node: " + this.m_nodeName);
        boolean checkRoot = !Boolean.getBoolean("srvm.vip.no_root_check");
        Util hasUtl = null;
        String primaryGroup = null;
        String oUser = null;
        String oGroup = null;
        if (checkRoot) {
            try {
                hasUtl = new Util();
                if (!hasUtl.hasHAPrivilege()) {
                    throw new ONSException(this.m_appMsgBdl.getMessage("2018", true));
                }
            }
            catch (UtilException e) {
                throw new ONSException(e.getMessage());
            }
            if (new SystemFactory().CreateSystem().isUnixSystem()) {
                try {
                    primaryGroup = hasUtl.getCurrentUserPrimaryGroup();
                }
                catch (UtilException e) {
                    throw new ONSException(e.getMessage());
                }
                try {
                    oUser = this.m_nodeApp.getUserName();
                    Trace.out("oracle user is " + oUser);
                    oGroup = this.m_nodeApp.getGroupName();
                    Trace.out("oracle OINSTALL group is " + oGroup);
                }
                catch (NodeException ne) {
                    throw new ONSException(ne.getMessage());
                }
            }
        }
        boolean bUpdate = this.exists();
        try {
            this.m_nodeApp.generateProfile(this.m_resName, this.m_oracleCRSHome, "ons");
            this.m_nodeApp.register(this.m_resName, bUpdate);
        }
        catch (NodeException ne) {
            Trace.out("Failed to register the resource: " + this.m_resName);
            throw new ONSException(ne.getMessage());
        }
        if (checkRoot && new SystemFactory().CreateSystem().isUnixSystem()) {
            try {
                this.m_nodeApp.setPermOwner(this.m_resName, oUser);
                if (primaryGroup != null && !primaryGroup.equals(oGroup)) {
                    Trace.out("Adding OINSTALL group to ONS resource");
                    this.m_nodeApp.setPermGroup(this.m_resName, oGroup);
                }
            }
            catch (NodeException ne) {
                Trace.out("Failed to change ownership of the resource: " + this.m_resName);
                throw new ONSException(ne.getMessage());
            }
            Trace.out("ONS resource ownership changed successfully to user:" + oUser);
        }
        Trace.out("ONS resource created & registered successfully");
    }

    public void remove() throws ONSException {
        Trace.out("Removing ONS resource for node: " + this.m_nodeName);
        try {
            this.m_nodeApp.unregister(this.m_resName);
        }
        catch (NodeException ne) {
            Trace.out("Failed to unregister the resource: " + this.m_resName);
            throw new ONSException(ne.getMessage());
        }
        Trace.out("ONS resource unregistered and removed successfully");
    }

    public void modifyHome(String newCRSHome) throws ONSException {
        Trace.out("Modifying Oracle home of the resource: " + this.m_resName);
        if (!this.exists()) {
            Trace.out("Resource: " + this.m_resName + " does not exist to modify");
            return;
        }
        try {
            VIP.assertNodeName(this.m_nodeName);
            VIP.assertCRSHome(this.m_nodeName, newCRSHome);
            Trace.out("Generating profile for ONS resource " + this.m_resName + " on node " + this.m_nodeName);
            this.m_nodeApp.generateProfile(this.m_resName, newCRSHome, "ons");
            this.m_nodeApp.register(this.m_resName, true);
            this.m_oracleCRSHome = newCRSHome;
        }
        catch (NodeException ne) {
            Trace.out("Failed to register the resource: " + this.m_resName + " with new Oracle home: " + this.m_oracleCRSHome);
            throw new ONSException(ne.getMessage());
        }
        Trace.out("ONS resource modified successfully");
    }

    public String getOracleHome() {
        Trace.out("Retrieving the Oracle home of ONS resource for node: " + this.m_nodeName);
        if (this.m_oracleCRSHome == null) {
            try {
                this.m_oracleCRSHome = this.m_nodeApp.getOracleHome(this.m_resName);
            }
            catch (NodeException ne) {
                Trace.out("Failed to retrieve Oracle home of resource: " + this.m_resName);
                Trace.out(ne);
            }
        }
        return this.m_oracleCRSHome;
    }

    public String getResourceName() {
        return this.m_resName;
    }
}

