/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.nativesystem;

import java.io.File;
import oracle.ops.mgmt.nativesystem.RuntimeExec;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;

class sQueryCluster {
    private static final String SKGXN = "/opt/ORCLcluster/lib/libskgxn2.so";
    private static final String SCINSTALL = "/usr/cluster/bin/scinstall";
    private static final String SCSTAT = "/usr/cluster/bin/scstat";

    sQueryCluster() {
    }

    public static boolean isCluster() {
        if (!new SystemFactory().CreateSystem().isUnixSystem()) {
            return true;
        }
        return sQueryCluster.isClusterFile() || sQueryCluster.isSUNCLUSTERConfigured() || sQueryCluster.isSunCluster32();
    }

    private static boolean isClusterFile() {
        File skgxnFile = new File(SKGXN);
        return skgxnFile.exists();
    }

    private static boolean isSUNCLUSTERConfigured() {
        String[] cmd = new String[]{SCSTAT, "-n"};
        File f = new File(cmd[0]);
        if (!f.exists()) {
            if (Trace.isLevelEnabled(1)) {
                Trace.out("Command File /usr/cluster/bin/scstat Does not exist, returning false.");
            }
            return false;
        }
        RuntimeExec runtimeExec = new RuntimeExec(cmd, null, null);
        runtimeExec.runCommand();
        if (Trace.isLevelEnabled(1)) {
            Trace.out("Exit status for cmd is (" + runtimeExec.getExitValue() + ")");
        }
        if (runtimeExec.getExitValue() != 0) {
            if (Trace.isLevelEnabled(1)) {
                Trace.out("Non-zero exit status for cmd (" + cmd[0] + ")");
            }
            return false;
        }
        String[] output = runtimeExec.getOutput();
        String[] error = runtimeExec.getError();
        if (output.length == 0) {
            if (Trace.isLevelEnabled(1)) {
                Trace.out(cmd[0] + " result is empty");
            }
            if (error.length != 0 && Trace.isLevelEnabled(1)) {
                Trace.out("Error is:=>" + error[0]);
            }
            return false;
        }
        if (Trace.isLevelEnabled(1)) {
            Trace.out("Output is:=> " + output[0]);
        }
        return true;
    }

    private static boolean isSunCluster32() {
        String[] cmd = new String[]{SCINSTALL, "-p"};
        File f = new File(cmd[0]);
        if (!f.exists()) {
            if (Trace.isLevelEnabled(1)) {
                Trace.out("Command file /usr/cluster/bin/scinstall Does not exist, returning false.");
            }
            return false;
        }
        RuntimeExec runtimeExec = new RuntimeExec(cmd, null, null);
        runtimeExec.runCommand();
        if (Trace.isLevelEnabled(1)) {
            Trace.out("Exit status for cmd is (" + runtimeExec.getExitValue() + ")");
        }
        if (runtimeExec.getExitValue() != 0) {
            Trace.out(1, "Non-zero exit status for cmd (" + cmd[0] + "), return false");
            return false;
        }
        String[] output = runtimeExec.getOutput();
        String[] error = runtimeExec.getError();
        if (output.length == 0) {
            if (Trace.isLevelEnabled(1)) {
                Trace.out(cmd[0] + " result is empty");
            }
            if (error.length != 0 && Trace.isLevelEnabled(1)) {
                Trace.out("Error:=> " + error[0]);
            }
            return false;
        }
        if (Trace.isLevelEnabled(1)) {
            Trace.out("Output:=> " + output[0]);
        }
        return output[0].startsWith("3.2");
    }
}

