/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.nativesystem;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterWindows;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.CopyListedFilesException;
import oracle.ops.mgmt.cluster.CreateListedDirsException;
import oracle.ops.mgmt.cluster.HostnameException;
import oracle.ops.mgmt.cluster.RemoteCopyException;
import oracle.ops.mgmt.cluster.RemoteDirException;
import oracle.ops.mgmt.cluster.RemoteShellException;
import oracle.ops.mgmt.cluster.RemoveListedFilesException;
import oracle.ops.mgmt.cluster.SharedDeviceException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.registry.RegistryKeyData;
import oracle.ops.mgmt.command.service.ServiceData;
import oracle.ops.mgmt.command.transfer.TransferQueues;
import oracle.ops.mgmt.command.transfer.TransferReader;
import oracle.ops.mgmt.command.transfer.TransferWriter;
import oracle.ops.mgmt.command.util.RemoteExecCommand;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.RuntimeExec;
import oracle.ops.mgmt.nativesystem.WindowsNative;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.rawdevice.OCR;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public final class WindowsSystem
extends NativeSystem
implements Constants {
    private static final String END_OF_STREAM = null;
    private static final int BUFFER_SIZE = 1024;
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String LOAD_PATH_DESCRIPTION = "PATH";
    private static final String HOSTNAME_KEY = "HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\TCPIP\\Parameters";
    private static final String HOSTNAME_VALUE = "Hostname";
    private static final String COMPUTERNAME_KEY = "HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Control\\ComputerName\\ActiveComputerName";
    private static final String REMOTE_EXEC_SYNC_TEMP_DIR = "Remote_Exec_Sync_Tempv2";
    private static final String HKEY_LOCAL_MACHINE_KEY = "HKEY_LOCAL_MACHINE";
    private static final String WIN_CURRENT_VERSION_SUBKEY = "Software\\microsoft\\windows nt\\currentversion";
    private static final String WIN_CURRENT_VERSION_KEY_FULL_PATH = "HKEY_LOCAL_MACHINE\\Software\\microsoft\\windows nt\\currentversion";
    private static final String SYSTEM_ROOT_ENTRY = "SystemRoot";
    private static final int WAIT_TIME_IN_SEC = 25;
    private static final int CHECK_INTERVAL_IN_MILLIS = 5000;
    private static final String COMPUTERNAME_VALUE = "ComputerName";
    private static final String SYSTEM32 = "system32";
    private static final String PING_EXE = "ping.exe";
    private static final String PING_ONCE = "-n 1";
    private static final String WINDIR_ENV = "WINDIR";
    private static final String CMD_SEP = " ";
    private static final String SPACE = " ";
    private static final String QUOTE = "\"";
    private static final String DOT = ".";
    private static final String FILE_SEP = File.separator;
    private static final int MAX_WIN_CMD_SIZE = Short.MAX_VALUE;
    private static final char COLON_CHAR = ':';
    private static final String XCOPY_EXE = "xcopy.exe";
    private static final String XCOPY_EMPTY_DIR_OPT = "/E";
    private static final String XCOPY_NO_VERBOSE_OPT = "/Q";
    private static final String XCOPY_IGNORE_ERR_OPT = "/C";
    private static final String XCOPY_NO_PROMPT_OPT = "/Y";
    private static final String XCOPY_MAKE_DIR_OPT = "/I";
    private static final String XCOPY_EXCLUDE_OPT = "/EXCLUDE:";
    private static final String XCOPY_ACL_OPT = "/O";
    private static final String ROBOCOPY_EXE = "robocopy.exe";
    private static final String RCOPY_COPY_ALL_OPT = "/COPYALL";
    private static final String RCOPY_EMPTY_DIR_OPT = "/E";
    private static final String RCOPY_EXCLUDE_FILES_OPT = "/XF";
    private static final String RCOPY_EXCLUDE_DIRS_OPT = "/XD";
    private static final String RCOPY_MULTITHREAD_OPT = "/MT";
    private static final String RCOPY_RESTART_MODE_OPT = "/ZB";
    private static final int RCOPY_EXIT_ERROR_NUM = 8;
    private static final int RCOPY_EXTRA_FILES_ERROR = 2;
    private static final int NO_ERROR_CODE = 0;
    private static final String RCOPY_NO_PROGRESS_OPT = "/NP";
    private static final String RCOPY_NO_SIZE_OPT = "/NS";
    private static final String RCOPY_NO_CLASS_OPT = "/NC";
    private static final String RCOPY_NO_FILE_OPT = "/NFL";
    private static final String RCOPY_NO_DIRECTORY_OPT = "/NDL";
    private static final String RCOPY_NO_JOB_HEADER_OPT = "/NJH";
    private static final String RCOPY_NO_JOB_SUMMARY_OPT = "/NJS";
    private static final String RCOPY_NUMBER_RETRIES = "/r:5";
    private static final String RCOPY_RETRY_TIMEOUT = "/w:5";
    private static final String FOR_DOSCMD_FILE_OPT = "for /f";
    private static final String FOR_DOSCMD_OPTIONS = "\"delims=;, usebackq\"";
    private static final String FOR_DOSCMD_IN = "in";
    private static final String FOR_DOSCMD_DO = "do";
    private static final String CMD_EXE = "cmd.exe";
    private static final String CMD_C_OPT = "/C";
    private static final String MKDIR_DOSCMD = "mkdir";
    private static final String RMDIR_DOSCMD = "rmdir";
    private static final String CSS_BIN_PATH = FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "ocssd.exe";
    private static final String[] WINDOWS_REMOTEEXEC_DEPENDENCIES;
    private static final String[] WINDOWS_REMOTEEXEC_DEPENDENCIES_MSVC;
    private static final String WSEC_LIBRARY_NAME = "orawsec12.dll";
    private static final String IPCONFIG_CMD = "ipconfig";
    private static final String NEWLINE = "\n";
    private static MessageBundle s_msgBundle;

    protected WindowsSystem() {
        try {
            if (!this.isLibraryLoaded()) {
                this.loadSRVMDependents();
                this.loadSRVMNativeLibrary();
            }
            if (!this.isRemoteExecLibraryLoaded()) {
                this.loadRemoteExecLibrary();
            }
        }
        catch (NativeException ne) {
            Trace.out("Failed to load SRVM library: " + ne);
        }
    }

    @Override
    String loadPathDescription() {
        return LOAD_PATH_DESCRIPTION;
    }

    @Override
    String getOracleLibraryName(String libraryName) {
        return "ora" + libraryName;
    }

    private String createRemoteFileName(String remoteNode, String filePath) {
        return "\\\\" + remoteNode + "\\" + filePath.replace(':', '$');
    }

    @Override
    public String getIPAddrCommand() {
        return IPCONFIG_CMD;
    }

    @Override
    public String getHostName(String nodeName) throws HostnameException {
        String hostName = null;
        String computerName = null;
        try {
            hostName = this.getPropertyValue(nodeName, HOSTNAME_KEY, HOSTNAME_VALUE);
            Trace.out("Hostname = " + hostName);
            if (hostName == null) {
                Object[] args = new Object[]{"HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\TCPIP\\Parameters\\Hostname", nodeName};
                throw new HostnameException("1058", args);
            }
            computerName = this.getPropertyValue(nodeName, COMPUTERNAME_KEY, COMPUTERNAME_VALUE);
            Trace.out("Computername = " + computerName);
            if (computerName == null) {
                Object[] args = new Object[]{"HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Control\\ComputerName\\ActiveComputerName\\ComputerName", nodeName};
                throw new HostnameException("1059", args);
            }
        }
        catch (NativeException ce) {
            throw new HostnameException(ce.getMessage());
        }
        if (!computerName.equalsIgnoreCase(hostName)) {
            Object[] args = new Object[]{nodeName};
            throw new HostnameException("1057", args);
        }
        return hostName;
    }

    @Override
    public String copyFilesLocally(String fileNamesToCopy, String sourceDirPathname, String destDirPathname, boolean preserve) {
        return "0|" + MessageBundle.getMessageBundle("Prkc").getMessage("1171", false, new String[]{"copy-win-error-01"});
    }

    @Override
    public String getPrivateNodeName(String nodeName) throws HostnameException {
        return null;
    }

    @Override
    public String copyFile(String sourceNode, String fileName1, String destNode, String fileName2) {
        Trace.out(" Source file is " + fileName1 + " dest is " + fileName2);
        Trace.out(" Source node is " + sourceNode + " dest is " + destNode);
        if (sourceNode.equalsIgnoreCase(destNode) && fileName1.equalsIgnoreCase(fileName2)) {
            try {
                if (this.pathExists(sourceNode, fileName1, 0)) {
                    return "1|making self copy no-op";
                }
                return "0|" + MessageBundle.getMessageBundle("Prkn").getMessage("1025", false, new String[]{fileName1, sourceNode});
            }
            catch (RemoteDirException e) {
                return "0|" + e.getMessage();
            }
        }
        String sourceFile = this.isLocalNode(sourceNode) ? fileName1 : this.createRemoteFileName(sourceNode, fileName1);
        String destFile = this.isLocalNode(destNode) ? fileName2 : this.createRemoteFileName(destNode, fileName2);
        Trace.out("Copy file " + sourceFile + " to " + destFile);
        return WindowsNative.copyFileCluster(sourceFile, destFile);
    }

    @Override
    public String copyFile(String node1, String file1, String node2, String file2, boolean noPreserve) {
        return this.copyFile(node1, file1, node2, file2);
    }

    @Override
    public String moveFile(String sourceNode, String fileName1, String fileName2) {
        String destFile;
        String sourceFile;
        if (fileName1.equalsIgnoreCase(fileName2)) {
            try {
                if (this.pathExists(sourceNode, fileName1, 0)) {
                    return "1|making self move no-op";
                }
                return "0|" + MessageBundle.getMessageBundle("Prkn").getMessage("1025", false, new String[]{fileName1, sourceNode});
            }
            catch (RemoteDirException e) {
                return "0|" + e.getMessage();
            }
        }
        if (this.isLocalNode(sourceNode)) {
            sourceFile = fileName1;
            destFile = fileName2;
        } else {
            sourceFile = this.createRemoteFileName(sourceNode, fileName1);
            destFile = this.createRemoteFileName(sourceNode, fileName2);
        }
        return WindowsNative.moveFileCluster(sourceFile, destFile);
    }

    @Override
    public String linkFile(String sourceNode, String fileName1, String fileName2) {
        return "0|Linking files is not supported on Windows platforms";
    }

    @Override
    public String removeFile(String destNode, String destFile) {
        String systemFileName = this.isLocalNode(destNode) ? destFile : this.createRemoteFileName(destNode, destFile);
        return WindowsNative.removeFileCluster(systemFileName);
    }

    @Override
    public String createDir(String destNode, String dir) {
        return this.createDirInternal(destNode, dir, false);
    }

    public String createDir(String destNode, String dir, boolean failIfDirExists) {
        return this.createDirInternal(destNode, dir, failIfDirExists);
    }

    @Override
    public String createDirRecurse(String destNode, String dir) {
        return this.createDirInternal(destNode, dir, false);
    }

    @Override
    public String createDirWithMode(String destNode, String dir) {
        return this.createDirInternal(destNode, dir, false);
    }

    @Override
    public String createDirWithModeRecurse(String destNode, String dir) {
        return this.createDirRecurse(destNode, dir);
    }

    @Override
    public String createDirWithPermissions(String destNode, String dir, String permissions) {
        return this.createDirInternal(destNode, dir, false);
    }

    private String createDirInternal(String node, String dir, boolean bFailIfDirExist) {
        String fullPath = this.createPath(node, dir);
        if (fullPath.startsWith("\\\\")) {
            if (fullPath.indexOf(36) == -1 || fullPath.indexOf(58) != -1) {
                Object[] args = new String[]{fullPath};
                return "0|" + s_msgBundle.getMessage("1188", true, args);
            }
        } else if (fullPath.indexOf(58) == -1) {
            Object[] args = new String[]{fullPath};
            return "0|" + s_msgBundle.getMessage("1188", true, args);
        }
        Trace.out("creating dir " + fullPath + " fail with exist " + bFailIfDirExist);
        File fileFullPath = new File(fullPath);
        boolean isPathExists = false;
        try {
            isPathExists = fileFullPath.exists();
        }
        catch (SecurityException e) {
            Object[] args = new String[]{fullPath, node};
            return "0|" + s_msgBundle.getMessage("1032", true, args);
        }
        if (isPathExists) {
            if (bFailIfDirExist) {
                Object[] args = new String[]{fullPath};
                return "0|" + s_msgBundle.getMessage("1189", true, args);
            }
            return "1|SUCCESSFUL";
        }
        boolean bRet = false;
        try {
            bRet = fileFullPath.mkdirs();
        }
        catch (SecurityException e) {
            Object[] args = new String[]{fullPath, node};
            return "0|" + s_msgBundle.getMessage("1110", true, args);
        }
        if (bRet) {
            return "1|SUCCESSFUL";
        }
        if (!fileFullPath.exists()) {
            Object[] args = new String[]{fullPath, node};
            return "0|" + MessageBundle.getMessageBundle("Prkn").getMessage("1039", true, args);
        }
        return "1|SUCCESSFUL";
    }

    @Override
    public boolean pathExists(String node, String path) throws RemoteDirException {
        return false;
    }

    @Override
    public boolean pathExists(String node, String path, int pathType) throws RemoteDirException {
        boolean bExists;
        String pathToVerify = null;
        pathToVerify = this.createPath(node, path);
        File file = new File(pathToVerify);
        switch (pathType) {
            case 0: {
                bExists = file.exists();
                break;
            }
            case 1: {
                bExists = file.exists() && file.isDirectory();
                break;
            }
            case 4: {
                bExists = this.isWritableDirPath(pathToVerify);
                break;
            }
            case 2: {
                bExists = file.exists() && file.isFile();
                break;
            }
            default: {
                Object[] args = new String[]{String.valueOf(pathType), path};
                throw new RemoteDirException(MessageBundle.getMessageBundle("Prkc").getMessage("1086", true, args));
            }
        }
        Trace.out("pathExists: path=" + file.getAbsolutePath() + " pathType=" + pathType + " bExists=" + bExists);
        return bExists;
    }

    private String createPath(String node, String path) {
        if (this.isLocalNode(node)) {
            return path;
        }
        return this.createRemoteFileName(node, path);
    }

    private String getLocalNode() {
        String localNode = null;
        try {
            localNode = InetAddress.getLocalHost().getHostName();
            int ix = localNode.indexOf(DOT);
            if (ix != -1) {
                localNode = localNode.substring(0, ix - 1);
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (localNode == null && (localNode = System.getenv(COMPUTERNAME_VALUE)) == null) {
            localNode = System.getenv(HOSTNAME_VALUE);
        }
        return localNode;
    }

    private boolean isLocalNode(String node) {
        return node.equalsIgnoreCase(this.getLocalNode()) || node.equalsIgnoreCase("localnode");
    }

    private boolean isWritableDirPath(String path) {
        boolean result = false;
        File fileWritable = new File(path);
        File tmpFile = null;
        if (fileWritable.exists() && fileWritable.isDirectory()) {
            try {
                tmpFile = File.createTempFile("cvu", null, fileWritable);
                tmpFile.delete();
                Trace.out("Path [" + path + "] is writeable");
                return true;
            }
            catch (IOException ioe) {
                Trace.out("IO Exception:" + ioe.getMessage());
                return false;
            }
        }
        return false;
    }

    @Override
    public String removeDir(String destNode, String dir) {
        String systemDirPath = this.createPath(destNode, dir);
        return WindowsNative.removeDirCluster(new NativeResult(), systemDirPath, false);
    }

    @Override
    public String removeDir(String destNode, String dir, boolean isDirPathRemove) {
        return this.removeDir(destNode, dir);
    }

    @Override
    public String removeDirRecurse(String destNode, String dir) {
        Trace.out("recursive removal of directories" + dir);
        String systemDirPath = this.createPath(destNode, dir);
        return WindowsNative.removeDirCluster(new NativeResult(), systemDirPath, true);
    }

    @Override
    public String getFreeSpace(String node, String path) throws RemoteShellException {
        String uncPath = this.createPath(node, path);
        if (!uncPath.equalsIgnoreCase(path) && !uncPath.endsWith(File.separator)) {
            uncPath = uncPath + File.separator;
        }
        NativeResult result = new NativeResult();
        WindowsNative.getFreeSpace(uncPath, result);
        if (result.getStatus()) {
            return "1|" + result.getStringResult();
        }
        return "0|" + result.getOSString();
    }

    @Override
    public boolean removeListedFilesFromNode(String node, String removeListFile) throws RemoteShellException, RemoveListedFilesException {
        Object[] msgArgs = new Object[]{"removeListedFilesFromNode"};
        throw new RemoveListedFilesException("1048", msgArgs);
    }

    @Override
    public boolean createListedDirsOnNode(String node, String createListFile) throws RemoteShellException, CreateListedDirsException {
        Object[] msgArgs = new Object[]{"createListedDirsOnNode"};
        throw new CreateListedDirsException("1048", msgArgs);
    }

    @Override
    public boolean copyListedFilesToNode(String node, String copyListFile) throws RemoteShellException, CopyListedFilesException {
        Object[] msgArgs = new Object[]{"copyListedFilesToNode"};
        throw new CopyListedFilesException("1048", msgArgs);
    }

    @Override
    public String isNodeAccessible(String node) throws RemoteShellException {
        return WindowsNative.isNodeAccessible(node);
    }

    @Override
    public boolean isACLSupported(String path) throws NativeException {
        Object[] args = new Object[]{"isACLSupported"};
        throw new NativeException(s_msgBundle.getMessage("1048", true, args));
    }

    @Override
    public boolean isACLSet(String srcFile) throws NativeException {
        Object[] args = new Object[]{"isACLSet"};
        throw new NativeException(s_msgBundle.getMessage("1048", true, args));
    }

    @Override
    public boolean isPathACFS(String path) throws NativeException {
        Object[] args = new Object[]{"isPathACFS"};
        throw new NativeException(s_msgBundle.getMessage("1048", true, args));
    }

    @Override
    public String getNodeAccessiblityCommand(String node) {
        return "";
    }

    @Override
    public String getRemoteShellCmd() throws RemoteShellException {
        return "0|getRemoteShellCmd is not supported on Windows platforms";
    }

    @Override
    public String getRemoteCopyCmd() throws RemoteCopyException {
        return "0|getRemoteCopyCmd is not supported on Windows platforms";
    }

    @Override
    public void resetRemoteShellCmd() {
    }

    @Override
    public void resetRemoteCopyCmd() {
    }

    public String startService(String serviceName, String nodeName, boolean ignore) {
        String retString = null;
        Trace.out("WindowsSystem: Inside startService2 with serviceName=" + serviceName + " and nodeName=" + nodeName);
        retString = WindowsNative.ntStartService(serviceName, nodeName, ignore);
        Trace.out("WindowsSystem.startService2() returning " + retString);
        return retString;
    }

    @Override
    public String startService(String serviceName, String nodeName) {
        String retString = null;
        Trace.out("WindowsSystem: Inside startService with serviceName=" + serviceName + " and nodeName=" + nodeName);
        retString = WindowsNative.ntStartService(serviceName, nodeName, false);
        Trace.out("WindowsSystem.startService() returning " + retString);
        return retString;
    }

    @Override
    public boolean checkService(String serviceName, String nodeName, ServiceData data, NativeResult srvResult) {
        return WindowsNative.ntCheckService(serviceName, nodeName, data, srvResult);
    }

    @Override
    public String stopService(String serviceName, String nodeName) {
        String retString = null;
        retString = WindowsNative.ntStopService(serviceName, nodeName);
        return retString;
    }

    @Override
    public String deleteService(String serviceName, String nodeName) {
        return this.deleteService(false, serviceName, nodeName);
    }

    @Override
    public String deleteService(boolean ignoreNotExist, String serviceName, String nodeName) {
        String retString = null;
        Trace.out("deleting service " + serviceName + " on " + nodeName);
        retString = WindowsNative.ntDeleteService2(serviceName, nodeName, ignoreNotExist);
        return retString;
    }

    protected NativeResult deleteService(String serviceName, String nodeName, boolean ignoreNotExist) {
        String retString = null;
        Trace.out("_WS_: deleting service2 " + serviceName + " on " + nodeName + " ignoreNotExist = " + ignoreNotExist);
        retString = WindowsNative.ntDeleteService2(serviceName, nodeName, ignoreNotExist);
        Trace.out("_WS_ deleteService2: node " + nodeName + " Service " + serviceName + " result: " + retString);
        return new NativeResult(retString);
    }

    protected NativeResult markServiceForDelete(String serviceName, String node) {
        String retString = null;
        Trace.out("_WS_ About to mark for delete: Service " + serviceName + " on " + node);
        retString = WindowsNative.ntMarkServiceDelete(serviceName, node);
        Trace.out("_WS_ MarkDeletService returned " + retString);
        return new NativeResult(retString);
    }

    @Override
    public String createService(String serviceName, String exeLocation, int mode, String nodeName) {
        String retString = null;
        retString = WindowsNative.ntCreateServiceAdvanced(exeLocation, serviceName, 0, 0, mode, 0, null, null, null, 0, null, nodeName);
        Trace.out("ntCreateServiceAdvanced returned " + retString);
        return retString;
    }

    @Override
    public String createService(String serviceName, String exeLocation, int access, int type, int mode, int errCtrl, String deps, String domainName, String userName, String password, String loadGrp, String nodeName) {
        String startname = null;
        if (userName != null && userName.trim().length() > 0) {
            startname = domainName != null && domainName.trim().length() > 0 ? domainName + "\\" + userName : ".\\" + userName;
            Trace.out("startname = " + startname);
        } else {
            Trace.out("startname is null");
        }
        String retString = WindowsNative.ntCreateServiceAdvanced(exeLocation, serviceName, access, type, mode, errCtrl, deps, startname, loadGrp, 0, password, nodeName);
        Trace.out("ntCreateServiceAdvanced returned " + retString);
        return retString;
    }

    @Override
    public String createServiceDep(String serviceName, String[] dependencyList, String nodeName) {
        StringBuffer listString = new StringBuffer();
        for (int i = 0; i < dependencyList.length; ++i) {
            listString.append(dependencyList[i] + '|');
        }
        String retString = null;
        retString = WindowsNative.ntCreateServiceDep(serviceName, listString.toString(), nodeName);
        return retString;
    }

    @Override
    public String removeServiceDep(String serviceName, String[] dependencyList, String nodeName) throws NativeException {
        int i;
        String queryRetStr = WindowsNative.ntQueryServiceDep(serviceName, nodeName);
        Trace.out("queryRetStr = " + queryRetStr);
        NativeResult queryResult = new NativeResult(queryRetStr);
        if (!queryResult.getStatus() || queryResult.getResultString().length > 1) {
            Object[] args = new Object[]{serviceName, nodeName, Utils.getString(queryResult.getResultString(), System.getProperty("line.separator"))};
            throw new NativeException("1022", args);
        }
        String existingDep = queryResult.getResultString()[0];
        Trace.out("existingDep = " + existingDep);
        String[] oldDep = Utils.getStringArray(existingDep, ",");
        for (i = 0; i < oldDep.length; ++i) {
            Trace.out("oldDep[" + i + "] = " + oldDep[i]);
        }
        for (i = 0; i < dependencyList.length; ++i) {
            boolean found = false;
            for (int j = 0; j < oldDep.length; ++j) {
                if (!dependencyList[i].trim().equalsIgnoreCase(oldDep[j])) continue;
                found = true;
                oldDep[j] = "";
                break;
            }
            if (found) continue;
            Object[] args = new Object[]{Utils.getString(dependencyList, ","), serviceName, nodeName};
            throw new NativeException("1023", args);
        }
        StringBuffer listString = new StringBuffer();
        for (int i2 = 0; i2 < oldDep.length; ++i2) {
            if (oldDep[i2].equals("")) continue;
            Trace.out("new depend, oldDep[" + i2 + "] = " + oldDep[i2]);
            listString.append(oldDep[i2] + '|');
        }
        Trace.out("listString = " + listString.toString());
        String retString = WindowsNative.ntUpdateServiceDep(serviceName, listString.toString(), nodeName);
        return retString;
    }

    @Override
    public String queryServiceDep(String serviceName, String nodeName) throws NativeException {
        String queryRetStr = WindowsNative.ntQueryServiceDep(serviceName, nodeName);
        Trace.out("queryRetStr = " + queryRetStr);
        NativeResult queryResult = new NativeResult(queryRetStr);
        if (!queryResult.getStatus() || queryResult.getResultString().length > 1) {
            Object[] args = new Object[]{serviceName, nodeName, Utils.getString(queryResult.getResultString(), System.getProperty("line.separator"))};
            throw new NativeException("1022", args);
        }
        return queryRetStr;
    }

    @Override
    public String startDaemon(String nodeName, String oracleHomeName) {
        String serviceName = "OracleGSDService";
        Trace.out("Starting service " + serviceName);
        String retString = WindowsNative.ntStartDaemon(serviceName, nodeName, "READY", oracleHomeName);
        Trace.out("startService returned " + retString);
        return retString;
    }

    @Override
    public String startListener(String nodeName, String listenerName, String oracleHome, String oracleHomeName) {
        String liName = "";
        String exeLocation = oracleHome + FILE_SEPARATOR + "BIN" + FILE_SEPARATOR + "TNSLSNR";
        liName = listenerName.equals("LISTENER") ? "" : listenerName;
        String serviceName = "Oracle" + oracleHomeName + "TNSListener" + liName;
        Trace.out("winSys.startListener: service is " + serviceName);
        String stopResult = this.stopService(serviceName, nodeName);
        if (!new NativeResult(stopResult).getStatus()) {
            Trace.out("winSys.startListener: service stop failed. igore it");
        } else {
            Trace.out("winSys.startListener: service stopped");
        }
        String deleteResult = this.deleteService(serviceName, nodeName);
        if (!new NativeResult(deleteResult).getStatus()) {
            Trace.out("winSys.startListener: service del failed. igore it");
        } else {
            Trace.out("winSys.startListener: service deleted");
        }
        String createResult = this.createService(serviceName, exeLocation, 2, nodeName);
        if (!new NativeResult(createResult).getStatus()) {
            return createResult;
        }
        Trace.out("winSys.startListener: service created");
        String startResult = this.startService(serviceName, nodeName);
        Trace.out("winSys.startListener: service started");
        return startResult;
    }

    @Override
    public void regCreateKey(String nodeName, String key, String subkey, NativeResult result) {
        WindowsNative.RegCreateKey(key, subkey, result, nodeName);
    }

    @Override
    public void regDeleteKey(String nodeName, String key, String deleteKey, NativeResult result) {
        Trace.out("WindowsSystem.regDeleteKey: mainkey= " + key + " deletekey= " + deleteKey);
        WindowsNative.RegDeleteKey(key, deleteKey, result, nodeName);
    }

    @Override
    public void regSetValue(String nodeName, String key, String value, RegistryKeyData regData, NativeResult regResult) {
        int mainKeyIndex = key.indexOf("\\");
        String mainkey = key.substring(0, mainKeyIndex);
        String subkey = key.substring(mainKeyIndex + 1);
        Trace.out("WindowsSystem.regSetValue: mainkey= " + mainkey + " subkey = " + subkey + " value= " + value);
        WindowsNative.RegSetValueDataObject(mainkey, subkey, value, regData, regResult, nodeName);
    }

    @Override
    public void regDeleteValue(String nodeName, String key, String value, NativeResult result) {
        int mainKeyIndex = key.indexOf("\\");
        String mainkey = key.substring(0, mainKeyIndex);
        String subkey = key.substring(mainKeyIndex + 1);
        Trace.out("WindowsSystem.regDeleteValue: mainkey= " + mainkey + " subkey = " + subkey + " value= " + value);
        WindowsNative.RegDeleteValue(mainkey, subkey, value, result, nodeName);
    }

    @Override
    public void regGetData(String nodeName, String key, String value, RegistryKeyData regData, NativeResult regResult) {
        int mainKeyIndex = key.indexOf("\\");
        String mainkey = key.substring(0, mainKeyIndex);
        String subkey = key.substring(mainKeyIndex + 1);
        Trace.out("WindowsSystem.regGetData: mainkey= " + mainkey + " subkey = " + subkey + " value= " + value);
        WindowsNative.RegGetDataObject(mainkey, subkey, value, regData, regResult, nodeName);
    }

    @Override
    public void regGetSubKey(String nodeName, String key, RegistryKeyData regKeyData, NativeResult result) {
        this.doRegGetSubKey(nodeName, key, regKeyData, result, false);
    }

    @Override
    public void getServices4ImagePath(String nodeName, String key, RegistryKeyData regKeyData, NativeResult result) {
        this.doRegGetSubKey(nodeName, key, regKeyData, result, true);
    }

    private void doRegGetSubKey(String nodeName, String key, RegistryKeyData regKeyData, NativeResult result, boolean getImagePath) {
        String subkey;
        String mainkey;
        int index = key.indexOf("\\");
        if (index != -1) {
            mainkey = key.substring(0, index);
            subkey = key.substring(index + 1);
        } else {
            mainkey = key;
            subkey = null;
        }
        Trace.out("WindowsSystem.regGetSubKey: nodeName=" + nodeName + " mainkey= " + mainkey + " subkey = " + subkey + " getImagePath = " + getImagePath);
        WindowsNative.RegGetSubKey(nodeName, mainkey, subkey, regKeyData, result, getImagePath);
    }

    @Override
    public boolean regKeyExists(String nodeName, String key, NativeResult regResult) {
        int mainKeyIndex = key.indexOf("\\");
        String mainkey = key.substring(0, mainKeyIndex);
        String subkey = key.substring(mainKeyIndex + 1);
        Trace.out("WindowsSystem.regKeyExists: mainkey= " + mainkey + " subkey = " + subkey);
        boolean keyExists = WindowsNative.RegKeyExists(mainkey, subkey, regResult, nodeName);
        return keyExists;
    }

    @Override
    public String initializeClusterThread() {
        return WindowsNative.initializeClusterThread();
    }

    @Override
    public String initializeClusterWare() {
        return null;
    }

    @Override
    public String changeModePermissions(String node, String paths, String permissions) throws RemoteShellException {
        Object[] args = new Object[]{"changeModePermissions"};
        throw new RemoteShellException(s_msgBundle.getMessage("1048", true, args));
    }

    @Override
    public void checkCFSPath(String nodeName, String pathName, String fileName, Constants.CFS_OP_TYPE opType, NativeResult nativeResult) throws RemoteShellException {
        Object[] args = new Object[]{"checkCFSPath"};
        throw new RemoteShellException(s_msgBundle.getMessage("1048", true, args));
    }

    @Override
    public NativeResult isSharedPath(String pathName, String[] nodeList, String localNode) throws SharedDeviceException {
        NativeResult nativeResult = new NativeResult();
        WindowsNative.isCFS(pathName, nativeResult);
        if (!nativeResult.getStatus()) {
            throw new SharedDeviceException(nativeResult.getOSString());
        }
        return nativeResult;
    }

    @Override
    public NativeResult validateRawDevice(String devName) {
        NativeResult nativeResult = new NativeResult();
        WindowsNative.validateRawDevice(devName, nativeResult);
        return nativeResult;
    }

    @Override
    public NativeResult validateDevice(String devName) {
        NativeResult nativeResult = new NativeResult();
        WindowsNative.validateRawDevice(devName, nativeResult);
        return nativeResult;
    }

    @Override
    public String getPfileName(String oh, String instName) {
        return oh + FILE_SEPARATOR + "database" + FILE_SEPARATOR + "init" + instName + ".ora";
    }

    @Override
    public String runCmd(String cmd, String[] args, String[] env, String node) {
        return this.runCmd(cmd, args, env, null, node, null, null);
    }

    @Override
    public String runCmd(String cmd, String[] args, String[] env, String[] stdin, String node) {
        return this.runCmd(cmd, args, env, stdin, node, null, null);
    }

    @Override
    public String runCmd(String cmd, String[] args, String[] env, String[] stdin, String node, String srcLoc, String destLoc) {
        CommandResult result = new CommandResult();
        RemoteExecCommand rmtExcCmd = new RemoteExecCommand(cmd, args, env, stdin, node, null, srcLoc, destLoc, result);
        boolean cmdSuccess = rmtExcCmd.execute();
        Trace.out("runCmd: rmtExcCmd result " + result.getStringResult());
        if (cmdSuccess) {
            if (result.getStringResult() != null) {
                return "1|" + result.getStringResult();
            }
            return "1|Command completed successfully";
        }
        if (result.getStringResult() != null) {
            return "0|" + result.getStringResult();
        }
        return "0|Command failed to execute";
    }

    @Override
    public String getExeName(String exeName) {
        return exeName + ".exe";
    }

    @Override
    public String getScriptFileName(String scriptFile) {
        return scriptFile + ".bat";
    }

    @Override
    public String getConfigLocation(Version version) {
        String ocrDevLoc;
        String cfgLoc = null;
        cfgLoc = !Version.isPre10i(version) ? ((ocrDevLoc = System.getProperty("srvm.ocr.loc")) != null ? "HKEY_LOCAL_MACHINE\\" + ocrDevLoc : "HKEY_LOCAL_MACHINE\\Software\\Oracle\\Ocr") : "HKEY_LOCAL_MACHINE\\Software\\Oracle\\osd9i";
        return cfgLoc;
    }

    @Override
    public String getOLRConfigLocation(String node, Version version) {
        String olrLoc = null;
        String olrDevLoc = System.getProperty("srvm.olr.loc");
        if (olrDevLoc != null) {
            olrLoc = olrDevLoc;
            String hostName = null;
            try {
                hostName = this.getHostName(node);
            }
            catch (HostnameException hne) {
                Trace.out(hne.getMessage());
                hostName = null;
            }
            if (hostName != null) {
                olrLoc = "HKEY_LOCAL_MACHINE\\" + olrLoc + "\\" + this.getNormHostName(hostName);
            }
        } else {
            olrLoc = "HKEY_LOCAL_MACHINE\\Software\\Oracle\\Olr";
        }
        return olrLoc;
    }

    @Override
    public Boolean getCSSConfigType(String node, Version version) throws NativeException {
        Boolean configType;
        String nodeName;
        String configLocation = this.getConfigLocation(version);
        NativeResult nativeResult = new NativeResult();
        String localOnly = null;
        String string = nodeName = "localnode".equalsIgnoreCase(node) ? null : node;
        if (this.regKeyExists(nodeName, configLocation, nativeResult)) {
            if (!Version.isPre10i(version)) {
                localOnly = this.getPropertyValue(nodeName, configLocation, "local_only");
            }
            Trace.out("localOnly = " + localOnly);
            configType = localOnly != null ? Boolean.valueOf(localOnly.trim()) : Boolean.valueOf(false);
        } else {
            if (!nativeResult.getStatus()) {
                Object[] args = new Object[]{"local_only", configLocation, node, nativeResult.getOSString()};
                throw new NativeException("1011", args);
            }
            configType = null;
        }
        Trace.out("configType=" + configType);
        return configType;
    }

    @Override
    public HashMap getOCRLocations(Version version) throws NativeException {
        HashMap<String, String> diskMap = new HashMap<String, String>(2);
        try {
            if (!Version.isPre112(version)) {
                String[] ocrLocs = OCR.getOCRLocations();
                for (int i = 0; i < ocrLocs.length; ++i) {
                    if (i == 0) {
                        diskMap.put(ocrLocs[0], "OCR_PRIMARY");
                        continue;
                    }
                    if (i == 1) {
                        diskMap.put(ocrLocs[1], "OCR_MIRROR");
                        continue;
                    }
                    diskMap.put(ocrLocs[i], "OCR_SECONDARY");
                }
            } else {
                String configLocation = this.getConfigLocation(version);
                String ocrConfigPropName = Version.isPre10i(version) ? "srvconfig_loc" : "ocrconfig_loc";
                String ocrMirrorPropName = "ocrmirrorconfig_loc";
                String ocrLoc = this.getPropertyValue("localnode", configLocation, ocrConfigPropName);
                diskMap.put(ocrLoc, "OCR_PRIMARY");
                if (!Version.isPre10i(version) && (ocrLoc = this.getPropertyValue("localnode", configLocation, ocrMirrorPropName)) != null) {
                    diskMap.put(ocrLoc, "OCR_MIRROR");
                }
            }
        }
        catch (OCRException ocre) {
            throw new NativeException(s_msgBundle.getMessage("1149", true), ocre);
        }
        return diskMap;
    }

    @Override
    public boolean isCRSConfigured(Version version) throws NativeException {
        return this.isCRSConfigured("localnode", version);
    }

    @Override
    public int checkOCRStorageType(String path) throws NativeException {
        int retVal;
        try {
            retVal = OCR.checkOCRStorageType(path);
        }
        catch (OCRException ocre) {
            throw new NativeException(ocre.getMessage(), ocre);
        }
        return retVal;
    }

    @Override
    public boolean isCRSConfigured(String node, Version version) throws NativeException {
        String ocrKey = this.getConfigLocation(version);
        String ocrConfigPropName = Version.isPre10i(version) ? "srvconfig_loc" : "ocrconfig_loc";
        String ocrCnfgLocPropertyValue = null;
        String localOnly = null;
        String nodeName = "localnode".equalsIgnoreCase(node) ? null : node;
        boolean m_ocrConfigured = false;
        NativeResult nativeResult = new NativeResult();
        if (this.regKeyExists(nodeName, ocrKey, nativeResult)) {
            boolean localOnlyBool;
            ocrCnfgLocPropertyValue = this.getPropertyValue(nodeName, ocrKey, ocrConfigPropName);
            Trace.out(ocrConfigPropName + " = " + ocrCnfgLocPropertyValue);
            String ocrCnfgLocalOnlyPropertyValue = this.getPropertyValue(nodeName, ocrKey, "local_only");
            boolean bl = localOnlyBool = ocrCnfgLocalOnlyPropertyValue == null ? false : Boolean.parseBoolean(ocrCnfgLocalOnlyPropertyValue);
            if (!Version.isPre10i(version)) {
                localOnly = this.getPropertyValue(nodeName, ocrKey, "local_only");
            }
            Trace.out("localOnly = " + localOnly);
            localOnlyBool = localOnly != null ? Boolean.valueOf(localOnly.trim()).booleanValue() : Boolean.valueOf(false).booleanValue();
            Trace.out("local_only = " + localOnly);
            m_ocrConfigured = !localOnlyBool && ocrCnfgLocPropertyValue != null;
        } else if (!nativeResult.getStatus()) {
            Object[] args = new Object[]{ocrConfigPropName, ocrKey, node, nativeResult.getOSString()};
            throw new NativeException("1011", args);
        }
        Trace.out("isOCRConfigured=" + m_ocrConfigured);
        return m_ocrConfigured;
    }

    @Override
    public boolean isHAConfigured(Version version) throws NativeException {
        return this.isHAConfigured("localnode", version);
    }

    @Override
    public boolean isHAConfigured(String node, Version version) throws NativeException {
        if (Version.isPre112(version)) {
            Object[] args = new String[]{version.toString(), "11.2.0.1.0"};
            throw new NativeException(MessageBundle.getMessageBundle("Prkc").getMessage("1141", true, args));
        }
        String olrKey = this.getOLRConfigLocation(node, version);
        Trace.out("olrKey = " + olrKey);
        String olrCnfgLocProperty = "olrconfig_loc";
        String olrCnfgLocPropertyValue = null;
        String nodeName = "localnode".equalsIgnoreCase(node) ? null : node;
        boolean m_olrConfigured = false;
        NativeResult nativeResult = new NativeResult();
        if (this.regKeyExists(nodeName, olrKey, nativeResult)) {
            olrCnfgLocPropertyValue = this.getPropertyValue(nodeName, olrKey, olrCnfgLocProperty);
            Trace.out(olrCnfgLocProperty + " = " + olrCnfgLocPropertyValue);
            m_olrConfigured = olrCnfgLocPropertyValue != null;
        } else if (!nativeResult.getStatus()) {
            Object[] args = new Object[]{olrCnfgLocProperty, olrKey, node, nativeResult.getOSString()};
            throw new NativeException("1011", args);
        }
        Trace.out("isOLRConfigured=" + m_olrConfigured);
        return m_olrConfigured;
    }

    @Override
    public String getCRSHome(String node, Version version) throws NativeException {
        String olrKey = this.getOLRConfigLocation(node, version);
        Trace.out("olrKey = " + olrKey);
        String crsHomeProperty = "crs_home";
        String crsHomePropertyValue = null;
        String nodeName = "localnode".equalsIgnoreCase(node) ? null : node;
        boolean m_olrConfigured = false;
        NativeResult nativeResult = new NativeResult();
        if (!this.regKeyExists(nodeName, olrKey, nativeResult)) {
            if (!nativeResult.getStatus()) {
                Object[] args = new Object[]{crsHomeProperty, olrKey, node, nativeResult.getOSString()};
                throw new NativeException("1011", args);
            }
            Object[] args = new Object[]{olrKey, node};
            throw new NativeException("1036", args);
        }
        crsHomePropertyValue = this.getPropertyValue(nodeName, olrKey, crsHomeProperty);
        Trace.out(crsHomeProperty + " = " + crsHomePropertyValue);
        if (crsHomePropertyValue == null) {
            Object[] args = new Object[]{"crs_home", olrKey};
            throw new NativeException("1104", args);
        }
        return crsHomePropertyValue;
    }

    private String getPropertyValue(String node, String configLocation, String propertyName) throws NativeException {
        String propertyValue = null;
        NativeResult nativeResult = new NativeResult();
        RegistryKeyData regData = new RegistryKeyData(configLocation, propertyName);
        String nodeName = "localnode".equalsIgnoreCase(node) ? null : node;
        regData.setDataType(10);
        if (this.regKeyExists(nodeName, configLocation, nativeResult)) {
            nativeResult.setStatus(false);
            this.regGetData(node, configLocation, propertyName, regData, nativeResult);
            if (nativeResult.getStatus()) {
                propertyValue = regData.getStringData();
            }
        } else if (!nativeResult.getStatus()) {
            Object[] args = new Object[]{propertyName, configLocation, node, nativeResult.getOSString()};
            throw new NativeException("1011", args);
        }
        return propertyValue;
    }

    @Override
    public String getOracleGroup(String oracleHome) throws NativeException {
        return "ORA_DBA";
    }

    @Override
    public String getASMAdminGroup(String oracleHome) throws NativeException {
        return "ORA_DBA";
    }

    @Override
    public String getEffectiveGroup() throws NativeException {
        Object[] args = new Object[]{"getEffectiveGroup"};
        throw new NativeException("1048", args);
    }

    @Override
    public boolean isRemoteExecServerNeeded() {
        return true;
    }

    @Override
    public void startRemoteExecServer(String srcLoc, String destLoc) throws NativeException {
        String localHost = null;
        try {
            localHost = Utils.getLocalHost();
        }
        catch (UnknownHostException e) {
            Trace.out("UnknownHostException for retrieval of local host; msg= " + e.getMessage());
            throw new NativeException(MessageBundle.getMessageBundle("Prkn").getMessage("1031", false), e);
        }
        this.startRemoteExecServer(localHost, srcLoc, destLoc);
    }

    @Override
    public void startRemoteExecServer(String node, String srcLoc, String destLoc) throws NativeException {
        String[] srvFiles = WINDOWS_REMOTEEXEC_DEPENDENCIES;
        ArrayList<String> remExecServerFiles = new ArrayList<String>();
        for (int i = 0; i < srvFiles.length; ++i) {
            String fileName = srvFiles[i];
            boolean sourceFilePathExists = false;
            String realSrcFilePath = srcLoc + FILE_SEPARATOR + fileName;
            sourceFilePathExists = new File(realSrcFilePath).exists();
            if (!sourceFilePathExists) {
                realSrcFilePath = srcLoc + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + fileName;
                sourceFilePathExists = new File(realSrcFilePath).exists();
            }
            if (sourceFilePathExists) {
                Trace.out("Remote Exec Server dependancy file at path (" + realSrcFilePath + ") exists, " + "hence adding this file path to the list of files to be copied to destination before starting the remote exec server.");
                remExecServerFiles.add(realSrcFilePath);
                continue;
            }
            Trace.out("Remote Exec Server dependancy file (" + fileName + ") does not exist at paths (" + srcLoc + ") and (" + srcLoc + FILE_SEPARATOR + "bin), " + " Hence skipping this file.");
        }
        String[] realSrcLocs = this.getMSVCRTFullPath(new String[]{srcLoc});
        for (int j = 0; j < realSrcLocs.length; ++j) {
            remExecServerFiles.add(realSrcLocs[j]);
        }
        this.startRemoteExecServer(node, remExecServerFiles.toArray(new String[0]), destLoc);
    }

    @Override
    public void startRemoteExecServer(String[] remoteExecServerFiles, String destLoc) throws NativeException {
        String localHost = null;
        try {
            localHost = Utils.getLocalHost();
        }
        catch (UnknownHostException e) {
            Trace.out("UnknownHostException for retrieval of local host; msg= " + e.getMessage());
            throw new NativeException(MessageBundle.getMessageBundle("Prkn").getMessage("1031", false), e);
        }
        this.startRemoteExecServer(localHost, remoteExecServerFiles, destLoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startRemoteExecServer(String node, String[] remoteExecServerFiles, String destLoc) throws NativeException {
        boolean isSrvStarted = false;
        boolean isSrvFileExist = false;
        boolean isSrvCreated = false;
        boolean isRemDirExist = false;
        boolean isRemDirDeleted = false;
        String fileName = null;
        String retStr = null;
        String dirLoc = null;
        String localHost = null;
        boolean isLockOwner = false;
        MessageBundle prknMsgBndl = MessageBundle.getMessageBundle("Prkn");
        String srvName = "OracleRemExecServiceV2";
        int mode = 1;
        NativeResult result = new NativeResult();
        try {
            localHost = Utils.getLocalHost();
        }
        catch (UnknownHostException e) {
            Trace.out("UnknownHostException for retrieval of local host; msg= " + e.getMessage());
            throw new NativeException(prknMsgBndl.getMessage("1031", true), e);
        }
        RegistryKeyData systemRootRegKey = new RegistryKeyData(SYSTEM_ROOT_ENTRY, 10);
        this.regGetData(node, WIN_CURRENT_VERSION_KEY_FULL_PATH, SYSTEM_ROOT_ENTRY, systemRootRegKey, result);
        String systemRoot = systemRootRegKey.getStringData();
        if (systemRoot == null || systemRoot.length() == 0) {
            return;
        }
        String winTempDirPathname = systemRootRegKey.getStringData() + File.separator + "Temp";
        String remoteExecSyncDirPathname = winTempDirPathname + File.separator + REMOTE_EXEC_SYNC_TEMP_DIR;
        boolean systemRootRegKeyReadSuccessfully = result.getStatus();
        String remExecSyncFile = this.createPath(node, remoteExecSyncDirPathname) + FILE_SEPARATOR + node;
        File syncFile = new File(remExecSyncFile);
        Trace.out("_WS_: Checking if service is started\n");
        result = new NativeResult();
        isSrvStarted = WindowsNative.ntCheckService("OracleRemExecServiceV2", node, new ServiceData(6), result);
        if (!isSrvStarted) {
            Trace.out("_WS_ serivce OracleRemExecServiceV2 not started on " + node);
            dirLoc = destLoc + "\\" + "oraremservicev2" + "\\";
            String returnStr = this.createDir(node, remoteExecSyncDirPathname, true);
            WindowsSystem.setDestLocPermissions(remoteExecSyncDirPathname);
            try {
                int retryCount = 25;
                do {
                    --retryCount;
                    try {
                        isLockOwner = syncFile.createNewFile();
                        syncFile.deleteOnExit();
                    }
                    catch (IOException e) {
                        Trace.out("couldn't create sync file " + e.getMessage());
                    }
                    if (isLockOwner) {
                        Trace.out("acquired lock for starting rem exec service");
                        break;
                    }
                    Trace.out("wait for sync ownership failed at retry " + retryCount);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ie) {
                        Trace.out("Unexcpeted error waiting for sync file ownership:" + ie.getMessage());
                    }
                } while (retryCount > 0);
                if (!isLockOwner) {
                    NativeResult serviceResult = new NativeResult();
                    if (!this.isRemExecServiceRunning(node, serviceResult)) {
                        Trace.out("lock could not be acquired and correct rem exec not found. Forcing service creation");
                    } else {
                        Trace.out("not lock owner, but compatible rem exec service found");
                        return;
                    }
                }
                this.cleanRemExecService(node, dirLoc);
                retStr = this.removeDirRecurse(node, dirLoc);
                isRemDirDeleted = new NativeResult(retStr).getStatus();
                if (!isRemDirDeleted) {
                    String displayRemoveDir = this.createPath(node, dirLoc);
                    Trace.out("_WS_ Couldn't delete dir" + displayRemoveDir);
                    String retStrDisplay = retStr.substring(retStr.indexOf("|") + 1, retStr.length()).trim();
                    Trace.out("_WS_ retStr was" + retStr);
                    Object[] args = new Object[]{displayRemoveDir, localHost};
                    String[] errMesgArr = new String[]{prknMsgBndl.getMessage("1040", true, args), LINE_SEPARATOR, retStrDisplay};
                    throw new NativeException(errMesgArr);
                }
                retStr = this.createDir(node, dirLoc);
                isRemDirExist = new NativeResult(retStr).getStatus();
                if (!isRemDirExist) {
                    String displayCreateDir = this.createPath(node, dirLoc);
                    String retStrDisplay = retStr.substring(retStr.indexOf("|") + 1, retStr.length()).trim();
                    Trace.out("_WS_ Couldn't create dir" + displayCreateDir + " on " + node);
                    Trace.out("_WS_ retStr was" + retStr);
                    Object[] args = new Object[]{displayCreateDir, localHost};
                    String[] errMesgArr = new String[]{prknMsgBndl.getMessage("1039", true, args), LINE_SEPARATOR, retStrDisplay};
                    throw new NativeException(errMesgArr);
                }
                WindowsSystem.setDestLocPermissions(dirLoc);
                for (int i = 0; i < remoteExecServerFiles.length; ++i) {
                    String realSrcLoc = null;
                    fileName = remoteExecServerFiles[i];
                    File file = new File(fileName);
                    if (!file.exists()) {
                        Object[] args = new Object[]{fileName, "localnode"};
                        throw new NativeException("1025", args);
                    }
                    Trace.out("_WS_ Source location for service files is " + realSrcLoc);
                    Trace.out("_WS_ Copying file " + fileName + " to " + node + ":" + dirLoc);
                    retStr = this.copyFile("localnode", fileName, node, dirLoc + FILE_SEPARATOR + file.getName());
                    isSrvFileExist = new NativeResult(retStr).getStatus();
                    if (isSrvFileExist) continue;
                    Trace.out("_WS_Couldn't copy " + fileName + " to " + node + ":" + dirLoc);
                    Object[] args = new Object[]{fileName, dirLoc, node, retStr};
                    throw new NativeException("1015", args);
                }
                result = this.deleteService("OracleRemExecServiceV2", node, true);
                if (!result.getStatus()) {
                    Trace.out("_WS_ Failed to delete Service OracleRemExecServiceV2 on " + node);
                    Object[] args = new Object[]{"OracleRemExecServiceV2", node, result.getResultString()[0]};
                    throw new NativeException("1016", args);
                }
                Trace.out("_WS_ About to create Service OracleRemExecServiceV2 on " + node);
                retStr = dirLoc.trim().startsWith(QUOTE) ? this.createService("OracleRemExecServiceV2", dirLoc + "RemoteExecService.exe", mode, node) : this.createService("OracleRemExecServiceV2", QUOTE + dirLoc + "RemoteExecService.exe" + QUOTE, mode, node);
                Trace.out("_WS_ create Service returned " + retStr);
                isSrvCreated = new NativeResult(retStr).getStatus();
                if (!isSrvCreated) {
                    Trace.out("_WS_ Failed to create Service OracleRemExecServiceV2 on " + node);
                    Object[] args = new Object[]{"OracleRemExecServiceV2", node, retStr};
                    throw new NativeException("1016", args);
                }
                retStr = this.startService("OracleRemExecServiceV2", node, true);
                Trace.out("_WS_ start Service returned " + retStr);
                isSrvStarted = new NativeResult(retStr).getStatus();
                if (isSrvStarted && !(result = this.markServiceForDelete("OracleRemExecServiceV2", node)).getStatus()) {
                    Trace.out("_WS_ Failed.2 to mark delete Service OracleRemExecServiceV2 on " + node);
                    Object[] args = new Object[]{"OracleRemExecServiceV2", node, result.getResultString()[0]};
                    throw new NativeException("1021", args);
                }
            }
            finally {
                if (isLockOwner) {
                    Trace.out("giving up ownership of sync file");
                    syncFile.delete();
                }
            }
        }
        if (!isSrvStarted) {
            Trace.out("_WS_ Failed to start Service OracleRemExecServiceV2 on " + node);
            Object[] args = new Object[]{"OracleRemExecServiceV2", node, retStr};
            throw new NativeException("1017", args);
        }
    }

    private void cleanRemExecService(String node, String desLoc) {
        NativeResult result = new NativeResult();
        if (WindowsNative.ntCheckService("OracleRemExecServiceV2", node, new ServiceData(1), result)) {
            Trace.out("rem exec service exists on node " + node);
            if (WindowsNative.ntCheckService("OracleRemExecServiceV2", node, new ServiceData(6), result)) {
                String retString = this.stopService("OracleRemExecServiceV2", node);
                Trace.out("stop service returned: " + retString);
            }
            result = this.deleteService("OracleRemExecServiceV2", node, true);
        }
    }

    @Override
    public boolean isRemExecServiceRunning(String node, NativeResult nativeResult) throws NativeException {
        String execNode = node;
        if (!WindowsNative.ntCheckService("OracleRemExecServiceV2", node, new ServiceData(6), nativeResult)) {
            Trace.out("remote exec service is not running");
            return false;
        }
        if (node.equalsIgnoreCase("localnode")) {
            try {
                execNode = Utils.getLocalHost();
            }
            catch (UnknownHostException e) {
                Trace.out("UnknownHostException for retrieval of local host; msg= " + e.getMessage());
                throw new NativeException(MessageBundle.getMessageBundle("Prkn").getMessage("1031", true), e);
            }
        }
        WindowsNative.ntCheckRemExecServiceHandshake(execNode, nativeResult);
        int osErrCode = nativeResult.getOSErrCode();
        if (128 == osErrCode) {
            Trace.out("Incompatible rem exec client/server versions found " + nativeResult.getStringResult());
            return false;
        }
        if (0 != osErrCode) {
            Trace.out("remote exec service check failed with error " + nativeResult.getStringResult());
            return false;
        }
        Trace.out("compatible rem exec server exists");
        return true;
    }

    @Override
    public String[] getRemoteExecServerFiles() {
        ArrayList<String> remoteExecServerFiles = new ArrayList<String>();
        remoteExecServerFiles.addAll(Arrays.asList(WINDOWS_REMOTEEXEC_DEPENDENCIES));
        return remoteExecServerFiles.toArray(new String[0]);
    }

    @Override
    public String[] getMSVCRTFullPath(String[] locArr) throws NativeException {
        if (locArr == null) {
            Trace.out("null location array");
            throw new NativeException(MessageBundle.getMessageBundle("Prkr").getMessage("1039", true, new String[]{"locArr"}));
        }
        ArrayList<String> msvcLocList = new ArrayList<String>();
        for (String loc : locArr) {
            String[] msvcSrcLocArr;
            Trace.out("Considering location : " + loc);
            int foundCount = 0;
            for (String msvcSrcLoc : msvcSrcLocArr = this.getMSVCRSourceLocations(loc)) {
                for (String depFile : WINDOWS_REMOTEEXEC_DEPENDENCIES_MSVC) {
                    String fullFileName = msvcSrcLoc + FILE_SEPARATOR + depFile;
                    Trace.out("Checking if file \"" + fullFileName + "\" exists");
                    if (!new File(fullFileName).exists()) continue;
                    Trace.out("Found \"" + depFile + "\" at location \"" + msvcSrcLoc + QUOTE);
                    ++foundCount;
                    msvcLocList.add(fullFileName);
                }
                if (foundCount == WINDOWS_REMOTEEXEC_DEPENDENCIES_MSVC.length) break;
                msvcLocList = new ArrayList();
                Trace.out("Did not find all msvc DLLs");
                foundCount = 0;
            }
            if (foundCount != WINDOWS_REMOTEEXEC_DEPENDENCIES_MSVC.length) continue;
            Trace.out("All msvc DLLs found");
            break;
        }
        return msvcLocList.toArray(new String[0]);
    }

    private void deleteRegKeyOnNode(String key, String subKey, String nodeName) throws NativeException {
        try {
            ClusterWindows clusterWindows = new ClusterWindows(4);
            clusterWindows.deleteRegKeyOnNode(key, subKey, nodeName);
        }
        catch (ClusterException ce) {
            throw new NativeException(ce.getMessage(), ce);
        }
    }

    @Override
    public void runRemoteExecCmd(String cmd, String[] args, String[] env, NativeResult result) {
        this.dorunRemoteExecCmd(cmd, args, env, null, result, false);
    }

    @Override
    public void runRemoteExecCmd(String cmd, String[] args, String[] env, NativeResult result, boolean chkException) {
        this.dorunRemoteExecCmd(cmd, args, env, null, result, chkException);
    }

    @Override
    public void runRemoteExecCmd(String cmd, String[] args, String[] env, NativeResult result, boolean chkException, boolean toIgnore) {
        this.dorunRemoteExecCmd(cmd, args, env, null, result, chkException, toIgnore);
    }

    @Override
    public void runRemoteExecCmd(String cmd, String[] args, String[] env, String[] stdin, NativeResult result, boolean chkException) {
        this.dorunRemoteExecCmd(cmd, args, env, stdin, result, chkException);
    }

    private void dorunRemoteExecCmd(String cmd, String[] args, String[] env, String[] stdin, NativeResult result, boolean chkException) {
        this.dorunRemoteExecCmd(cmd, args, env, stdin, result, chkException, false);
    }

    private void dorunRemoteExecCmd(String cmd, String[] args, String[] env, String[] stdin, NativeResult result, boolean chkException, boolean toIgnore) {
        String localHost = null;
        try {
            localHost = Utils.getLocalHost();
        }
        catch (UnknownHostException e) {
            Trace.out("UnknownHostException for retrieval of local host; msg= " + e.getMessage());
            NativeException ne = new NativeException(MessageBundle.getMessageBundle("Prkn").getMessage("1031", false), e);
            result.setException(ne);
            result.setStatus(false);
            result.setBooleanResult(false);
            return;
        }
        this.runRemoteExecCmd(cmd, args, env, stdin, localHost, result, chkException, toIgnore);
    }

    @Override
    public void runRemoteExecCmd(String cmd, String[] args, String[] env, String node, NativeResult result) {
        this.dorunRemoteExecCmd(cmd, args, env, null, node, result, false);
    }

    @Override
    public void runRemoteExecCmd(String cmd, String[] args, String[] env, String node, NativeResult result, boolean chkException) {
        this.dorunRemoteExecCmd(cmd, args, env, null, node, result, chkException);
    }

    @Override
    public void runRemoteExecCmd(String cmd, String[] args, String[] env, String[] stdin, String node, NativeResult result, boolean chkException) {
        this.dorunRemoteExecCmd(cmd, args, env, stdin, node, result, chkException);
    }

    public void runRemoteExecCmd(String cmd, String[] args, String[] env, String[] stdin, String node, NativeResult result, boolean chkException, boolean toIgnore) {
        this.dorunRemoteExecCmd(cmd, args, env, stdin, node, result, chkException, toIgnore);
    }

    public void dorunRemoteExecCmd(String cmd, String[] args, String[] env, String[] stdin, String node, NativeResult result, boolean chkException) {
        this.dorunRemoteExecCmd(cmd, args, env, stdin, node, result, chkException, false);
    }

    private void dorunRemoteExecCmd(String cmd, String[] args, String[] env, String[] stdin, String node, NativeResult result, boolean chkException, boolean toIgnore) {
        boolean nativeSucc = false;
        boolean cmdSucc = false;
        Trace.out("_WS_: Calling windowsNative with cmd: " + cmd);
        result.setNodeName(node);
        WindowsNative.runRemoteExecCmd(cmd, args, env, stdin, node, result);
        nativeSucc = result.getStatus();
        Trace.out("_WS_: WinNative returned: " + nativeSucc);
        if (!toIgnore && !nativeSucc) {
            Object[] msgArgs = new Object[]{node, cmd};
            result.setException(new NativeException("1014", msgArgs));
            byte[] arr = result.getByteResult();
            if (arr != null) {
                String nativeStr = new String(arr);
                String[] resultStr = new String[]{nativeStr};
                result.setResultString(resultStr);
            }
        } else {
            byte[] arr;
            cmdSucc = result.getBooleanResult();
            if (!cmdSucc) {
                Trace.out("_WS_: remote command executed, but didn't return zero.");
            }
            if (null == result.getResultString() && (arr = result.getByteResult()) != null) {
                String[] resultStr;
                String bstr = new String(arr);
                for (String str : resultStr = bstr.split(NEWLINE)) {
                    Trace.out("SPLIT:" + str);
                }
                result.setResultString(resultStr);
            }
        }
    }

    protected String getWindowsCommand(String cmdName) throws NativeException {
        String eval;
        String winCmd = null;
        NativeResult result = this.getEnvironment(WINDIR_ENV);
        if (result.getStatus() && (eval = result.getStringResult()) != null) {
            File file = new File(eval + FILE_SEPARATOR + cmdName);
            if (file.exists()) {
                winCmd = file.getAbsolutePath();
            } else {
                file = new File(eval + FILE_SEPARATOR + SYSTEM32 + FILE_SEPARATOR + cmdName);
                if (file.exists()) {
                    winCmd = file.getAbsolutePath();
                }
            }
        }
        Trace.out("winCmd = " + winCmd);
        if (winCmd == null) {
            Object[] args = new String[]{cmdName, WINDIR_ENV, cmdName};
            throw new NativeException("1013", args);
        }
        return winCmd;
    }

    @Override
    public void isNodeAlive(String node, int timeout, NativeResult nativeResult) {
        nativeResult.setNodeName(node);
        try {
            if (timeout < 0) {
                timeout = 60;
            }
            InetAddress ia = InetAddress.getByName(node);
            nativeResult.setStatus(true);
            boolean isReachable = ia.isReachable(timeout * 1000);
            if (isReachable) {
                Trace.out("Node " + node + " is reachable");
                try {
                    String pingCmd = this.getWindowsCommand(PING_EXE);
                    Process pingProcess = Runtime.getRuntime().exec(pingCmd + " " + PING_ONCE + " " + node);
                    BufferedReader stdInput = new BufferedReader(new InputStreamReader(pingProcess.getInputStream()));
                    BufferedReader stdError = new BufferedReader(new InputStreamReader(pingProcess.getErrorStream()));
                    StringBuilder cmdOutput = new StringBuilder();
                    String line = null;
                    while ((line = stdInput.readLine()) != null) {
                        cmdOutput.append(line + NEWLINE);
                        isReachable = isReachable && !line.toLowerCase().contains("unreachable");
                    }
                    if (cmdOutput.length() > 0) {
                        Trace.out("Ping std out:\n" + cmdOutput);
                    }
                    StringBuilder cmdError = new StringBuilder();
                    while ((line = stdError.readLine()) != null) {
                        cmdError.append(line + NEWLINE);
                    }
                    if (cmdError.length() > 0) {
                        Trace.out("Ping std error:\n" + cmdError);
                    }
                    Trace.out("'" + node + "' is reachable (via ping):" + isReachable);
                }
                catch (NativeException ne) {
                    Trace.out("ping.exe not found.");
                }
            }
            if (isReachable) {
                nativeResult.setBooleanResult(true);
                nativeResult.setStringResult("reachability test successful");
            } else {
                Trace.out("valid IP. node " + node + " unreachable");
                nativeResult.setBooleanResult(false);
                nativeResult.setStatus(false);
                String errorMsg = MessageBundle.getMessageBundle("Prkn").getMessage("1035", true, new String[]{node});
                Trace.out("Error message: " + errorMsg);
                nativeResult.setStringResult(errorMsg);
                nativeResult.setOSString(new String[]{errorMsg});
            }
        }
        catch (UnknownHostException e) {
            StringBuilder errMsg = new StringBuilder();
            errMsg.append(MessageBundle.getMessageBundle("Prkn").getMessage("1034", true, new String[]{node}));
            if (node.equals(e.getMessage())) {
                errMsg.append(NEW_LINE + MessageBundle.getMessageBundle("Prkn").getMessage("1043", false, new String[]{node}));
            } else {
                errMsg.append(NEW_LINE + e.getMessage());
            }
            Trace.out("UnknownHostException for node=" + node + " msg= " + errMsg.toString());
            NativeException ne = new NativeException(new String[]{errMsg.toString()});
            nativeResult.setException(ne);
            nativeResult.setStatus(false);
            nativeResult.setBooleanResult(false);
        }
        catch (IOException e) {
            Trace.out("IOE for node" + node + " " + e.getMessage());
            NativeException ne = new NativeException(new String[]{MessageBundle.getMessageBundle("Prkn").getMessage("1034", true, new String[]{node}) + LINE_SEPARATOR + e.getMessage()});
            nativeResult.setException(ne);
            nativeResult.setStatus(false);
            nativeResult.setBooleanResult(false);
        }
    }

    @Override
    public void transferDirToNode(String nodeName, String pathName, String excludeListFile, NativeResult resultObj) {
        Trace.out("transferDirToNode operation on node: " + nodeName);
        String robocopyCmd = "";
        try {
            robocopyCmd = this.getWindowsCommand(ROBOCOPY_EXE);
        }
        catch (NativeException ne) {
            Trace.out(ne.getMessage());
            resultObj.setStatus(false);
            resultObj.setOSString(ne.getMessage());
            resultObj.setException(ne);
            return;
        }
        resultObj.setStatus(true);
        List<String> directories = null;
        List<String> files = null;
        if (excludeListFile != null) {
            try {
                Map<FileListType, List<String>> excludeMap = this.processFileList(pathName, excludeListFile);
                directories = excludeMap.get((Object)FileListType.DIR);
                files = excludeMap.get((Object)FileListType.FILE);
            }
            catch (NativeException ne) {
                Trace.out("Error processing the exclude-list. Details:" + NEW_LINE + ne.getMessage());
                resultObj.setStatus(false);
                resultObj.setOSString(ne.getMessage());
                resultObj.setException(ne);
                return;
            }
        }
        String robocopyExecCmd = robocopyCmd + " ";
        robocopyExecCmd = pathName.contains(" ") ? robocopyExecCmd + QUOTE + pathName + QUOTE + " " + QUOTE + this.createRemoteFileName(nodeName, pathName) + QUOTE : robocopyExecCmd + pathName + " " + this.createRemoteFileName(nodeName, pathName);
        robocopyExecCmd = robocopyExecCmd + " /E /MT /COPYALL /ZB /NP /NS /NC /NFL /NDL /NJH /NJS /r:5 /w:5";
        if (directories != null && !directories.isEmpty()) {
            StringBuilder excludedDirs = new StringBuilder();
            for (String directory : directories) {
                excludedDirs.append(" ");
                if (directory.contains(" ")) {
                    excludedDirs.append(QUOTE);
                    excludedDirs.append(directory);
                    excludedDirs.append(QUOTE);
                    continue;
                }
                excludedDirs.append(directory);
            }
            robocopyExecCmd = robocopyExecCmd + " /XD" + excludedDirs.toString();
        }
        if (files != null && !files.isEmpty()) {
            StringBuilder excludedFiles = new StringBuilder();
            for (String file : files) {
                excludedFiles.append(" ");
                if (file.contains(" ")) {
                    excludedFiles.append(" ");
                    excludedFiles.append(QUOTE);
                    excludedFiles.append(file);
                    excludedFiles.append(QUOTE);
                    continue;
                }
                excludedFiles.append(file);
            }
            robocopyExecCmd = robocopyExecCmd + " /XF" + excludedFiles.toString();
        }
        this.execNValidateRobocopy(robocopyExecCmd, resultObj);
        Trace.out("After robocopy command execution on node '" + nodeName + "'. Cmd executed -->" + robocopyExecCmd + " Success-->" + resultObj.getStatus());
    }

    @Override
    public void transferListedDirsToNode(String nodeName, String oracleHome, String copyListFile, String excludeListFile, NativeResult result) {
        Trace.out("transferListedDirsToNode operation on node: " + nodeName);
        this.transferListedToNode(nodeName, copyListFile, excludeListFile, result);
    }

    @Override
    public void writeCommandsToFile(String scriptFileName, String[] scriptLines, NativeResult result) {
        String[] writeLines = new String[scriptLines.length + 1];
        writeLines[0] = "@echo off" + System.getProperty("line.separator");
        for (int i = 0; i < scriptLines.length; ++i) {
            writeLines[i + 1] = "@" + scriptLines[i];
        }
        super.writeCommandsToFile(scriptFileName, writeLines, result);
    }

    @Override
    public void transferListedFilesToNode(String nodeName, String oracleHome, String copyListFile, NativeResult result) {
        Trace.out("transferListedFilesToNode operation on node: " + nodeName);
        this.transferListedToNode(nodeName, copyListFile, null, result);
    }

    @Override
    public void transferFileToNode(String nodeName, String oracleHome, String sourceFile, NativeResult resultObj) {
        Trace.out("transferFileToNode operation on node: " + nodeName);
        String roboCopyCmd = "";
        try {
            roboCopyCmd = this.getWindowsCommand(ROBOCOPY_EXE);
        }
        catch (NativeException ne) {
            Trace.out(ne.getMessage());
            resultObj.setStatus(false);
            resultObj.setOSString(ne.getMessage());
            resultObj.setException(ne);
            return;
        }
        File srcFile = new File(sourceFile);
        int indexLastFileSeparator = sourceFile.lastIndexOf(File.separator);
        String remoteFloc = indexLastFileSeparator != -1 && srcFile.isFile() ? this.createRemoteFileName(nodeName, srcFile.getParent()) : this.createRemoteFileName(nodeName, sourceFile);
        String robocopyExecCmd = roboCopyCmd + " " + srcFile.getParent() + " " + remoteFloc + " " + srcFile.getName() + " " + RCOPY_COPY_ALL_OPT + " " + RCOPY_NO_PROGRESS_OPT + " " + RCOPY_NO_SIZE_OPT + " " + RCOPY_NO_CLASS_OPT + " " + RCOPY_NO_FILE_OPT + " " + RCOPY_NO_DIRECTORY_OPT + " " + RCOPY_NO_JOB_HEADER_OPT + " " + RCOPY_NO_JOB_SUMMARY_OPT + " " + RCOPY_NUMBER_RETRIES + " " + RCOPY_RETRY_TIMEOUT;
        this.execNValidateRobocopy(robocopyExecCmd, resultObj);
    }

    @Override
    public void createListedDirsOnNode(String nodeName, String createListFile, NativeResult result) {
        String cmd;
        Trace.out("createListedDirsOnNode: " + nodeName);
        String CMD_SEP = " ";
        try {
            cmd = this.getWindowsCommand(CMD_EXE);
        }
        catch (NativeException ne) {
            Trace.out(ne.getMessage());
            result.setStatus(false);
            result.setOSString(ne.getMessage());
            result.setException(ne);
            return;
        }
        String mkdirExecCmd = cmd + CMD_SEP + "/C" + CMD_SEP + FOR_DOSCMD_FILE_OPT + CMD_SEP + FOR_DOSCMD_OPTIONS + CMD_SEP + "%i" + CMD_SEP + FOR_DOSCMD_IN + CMD_SEP + "(" + createListFile + ")" + CMD_SEP + FOR_DOSCMD_DO + CMD_SEP + "if" + CMD_SEP + "NOT" + CMD_SEP + "EXIST" + CMD_SEP + "\\\\" + nodeName + "\\%i" + CMD_SEP + cmd + CMD_SEP + "/C" + CMD_SEP + MKDIR_DOSCMD + CMD_SEP + "\\\\" + nodeName + "\\%i";
        Trace.out("mkdirCommand = " + mkdirExecCmd);
        RuntimeExec runtime = new RuntimeExec(WindowsSystem.getCmdArr(mkdirExecCmd), null, null);
        int retval = runtime.runCommand();
        String[] rtErr = runtime.getError();
        Trace.out("retval = " + retval);
        boolean bstatus = retval == 0;
        result.setStatus(bstatus);
        result.setOSErrCode(runtime.getExitValue());
        if (rtErr.length > 0) {
            Trace.out("There are error strings returned");
            result.setOSString(rtErr);
        }
    }

    @Override
    public void removeListedDirsFromNode(String nodeName, String removeListFile, NativeResult result) {
        String cmd;
        Trace.out("removeListedDirsOnNode: " + nodeName);
        String CMD_SEP = " ";
        try {
            cmd = this.getWindowsCommand(CMD_EXE);
        }
        catch (NativeException ne) {
            Trace.out(ne.getMessage());
            result.setStatus(false);
            result.setOSString(ne.getMessage());
            result.setException(ne);
            return;
        }
        String rmdirExecCmd = cmd + CMD_SEP + "/C" + CMD_SEP + FOR_DOSCMD_FILE_OPT + CMD_SEP + FOR_DOSCMD_OPTIONS + CMD_SEP + "%i" + CMD_SEP + FOR_DOSCMD_IN + CMD_SEP + "(" + removeListFile + ")" + CMD_SEP + FOR_DOSCMD_DO + CMD_SEP + "if" + CMD_SEP + "EXIST" + CMD_SEP + "\\\\" + nodeName + "\\%i" + CMD_SEP + cmd + CMD_SEP + "/C" + CMD_SEP + RMDIR_DOSCMD + CMD_SEP + "/S" + CMD_SEP + XCOPY_NO_VERBOSE_OPT + CMD_SEP + "\\\\" + nodeName + "\\%i";
        Trace.out("rmdirCommand = " + rmdirExecCmd);
        RuntimeExec runtime = new RuntimeExec(WindowsSystem.getCmdArr(rmdirExecCmd), null, null);
        int retval = runtime.runCommand();
        String[] rtErr = runtime.getError();
        Trace.out("retval = " + retval);
        boolean bstatus = retval == 0;
        result.setStatus(bstatus);
        result.setOSErrCode(runtime.getExitValue());
        if (rtErr.length > 0) {
            Trace.out("There are error strings returned");
            result.setOSString(rtErr);
        }
    }

    private void transferListedToNode(String nodeName, String copyListFile, String excludeFile, NativeResult result) {
        int i;
        int nQueueSize = Integer.parseInt(System.getProperty("NUM_TRANSFER_BUFFERS", "20"));
        TransferQueues transferQueues = new TransferQueues(nQueueSize);
        TransferReader transferReader = new TransferReader(transferQueues, copyListFile, excludeFile);
        TransferWriter transferWriter = new TransferWriter(transferQueues, nodeName);
        Trace.out("Staring Reader/Writer threads for block transfer");
        transferReader.start();
        transferWriter.start();
        try {
            transferReader.join();
            transferWriter.join();
        }
        catch (InterruptedException ie) {
            result.setStatus(false);
            result.setException(ie);
            return;
        }
        String[] readErrors = transferReader.getErrors();
        String[] writeErrors = transferWriter.getErrors();
        String[] copyErrors = new String[readErrors.length + writeErrors.length];
        int len = 0;
        if (readErrors != null) {
            i = 0;
            for (i = 0; i < readErrors.length; ++i) {
                copyErrors[i] = readErrors[i];
            }
            len = i;
        }
        if (writeErrors != null) {
            i = 0;
            while (i < writeErrors.length) {
                copyErrors[len] = writeErrors[i];
                ++i;
                ++len;
            }
        }
        Trace.out("copyErrors = " + copyErrors);
        if (copyErrors.length > 0) {
            result.setStatus(false);
        } else {
            result.setStatus(true);
        }
        Trace.out("result.status = " + result.getStatus());
        result.setOSString(copyErrors);
    }

    @Override
    public void updateEnv(String srcLoc, NativeResult result) {
        String node = result.getNodeName();
        Trace.out("srcLoc = " + srcLoc);
        String destLoc = this.getRemExecDestLocationInternal(node);
        Trace.out("destLoc = " + destLoc);
        RemoteExecCommand cmd = new RemoteExecCommand("srvmUpdateEnv", null, null, node, null, srcLoc, destLoc, result);
        cmd.execute();
    }

    @Override
    public void registerOCX(String ocxFname, String wkdir, boolean bregisterFlag, String srcLoc, NativeResult result) {
        String node = result.getNodeName();
        String registerFlag = bregisterFlag ? "true" : "false";
        String[] args = new String[]{ocxFname, wkdir, registerFlag};
        String destLoc = this.getRemExecDestLocationInternal(node);
        RemoteExecCommand cmd = new RemoteExecCommand("srvmRegisterOCX", args, null, node, null, srcLoc, destLoc, result);
        cmd.execute();
    }

    @Override
    public void rebootNode(String srcLoc, NativeResult result) {
        String node = result.getNodeName();
        Trace.out("node = " + node);
        String destLoc = this.getRemExecDestLocationInternal(node);
        RemoteExecCommand cmd = new RemoteExecCommand("srvmRebootNode", null, null, node, null, srcLoc, destLoc, result);
        cmd.execute();
    }

    private String getRemExecDestLocation(String nodeName) throws ClusterException {
        return this.getRemExecDestLocationInternal(nodeName);
    }

    public String getDestLoc(String nodeName) throws ClusterException {
        String destLoc = this.getRemExecDestLocationInternal(nodeName);
        if (destLoc == null) {
            return null;
        }
        File destDir = new File(destLoc);
        return destDir.getParent();
    }

    private String getRemExecDestLocationInternal(String nodeName) {
        RegistryKeyData regData;
        String remExecLoc = null;
        Trace.out("Trying to populate remExecLoc");
        NativeResult result = new NativeResult();
        if (this.regKeyExists(nodeName, "HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\OracleRemExecServicev2", result)) {
            Trace.out("getting imagePath value for rem exec service key");
            regData = new RegistryKeyData("HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\OracleRemExecServicev2", "ImagePath");
            this.regGetData(nodeName, "HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\OracleRemExecServicev2", "ImagePath", regData, result);
            String value = regData.getStringData();
            Trace.out("value from service = " + value);
            if (value != null && value.trim().length() > 0) {
                int index;
                if (value.startsWith(QUOTE)) {
                    value = value.substring(1);
                }
                if (value.endsWith(QUOTE)) {
                    value = value.substring(0, value.length() - 1);
                }
                if ((index = value.toLowerCase().indexOf("oraremservicev2".toLowerCase())) != -1) {
                    remExecLoc = value.substring(0, index);
                    if ((remExecLoc = remExecLoc + "oraremservicev2".toLowerCase()).startsWith(QUOTE)) {
                        remExecLoc = remExecLoc.substring(1, remExecLoc.length());
                    }
                    Trace.out("After parsing the imagePath value for rem exec service key the remExecLoc=" + remExecLoc);
                }
            } else {
                remExecLoc = null;
            }
        } else {
            Trace.out("RegKeyExists OSString: " + result.getOSString());
        }
        Trace.out("After checking for remexec service key");
        if (remExecLoc == null) {
            String tempLoc = System.getProperty("java.io.tmpdir");
            Trace.out("tempLoc = " + tempLoc);
            File file = new File(this.createPath(nodeName, tempLoc));
            if (file.exists() && file.isDirectory()) {
                Trace.out("the temp location exists on the remote node too");
                remExecLoc = tempLoc;
            } else {
                int driveInd = tempLoc.indexOf(58);
                String drive = tempLoc.substring(0, driveInd + 1);
                Trace.out("drive = " + drive);
                tempLoc = drive + FILE_SEPARATOR + "temp";
                file = new File(this.createPath(nodeName, tempLoc));
                if (file.exists() && file.isDirectory()) {
                    Trace.out("drive temp exists on remote node too");
                    remExecLoc = tempLoc;
                } else {
                    file = new File(this.createPath(nodeName, drive));
                    if (file.exists()) {
                        String retval = this.createDir(nodeName, tempLoc);
                        Trace.out("retval = " + retval);
                        remExecLoc = tempLoc;
                    } else if (this.regKeyExists(nodeName, "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", result)) {
                        regData = new RegistryKeyData("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", SYSTEM_ROOT_ENTRY);
                        this.regGetData(nodeName, "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", SYSTEM_ROOT_ENTRY, regData, result);
                        String value = regData.getStringData();
                        Trace.out("system root value = " + value);
                        int index = value.indexOf(58);
                        String sysDrive = value.substring(0, index + 1);
                        Trace.out("sysDrive = " + sysDrive);
                        if (!sysDrive.toLowerCase().equals(drive.toLowerCase())) {
                            tempLoc = sysDrive + FILE_SEPARATOR + "temp";
                            file = new File(this.createPath(nodeName, tempLoc));
                            if (file.exists() && file.isDirectory()) {
                                Trace.out("system temp dir exists on the remote node");
                                remExecLoc = tempLoc;
                            } else {
                                file = new File(this.createPath(nodeName, sysDrive));
                                if (file.exists()) {
                                    String retval = this.createDir(nodeName, tempLoc);
                                    Trace.out("sys retval = " + retval);
                                    remExecLoc = tempLoc;
                                }
                            }
                        }
                    } else {
                        Trace.out("RegKeyExists OSString: " + result.getOSString());
                    }
                }
            }
            if (remExecLoc != null && remExecLoc.trim().length() > 0) {
                int index = (remExecLoc = remExecLoc.trim()).toLowerCase().indexOf("oraremservicev2".toLowerCase());
                if (index != -1) {
                    remExecLoc = remExecLoc.substring(0, index);
                }
                if (!remExecLoc.endsWith("\\")) {
                    remExecLoc = remExecLoc + "\\";
                }
                remExecLoc = remExecLoc + "oraremservicev2".toLowerCase();
                Trace.out("The remExecLoc formed as =" + remExecLoc);
            }
        }
        Trace.out("remExecLoc = \"" + remExecLoc + QUOTE);
        return remExecLoc;
    }

    @Override
    public String getLocalCSSHome(String nodeName, Version version) throws NativeException {
        String node;
        String cssHome = null;
        boolean bFailed = true;
        NativeResult result = new NativeResult();
        String string = node = "localnode".equalsIgnoreCase(nodeName) ? null : nodeName;
        if (this.regKeyExists(node, "HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\OracleCSService", result)) {
            Trace.out("getting imagePath value for css service key");
            RegistryKeyData regData = new RegistryKeyData("HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\OracleCSService", "ImagePath");
            this.regGetData(node, "HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\OracleCSService", "ImagePath", regData, result);
            String value = regData.getStringData();
            if (value != null) {
                Trace.out("value from service = " + value);
                int index = value.toLowerCase().indexOf(CSS_BIN_PATH.toLowerCase());
                if (index != -1) {
                    cssHome = value.substring(0, index);
                    bFailed = false;
                }
            }
        }
        if (!result.getStatus() || bFailed) {
            String msg = result.getOSString();
            if (msg == null) {
                msg = "";
            }
            Object[] args = new Object[]{"ImagePath", "HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\OracleCSService", nodeName, msg};
            throw new NativeException("1011", args);
        }
        return cssHome;
    }

    private String[] getMSVCRSourceLocations(String srcLoc) {
        String[] paths = new String[]{srcLoc, srcLoc + FILE_SEPARATOR + "bin", srcLoc + FILE_SEPARATOR + "inventory" + FILE_SEPARATOR + "Scripts" + FILE_SEPARATOR + "ext" + FILE_SEPARATOR + "bin"};
        return paths;
    }

    @Override
    public void setACLs(String node, String path, boolean isAdmin, NativeResult result) {
        String targetPath = "localnode".equalsIgnoreCase(node) ? path : this.createRemoteFileName(node, path);
        Trace.out("path=" + path + " targetPath=" + targetPath);
        WindowsNative.setACLs(targetPath, isAdmin, result);
    }

    @Override
    public boolean checkCSSStatus(String nodeName, String oracleHome, Version version, NativeResult result) {
        Trace.out("checkCSSStatus operation on node: " + nodeName);
        return WindowsNative.ntCheckService("OracleCSService", nodeName, new ServiceData(6), result);
    }

    @Override
    public void listDirectory(String nodeName, String dirPath, NativeResult result) {
        File file = "localnode".equalsIgnoreCase(nodeName) ? new File(dirPath) : new File(this.createRemoteFileName(nodeName, dirPath));
        String[] dirList = file.list();
        if (dirList == null) {
            Object[] args = new Object[]{file.getAbsolutePath()};
            NativeException ne = new NativeException(MessageBundle.getMessageBundle("Prkc").getMessage("1026", true, args));
            result.setStatus(false);
            result.setException(ne);
        } else {
            result.setStatus(true);
            result.setResultString(dirList);
        }
    }

    @Override
    public void getLibraryVersion(String libPath, NativeResult result) {
        WindowsNative.getLibraryVersion(libPath, result);
    }

    @Override
    public String getOFSUtilLocation() {
        String ofsUtilLoc = null;
        NativeResult result = this.getEnvironment(WINDIR_ENV);
        if (result.getStatus()) {
            Trace.out("Able to get windir environment");
            String eval = result.getStringResult();
            if (eval != null) {
                Trace.out("eval = " + eval);
                ofsUtilLoc = eval + FILE_SEPARATOR + SYSTEM32;
            }
        }
        return ofsUtilLoc;
    }

    public void loadSRVMDependents() throws NativeException {
        this.m_library.load("MSVCR120", false);
        this.m_library.load("uts", true);
        this.m_library.load("wsec12", true);
    }

    @Override
    public void resolvePath(String path, String srcLoc, String destLoc, NativeResult result) {
        String node = result.getNodeName();
        String[] args = new String[]{path};
        RemoteExecCommand cmd = new RemoteExecCommand("srvmResolvePath", args, null, node, null, srcLoc, destLoc, result);
        cmd.execute();
    }

    @Override
    public void getWinDomainName(String srcLoc, String destLoc, NativeResult result) {
        String node = result.getNodeName();
        RemoteExecCommand cmd = new RemoteExecCommand("srvmGetWindDomain", null, null, node, null, srcLoc, destLoc, result);
        cmd.execute();
    }

    public static boolean setDestLocPermissions(String destLoc) {
        NativeResult nativeResult = new NativeResult();
        Trace.out("Calling native method to modify permissions : " + destLoc);
        WindowsNative.setDestLocPermissions(destLoc, nativeResult);
        Trace.out("change directory permissions success? " + nativeResult.getBooleanResult());
        if (!nativeResult.getBooleanResult()) {
            Trace.out("There is an error while modifying directory's ACL: " + nativeResult.getOSString());
            return nativeResult.getBooleanResult();
        }
        return nativeResult.getBooleanResult();
    }

    @Override
    public String getCurrentUserName() throws NativeException {
        String userName = null;
        NativeResult nativeRes = new NativeResult();
        Trace.out("Calling native method to get the current user name");
        WindowsNative.getCurrentUserName(nativeRes);
        if (!nativeRes.getStatus()) {
            Trace.out("Failed to retrieve the current user name");
            throw new NativeException("1041", new String[]{nativeRes.getOSString()});
        }
        userName = nativeRes.getStringResult();
        Trace.out("Retrieved the current user name as " + userName);
        return userName;
    }

    private void execNValidateRobocopy(String roboExecCmd, NativeResult resultObj) {
        Trace.out("transferCommand = " + roboExecCmd);
        RuntimeExec runtime = new RuntimeExec(WindowsSystem.getCmdArr(roboExecCmd), null, null);
        int retval = runtime.runCommand();
        String[] rtErr = runtime.getError();
        boolean bstatus = false;
        Trace.out("retval = " + retval);
        if (retval == 2 || retval >= 8) {
            if (rtErr.length == 0) {
                rtErr = runtime.getOutput();
            }
            Trace.out("An error occurred: " + rtErr);
            resultObj.setOSErrCode(runtime.getExitValue());
            resultObj.setOSString(rtErr);
        } else {
            resultObj.setOSErrCode(0);
            bstatus = true;
        }
        resultObj.setStatus(bstatus);
    }

    private Map<FileListType, List<String>> processFileList(String topLevelDirPathname, String filePathname) throws NativeException {
        List<String> excludeContents = this.readFile(filePathname);
        try {
            topLevelDirPathname = new File(topLevelDirPathname).getCanonicalPath();
        }
        catch (IOException ioe) {
            Trace.out("Error canonicalizing path name \"" + topLevelDirPathname + QUOTE);
        }
        if (!topLevelDirPathname.endsWith(File.separator)) {
            topLevelDirPathname = topLevelDirPathname + File.separator;
        }
        topLevelDirPathname = this.toWindowsPath(topLevelDirPathname);
        String baseDirPathname = topLevelDirPathname.toLowerCase();
        LinkedList<String> absolutePathsToExclude = new LinkedList<String>();
        for (String excludeContent : excludeContents) {
            if ((excludeContent = this.toWindowsPath(excludeContent)).toLowerCase().startsWith(baseDirPathname)) {
                absolutePathsToExclude.add(excludeContent);
                continue;
            }
            absolutePathsToExclude.add(topLevelDirPathname + excludeContent);
        }
        LinkedList<String> directories = new LinkedList<String>();
        LinkedList<String> files = new LinkedList<String>();
        HashMap<String, LinkedList<String>> regexMap = new HashMap<String, LinkedList<String>>();
        for (String string : absolutePathsToExclude) {
            File fileOrDirToExlude = new File(string);
            try {
                int splitIndex;
                if (fileOrDirToExlude.exists()) {
                    if (fileOrDirToExlude.isDirectory()) {
                        directories.add(string);
                        continue;
                    }
                    if (!fileOrDirToExlude.isFile()) continue;
                    files.add(string);
                    continue;
                }
                int regexIndex = string.indexOf(".*");
                if (regexIndex == -1 || (splitIndex = string.substring(0, regexIndex).lastIndexOf(File.separator)) == -1) continue;
                String dirPathname = string.substring(0, splitIndex);
                String regexInDir = string.substring(splitIndex + 1);
                LinkedList<String> regexList = (LinkedList<String>)regexMap.get(dirPathname);
                if (regexList == null) {
                    regexList = new LinkedList<String>();
                    regexMap.put(dirPathname, regexList);
                }
                regexList.add(regexInDir.toLowerCase());
            }
            catch (SecurityException se) {
                Trace.out("Accesibility error. Details:" + NEW_LINE + se.getMessage());
            }
        }
        Set dirPathnames = regexMap.keySet();
        for (String dirPathname : dirPathnames) {
            List regexList = (List)regexMap.get(dirPathname);
            File dir = new File(dirPathname);
            try {
                File[] dirContents;
                if (!dir.exists()) continue;
                block9: for (File fileOrDir : dirContents = dir.listFiles()) {
                    String stringToCheckForMatch = fileOrDir.getName().toLowerCase();
                    for (String currRegex : regexList) {
                        if (!Pattern.matches(currRegex, stringToCheckForMatch)) continue;
                        if (fileOrDir.isFile()) {
                            files.add(fileOrDir.getAbsolutePath());
                            continue block9;
                        }
                        if (!fileOrDir.isDirectory()) continue block9;
                        directories.add(fileOrDir.getAbsolutePath());
                        continue block9;
                    }
                }
            }
            catch (SecurityException se) {
                Trace.out("Accesibility error. Details:" + NEW_LINE + se.getMessage());
            }
        }
        HashMap<FileListType, List<String>> hashMap = new HashMap<FileListType, List<String>>(3);
        hashMap.put(FileListType.DIR, directories);
        hashMap.put(FileListType.FILE, files);
        return hashMap;
    }

    private String toWindowsPath(String path) {
        return path.replaceAll("/", "\\\\");
    }

    private List<String> readFile(String filePathname) throws NativeException {
        BufferedInputStream bufInStream;
        try {
            bufInStream = new BufferedInputStream(new FileInputStream(filePathname), 1024);
        }
        catch (FileNotFoundException fnfe) {
            Object[] args = new String[]{filePathname};
            throw new NativeException("1144", args);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bufInStream));
        LinkedList<String> processedLines = new LinkedList<String>();
        try {
            String currLine;
            while ((currLine = bufferedReader.readLine()) != END_OF_STREAM) {
                if ((currLine = currLine.trim()).trim().equals("")) continue;
                processedLines.add(currLine);
            }
        }
        catch (IOException ioe) {
            Object[] args = new String[]{filePathname};
            throw new NativeException("1026", args, (Exception)ioe);
        }
        finally {
            try {
                bufInStream.close();
            }
            catch (IOException iOException) {}
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        return processedLines;
    }

    static {
        s_msgBundle = MessageBundle.getMessageBundle("Prkc");
        WINDOWS_REMOTEEXEC_DEPENDENCIES_MSVC = new String[]{"MSVCR120.DLL", "MSVCP120.DLL"};
        WINDOWS_REMOTEEXEC_DEPENDENCIES = new String[]{"ORAUTS.DLL", WSEC_LIBRARY_NAME, "RemoteExecService.exe"};
    }

    private static enum FileListType {
        DIR,
        FILE;

    }
}

