/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.nativesystem;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import oracle.cluster.impl.util.Utils;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.nativesystem.DeterminePlatform;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.trace.Trace;

public class Library
implements Constants {
    private static Library s_instance;
    private static Object s_instanceLock;
    private Hashtable m_libraryTable;
    private NativeSystem m_system;

    private Library(NativeSystem system) {
        this.m_system = system;
        this.m_libraryTable = new Hashtable(11);
        this.m_libraryTable.put(FRAMEWORK_LIBRARY_NAME, "");
        this.m_libraryTable.put(FRAMEWORK_OCR_LIBRARY_NAME, "");
        this.m_libraryTable.put(FRAMEWORK_OPSM_HA_LIBRARY_NAME, "");
        this.m_libraryTable.put(FRAMEWORK_CRED_LIBRARY_NAME, "");
        this.m_libraryTable.put(FRAMEWORK_RD_JNI_LIBRARY_NAME, "");
        this.m_libraryTable.put(FRAMEWORK_GNS_JNI_LIBRARY_NAME, "");
        this.m_libraryTable.put(FRAMEWORK_CLSCE_JNI_LIBRARY_NAME, "");
        this.m_libraryTable.put(FRAMEWORK_CLSCRED_JNI_LIBRARY_NAME, "");
        this.m_libraryTable.put(FRAMEWORK_CLSNS_JNI_LIBRARY_NAME, "");
        String osArch = System.getProperty("os.arch").toUpperCase();
        if (!this.m_system.isUnixSystem()) {
            this.m_libraryTable.put("uts", "");
            this.m_libraryTable.put("wsec12", "");
            this.m_libraryTable.put("MSVCR120", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized Library getInstance(NativeSystem system) {
        Object object = s_instanceLock;
        synchronized (object) {
            if (s_instance == null) {
                s_instance = new Library(system);
            }
        }
        return s_instance;
    }

    private void assertLibraryName(String libraryName) throws NativeException {
        if (!this.m_libraryTable.containsKey(libraryName)) {
            throw new NativeException("1027", new String[]{libraryName});
        }
    }

    public Enumeration librariesSupported() {
        return this.m_libraryTable.keys();
    }

    public synchronized String getLibraryPath(String libraryName) throws NativeException {
        this.assertLibraryName(libraryName);
        return (String)this.m_libraryTable.get(libraryName);
    }

    public synchronized boolean isLoaded(String libraryName) throws NativeException {
        this.assertLibraryName(libraryName);
        return "" != (String)this.m_libraryTable.get(libraryName);
    }

    public synchronized void load(String libraryName) throws NativeException {
        this.load(libraryName, true);
    }

    public synchronized void load(String libraryName, boolean isOracleLib) throws NativeException {
        String oracleLibFile;
        String installLibFile;
        String path;
        this.assertLibraryName(libraryName);
        Trace.out("library.load");
        if (this.isLoaded(libraryName)) {
            return;
        }
        String libraryFile = this.m_system.getNativeLibraryName(libraryName, isOracleLib);
        String libPath = path = System.getProperties().getProperty("java.library.path");
        String installerLibLoc = System.getProperty("oracle.installer.library_loc");
        String oracleHome = System.getProperty("ORACLE_HOME");
        boolean isNonBootstrap = Boolean.valueOf(System.getProperty("oracle.installer.not_bootstrap"));
        String osName = DeterminePlatform.getOSName();
        if (!osName.equals("AIX")) {
            if (!osName.equals("OpenVMS")) {
                installLibFile = installerLibLoc + File.separator + libraryFile;
                oracleLibFile = DeterminePlatform.getLibraryPath(oracleHome) + File.separator + libraryFile;
            } else {
                oracleLibFile = installLibFile = this.m_system.getOracleLibraryName(libraryName);
            }
        } else {
            installLibFile = installerLibLoc + File.separator + "lib" + libraryName + ".so";
            oracleLibFile = DeterminePlatform.getLibraryPath(oracleHome) + File.separator + "lib" + libraryName + ".so";
        }
        if (Trace.isLevelEnabled(1)) {
            Trace.out("oracleHome " + oracleHome);
            Trace.out("Loading " + libraryFile + "...");
            Trace.out("installLibFile " + installLibFile);
        }
        String osArch = System.getProperty("os.arch").toUpperCase();
        try {
            if (!isNonBootstrap && installerLibLoc != null && new File(installLibFile).exists() && (libraryName.equalsIgnoreCase(FRAMEWORK_LIBRARY_NAME) || libraryName.equalsIgnoreCase("uts") || libraryName.equalsIgnoreCase("wsec12") || libraryName.equalsIgnoreCase("MSVCR120"))) {
                libPath = installerLibLoc;
                Trace.out("Property oracle.installer.library_loc is set to value=" + installerLibLoc);
                Trace.out("Loading  library " + installLibFile);
                try {
                    installLibFile = Utils.canonicalizePath(installLibFile);
                }
                catch (IOException io) {
                    Trace.out("Failed to canonicalize, trying to load anyway " + installLibFile);
                    Trace.out("Exception: " + io);
                }
                System.load(installLibFile);
            } else if (oracleHome != null && new File(oracleLibFile).exists()) {
                libPath = DeterminePlatform.getLibraryPath(oracleHome);
                Trace.out("Loading  library " + oracleLibFile);
                if (this.isLoaded(FRAMEWORK_LIBRARY_NAME)) {
                    this.validateLibVersion(oracleLibFile);
                }
                System.load(oracleLibFile);
            } else {
                String string = libraryFile = isOracleLib ? this.m_system.getOracleLibraryName(libraryName) : libraryName;
                if (Trace.isLevelEnabled(1)) {
                    Trace.out("Loading  library " + libraryFile + " from path=\n" + libPath);
                }
                System.loadLibrary(libraryFile);
            }
            this.m_libraryTable.put(libraryName, libPath);
            if (Trace.isLevelEnabled(1)) {
                Trace.out("Loaded library " + libraryFile + " from path=\n" + libPath);
            }
        }
        catch (NativeException ne) {
            if (path == null) {
                path = "<null>";
            }
            if (libPath == null) {
                libPath = path;
            }
            Trace.out("Failure loading shared library: " + libraryFile);
            Trace.out("Exception: " + ne);
            Object[] args = new String[]{libraryFile, this.m_system.loadPathDescription(), libPath, ne.getMessage()};
            throw new NativeException("1008", args);
        }
        catch (UnsatisfiedLinkError ule) {
            if (path == null) {
                path = "<null>";
            }
            if (libPath == null) {
                libPath = path;
            }
            Trace.out("Failure loading shared library: " + libraryFile);
            Trace.out("Exception: " + ule);
            Object[] args = new String[]{libraryFile, this.m_system.loadPathDescription(), libPath, ule.toString()};
            Trace.out("UNSATISFIEDLINKERROR: \n LibraryFile: '" + libraryFile + "'\n" + " loadPath: '" + this.m_system.loadPathDescription() + "'\n" + " libPath: '" + libPath + "'\n ExceptionMSG: '" + ule.getMessage() + "'\n ExceptiontoString: '" + ule.toString() + "'");
            throw new NativeException("1008", args);
        }
    }

    void validateLibVersion(String libPath) throws NativeException {
        if (!this.m_system.isUnixSystem()) {
            Trace.out("Validating library version of " + libPath);
            NativeResult result = new NativeResult();
            this.m_system.getLibraryVersion(libPath, result);
            if (result.getStatus()) {
                String majorVer;
                String libVer = result.getStringResult();
                Trace.out("libVer=" + libVer);
                StringTokenizer st = new StringTokenizer(libVer, ".");
                if (st.hasMoreTokens() && !SRVM_LIBS_SUFFIX.equals(majorVer = st.nextToken())) {
                    Object[] args = new String[]{libPath, majorVer, SRVM_LIBS_SUFFIX};
                    throw new NativeException("1020", args);
                }
            }
            Trace.out("Validated version for " + libPath);
        }
    }

    static {
        s_instanceLock = new Object();
    }
}

