/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.nativesystem;

import java.io.File;
import java.util.Vector;
import oracle.ops.mgmt.command.registry.RegistryKeyData;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.WindowsSystem;
import oracle.ops.mgmt.nativesystem.sPlatform;

public class DeterminePlatform {
    private static String OSGroup = "## UNKNOWN ##";
    private static String osName = System.getProperty("os.name");
    private static String osNameWin;
    public static final String LINUX = "Linux";
    public static final String AIX = "AIX";
    public static final String SUNOS = "SunOS";
    public static final String SOLARIS = "Solaris";
    public static final String HPUX = "HP-UX";
    public static final String OpenVMS = "OpenVMS";

    public static String getOSGroup() {
        return OSGroup;
    }

    public static String getOSName() {
        return osName;
    }

    static String getLibraryPath(String oracleHome) {
        File dir;
        String libPath = oracleHome + File.separator;
        libPath = DeterminePlatform.getOSGroup().equalsIgnoreCase("WINDOWS") ? libPath + "bin" : libPath + "lib";
        if (sPlatform.isHybrid(DeterminePlatform.getOSName()) && (dir = new File(libPath + "32")).exists() && dir.isDirectory()) {
            libPath = dir.getAbsolutePath();
        }
        return libPath;
    }

    static {
        if (osName.contains("Windows")) {
            WindowsSystem WinSys = new WindowsSystem();
            NativeResult result = new NativeResult();
            RegistryKeyData regData = new RegistryKeyData("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", 10);
            WinSys.regGetData("localnode", "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", "ProductName", regData, result);
            osNameWin = regData.getStringData();
            if (osNameWin.startsWith("Windows")) {
                osName = osNameWin;
            }
        }
        Vector<String> plat = new Vector<String>();
        plat.addElement(SOLARIS);
        plat.addElement(SUNOS);
        plat.addElement(HPUX);
        plat.addElement(LINUX);
        plat.addElement("Digital UNIX");
        plat.addElement(AIX);
        plat.addElement("Intel_Solaris");
        plat.addElement("SINIX_Y");
        plat.addElement("ReliantUNIX_M");
        plat.addElement("UNIX_Alpha");
        plat.addElement("Dynix");
        plat.addElement("DYNIX/ptx");
        plat.addElement("Unixware");
        plat.addElement("NEC");
        plat.addElement("UX/4800");
        plat.addElement("Hitachi_UX");
        plat.addElement("Iris");
        plat.addElement("NCOS");
        plat.addElement(OpenVMS);
        plat.addElement("IBM_MVS");
        if (plat.contains(osName)) {
            OSGroup = "UNIX";
        }
        plat.removeAllElements();
        plat.addElement("Windows NT");
        plat.addElement("Windows 95");
        plat.addElement("Windows 98");
        plat.addElement("Windows 2000");
        plat.addElement("Windows 2003");
        plat.addElement("Windows XP");
        plat.addElement("Windows Vista");
        plat.addElement("Windows NT (unknown)");
        plat.addElement("NT_Alpha");
        if (plat.contains(osName) || osName.indexOf("Windows") != -1) {
            OSGroup = "WINDOWS";
        }
        plat.removeAllElements();
        plat.addElement("NetWare_411");
        plat.addElement("NetWare_500");
        if (plat.contains(osName)) {
            OSGroup = "Desktop";
        }
    }
}

