/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.database.config.upgrade;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.database.DatabaseException;
import oracle.ops.mgmt.database.InstanceException;
import oracle.ops.mgmt.database.ParallelServer;
import oracle.ops.mgmt.database.ParallelServerConfig;
import oracle.ops.mgmt.database.ParallelServerHA;
import oracle.ops.mgmt.database.ServiceException;
import oracle.ops.mgmt.database.config.DatabaseConfigConverter;
import oracle.ops.mgmt.database.config.downgrade.DowngradeDBConfig;
import oracle.ops.mgmt.database.config.downgrade.DowngradeException;
import oracle.ops.mgmt.database.config.downgrade.HADatabase;
import oracle.ops.mgmt.database.config.upgrade.UpgradeException;
import oracle.ops.mgmt.has.ClusterAlias;
import oracle.ops.mgmt.has.ClusterAliasException;
import oracle.ops.mgmt.nodeapps.VIP;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.nodeapps.VirtualIPException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.CmdLineParser;
import oracle.ops.util.MissingArgumentException;
import oracle.ops.util.ParamMissingArgumentException;
import oracle.ops.util.UnexpectedArgumentException;

public class UpgradeDBConfig {
    public static final String[] PARAMS = new String[]{"dbname", "orahome"};
    public static final String[] OPTIONAL = new String[0];
    private String m_dbName = null;
    private String m_dbDomain = null;
    private String m_gdbName = null;
    private String m_oldOracleHome = null;
    private String m_newOracleHome = null;
    private String m_spfileName = null;
    private String[] m_instances = null;
    private String[] m_nodes = null;
    private boolean m_bEnableCancel = false;
    private HADatabase m_haDatabase = null;
    private Version m_fromVersion = null;

    public void processCmdArgs(String[] args) throws UpgradeException {
        Trace.out("Processing command line arguments passed");
        CmdLineParser cmdParser = new CmdLineParser("-", DatabaseConfigConverter.FLAGS, PARAMS, OPTIONAL);
        try {
            cmdParser.parse(args);
        }
        catch (MissingArgumentException mae) {
            throw new UpgradeException(mae.getMessage());
        }
        catch (ParamMissingArgumentException pmae) {
            throw new UpgradeException(pmae.getMessage());
        }
        catch (UnexpectedArgumentException uae) {
            throw new UpgradeException(uae.getMessage());
        }
        String dbName = cmdParser.getParam("dbname");
        int dot = dbName.indexOf(".");
        if (dot > 0) {
            this.m_dbName = dbName.substring(0, dot);
            this.m_dbDomain = dbName.substring(dot + 1);
        } else {
            this.m_dbName = dbName;
            this.m_dbDomain = null;
        }
        this.m_newOracleHome = cmdParser.getParam("orahome");
    }

    private void upgradeDatabaseConfig() throws UpgradeException {
        Trace.out("downgradeDatabaseConfig: database = " + this.m_dbName);
        ParallelServer pServer = null;
        ParallelServerConfig pConfig = null;
        Collection priorVersions = Version.getPrevVersions();
        String msg = null;
        int tries = 1;
        Trace.out("size of prior versions = " + priorVersions.size());
        for (Object pv : priorVersions) {
            Version priorVer = (Version)pv;
            Trace.out("prior version = " + priorVer.toString());
            try {
                pServer = Cluster.getParallelServer(this.m_dbName, this.m_dbDomain, priorVer);
                this.m_fromVersion = priorVer;
                break;
            }
            catch (ConfigurationException ce) {
                msg = msg + ce.getMessage();
                Trace.out("msg = " + msg);
                Trace.out("tries = " + tries);
                if (tries == priorVersions.size()) {
                    throw new UpgradeException(msg);
                }
                ++tries;
            }
        }
        if (pServer == null) {
            Trace.out("Couldn't get an handle to database object");
            return;
        }
        try {
            pConfig = pServer.getConfiguration();
        }
        catch (ConfigurationException ce) {
            throw new UpgradeException(ce.getMessage());
        }
        Trace.out("Getting database details....");
        this.m_dbDomain = pConfig.getDomain();
        this.m_gdbName = this.m_dbName;
        if (this.m_dbDomain != null) {
            this.m_gdbName = this.m_dbName + "." + this.m_dbDomain;
        }
        this.m_oldOracleHome = pConfig.getOracleHome();
        this.m_spfileName = pConfig.getSPFile();
        String[] instances = pConfig.enumerateInstances();
        this.m_instances = new String[instances.length];
        for (int i = 0; i < instances.length; ++i) {
            this.m_instances[i] = instances[i];
        }
        String[] nodes = pConfig.enumerateNodes();
        this.m_nodes = new String[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            this.m_nodes[i] = nodes[i];
        }
        Trace.out("Upgrading database OCR configuration");
        VIPAddress dbCluaVIPAddr = null;
        try {
            ClusterAlias clusterAlias = new ClusterAlias();
            if (clusterAlias.isSupported()) {
                Trace.out("Cluster Alias in  supported");
                dbCluaVIPAddr = this.getDBCluaVIPAddr(this.m_gdbName, this.m_newOracleHome);
            } else {
                Trace.out("Cluster Alias is not supported");
            }
        }
        catch (ClusterAliasException cae) {
            Trace.out((Exception)((Object)cae));
            throw new UpgradeException(cae.getMessage());
        }
        catch (VirtualIPException vae) {
            Trace.out(vae);
            throw new UpgradeException(vae.getMessage());
        }
        Object haDatabase = null;
        if (Version.get101Version().equals(this.m_fromVersion) || Version.get102Version().equals(this.m_fromVersion)) {
            Trace.out("Getting 10s configuration");
            this.m_haDatabase = new HADatabase(this.m_dbName, this.m_dbDomain);
            this.m_haDatabase.setOldOracleHome(pConfig.getOracleHome());
            this.m_haDatabase.setNewOracleHome(this.m_newOracleHome);
            this.m_haDatabase.setVIPAddress(dbCluaVIPAddr);
            this.m_haDatabase.setSPFile(pConfig.getSPFile());
            this.m_haDatabase.setInstances(pConfig.enumerateInstances());
            this.m_haDatabase.setNodes(pConfig.enumerateNodes());
            try {
                this.m_haDatabase.setHAServices(DowngradeDBConfig.retrieveDatabaseServices(pServer, pConfig));
            }
            catch (ConfigurationException ce) {
                throw new UpgradeException(ce.getMessage());
            }
            catch (ServiceException se) {
                throw new UpgradeException(se.getMessage());
            }
            try {
                DowngradeDBConfig.deleteHAServices(pServer, pConfig);
            }
            catch (DowngradeException ex) {
                throw new UpgradeException(ex.getMessage());
            }
        }
        try {
            Trace.out("Removing pre-10.2configuration of database:" + this.m_gdbName);
            pServer.remove();
            this.m_bEnableCancel = true;
        }
        catch (DatabaseException e) {
            Trace.out("Failed to delete the database: " + this.m_gdbName);
            throw new UpgradeException(e.getMessage());
        }
        if (!Cluster.isParallelServerConfigured(this.m_dbName, this.m_dbDomain)) {
            Trace.out("Done deleting of " + this.m_gdbName + " from OCR.");
        } else {
            Trace.out("Database configuration deletion failed");
        }
        Trace.out("SP File name = " + this.m_spfileName);
        Trace.out("DBCLUA VIP Address = " + dbCluaVIPAddr);
        Version toVer = new Version();
        ParallelServerHA pServerHA = null;
        try {
            pServerHA = dbCluaVIPAddr != null ? (ParallelServerHA)Cluster.createParallelServer(this.m_dbName, this.m_dbDomain, this.m_newOracleHome, this.m_spfileName, dbCluaVIPAddr, toVer) : (ParallelServerHA)Cluster.createParallelServer(this.m_dbName, this.m_dbDomain, this.m_newOracleHome, this.m_spfileName);
        }
        catch (ConfigurationException e) {
            Trace.out("Failed to create the 10g config for database: " + this.m_gdbName);
            throw new UpgradeException(e.getMessage());
        }
        try {
            for (int i = 0; i < this.m_instances.length; ++i) {
                Trace.out("Adding instance: " + this.m_instances[i] + " running on node: " + this.m_nodes[i] + " to OCR");
                pServerHA.createInstance(this.m_instances[i], this.m_nodes[i]);
            }
        }
        catch (InstanceException e) {
            Trace.out("Failed to add instances to the database:" + this.m_gdbName);
            throw new UpgradeException(e.getMessage());
        }
        if (Version.get101Version().equals(this.m_fromVersion) || Version.get102Version().equals(this.m_fromVersion)) {
            Trace.out("Recreating services");
            if (DowngradeDBConfig.createHAServices(pServerHA, this.m_haDatabase)) {
                Trace.out("Done creating HA services for the database");
            } else {
                Trace.out("Failed to create HA services for the database");
            }
        }
        if (Cluster.isParallelServerConfigured(this.m_dbName, this.m_dbDomain, toVer)) {
            Trace.out("Done creation of " + this.m_gdbName + " in OCR.");
        } else {
            Trace.out("Database configuration creation failed");
        }
    }

    private String getDBClusterAlias(String gdbName) throws VirtualIPException {
        String ipAddress;
        String dbClua;
        block4: {
            dbClua = null;
            ipAddress = null;
            String dbName = null;
            String errMsg = null;
            try {
                InetAddress inetAddr = InetAddress.getByName(gdbName);
                ipAddress = inetAddr.getHostAddress();
                dbClua = inetAddr.getHostName();
            }
            catch (UnknownHostException e) {
                errMsg = e.getMessage();
                Trace.out("Failed to retrieve ip for gdbName=" + gdbName + "\n " + errMsg);
                int index = gdbName.indexOf(".");
                if (index == -1) break block4;
                dbName = gdbName.substring(0, index);
                try {
                    InetAddress inetAddr = InetAddress.getByName(dbName);
                    ipAddress = inetAddr.getHostAddress();
                    dbClua = inetAddr.getHostName();
                }
                catch (UnknownHostException ee) {
                    errMsg = e.getMessage();
                    Trace.out("Failed to retrieve ip for dbName=" + dbName + "\n " + errMsg);
                }
            }
        }
        Trace.out("gdbName=" + gdbName + " dbClua=" + dbClua + " ipAddress=" + ipAddress);
        return dbClua;
    }

    private VIPAddress createVIPAddress(String gdbName, String nodeAddress) throws VirtualIPException {
        Trace.out("Create VIPAddress object");
        VIPAddress vipAddress = new VIPAddress(gdbName, nodeAddress, "255.255.255.0", null);
        if (vipAddress != null) {
            Trace.out("getVIPAddress: node=" + gdbName + " vipAddress=" + vipAddress);
        }
        return vipAddress;
    }

    public VIP createVIP(String gdbName, String ohome, String ipaddress) throws VirtualIPException {
        try {
            VIPAddress vipAddress = this.createVIPAddress(gdbName, ipaddress);
            if (vipAddress == null) {
                return null;
            }
            VIP vip = new VIP(gdbName, ohome);
            vip.create(vipAddress);
            return vip;
        }
        catch (VirtualIPException e) {
            Trace.out(e);
            throw new VirtualIPException(e.getMessage());
        }
    }

    public VIPAddress getDBCluaVIPAddr(String gdbName, String oHome) throws VirtualIPException {
        try {
            VIP vip = new VIP(gdbName, oHome);
            if (vip.exists()) {
                return vip.getVIPAddress();
            }
            String ipAddress = this.getDBClusterAlias(gdbName);
            if (ipAddress == null || ipAddress.length() == 0) {
                throw new VirtualIPException("No Cluster Alias defined for database");
            }
            vip = this.createVIP(gdbName, oHome, ipAddress);
            return vip.getVIPAddress();
        }
        catch (VirtualIPException e) {
            Trace.out(e);
            throw new VirtualIPException(e.getMessage());
        }
    }

    private void doCancel() {
        VIPAddress dbCluaVIPAddr;
        ParallelServer pServer;
        Version configVersion;
        block17: {
            Trace.out("Cancelling upgrade operation");
            configVersion = new Version();
            Trace.out("Deleting " + configVersion + " version of database repository from OCR");
            pServer = null;
            ParallelServerConfig pConfig = null;
            dbCluaVIPAddr = null;
            try {
                pServer = Cluster.getParallelServer(this.m_dbName, this.m_dbDomain, configVersion);
                pConfig = pServer.getConfiguration();
                if (!Version.get101Version().equals(this.m_fromVersion)) break block17;
                try {
                    DowngradeDBConfig.deleteHAServices(pServer, pConfig);
                }
                catch (DowngradeException ex) {
                    Trace.out(ex);
                }
                try {
                    ClusterAlias clusterAlias = new ClusterAlias();
                    if (clusterAlias.isSupported()) {
                        Trace.out("Cluster Alias in  supported");
                        dbCluaVIPAddr = this.getDBCluaVIPAddr(this.m_gdbName, this.m_newOracleHome);
                        break block17;
                    }
                    Trace.out("Cluster Alias is not supported");
                }
                catch (ClusterAliasException cae) {
                    Trace.out((Exception)((Object)cae));
                }
                catch (VirtualIPException vae) {
                    Trace.out(vae);
                }
            }
            catch (ConfigurationException ce) {
                Trace.out("Failed to get parallelserver object for OCR");
                Trace.out(ce);
                return;
            }
        }
        if (pServer != null) {
            Trace.out("Deleting the database configuration");
            try {
                pServer.delete();
            }
            catch (ConfigurationException ce) {
                Trace.out("Failed to delete the database configuration");
                Trace.out(ce);
                return;
            }
        }
        Trace.out("SP File name = " + this.m_spfileName);
        configVersion = Version.get101Version().equals(this.m_fromVersion) ? Version.get101Version() : Version.get92Version();
        Trace.out("Creating database configuration of version:" + configVersion);
        try {
            pServer = Cluster.createParallelServer(this.m_dbName, this.m_dbDomain, this.m_oldOracleHome, this.m_spfileName, dbCluaVIPAddr, configVersion);
        }
        catch (ConfigurationException e) {
            Trace.out("Failed to create HA database: " + this.m_gdbName);
            Trace.out(e);
            return;
        }
        Trace.out("Adding instances to the database : " + this.m_gdbName);
        try {
            for (int i = 0; i < this.m_instances.length; ++i) {
                Trace.out("Adding instance: " + this.m_instances[i] + " running on node: " + this.m_nodes[i] + " to OCR");
                pServer.createInstance(this.m_instances[i], this.m_nodes[i]);
            }
        }
        catch (InstanceException e) {
            Trace.out("Failed to add instances to the database:" + this.m_gdbName);
            Trace.out(e);
            return;
        }
        if (Version.get101Version().equals(this.m_fromVersion)) {
            DowngradeDBConfig.createHAServices(pServer, this.m_haDatabase);
        }
    }

    public void upgradeMain() {
        block2: {
            Trace.out("Inside upgradeMain");
            try {
                this.upgradeDatabaseConfig();
                Trace.out("database '" + this.m_dbName + "' is upgraded successfully");
            }
            catch (UpgradeException de) {
                Trace.out("failed to upgrade the database: " + this.m_dbName);
                Trace.out(de);
                if (!this.m_bEnableCancel) break block2;
                Trace.out("Cancelling the upgrade operation");
                this.doCancel();
            }
        }
    }
}

