/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.database.config;

import oracle.ops.mgmt.database.config.downgrade.DowngradeDBConfig;
import oracle.ops.mgmt.database.config.downgrade.DowngradeException;
import oracle.ops.mgmt.database.config.upgrade.UpgradeDBConfig;
import oracle.ops.mgmt.database.config.upgrade.UpgradeException;
import oracle.ops.mgmt.rawdevice.RawDeviceException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.CmdLineParser;
import oracle.ops.util.MissingArgumentException;
import oracle.ops.util.ParamMissingArgumentException;
import oracle.ops.util.UnexpectedArgumentException;

public class DatabaseConfigConverter {
    public static final String OPT = "-";
    public static final String UPGRADE = "upgrade";
    public static final String DOWNGRADE = "downgrade";
    public static final String DATABASE = "dbname";
    public static final String ORACLEHOME = "orahome";
    public static final String VERSION = "version";
    public static final String[] FLAGS = new String[]{"upgrade", "downgrade"};
    public static final String[] PARAMS = new String[0];
    public static final String[] OPTIONAL = new String[]{"dbname", "orahome", "version"};
    public static final int UP = 0;
    public static final int DOWN = 1;
    private int m_operationType = 1;

    private void processCmdArgs(String[] args) throws RawDeviceException {
        Trace.out("Processing command line arguments passed");
        CmdLineParser cmdParser = new CmdLineParser(OPT, FLAGS, PARAMS, OPTIONAL);
        try {
            cmdParser.parse(args);
        }
        catch (MissingArgumentException mae) {
            throw new RawDeviceException(mae.getMessage());
        }
        catch (ParamMissingArgumentException pmae) {
            throw new RawDeviceException(pmae.getMessage());
        }
        catch (UnexpectedArgumentException uae) {
            throw new RawDeviceException(uae.getMessage());
        }
        if (cmdParser.getFlag(UPGRADE) && cmdParser.getFlag(DOWNGRADE)) {
            throw new RawDeviceException();
        }
        if (cmdParser.getFlag(UPGRADE)) {
            this.m_operationType = 0;
        } else if (cmdParser.getFlag(DOWNGRADE)) {
            this.m_operationType = 1;
        }
    }

    public void databaseConfigMain(String[] args) throws RawDeviceException {
        Trace.out("Inside downgradeMain");
        Trace.out("Parsing command line args for upgrade/downgrade");
        this.processCmdArgs(args);
        Trace.out("Command line args parsed successfully");
        if (this.m_operationType == 0) {
            UpgradeDBConfig upgradeConfig = new UpgradeDBConfig();
            try {
                upgradeConfig.processCmdArgs(args);
            }
            catch (UpgradeException ue) {
                throw new RawDeviceException(ue.getMessage());
            }
            upgradeConfig.upgradeMain();
        } else {
            Trace.out("Downgrading the database");
            DowngradeDBConfig downgradeConfig = new DowngradeDBConfig();
            try {
                downgradeConfig.processCmdArgs(args);
            }
            catch (DowngradeException ue) {
                throw new RawDeviceException(ue.getMessage());
            }
            downgradeConfig.downgradeMain();
        }
    }
}

