/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.database;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.GetActiveNodes;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.LocalCommand;
import oracle.ops.mgmt.database.ActionEvent;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.database.DatabaseException;
import oracle.ops.mgmt.database.HAResourceStateUnknownException;
import oracle.ops.mgmt.database.HAResourceStatus;
import oracle.ops.mgmt.database.Instance;
import oracle.ops.mgmt.database.InstanceException;
import oracle.ops.mgmt.database.OracleServiceException;
import oracle.ops.mgmt.database.ParallelServer;
import oracle.ops.mgmt.database.ParallelServerConfig;
import oracle.ops.mgmt.database.Service;
import oracle.ops.mgmt.database.ServiceComposite;
import oracle.ops.mgmt.database.ServiceException;
import oracle.ops.mgmt.has.AlreadyExistsException;
import oracle.ops.mgmt.has.ClusterAlias;
import oracle.ops.mgmt.has.ClusterAliasException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.nodeapps.config.NodeApps;
import oracle.ops.mgmt.operation.CreateOracleServiceOperation;
import oracle.ops.mgmt.operation.DeleteOracleServiceOperation;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.operation.ha.HAGetPermOperation;
import oracle.ops.mgmt.operation.ha.HALiterals;
import oracle.ops.mgmt.operation.ha.HAOperation;
import oracle.ops.mgmt.operation.ha.HAOperationException;
import oracle.ops.mgmt.operation.ha.HAOperationResult;
import oracle.ops.mgmt.operation.ha.HAPolicyOperation;
import oracle.ops.mgmt.operation.ha.HAProfileOperation;
import oracle.ops.mgmt.operation.ha.HARegisterOperation;
import oracle.ops.mgmt.operation.ha.HARelocateOperation;
import oracle.ops.mgmt.operation.ha.HAStartOperation;
import oracle.ops.mgmt.operation.ha.HAStatusOperation;
import oracle.ops.mgmt.operation.ha.HAStopOperation;
import oracle.ops.mgmt.operation.ha.HAUnregisterOperation;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.trace.Trace;

public class ParallelServerHA
extends ParallelServer
implements Constants,
HALiterals {
    private static final String INSTANCE_CHECK_INTERVAL = "INSTANCE_CHECK_INTERVAL";
    private static final int DEFAULT_INSTANCE_CHECK_INTERVAL = 30;
    private static final int MAX_INSTANCE_CHECK_INTERVAL = 600;

    protected ParallelServerHA(String name, Version v) throws ConfigurationException {
        super(name, null, v);
    }

    protected ParallelServerHA(String name, String domain, Version v) throws ConfigurationException {
        super(name, domain, v);
    }

    @Override
    public boolean isRunning() throws DatabaseException {
        boolean retval;
        try {
            retval = this.isRunningInternal(false);
        }
        catch (HAResourceStateUnknownException hre) {
            retval = false;
        }
        return retval;
    }

    private boolean isRunningInternal(boolean checkTarget) throws DatabaseException, HAResourceStateUnknownException {
        HAStatusOperation statOp;
        String dbName;
        try {
            dbName = this.m_ocrTree.getKeyValue(this.m_ocrTree.getTreeDefinition().getDBKey(this.m_spName));
        }
        catch (OCRException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        if (dbName == null) {
            dbName = this.m_spName;
        }
        String resourceName = this.getDBResourceName(dbName, null);
        try {
            statOp = new HAStatusOperation(resourceName, this.m_version);
        }
        catch (HAOperationException haoe) {
            throw new DatabaseException(haoe.getMessage(), haoe);
        }
        LocalCommand lCommand = new LocalCommand(statOp);
        lCommand.execute();
        HAOperationResult result = (HAOperationResult)lCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Trace.out("stat command failed");
            throw new DatabaseException(result.getError());
        }
        String[] statOutput = result.getOutput();
        Vector stats = HAResourceStatus.parseHAStatusOutput(statOutput);
        if (stats.size() != 1) {
            Object[] args = new Object[]{this.m_spName};
            throw new DatabaseException(s_rawMsgBundle.getMessage("1001", true, args));
        }
        HAResourceStatus stat = (HAResourceStatus)stats.elementAt(0);
        if (stat.isUnknown()) {
            Trace.out("resource state unknown");
            throw new HAResourceStateUnknownException();
        }
        if (checkTarget) {
            return stat.isOnline() || stat.isTargetOnline();
        }
        return stat.isOnline();
    }

    @Override
    public boolean isRunning(String inst) throws DatabaseException {
        boolean retval;
        try {
            retval = this.isRunningInternal(inst, false);
        }
        catch (HAResourceStateUnknownException hre) {
            retval = false;
        }
        return retval;
    }

    private HAResourceStatus getInstanceStatus(String inst, boolean pFlag) throws DatabaseException {
        HAStatusOperation statOp;
        String instanceName;
        String dbName;
        try {
            this.validateName(inst, true);
            dbName = this.m_ocrTree.getKeyValue(this.m_ocrTree.getTreeDefinition().getDBKey(this.m_spName));
            instanceName = this.m_ocrTree.getKeyValue(this.m_ocrTree.getTreeDefinition().getDBInstanceNameKey(this.m_spName, inst));
        }
        catch (ConfigurationException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        catch (OCRException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        if (dbName == null) {
            dbName = this.m_spName;
        }
        if (instanceName == null) {
            instanceName = inst;
        }
        String resourceName = ParallelServerHA.getInstResourceName(dbName, instanceName, null);
        try {
            statOp = new HAStatusOperation(resourceName, this.m_version, pFlag);
        }
        catch (HAOperationException haoe) {
            throw new DatabaseException(haoe.getMessage(), haoe);
        }
        LocalCommand lCommand = new LocalCommand(statOp);
        lCommand.execute();
        HAOperationResult result = (HAOperationResult)lCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Trace.out("Stat operation failed");
            String msg = result.getOutputSingle() + s_newline + result.getError();
            throw new DatabaseException(msg);
        }
        String[] statOutput = result.getOutput();
        HAResourceStatus stat = null;
        if (pFlag) {
            stat = HAResourceStatus.parseHAStatusWithPFlagOutput(statOutput);
        } else {
            Vector stats = HAResourceStatus.parseHAStatusOutput(statOutput);
            if (stats.size() != 1) {
                Trace.out("HAResourceStatus vector size = " + stats.size());
                Object[] args = new Object[]{inst};
                throw new DatabaseException(s_rawMsgBundle.getMessage("1003", true, args));
            }
            stat = (HAResourceStatus)stats.elementAt(0);
        }
        if (stat == null) {
            Object[] args = new Object[]{inst};
            throw new DatabaseException(s_rawMsgBundle.getMessage("1003", true, args));
        }
        return stat;
    }

    private boolean isStopping(HAResourceStatus stat) {
        return stat.isOnline() && !stat.isTargetOnline();
    }

    private boolean isRunning(HAResourceStatus stat) {
        return stat.isOnline();
    }

    private boolean isRunningInternal(String inst, boolean checkTarget) throws DatabaseException, HAResourceStateUnknownException {
        HAStatusOperation statOp;
        String instanceName;
        String dbName;
        try {
            this.validateName(inst, true);
            dbName = this.m_ocrTree.getKeyValue(this.m_ocrTree.getTreeDefinition().getDBKey(this.m_spName));
            instanceName = this.m_ocrTree.getKeyValue(this.m_ocrTree.getTreeDefinition().getDBInstanceNameKey(this.m_spName, inst));
        }
        catch (ConfigurationException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        catch (OCRException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        if (dbName == null) {
            dbName = this.m_spName;
        }
        if (instanceName == null) {
            instanceName = inst;
        }
        String resourceName = ParallelServerHA.getInstResourceName(dbName, instanceName, null);
        try {
            statOp = new HAStatusOperation(resourceName, this.m_version);
        }
        catch (HAOperationException haoe) {
            throw new DatabaseException(haoe.getMessage(), haoe);
        }
        LocalCommand lCommand = new LocalCommand(statOp);
        lCommand.execute();
        HAOperationResult result = (HAOperationResult)lCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Trace.out("Stat operation failed");
            String msg = result.getOutputSingle() + s_newline + result.getError();
            throw new DatabaseException(msg);
        }
        String[] statOutput = result.getOutput();
        Vector stats = HAResourceStatus.parseHAStatusOutput(statOutput);
        if (stats.size() != 1) {
            Trace.out("HAResourceStatus vector size = " + stats.size());
            Object[] args = new Object[]{inst};
            throw new DatabaseException(s_rawMsgBundle.getMessage("1003", true, args));
        }
        HAResourceStatus stat = (HAResourceStatus)stats.elementAt(0);
        if (stat.isUnknown()) {
            Trace.out("resource state unknown");
            throw new HAResourceStateUnknownException();
        }
        Trace.out("isRunning(inst) returning with " + stat.isOnline());
        if (checkTarget) {
            return stat.isOnline() || stat.isTargetOnline();
        }
        return stat.isOnline();
    }

    @Override
    public String[] isRunningInstances(String[] insts, boolean displayDisabled) throws DatabaseException {
        HAStatusOperation statOp;
        String[] runningStatus = new String[insts.length];
        String[] instanceNames = new String[insts.length];
        boolean[] instsEnabled = new boolean[insts.length];
        String[] resourceNames = new String[insts.length];
        try {
            String dbName = this.m_ocrTree.getKeyValue(this.m_ocrTree.getTreeDefinition().getDBKey(this.m_spName));
            if (dbName == null) {
                dbName = this.m_spName;
            }
            for (int i = 0; i < insts.length; ++i) {
                instanceNames[i] = this.m_ocrTree.getKeyValue(this.m_ocrTree.getTreeDefinition().getDBInstanceNameKey(this.m_spName, insts[i]));
                if (instanceNames[i] == null) {
                    instanceNames[i] = insts[i];
                }
                instsEnabled[i] = this.isEnabled(insts[i]);
                resourceNames[i] = ParallelServerHA.getInstResourceName(dbName, instanceNames[i], null);
                runningStatus[i] = displayDisabled || instsEnabled[i] ? "UNKNOWN" : "DISABLED";
            }
        }
        catch (OCRException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        catch (InstanceException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        try {
            statOp = new HAStatusOperation(resourceNames, null, this.m_version);
        }
        catch (HAOperationException haoe) {
            throw new DatabaseException(haoe.getMessage(), haoe);
        }
        LocalCommand lCommand = new LocalCommand(statOp);
        lCommand.execute();
        HAOperationResult result = (HAOperationResult)lCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Trace.out("Stat operation failed. it could be a partial failure. no exception thrown.");
        }
        String[] statOutput = result.getOutput();
        Vector stats = HAResourceStatus.parseHAStatusOutput(statOutput);
        int i = 0;
        int j = 0;
        while (i < stats.size()) {
            HAResourceStatus stat = (HAResourceStatus)stats.elementAt(i);
            for (j = 0; j < insts.length && !stat.getResourceName().equalsIgnoreCase(resourceNames[j]); ++j) {
                Trace.out("running status j=" + j + " is " + runningStatus[j]);
            }
            if (j == insts.length) break;
            runningStatus[j] = stat.isOnline() ? "UP" : "DOWN";
            if (stat.isUnknown()) {
                runningStatus[j] = "UNKNOWN";
            }
            if (!displayDisabled && !instsEnabled[j]) {
                runningStatus[j] = "DISABLED";
            }
            Trace.out("running status j=" + j + " inst=" + resourceNames[j] + " is " + runningStatus[j]);
            ++i;
            ++j;
        }
        return runningStatus;
    }

    @Override
    public void create(String oracleHome) throws ConfigurationException, DatabaseException {
        this.create(oracleHome, null, null, null, null, null);
    }

    @Override
    public void create(String oracleHome, String spfileName) throws DatabaseException, ConfigurationException {
        this.create(oracleHome, spfileName, null, null, null, null);
    }

    @Override
    public void create(String oracleHome, VIPAddress addr) throws DatabaseException {
        this.create(oracleHome, null, addr, null, null, null);
    }

    @Override
    public void create(String oracleHome, String spfileName, VIPAddress addr, String dbName, String role, String startOpt) throws DatabaseException {
        this.create(oracleHome, spfileName, addr, dbName, role, startOpt, "AUTOMATIC");
    }

    private boolean isNonNullFileNameValid(String fileName) {
        String tempFileName;
        boolean validFile = true;
        if (fileName != null && (tempFileName = fileName.trim()).length() == 0) {
            validFile = false;
        }
        return validFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(String oracleHome, String spfileName, VIPAddress addr, String dbName, String role, String startOpt, String policy) throws DatabaseException {
        HARegisterOperation regOp;
        HAProfileOperation profileOp;
        try {
            new Util().checkOracleUser(oracleHome, new SystemFactory().CreateSystem().isUnixSystem());
        }
        catch (UtilException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        if (!this.validatePolicy(policy)) {
            Object[] args = new Object[]{policy, "create"};
            throw new DatabaseException(s_rawMsgBundle.getMessage("1077", true, args));
        }
        boolean validSPFile = this.isNonNullFileNameValid(spfileName);
        if (!validSPFile) {
            Object[] args = new Object[]{spfileName, "create"};
            throw new DatabaseException(s_rawMsgBundle.getMessage("1077", true, args));
        }
        this.checkExistsAll();
        String resourceName = this.getDBResourceName(this.m_spName, null);
        try {
            profileOp = new HAProfileOperation(resourceName, oracleHome, "db", this.m_version);
            profileOp.setManagementPolicy(policy);
        }
        catch (HAOperationException haoe) {
            throw new DatabaseException(haoe.getMessage(), haoe);
        }
        LocalCommand localCommand = new LocalCommand(profileOp);
        localCommand.execute();
        HAOperationResult result = (HAOperationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Trace.out("ps.create(): profile operation failed");
            Object[] args = new Object[]{this.m_spName};
            String msg = s_opsMsgBundle.getMessage("1037", true, args);
            throw new DatabaseException(msg);
        }
        try {
            regOp = new HARegisterOperation(resourceName, this.m_version);
        }
        catch (HAOperationException haoe) {
            throw new DatabaseException(haoe.getMessage(), haoe);
        }
        localCommand = new LocalCommand(regOp);
        localCommand.execute();
        result = (HAOperationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Trace.out("ps.create(): register operation failed");
            Object[] args = new Object[]{this.m_spName};
            String msg = s_opsMsgBundle.getMessage("1037", true, args);
            throw new DatabaseException(msg);
        }
        DatabaseException dException = null;
        if (addr != null) {
            ClusterAlias clua = null;
            try {
                clua = new ClusterAlias();
                if (clua.isSupported()) {
                    Trace.out("creating clua");
                    String cluaName = this.m_spName;
                    if (addr.getVIPName() != null) {
                        cluaName = addr.getVIPName();
                    }
                    clua.create(cluaName, addr.getIPAddress().getHostAddress(), addr.getNetmask());
                } else {
                    Trace.out("clua is not supported");
                }
            }
            catch (ClusterAliasException e) {
                dException = new DatabaseException(e.getMessage(), e);
            }
            catch (AlreadyExistsException e) {
                dException = new DatabaseException(e.getMessage(), e);
            }
            finally {
                if (clua != null) {
                    try {
                        clua.destroy();
                    }
                    catch (ClusterAliasException e) {}
                }
            }
        }
        if (dException == null) {
            try {
                Trace.out("updating ocr with policy information");
                super.create(oracleHome, spfileName, addr, dbName, role, startOpt, policy);
            }
            catch (DatabaseException e) {
                dException = e;
            }
        }
        if (dException != null) {
            HAUnregisterOperation unregOp;
            try {
                unregOp = new HAUnregisterOperation(resourceName, this.m_version);
            }
            catch (HAOperationException e) {
                throw dException;
            }
            localCommand = new LocalCommand(unregOp);
            localCommand.execute();
            result = (HAOperationResult)localCommand.getOperationResult();
            if (result.getStatus() != 0) {
                Trace.out("ps.create(): rollback unregister operation failed, but that's ok");
            }
            throw dException;
        }
    }

    private void checkExistsAll() throws DatabaseException {
        String[] dbNameArray;
        try {
            dbNameArray = this.m_ocrTree.listDatabases();
        }
        catch (OCRException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        if (dbNameArray != null) {
            for (int i = 0; i < dbNameArray.length; ++i) {
                if (!this.m_spName.equalsIgnoreCase(dbNameArray[i])) continue;
                Object[] args = new Object[]{this.m_spName, dbNameArray[i]};
                throw new DatabaseException(s_opsMsgBundle.getMessage("1073", true, args));
            }
        }
    }

    @Override
    public void start(String startupOptions) throws DatabaseException {
        ParallelServerConfig config;
        try {
            Trace.out("getting configuration for the db");
            config = this.getConfiguration();
        }
        catch (ConfigurationException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        if (!config.isEnabled()) {
            Object[] args = new Object[]{this.m_spName};
            throw new DatabaseException(s_opsMsgBundle.getMessage("1019", true, args));
        }
        String[] instanceNames = config.enumerateInstances();
        try {
            this.startInstance(instanceNames, startupOptions, config);
        }
        catch (InstanceException ie) {
            throw new DatabaseException(ie.getMessage(), ie);
        }
    }

    @Override
    public boolean stop(String mode) throws DatabaseException {
        ParallelServerConfig config;
        try {
            config = this.getConfiguration();
        }
        catch (ConfigurationException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        String[] instanceNames = config.enumerateInstances();
        try {
            this.stopInstance(instanceNames, mode, config);
        }
        catch (InstanceException ie) {
            throw new DatabaseException(ie.getMessage(), ie);
        }
        return true;
    }

    @Override
    public void startInstance(String[] instances, String startupOptions) throws InstanceException {
        ParallelServerConfig config;
        try {
            Trace.out("getting configuration for the db");
            config = this.getConfiguration();
        }
        catch (ConfigurationException e) {
            throw new InstanceException(e.getMessage(), e);
        }
        Trace.out("got configuration");
        this.startInstance(instances, startupOptions, config);
    }

    public void startInstance(String[] instances, String startupOptions, ParallelServerConfig config) throws InstanceException {
        int i;
        int i2;
        Vector<LocalCommand> instOperationToStart = new Vector<LocalCommand>(instances.length);
        Vector<String> nodeNames = new Vector<String>(instances.length);
        HAStartOperation startOp = null;
        String node = null;
        Vector<String> transitionalInstances = new Vector<String>(instances.length);
        Vector<LocalCommand> transitionalInstancesOperation = new Vector<LocalCommand>(instances.length);
        int transitionTimeOut = 0;
        int sleepTime = Integer.getInteger(INSTANCE_CHECK_INTERVAL, 30);
        Vector<String> toNotify = new Vector<String>(instances.length);
        String openMode = null;
        String pFileName = null;
        if (startupOptions != null) {
            StringTokenizer tokens = new StringTokenizer(startupOptions);
            StringBuffer buffer = new StringBuffer();
            while (tokens.hasMoreTokens()) {
                String thisToken = tokens.nextToken();
                if (thisToken.toUpperCase().startsWith("PFILE=")) {
                    pFileName = thisToken.substring(6);
                    continue;
                }
                buffer.append(thisToken + " ");
            }
            if (buffer.length() > 0) {
                openMode = buffer.toString().trim();
            }
        }
        Trace.out("open mode = " + openMode + ", pfile = " + pFileName);
        boolean forceStart = this.isForceWithYou(startupOptions);
        for (int i3 = 0; i3 < instances.length; ++i3) {
            boolean isInTransition = false;
            try {
                if (this.instanceExists(config, instances[i3])) {
                    node = config.getNode(instances[i3]);
                }
            }
            catch (ConfigurationException ce) {
                this.notifyEventAll(toNotify, 2007, 4);
                throw new InstanceException(ce.getMessage(), ce);
            }
            if (!this.isEnabled(instances[i3])) {
                Trace.out("skipping disabled instance " + instances[i3]);
                Object[] args = new Object[]{instances[i3]};
                String msg = s_opsMsgBundle.getMessage("1020", true, args);
                Trace.out(msg);
                continue;
            }
            try {
                HAResourceStatus stat = this.getInstanceStatus(instances[i3], false);
                if (this.isRunning(stat)) {
                    if (!this.isStopping(stat)) {
                        Trace.out("skipping already running instance " + instances[i3]);
                        continue;
                    }
                    Trace.out("instance " + instances[i3] + "is stopping");
                    isInTransition = true;
                    HAResourceStatus timeOutStat = this.getInstanceStatus(instances[i3], true);
                    if (transitionTimeOut < timeOutStat.getStopTimeOut() * 1000) {
                        transitionTimeOut = timeOutStat.getStopTimeOut() * 1000;
                    }
                }
            }
            catch (DatabaseException de) {
                throw new InstanceException(de.getMessage(), de);
            }
            toNotify.addElement(node);
            this.notifyEvent(new ActionEvent(this, 2003, node, i3));
            String resName = this.getInstResourceNameUsingDBName(this.m_spName, instances[i3], config);
            try {
                startOp = new HAStartOperation(resName, openMode, pFileName, this.m_credentials, this.m_version);
            }
            catch (HAOperationException haoe) {
                this.notifyEventAll(toNotify, 2007, 4);
                throw new InstanceException(haoe.getMessage(), haoe);
            }
            startOp.setNode(node);
            if (isInTransition) {
                transitionalInstances.add(instances[i3]);
                transitionalInstancesOperation.add(new LocalCommand(startOp));
                continue;
            }
            instOperationToStart.addElement(new LocalCommand(startOp));
            nodeNames.addElement(node);
        }
        if (instOperationToStart.size() == 0 && transitionalInstances.size() == 0) {
            Trace.out("there is nothing to start");
            return;
        }
        Vector<LocalCommand> serialInsts = new Vector<LocalCommand>();
        for (i2 = 0; i2 < nodeNames.size() - 1; ++i2) {
            for (int j = i2 + 1; j < nodeNames.size(); ++j) {
                String nodeI = (String)nodeNames.elementAt(i2);
                String nodeJ = (String)nodeNames.elementAt(j);
                if (nodeI == null || !nodeI.equalsIgnoreCase(nodeJ)) continue;
                Trace.out("find multiple instances on same node");
                serialInsts.addElement((LocalCommand)instOperationToStart.elementAt(j));
            }
        }
        for (i2 = 0; i2 < serialInsts.size(); ++i2) {
            if (!instOperationToStart.contains(serialInsts.elementAt(i2))) continue;
            instOperationToStart.remove(serialInsts.elementAt(i2));
        }
        Trace.out("parallel execution");
        ClusterCmd clusterCmd = new ClusterCmd();
        try {
            Trace.out("submitting startinstance command");
            clusterCmd.submit(instOperationToStart);
        }
        catch (ClusterException ce) {
            Trace.out("Could not submit" + ce.getMessage());
            this.notifyEventAll(toNotify, 2007, 4);
            throw new InstanceException(ce.getMessage(), ce);
        }
        Trace.out("serialized execution");
        for (i = 0; i < serialInsts.size(); ++i) {
            LocalCommand instCmd = (LocalCommand)serialInsts.elementAt(i);
            instCmd.execute();
        }
        if (transitionTimeOut == 0) {
            transitionTimeOut = 600000;
        }
        if (transitionalInstances.size() > 0) {
            for (i = 0; i < transitionalInstances.size(); ++i) {
                String instanceToCheck = (String)transitionalInstances.elementAt(i);
                boolean remove = true;
                do {
                    HAResourceStatus stat = null;
                    try {
                        stat = this.getInstanceStatus(instanceToCheck, false);
                    }
                    catch (DatabaseException dbEx) {
                        Trace.out(dbEx.toString());
                        break;
                    }
                    if (stat == null) break;
                    if (!this.isStopping(stat)) {
                        if (this.isRunning(stat)) break;
                        remove = false;
                        break;
                    }
                    if (transitionTimeOut <= 0) continue;
                    try {
                        Thread.sleep(sleepTime * 1000);
                    }
                    catch (InterruptedException ex) {
                        Trace.out("sleep interrupted " + ex.toString());
                    }
                } while ((transitionTimeOut -= sleepTime * 1000) > 0);
                if (!remove) continue;
                transitionalInstancesOperation.remove(i);
                transitionalInstances.remove(i);
            }
        }
        for (i = 0; i < transitionalInstancesOperation.size(); ++i) {
            LocalCommand instCmd = (LocalCommand)transitionalInstancesOperation.elementAt(i);
            instCmd.execute();
        }
        StringBuffer exceptionMesg = new StringBuffer();
        for (int i4 = 0; i4 < instOperationToStart.size() + serialInsts.size() + transitionalInstancesOperation.size(); ++i4) {
            LocalCommand lCommand = i4 < instOperationToStart.size() ? (LocalCommand)instOperationToStart.elementAt(i4) : (i4 < instOperationToStart.size() + serialInsts.size() ? (LocalCommand)serialInsts.elementAt(i4 - instOperationToStart.size()) : (LocalCommand)transitionalInstancesOperation.elementAt(i4 - instOperationToStart.size() - serialInsts.size()));
            HAOperationResult result = (HAOperationResult)lCommand.getOperationResult();
            startOp = (HAStartOperation)lCommand.getOperation();
            node = startOp.getNode();
            String resourceName = startOp.getResourceName();
            StringTokenizer st = new StringTokenizer(resourceName, ".");
            st.nextToken();
            st.nextToken();
            String instanceName = st.nextToken();
            toNotify.removeElement(node);
            if (result.getStatus() != 0) {
                Trace.out("Failed to start " + instanceName + " on " + node + " error=" + result.getOutputAll());
                this.notifyEvent(new ActionEvent(this, 2005, node, i4, 2007, 4));
                Object[] args = new Object[]{instanceName, node};
                String msg = s_opsMsgBundle.getMessage("1001", true, args);
                exceptionMesg.append(msg + s_newline + result.getOutputAll() + s_newline);
                continue;
            }
            this.notifyEvent(new ActionEvent(this, 2005, node, i4, 2006, 1));
        }
        if (exceptionMesg.length() > 0) {
            throw new InstanceException(exceptionMesg.toString().trim());
        }
    }

    @Override
    public void stopInstance(String[] instances, String stopOptions) throws InstanceException {
        ParallelServerConfig config;
        try {
            Trace.out("getting configuration for the db");
            config = this.getConfiguration();
        }
        catch (ConfigurationException e) {
            throw new InstanceException(e.getMessage(), e);
        }
        this.stopInstance(instances, stopOptions, config);
    }

    public void stopInstance(String[] instances, String stopOptions, ParallelServerConfig config) throws InstanceException {
        Vector<LocalCommand> instOperationToStop = new Vector<LocalCommand>(instances.length);
        HAStopOperation stopOp = null;
        String node = null;
        Vector<String> toNotify = new Vector<String>(instances.length);
        String criticalInstName = null;
        String role = config.getRole();
        if (role != null && (role.equalsIgnoreCase("PHYSICAL_STANDBY") || role.equalsIgnoreCase("LOGICAL_STANDBY"))) {
            String criticalStandbyGroupName = "DM" + this.m_spName.toUpperCase();
            Trace.out("criticalStandbyGroup=" + criticalStandbyGroupName);
            try {
                GetActiveNodes activeNodes = GetActiveNodes.create();
                for (int i = 0; i < instances.length; ++i) {
                    if (!activeNodes.checkInstance(criticalStandbyGroupName, instances[i])) continue;
                    criticalInstName = instances[i];
                    break;
                }
            }
            catch (ClusterException ce) {
                throw new InstanceException(ce.getMessage(), ce);
            }
        }
        Trace.out("critical instance name = " + criticalInstName);
        for (int i = 0; i < instances.length; ++i) {
            if (role != null && (role.equalsIgnoreCase("PHYSICAL_STANDBY") || role.equalsIgnoreCase("LOGICAL_STANDBY")) && criticalInstName != null && criticalInstName.equals(instances[i])) continue;
            try {
                if (this.instanceExists(config, instances[i])) {
                    node = config.getNode(instances[i]);
                    Trace.out("node=" + node + ", instance=" + instances[i]);
                }
            }
            catch (ConfigurationException ce) {
                this.notifyEventAll(toNotify, 2007, 4);
                throw new InstanceException(ce.getMessage(), ce);
            }
            try {
                if (!this.isRunningInternal(instances[i], true)) {
                    Trace.out("skipping already stopped instance " + instances[i]);
                    continue;
                }
            }
            catch (HAResourceStateUnknownException hre) {
                Trace.out("resource state unknown, will try to stop it");
            }
            catch (DatabaseException de) {
                throw new InstanceException(de.getMessage(), de);
            }
            toNotify.addElement(node);
            this.notifyEvent(new ActionEvent(this, 2004, node, i));
            String resName = this.getInstResourceNameUsingDBName(this.m_spName, instances[i], config);
            try {
                stopOp = new HAStopOperation(resName, stopOptions, this.m_credentials, this.m_version);
            }
            catch (HAOperationException haoe) {
                this.notifyEventAll(toNotify, 2007, 4);
                throw new InstanceException(haoe.getMessage(), haoe);
            }
            stopOp.setNode(node);
            Trace.out("adding resource " + resName + " to stop list");
            instOperationToStop.addElement(new LocalCommand(stopOp));
        }
        if (instOperationToStop.size() > 0) {
            ClusterCmd clusterCmd = new ClusterCmd();
            try {
                clusterCmd.submit(instOperationToStop);
            }
            catch (ClusterException ce) {
                Trace.out("Could not submit" + ce.getMessage());
                this.notifyEventAll(toNotify, 2007, 4);
                throw new InstanceException(ce.getMessage(), ce);
            }
        } else {
            Trace.out("there is nothing to stop");
        }
        StringBuffer exceptionMesg = new StringBuffer();
        for (int i = 0; i < instOperationToStop.size(); ++i) {
            LocalCommand lCommand = (LocalCommand)instOperationToStop.elementAt(i);
            HAOperationResult result = (HAOperationResult)lCommand.getOperationResult();
            stopOp = (HAStopOperation)lCommand.getOperation();
            node = stopOp.getNode();
            String resourceName = stopOp.getResourceName();
            StringTokenizer st = new StringTokenizer(resourceName, ".");
            st.nextToken();
            st.nextToken();
            String instanceName = st.nextToken();
            toNotify.removeElement(node);
            if (result.getStatus() != 0) {
                Trace.out("Failed to stop " + instanceName + " on " + node + " error=" + result.getOutputAll());
                this.notifyEvent(new ActionEvent(this, 2005, node, i, 2007, 4));
                Object[] args = new Object[]{instanceName, node};
                String msg = s_opsMsgBundle.getMessage("1002", true, args);
                exceptionMesg.append(msg + s_newline + result.getOutputAll() + s_newline);
                continue;
            }
            this.notifyEvent(new ActionEvent(this, 2005, node, i, 2006, 3));
        }
        if (criticalInstName != null) {
            Object[] args = new Object[]{criticalInstName, this.m_spName};
            String mesg = s_opsMsgBundle.getMessage("1068", true, args);
            exceptionMesg.append(mesg);
        }
        if (exceptionMesg.length() > 0) {
            throw new InstanceException(exceptionMesg.toString().trim());
        }
    }

    @Override
    public void createInstance(String instName, String nodeName) throws InstanceException {
        HARegisterOperation regOp;
        HAProfileOperation profileOp;
        try {
            this.validateName(instName, true);
        }
        catch (ConfigurationException ce) {
            throw new InstanceException(ce.getMessage(), ce);
        }
        try {
            Cluster.getHostName(nodeName);
        }
        catch (ClusterException e) {
            Object[] args = new String[]{instName, nodeName, this.m_spName};
            String msg = s_rawMsgBundle.getMessage("1008", true, args) + s_newline + e.getMessage();
            throw new InstanceException(msg);
        }
        String oracleHome = null;
        try {
            oracleHome = this.m_ocrTree.getKeyValue(this.m_ocrTree.getTreeDefinition().getDBOHomeKey(this.m_spName));
            new Util().checkOracleUser(oracleHome, new SystemFactory().CreateSystem().isUnixSystem());
        }
        catch (OCRException e) {
            throw new InstanceException(e.getMessage(), e);
        }
        catch (UtilException e) {
            throw new InstanceException(e.getMessage(), e);
        }
        String resourceName = this.getInstResourceNameUsingDBName(this.m_spName, instName, null);
        String policy = "AUTOMATIC";
        try {
            policy = this.m_ocrTree.getKeyValue(this.m_ocrTree.getTreeDefinition().getDBPolicyKey(this.m_spName));
        }
        catch (OCRException e) {
            throw new InstanceException(e.getMessage(), e);
        }
        if (policy == null) {
            policy = "AUTOMATIC";
        }
        try {
            profileOp = new HAProfileOperation(resourceName, oracleHome, "inst", nodeName, this.m_version);
            if (policy.equalsIgnoreCase("MANUAL")) {
                profileOp.setManagementPolicy(policy);
            }
        }
        catch (HAOperationException haoe) {
            throw new InstanceException(haoe.getMessage(), haoe);
        }
        LocalCommand localCommand = new LocalCommand(profileOp);
        localCommand.execute();
        HAOperationResult result = (HAOperationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Trace.out("ps.createInstance(): profile operation failed");
            Object[] args = new Object[]{instName, nodeName, this.m_spName};
            String msg = s_rawMsgBundle.getMessage("1008", true, args) + s_newline + result.getOutputAll();
            throw new InstanceException(msg);
        }
        try {
            regOp = new HARegisterOperation(resourceName, this.m_version);
        }
        catch (HAOperationException haoe) {
            throw new InstanceException(haoe.getMessage(), haoe);
        }
        localCommand = new LocalCommand(regOp);
        localCommand.execute();
        result = (HAOperationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Trace.out("ps.createInstance(): register operation failed");
            Object[] args = new Object[]{instName, nodeName, this.m_spName};
            String msg = s_rawMsgBundle.getMessage("1008", true, args) + s_newline + result.getOutputAll();
            throw new InstanceException(msg);
        }
        try {
            super.createInstance(instName, nodeName);
        }
        catch (InstanceException e) {
            try {
                HAUnregisterOperation unregisterOp = new HAUnregisterOperation(resourceName, this.m_version);
                localCommand = new LocalCommand(unregisterOp);
                localCommand.execute();
                result = (HAOperationResult)localCommand.getOperationResult();
                if (result.getStatus() != 0) {
                    throw new InstanceException(e.getMessage() + s_newline + result.getOutputAll());
                }
                throw e;
            }
            catch (HAOperationException haoe) {
                throw new InstanceException(e.getMessage() + s_newline + haoe.getMessage(), haoe);
            }
        }
    }

    @Override
    public void removeInstance(String instName) throws ConfigurationException, InstanceException {
        this.removeInstance(instName, false);
    }

    @Override
    public void removeInstance(String instName, boolean force) throws ConfigurationException, InstanceException {
        LocalCommand localCommand;
        HAOperationResult result;
        String nodeName;
        StringBuffer stagedExceptionMesgs;
        block64: {
            this.validateName(instName, true);
            stagedExceptionMesgs = new StringBuffer();
            Object inst = null;
            nodeName = null;
            try {
                if (!force || this.m_ocrTree.keyExists(this.m_ocrTree.getTreeDefinition().getDBInstanceNameKey(this.m_spName, instName))) break block64;
                String resName = this.getInstResourceNameUsingDBName(this.m_spName, instName, null);
                try {
                    String oracleHome = new NodeApps(null, this.m_version).getOracleHome(resName);
                    this.removeResources(new String[]{resName}, oracleHome);
                }
                catch (NodeException ne) {
                    throw new InstanceException(ne.getMessage(), ne);
                }
                catch (DatabaseException de) {
                    throw new InstanceException(de.getMessage(), de);
                }
                return;
            }
            catch (OCRException oe) {
                throw new InstanceException(oe.getMessage(), oe);
            }
        }
        ParallelServerConfig config = null;
        try {
            config = this.getConfiguration();
        }
        catch (ConfigurationException e) {
            Trace.out(e);
            throw new InstanceException(e.getMessage(), e);
        }
        nodeName = config.getNode(instName);
        Trace.out("nodeName = " + nodeName);
        boolean runningInternal = false;
        try {
            runningInternal = this.isRunningInternal(instName, true);
        }
        catch (HAResourceStateUnknownException e) {
            if (force) {
                runningInternal = false;
            } else {
                Trace.out("resource state unknown. not removed");
                runningInternal = true;
            }
        }
        catch (DatabaseException e) {
            Trace.out("isRunning(" + instName + ") throws InstanceException");
            if (force) {
                stagedExceptionMesgs.append(e.getMessage());
            }
            throw new InstanceException(e.getMessage(), e);
        }
        Trace.out("isRunning(" + instName + ") returned " + runningInternal);
        if (runningInternal) {
            boolean running = false;
            try {
                running = this.isRunning(instName);
            }
            catch (DatabaseException e) {
                Trace.out("isRunning(" + instName + ") throws InstanceException");
                stagedExceptionMesgs.append(e.getMessage());
            }
            if (running) {
                throw new InstanceException(s_opsMsgBundle.getMessage("1023", true, new String[]{instName}));
            }
            String node = config.getNode(instName);
            String resName = this.getInstResourceNameUsingDBName(this.m_spName, instName, config);
            HAStopOperation stopOp = null;
            try {
                stopOp = new HAStopOperation(resName, null, this.m_credentials, this.m_version);
            }
            catch (HAOperationException haoe) {
                throw new InstanceException(haoe.getMessage(), haoe);
            }
            stopOp.setNode(node);
            LocalCommand lCommand = new LocalCommand(stopOp);
            lCommand.execute();
            result = (HAOperationResult)lCommand.getOperationResult();
            if (result.getStatus() != 0) {
                Trace.out("Failed to stop " + instName + " on " + node + " error=" + result.getOutputAll());
                Object[] args = new Object[]{instName, node};
                String msg = s_opsMsgBundle.getMessage("1002", true, args);
                throw new InstanceException(msg.toString().trim());
            }
        }
        try {
            new Util().checkOracleUser(config.getOracleHome());
        }
        catch (UtilException e) {
            throw new InstanceException(e.getMessage(), e);
        }
        Vector services = config.getServices();
        Trace.out("ParallelServerHA.removeInstance: removing services");
        Service serv = null;
        for (int i = 0; i < services.size(); ++i) {
            ServiceComposite sc = (ServiceComposite)services.elementAt(i);
            try {
                serv = new Service(sc.getName(), this, config);
                if (sc.isPreferred(instName)) {
                    Trace.out("remove preferred instance from service " + sc.getName());
                    serv.removeMember(instName, force);
                    continue;
                }
                if (sc.isAvailable(instName)) {
                    if (sc.getAvailableInstances() != null && sc.getAvailableInstances().length > 1) {
                        Trace.out("remove available instance from service " + sc.getName());
                        serv.removeAvailable(instName);
                        continue;
                    }
                    Trace.out("remove last available instance from service " + sc.getName());
                    serv.modify(sc.getPreferredInstances(), null, sc.getTAFPolicy());
                    continue;
                }
                Trace.out("nothing to remove for service " + sc.getName());
                continue;
            }
            catch (ServiceException se) {
                if (force) {
                    stagedExceptionMesgs.append(s_newline + se.getMessage());
                    continue;
                }
                throw new InstanceException(se.getMessage(), se);
            }
        }
        String resName = this.getInstResourceNameUsingDBName(this.m_spName, instName, config);
        try {
            HAUnregisterOperation unregisterOp = new HAUnregisterOperation(resName, this.m_version);
            localCommand = new LocalCommand(unregisterOp);
        }
        catch (HAOperationException haoe) {
            throw new InstanceException(haoe.getMessage(), haoe);
        }
        localCommand.execute();
        result = (HAOperationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            if (force) {
                stagedExceptionMesgs.append(s_newline + result.getOutputAll());
            } else {
                throw new InstanceException(result.getOutputAll());
            }
        }
        try {
            this.m_ocrTree.removeInstance(this.m_spName, instName);
        }
        catch (OCRException oe) {
            Object[] args = new Object[]{instName, this.m_spName, oe.getMessage()};
            String msg = s_rawMsgBundle.getMessage("1009", true, args);
            if (force) {
                stagedExceptionMesgs.append(s_newline + msg);
            }
            throw new ConfigurationException(msg);
        }
        Instance thisInstance = config.getInstance(instName);
        Vector instances = config.getInstances();
        if (thisInstance != null) {
            instances.remove(thisInstance);
            config.setInstances(instances);
            Trace.out("Removed the instance <" + instName + "> from the config object.");
        }
        if (instances.size() > 0) {
            String[] statOutput;
            Vector stats;
            HAStatusOperation statOp = null;
            String[] resNames = new String[]{this.getDBResourceName(this.m_spName, config)};
            try {
                statOp = new HAStatusOperation(resNames, nodeName, this.m_version);
            }
            catch (HAOperationException haoe) {
                if (force) {
                    stagedExceptionMesgs.append(s_newline + haoe.getMessage());
                }
                Trace.out(s_newline + haoe.getMessage());
            }
            LocalCommand lCommand = new LocalCommand(statOp);
            lCommand.execute();
            HAOperationResult resultHA = (HAOperationResult)lCommand.getOperationResult();
            if (resultHA.getStatus() != 0) {
                Object[] args = new Object[]{resNames[0], nodeName};
                String msg = s_rawMsgBundle.getMessage("1056", true, args) + s_newline + resultHA.getOutputAll();
                if (force) {
                    stagedExceptionMesgs.append(s_newline + msg);
                } else {
                    Trace.out(s_newline + msg);
                }
            }
            if ((stats = HAResourceStatus.parseHAStatusOutput(statOutput = resultHA.getOutput())).size() > 0) {
                HAResourceStatus stat = (HAResourceStatus)stats.elementAt(0);
                if (stat.getHost().equalsIgnoreCase(nodeName)) {
                    int index = -1;
                    boolean running = false;
                    for (int i = 0; i < instances.size(); ++i) {
                        String name = ((Instance)instances.elementAt(i)).getName();
                        if (name.equalsIgnoreCase(instName)) continue;
                        try {
                            running = this.isRunningInternal(name, false);
                        }
                        catch (DatabaseException e) {
                            if (force) {
                                stagedExceptionMesgs.append(s_newline + e.getMessage());
                            }
                            Trace.out(s_newline + e.getMessage());
                        }
                        if (running) {
                            index = i;
                            break;
                        }
                        if (index != -1) continue;
                        index = i;
                    }
                    HARelocateOperation relocateOp = null;
                    if (index != -1) {
                        String targetName = config.getNode(((Instance)instances.elementAt(index)).getName());
                        try {
                            relocateOp = new HARelocateOperation(resNames[0], targetName, this.m_version);
                        }
                        catch (HAOperationException haoe) {
                            if (force) {
                                stagedExceptionMesgs.append(s_newline + haoe.getMessage());
                            }
                            Trace.out(s_newline + haoe.getMessage());
                        }
                        HAOperationResult resultRelocate = null;
                        LocalCommand localCmd = new LocalCommand(relocateOp);
                        localCmd.execute();
                        resultRelocate = (HAOperationResult)localCmd.getOperationResult();
                        if (resultRelocate.getStatus() != 0) {
                            Object[] args = new Object[]{resNames[0], instName, targetName};
                            String msg = s_rawMsgBundle.getMessage("1033", true, args) + s_newline + resultRelocate.getOutputAll();
                            if (force) {
                                stagedExceptionMesgs.append(s_newline + msg);
                            } else {
                                Trace.out(s_newline + msg);
                            }
                        } else {
                            Trace.out("DB composite resource has been successfully migrated to the node: " + targetName);
                        }
                    } else {
                        Trace.out("It seems that the instance which is going  to be removed is the only instance in the cluster. Cannot migrate DB composite resource.");
                    }
                } else {
                    Trace.out("DB composite resource is not in the node  where the to-be-removed instanace resides.  Don't need to migrate it.");
                }
            }
        } else {
            Trace.out("there is no instance running...");
        }
        if (stagedExceptionMesgs.length() > 0) {
            throw new InstanceException(stagedExceptionMesgs.toString());
        }
    }

    @Override
    public void moveInstance(String instName, String newNode) throws ConfigurationException {
        HARegisterOperation regOp;
        HAProfileOperation profileOp;
        String cpInstName;
        String oracleHome = null;
        this.validateName(instName, true);
        try {
            Cluster.getHostName(newNode);
        }
        catch (ClusterException e) {
            Object[] args = new Object[]{instName, newNode, this.m_spName, e.getMessage()};
            String msg = s_rawMsgBundle.getMessage("1010", true, args);
            throw new ConfigurationException(msg);
        }
        try {
            oracleHome = this.m_ocrTree.getKeyValue(this.m_ocrTree.getTreeDefinition().getDBOHomeKey(this.m_spName));
            cpInstName = this.m_ocrTree.getKeyValue(this.m_ocrTree.getTreeDefinition().getDBInstanceNameKey(this.m_spName, instName));
            new Util().checkOracleUser(oracleHome, new SystemFactory().CreateSystem().isUnixSystem());
        }
        catch (OCRException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
        catch (UtilException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
        if (cpInstName == null) {
            Object[] args = new String[]{instName, this.m_spName};
            throw new ConfigurationException(s_opsMsgBundle.getMessage("1082", true, args));
        }
        try {
            this.m_ocrTree.moveInstance(this.m_spName, instName, newNode);
        }
        catch (OCRException oe) {
            Object[] args = new Object[]{instName, newNode, this.m_spName, oe.getMessage()};
            String msg = s_rawMsgBundle.getMessage("1010", true, args);
            throw new ConfigurationException(msg, oe);
        }
        String resName = this.getInstResourceNameUsingDBName(this.m_spName, cpInstName, null);
        try {
            profileOp = new HAProfileOperation(resName, oracleHome, "inst", newNode, this.m_version);
        }
        catch (HAOperationException haoe) {
            throw new ConfigurationException(haoe.getMessage(), haoe);
        }
        profileOp.setProfileOption("-update");
        LocalCommand localCommand = new LocalCommand(profileOp);
        localCommand.execute();
        HAOperationResult haResult = (HAOperationResult)localCommand.getOperationResult();
        if (haResult.getStatus() != 0) {
            Trace.out("profile update operation failed");
            Object[] args = new Object[]{instName, newNode, this.m_spName};
            String msg = haResult.getOutputAll() != null ? s_rawMsgBundle.getMessage("1010", true, args) + s_newline + haResult.getOutputAll() : s_rawMsgBundle.getMessage("1010", true, args);
            throw new ConfigurationException(msg);
        }
        try {
            regOp = new HARegisterOperation(resName, true, this.m_version);
        }
        catch (HAOperationException haoe) {
            throw new ConfigurationException(haoe.getMessage(), haoe);
        }
        localCommand = new LocalCommand(regOp);
        localCommand.execute();
        haResult = (HAOperationResult)localCommand.getOperationResult();
        if (haResult.getStatus() != 0) {
            Trace.out("register update operation failed");
            Object[] args = new Object[]{instName, newNode, this.m_spName};
            String msg = s_rawMsgBundle.getMessage("1010", true, args) + s_newline + haResult.getOutputAll();
            throw new ConfigurationException(msg);
        }
    }

    @Override
    public void modifyDatabase(String dbName, String ohome, String domain, String spfile, String role, String startOpt) throws DatabaseException {
        this.modifyDatabase(dbName, ohome, domain, spfile, role, startOpt, "AUTOMATIC");
    }

    @Override
    public void modifyDatabase(String dbName, String ohome, String domain, String spfile, String role, String startOpt, String policy) throws DatabaseException {
        boolean policyChanged;
        boolean oracleHomeChanged;
        String[] servNames;
        Trace.out("Modifying the database " + this.m_spName);
        if (dbName != null) {
            try {
                this.validateName(dbName, false);
            }
            catch (ConfigurationException ce) {
                throw new DatabaseException(ce.getMessage(), ce);
            }
        }
        if (ohome == null || !this.isNonNullFileNameValid(ohome)) {
            Object[] args = new Object[]{this.m_spName};
            String msg = s_opsMsgBundle.getMessage("1061", true, args) + s_newline + s_opsMsgBundle.getMessage("1077", false, args);
            throw new DatabaseException(msg);
        }
        ParallelServerConfig config = null;
        try {
            config = this.getConfiguration();
        }
        catch (ConfigurationException ce) {
            Object[] args = new Object[]{this.m_spName};
            throw new DatabaseException(s_opsMsgBundle.getMessage("1088", true, args), ce);
        }
        try {
            new Util().checkOracleUser(config.getOracleHome(), this.m_ocrTree.getUserName(this.m_ocrTree.getTreeDefinition().getDBKey(this.m_spName)));
        }
        catch (UtilException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        catch (OCRException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        if (domain != null && !domain.equalsIgnoreCase(config.getDomain()) && (servNames = config.enumerateServices()) != null) {
            String upNewDomain = domain.toUpperCase();
            for (int i = 0; i < servNames.length; ++i) {
                String upServName = servNames[i].toUpperCase();
                if (!upServName.endsWith(upNewDomain)) continue;
                Object[] args = new Object[]{this.m_spName, domain, servNames[i]};
                String msg = s_opsMsgBundle.getMessage("1069", true, args);
                throw new DatabaseException(msg);
            }
        }
        boolean bl = oracleHomeChanged = !config.getOracleHome().equalsIgnoreCase(ohome);
        if (oracleHomeChanged) {
            Trace.out("new oracle home is " + ohome);
        }
        String configPolicy = config.getManagementPolicy();
        boolean bl2 = policyChanged = policy != null && !policy.equalsIgnoreCase(configPolicy);
        if (policyChanged) {
            Trace.out("new policy is " + policy);
        }
        if (oracleHomeChanged || policyChanged) {
            ServiceComposite sc;
            Trace.out("Re-registering all resources for " + this.m_spName + " since its ORACLE_HOME and/or POLICY is being" + " modified");
            int numServResources = 0;
            Vector instances = config.getInstances();
            Vector services = config.getServices();
            for (int i = 0; i < services.size(); ++i) {
                sc = (ServiceComposite)services.elementAt(i);
                numServResources += sc.getSMResourceNames().size() + 1;
            }
            LocalCommand[] localCommands = new LocalCommand[numServResources + instances.size() + 1];
            Trace.out("Number of resources =" + localCommands.length);
            int count = 0;
            HAPolicyOperation policyOp = null;
            String resourceName = this.getDBResourceName(this.m_spName, null);
            try {
                policyOp = new HAPolicyOperation(resourceName, "db", s_version);
                if (oracleHomeChanged) {
                    policyOp.setOracleHome(ohome);
                }
                if (policyChanged) {
                    policyOp.setManagementPolicy(policy);
                }
            }
            catch (HAOperationException haoe) {
                throw new DatabaseException(haoe.getMessage(), haoe);
            }
            localCommands[count++] = new LocalCommand(policyOp);
            for (int i = 0; i < instances.size(); ++i) {
                String instName = ((Instance)instances.elementAt(i)).getName();
                resourceName = this.getInstResourceNameUsingDBName(this.m_spName, instName, config);
                try {
                    policyOp = new HAPolicyOperation(resourceName, "inst", s_version);
                    if (oracleHomeChanged) {
                        policyOp.setOracleHome(ohome);
                    }
                    if (policyChanged) {
                        policyOp.setManagementPolicy(policy);
                    }
                }
                catch (HAOperationException haoe) {
                    throw new DatabaseException(haoe.getMessage(), haoe);
                }
                localCommands[count++] = new LocalCommand(policyOp);
            }
            for (int i = 0; i < services.size(); ++i) {
                sc = (ServiceComposite)services.elementAt(i);
                resourceName = sc.getSCResourceName();
                try {
                    policyOp = new HAPolicyOperation(resourceName, "cs", s_version);
                    if (oracleHomeChanged) {
                        policyOp.setOracleHome(ohome);
                    }
                    if (policyChanged) {
                        policyOp.setManagementPolicy(policy);
                    }
                }
                catch (HAOperationException haoe) {
                    throw new DatabaseException(haoe.getMessage(), haoe);
                }
                localCommands[count++] = new LocalCommand(policyOp);
                Enumeration smResources = sc.getSMResourceNames().elements();
                while (smResources.hasMoreElements()) {
                    resourceName = (String)smResources.nextElement();
                    try {
                        policyOp = new HAPolicyOperation(resourceName, "srv", s_version);
                        if (oracleHomeChanged) {
                            policyOp.setOracleHome(ohome);
                        }
                        if (policyChanged) {
                            policyOp.setManagementPolicy(policy);
                        }
                    }
                    catch (HAOperationException haoe) {
                        throw new DatabaseException(haoe.getMessage(), haoe);
                    }
                    localCommands[count++] = new LocalCommand(policyOp);
                }
            }
            for (int i = 0; i < localCommands.length; ++i) {
                HAOperation operation = (HAOperation)localCommands[i].getOperation();
                resourceName = operation.getResourceName();
                Trace.out("Registering resource " + resourceName);
                localCommands[i].execute();
                HAOperationResult result = (HAOperationResult)localCommands[i].getOperationResult();
                if (result.getStatus() == 0) continue;
                Object[] args = new Object[]{this.m_spName};
                throw new DatabaseException(s_opsMsgBundle.getMessage("1061", true, args) + s_newline + result.getOutputAll());
            }
        }
        if (!(!oracleHomeChanged || policyChanged || dbName != config.getDBName() && !dbName.equals(config.getDBName()) || domain != config.getDomain() && !domain.equals(config.getDomain()) || spfile != config.getSPFile() && !spfile.equals(config.getSPFile()) || role != config.getRole() && !role.equals(config.getRole()) || startOpt != config.getStartOpt() && !startOpt.equals(config.getStartOpt()))) {
            try {
                this.m_ocrTree.setDBOracleHome(this.m_spName, ohome);
            }
            catch (OCRException e) {
                throw new DatabaseException(e.getMessage(), e);
            }
        }
        config.setDBName(dbName);
        config.setDomain(domain);
        config.setOracleHome(ohome);
        config.setSPFile(spfile);
        config.setRole(role);
        config.setStartOpt(startOpt);
        if (policy != null && policyChanged) {
            config.setManagementPolicy(policy);
        }
        try {
            this.setConfiguration(config);
        }
        catch (ConfigurationException e) {
            Object[] args = new Object[]{this.m_spName};
            throw new DatabaseException(s_rawMsgBundle.getMessage("1005", true, args), e);
        }
    }

    private void updateStartValues(ParallelServerConfig config, String ohome, String policy) throws DatabaseException {
        if (policy != null && policy.compareToIgnoreCase(config.getManagementPolicy()) != 0) {
            ServiceComposite sc;
            Trace.out("Re-registering all resources for " + this.m_spName + " since its POLICY is being modified");
            int numServResources = 0;
            Vector instances = config.getInstances();
            Vector services = config.getServices();
            for (int i = 0; i < services.size(); ++i) {
                sc = (ServiceComposite)services.elementAt(i);
                numServResources += sc.getSMResourceNames().size() + 1;
            }
            LocalCommand[] localCommands = new LocalCommand[numServResources + instances.size() + 1];
            Trace.out("Number of resources =" + localCommands.length);
            int count = 0;
            HAPolicyOperation policyOp = null;
            String resourceName = this.getDBResourceName(this.m_spName, null);
            try {
                policyOp = new HAPolicyOperation(resourceName, "db", s_version);
                policyOp.setManagementPolicy(policy);
            }
            catch (HAOperationException haoe) {
                throw new DatabaseException(haoe.getMessage(), haoe);
            }
            localCommands[count++] = new LocalCommand(policyOp);
            for (int i = 0; i < instances.size(); ++i) {
                String instName = ((Instance)instances.elementAt(i)).getName();
                resourceName = this.getInstResourceNameUsingDBName(this.m_spName, instName, config);
                try {
                    policyOp = new HAPolicyOperation(resourceName, "inst", s_version);
                    policyOp.setManagementPolicy(policy);
                }
                catch (HAOperationException haoe) {
                    throw new DatabaseException(haoe.getMessage(), haoe);
                }
                localCommands[count++] = new LocalCommand(policyOp);
            }
            for (int i = 0; i < services.size(); ++i) {
                sc = (ServiceComposite)services.elementAt(i);
                resourceName = sc.getSCResourceName();
                try {
                    policyOp = new HAPolicyOperation(resourceName, "cs", s_version);
                    policyOp.setManagementPolicy(policy);
                }
                catch (HAOperationException haoe) {
                    throw new DatabaseException(haoe.getMessage(), haoe);
                }
                localCommands[count++] = new LocalCommand(policyOp);
                Enumeration smResources = sc.getSMResourceNames().elements();
                while (smResources.hasMoreElements()) {
                    resourceName = (String)smResources.nextElement();
                    try {
                        policyOp = new HAPolicyOperation(resourceName, "srv", s_version);
                        policyOp.setManagementPolicy(policy);
                    }
                    catch (HAOperationException haoe) {
                        throw new DatabaseException(haoe.getMessage(), haoe);
                    }
                    localCommands[count++] = new LocalCommand(policyOp);
                }
            }
            for (int i = 0; i < localCommands.length; ++i) {
                HAOperation operation = (HAOperation)localCommands[i].getOperation();
                resourceName = operation.getResourceName();
                Trace.out("Registering resource " + resourceName);
                localCommands[i].execute();
                HAOperationResult result = (HAOperationResult)localCommands[i].getOperationResult();
                if (result.getStatus() == 0) continue;
                for (int k = 0; k <= i; ++k) {
                    HAPolicyOperation op = (HAPolicyOperation)localCommands[i].getOperation();
                    resourceName = operation.getResourceName();
                    if (op.getManagementPolicy().equalsIgnoreCase("AUTOMATIC")) {
                        op.setManagementPolicy("MANUAL");
                    } else {
                        op.setManagementPolicy("AUTOMATIC");
                    }
                    localCommands[k].execute();
                }
                Object[] args = new Object[]{this.m_spName};
                throw new DatabaseException(s_opsMsgBundle.getMessage("1061", true, args) + s_newline + result.getOutputAll());
            }
        } else {
            Trace.out("Not registering resources  since its POLICY is NOT being modified");
        }
    }

    @Override
    public void remove() throws DatabaseException {
        this.remove(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(boolean force) throws DatabaseException {
        String resName;
        String oracleHome;
        ParallelServerConfig config;
        Vector<String> resourcesToStop = null;
        Vector<String> resourcesToGo = null;
        Vector instances = null;
        StringBuffer stagedExceptionMesgs = new StringBuffer();
        try {
            config = this.getConfiguration();
            oracleHome = config.getOracleHome();
            resName = this.getDBResourceName(this.m_spName, config);
        }
        catch (ConfigurationException e) {
            if (!force) {
                throw new DatabaseException(e.getMessage(), e);
            }
            try {
                this.checkExistsAll();
            }
            catch (DatabaseException ex) {
                throw new DatabaseException(e.getMessage(), e);
            }
            config = null;
            resName = this.getDBResourceName(this.m_spName, config);
            try {
                oracleHome = new NodeApps(null, this.m_version).getOracleHome(resName);
            }
            catch (NodeException e2) {
                throw new DatabaseException(e.getMessage(), e);
            }
        }
        Trace.out("removing database");
        if (force && config == null) {
            try {
                LocalCommand localCommand = new LocalCommand(new HAStatusOperation(this.m_version));
                localCommand.execute();
                HAOperationResult result = (HAOperationResult)localCommand.getOperationResult();
                if (result.getStatus() != 0) {
                    Trace.out("Stat operation failed");
                    String msg = result.getOutputSingle() + s_newline + result.getError();
                    stagedExceptionMesgs.append(msg);
                }
                Vector vResourceStats = HAResourceStatus.parseHAStatusOutput(result.getOutput());
                String sigPrefix = "ora." + this.m_spName + ".";
                Pattern pattern1 = Pattern.compile(sigPrefix + "*.*." + "srv");
                Pattern pattern2 = Pattern.compile(sigPrefix + "*." + "cs");
                Pattern pattern3 = Pattern.compile(sigPrefix + "*." + "inst");
                Pattern pattern4 = Pattern.compile(sigPrefix + "db");
                ArrayList<String> list = new ArrayList<String>(vResourceStats.size());
                for (int i = 0; i < vResourceStats.size(); ++i) {
                    resName = ((HAResourceStatus)vResourceStats.elementAt(i)).getResourceName();
                    if (!pattern1.matcher(resName).matches() && !pattern2.matcher(resName).matches() && !pattern3.matcher(resName).matches() && !pattern4.matcher(resName).matches()) continue;
                    list.add(resName);
                }
                if (list.size() > 0) {
                    String[] resourceNames = new String[list.size()];
                    list.toArray(resourceNames);
                    this.removeResources(resourceNames, oracleHome);
                }
                ClusterAlias clua = null;
                try {
                    clua = new ClusterAlias();
                    if (clua.isSupported()) {
                        Trace.out("deleting clua");
                        clua.delete(this.m_spName);
                    }
                }
                catch (ClusterAliasException ce) {
                    stagedExceptionMesgs.append(s_newline + ce.getMessage());
                }
                finally {
                    try {
                        if (clua != null) {
                            clua.destroy();
                        }
                    }
                    catch (ClusterAliasException ce) {}
                }
            }
            catch (HAOperationException e) {
                stagedExceptionMesgs.append(s_newline + e.getMessage());
            }
        } else {
            block88: {
                VIPAddress addr;
                int i;
                HAUnregisterOperation unregisterOp;
                Instance inst;
                int i2;
                try {
                    new Util().checkOracleUser(oracleHome, this.m_ocrTree.getUserName(this.m_ocrTree.getTreeDefinition().getDBKey(this.m_spName)));
                }
                catch (OCRException e) {
                    throw new DatabaseException(e.getMessage(), e);
                }
                catch (UtilException e) {
                    throw new DatabaseException(e.getMessage(), e);
                }
                boolean runningInternal = false;
                try {
                    runningInternal = this.isRunningInternal(true);
                }
                catch (HAResourceStateUnknownException re) {
                    if (force) {
                        runningInternal = false;
                    } else {
                        Trace.out("resource state unknown. not removed");
                        runningInternal = true;
                    }
                }
                catch (DatabaseException e) {
                    if (force) {
                        stagedExceptionMesgs.append(e.getMessage());
                    }
                    throw new DatabaseException(e.getMessage(), e);
                }
                boolean running = false;
                if (runningInternal) {
                    try {
                        running = this.isRunning();
                    }
                    catch (DatabaseException dEx) {
                        throw new DatabaseException(dEx.getMessage(), dEx);
                    }
                    if (!running) {
                        String[] instanceNames = config.enumerateInstances();
                        try {
                            this.stopInstance(instanceNames, "immediate", config);
                        }
                        catch (InstanceException ie) {
                            throw new DatabaseException(ie.getMessage(), ie);
                        }
                    }
                }
                if (config.isEnabled() && running) {
                    Object[] args = new Object[]{this.m_spName};
                    throw new DatabaseException(s_opsMsgBundle.getMessage("1022", true, args));
                }
                resourcesToStop = new Vector<String>();
                resourcesToGo = new Vector<String>();
                instances = config.getInstances();
                Vector services = config.getServices();
                boolean is101Version = Version.get101Version().equals(this.m_version);
                for (i2 = 0; i2 < services.size(); ++i2) {
                    ServiceComposite sc = (ServiceComposite)services.elementAt(i2);
                    resName = sc.getSCResourceName();
                    resourcesToStop.addElement(resName);
                    resourcesToGo.addElement(resName);
                    Hashtable sms = sc.getSMResourceNames();
                    Enumeration e = sms.elements();
                    while (e.hasMoreElements()) {
                        resName = (String)e.nextElement();
                        resourcesToStop.addElement(resName);
                        resourcesToGo.addElement(resName);
                    }
                    if (!is101Version) continue;
                    Hashtable sas = sc.getSAResourceNames();
                    e = sas.elements();
                    while (e.hasMoreElements()) {
                        resName = (String)e.nextElement();
                        resourcesToStop.addElement(resName);
                        resourcesToGo.addElement(resName);
                    }
                }
                for (i2 = 0; i2 < instances.size(); ++i2) {
                    inst = (Instance)instances.elementAt(i2);
                    resName = this.getInstResourceNameUsingDBName(this.m_spName, inst.getName(), config);
                    resourcesToStop.addElement(resName);
                }
                Command[] localCommands = new LocalCommand[resourcesToStop.size()];
                try {
                    for (int i3 = 0; i3 < resourcesToStop.size(); ++i3) {
                        resName = (String)resourcesToStop.elementAt(i3);
                        HAStopOperation stopOp = new HAStopOperation(resName, this.m_version);
                        localCommands[i3] = new LocalCommand(stopOp);
                    }
                }
                catch (HAOperationException haoe) {
                    throw new DatabaseException(haoe.getMessage(), haoe);
                }
                ClusterCmd clusterCmd = new ClusterCmd();
                try {
                    clusterCmd.submit(localCommands);
                }
                catch (ClusterException ce) {
                    Trace.out("stop a service resource failed. which is fine");
                }
                localCommands = new LocalCommand[resourcesToGo.size()];
                try {
                    for (int i4 = 0; i4 < resourcesToGo.size(); ++i4) {
                        resName = (String)resourcesToGo.elementAt(i4);
                        unregisterOp = new HAUnregisterOperation(resName, this.m_version, force);
                        localCommands[i4] = new LocalCommand(unregisterOp);
                    }
                }
                catch (HAOperationException haoe) {
                    throw new DatabaseException(haoe.getMessage(), haoe);
                }
                try {
                    clusterCmd.submit(localCommands);
                }
                catch (ClusterException ce) {
                    Trace.out("Could not submit" + ce.getMessage());
                    if (force) {
                        stagedExceptionMesgs.append(s_newline + ce.getMessage());
                    }
                    throw new DatabaseException(ce.getMessage(), ce);
                }
                resourcesToGo = new Vector();
                for (i = 0; i < instances.size(); ++i) {
                    inst = (Instance)instances.elementAt(i);
                    resName = this.getInstResourceNameUsingDBName(this.m_spName, inst.getName(), config);
                    resourcesToGo.addElement(resName);
                }
                resName = this.getDBResourceName(this.m_spName, config);
                resourcesToGo.addElement(resName);
                localCommands = new LocalCommand[resourcesToGo.size()];
                try {
                    for (i = 0; i < resourcesToGo.size(); ++i) {
                        resName = (String)resourcesToGo.elementAt(i);
                        unregisterOp = new HAUnregisterOperation(resName, this.m_version, force);
                        localCommands[i] = new LocalCommand(unregisterOp);
                    }
                }
                catch (HAOperationException haoe) {
                    throw new DatabaseException(haoe.getMessage(), haoe);
                }
                try {
                    clusterCmd.submit(localCommands);
                }
                catch (ClusterException ce) {
                    Trace.out("Could not submit" + ce.getMessage());
                    if (force) {
                        stagedExceptionMesgs.append(s_newline + ce.getMessage());
                    }
                    throw new DatabaseException(ce.getMessage(), ce);
                }
                if (!force) {
                    for (int i5 = 0; i5 < localCommands.length; ++i5) {
                        HAOperationResult result = (HAOperationResult)((LocalCommand)localCommands[i5]).getOperationResult();
                        unregisterOp = (HAUnregisterOperation)((LocalCommand)localCommands[i5]).getOperation();
                        String resourceName = unregisterOp.getResourceName();
                        if (result.getStatus() == 0) continue;
                        Trace.out("Failed to unregister " + resourceName + " error=" + result.getOutputAll());
                        Object[] args = new Object[]{resourceName};
                        String msg = s_opsMsgBundle.getMessage("1036", true, args) + s_newline + result.getOutputAll();
                        throw new DatabaseException(msg.trim());
                    }
                }
                if ((addr = config.getVIPAddress()) != null) {
                    ClusterAlias clua = null;
                    try {
                        clua = new ClusterAlias();
                        if (clua.isSupported()) {
                            Trace.out("deleting clua");
                            String cluaName = addr.getVIPName() != null && addr.getVIPName().length() > 0 ? addr.getVIPName() : this.m_spName;
                            clua.delete(cluaName);
                        } else {
                            Trace.out("clua is not supported");
                        }
                    }
                    catch (ClusterAliasException ce) {
                        if (force) {
                            stagedExceptionMesgs.append(s_newline + ce.getMessage());
                            break block88;
                        }
                        throw new DatabaseException(ce.getMessage());
                    }
                    finally {
                        if (clua != null) {
                            try {
                                clua.destroy();
                            }
                            catch (ClusterAliasException clusterAliasException) {}
                        }
                    }
                }
            }
            try {
                super.remove(force);
            }
            catch (DatabaseException de) {
                if (force) {
                    stagedExceptionMesgs.append(s_newline + de.getMessage());
                }
                throw de;
            }
        }
        if (stagedExceptionMesgs.length() > 0) {
            throw new DatabaseException(stagedExceptionMesgs.toString());
        }
    }

    @Override
    public void removeServiceAttractors() throws DatabaseException {
        String resName;
        Enumeration e;
        ServiceComposite sc;
        ParallelServerConfig config;
        if (new Version().equals(this.m_version)) {
            return;
        }
        try {
            config = this.getConfiguration();
        }
        catch (ConfigurationException e2) {
            throw new DatabaseException(e2.getMessage(), e2);
        }
        String oh = config.getOracleHome();
        try {
            new Util().checkOracleUser(oh);
        }
        catch (UtilException e3) {
            throw new DatabaseException(e3.getMessage(), e3);
        }
        Vector<LocalCommand> toUpdate = new Vector<LocalCommand>();
        Vector<LocalCommand> toReg = new Vector<LocalCommand>();
        Vector<String> resourcesToGo = new Vector<String>();
        Vector services = config.getServices();
        for (int i = 0; i < services.size(); ++i) {
            sc = (ServiceComposite)services.elementAt(i);
            if (sc.getAvailableInstances() == null || sc.getAvailableInstances().length <= 0) continue;
            Hashtable sms = sc.getSMResourceNames();
            e = sms.elements();
            while (e.hasMoreElements()) {
                resName = (String)e.nextElement();
                try {
                    HAProfileOperation profileOp = new HAProfileOperation(resName, oh, this.m_version);
                    profileOp.setProfileOption("-update -l");
                    toUpdate.addElement(new LocalCommand(profileOp));
                    HARegisterOperation regOp = new HARegisterOperation(resName, true, this.m_version);
                    toReg.addElement(new LocalCommand(regOp));
                }
                catch (HAOperationException hoe) {
                    Trace.out("cannot create operation " + hoe.getMessage());
                    throw new DatabaseException(hoe.getMessage(), hoe);
                }
            }
        }
        if (toUpdate.size() == 0) {
            return;
        }
        ClusterCmd clusterCmd = new ClusterCmd();
        try {
            clusterCmd.submit(toUpdate);
        }
        catch (ClusterException ce) {
            Trace.out("Could not submit" + ce.getMessage());
            throw new DatabaseException(ce.getMessage(), ce);
        }
        try {
            clusterCmd.submit(toReg);
        }
        catch (ClusterException ce) {
            Trace.out("Could not submit" + ce.getMessage());
            throw new DatabaseException(ce.getMessage(), ce);
        }
        for (int i = 0; i < services.size(); ++i) {
            sc = (ServiceComposite)services.elementAt(i);
            Hashtable sas = sc.getSAResourceNames();
            e = sas.elements();
            while (e.hasMoreElements()) {
                resName = (String)e.nextElement();
                resourcesToGo.addElement(resName);
            }
        }
        Command[] localCommands = new LocalCommand[resourcesToGo.size()];
        try {
            for (int i = 0; i < resourcesToGo.size(); ++i) {
                resName = (String)resourcesToGo.elementAt(i);
                HAStopOperation stopOp = new HAStopOperation(resName, this.m_version);
                localCommands[i] = new LocalCommand(stopOp);
            }
        }
        catch (HAOperationException haoe) {
            throw new DatabaseException(haoe.getMessage(), haoe);
        }
        try {
            clusterCmd.submit(localCommands);
        }
        catch (ClusterException ce) {
            Trace.out("stop a service attractor failed. which is fine");
        }
        localCommands = new LocalCommand[resourcesToGo.size()];
        try {
            for (int i = 0; i < resourcesToGo.size(); ++i) {
                resName = (String)resourcesToGo.elementAt(i);
                HAUnregisterOperation unregisterOp = new HAUnregisterOperation(resName, this.m_version);
                localCommands[i] = new LocalCommand(unregisterOp);
            }
        }
        catch (HAOperationException haoe) {
            throw new DatabaseException(haoe.getMessage(), haoe);
        }
        try {
            clusterCmd.submit(localCommands);
        }
        catch (ClusterException ce) {
            Trace.out("Could not submit" + ce.getMessage());
            throw new DatabaseException(ce.getMessage(), ce);
        }
    }

    @Override
    public boolean createOracleService(String sid, String nodeName) throws OracleServiceException {
        if (new SystemFactory().CreateSystem().isUnixSystem()) {
            return false;
        }
        if (sid == null || sid.trim().length() == 0) {
            Trace.out("ParallelServerHA.createOracleService: Null passed for sid");
            throw new OracleServiceException(s_opsMsgBundle.getMessage("1076", true));
        }
        try {
            Cluster.getHostName(nodeName);
        }
        catch (ClusterException e) {
            throw new OracleServiceException(e.getMessage());
        }
        String oracleHome = null;
        try {
            oracleHome = this.m_ocrTree.getKeyValue(this.m_ocrTree.getTreeDefinition().getDBOHomeKey(this.m_spName));
        }
        catch (OCRException e) {
            throw new OracleServiceException(e.getMessage(), e);
        }
        if (oracleHome == null) {
            Trace.out("ParallelServerHA.createOracleService: oracleHome is null for the cluster database " + this.m_spName);
            Object[] args = new String[]{this.m_spName};
            throw new OracleServiceException(s_opsMsgBundle.getMessage("1077", true, args));
        }
        CreateOracleServiceOperation createOperation = new CreateOracleServiceOperation(oracleHome, sid, nodeName, this.m_version);
        LocalCommand localCommand = new LocalCommand(createOperation);
        localCommand.execute();
        OperationResult result = localCommand.getOperationResult();
        Trace.out("ParallelServerHA.createOracleService status: " + result.getStatus());
        return result.getStatus() == 0;
    }

    @Override
    public boolean deleteOracleService(String sid, String nodeName) throws OracleServiceException {
        if (new SystemFactory().CreateSystem().isUnixSystem()) {
            return false;
        }
        if (sid == null || sid.trim().length() == 0) {
            Trace.out("ParallelServerHA.deleteOracleService: Null passed for sid");
            throw new OracleServiceException(s_opsMsgBundle.getMessage("1076", true));
        }
        try {
            Cluster.getHostName(nodeName);
        }
        catch (ClusterException e) {
            throw new OracleServiceException(e.getMessage());
        }
        String oracleHome = null;
        try {
            oracleHome = this.m_ocrTree.getKeyValue(this.m_ocrTree.getTreeDefinition().getDBOHomeKey(this.m_spName));
        }
        catch (OCRException e) {
            throw new OracleServiceException(e.getMessage(), e);
        }
        if (oracleHome == null) {
            Trace.out("ParallelServerHA.deleteOracleService: oracleHome is null for the cluster database " + this.m_spName);
            Object[] args = new String[]{this.m_spName};
            throw new OracleServiceException(s_opsMsgBundle.getMessage("1077", true, args));
        }
        DeleteOracleServiceOperation deleteOperation = new DeleteOracleServiceOperation(oracleHome, sid, nodeName, this.m_version);
        LocalCommand localCommand = new LocalCommand(deleteOperation);
        localCommand.execute();
        OperationResult result = localCommand.getOperationResult();
        Trace.out("ParallelServerHA.deleteOracleService status: " + result.getStatus());
        return result.getStatus() == 0;
    }

    @Override
    public void enable() throws DatabaseException {
        ParallelServerConfig config = null;
        String ohome = null;
        try {
            config = this.getConfiguration();
            ohome = config.getOracleHome();
        }
        catch (ConfigurationException ce) {
            Object[] args = new Object[]{this.m_spName};
            throw new DatabaseException(s_opsMsgBundle.getMessage("1088", true, args), ce);
        }
        if (config.isEnabled()) {
            Trace.out("Database already enabled; returning without doing any work");
            Object[] args = new Object[]{this.m_spName};
            throw new DatabaseException(s_opsMsgBundle.getMessage("1016", true, args));
        }
        String policy = config.getPriorManagementPolicy();
        if (policy == null) {
            policy = "AUTOMATIC";
        }
        this.updateStartValues(config, ohome, policy);
        try {
            this.m_ocrTree.setDBEnableDisable(this.m_spName, new Boolean(true), policy, "AUTOMATIC");
        }
        catch (OCRException e) {
            Trace.out(e);
            Object[] args = new Object[]{this.m_spName};
            throw new DatabaseException(s_rawMsgBundle.getMessage("1005", true, args), e);
        }
    }

    @Override
    public void disable() throws DatabaseException {
        ParallelServerConfig config = null;
        String ohome = null;
        try {
            config = this.getConfiguration();
            ohome = config.getOracleHome();
        }
        catch (ConfigurationException ce) {
            Object[] args = new Object[]{this.m_spName};
            throw new DatabaseException(s_opsMsgBundle.getMessage("1088", true, args), ce);
        }
        if (!config.isEnabled()) {
            Trace.out("Database already disabled; returning without doing any work");
            Object[] args = new Object[]{this.m_spName};
            throw new DatabaseException(s_opsMsgBundle.getMessage("1019", true, args));
        }
        this.updateStartValues(config, ohome, "MANUAL");
        try {
            this.m_ocrTree.setDBEnableDisable(this.m_spName, new Boolean(false), "MANUAL", config.getManagementPolicy());
        }
        catch (OCRException e) {
            Object[] args = new Object[]{this.m_spName};
            throw new DatabaseException(s_rawMsgBundle.getMessage("1005", true, args), e);
        }
    }

    private void enableDisable(boolean bEnable) throws DatabaseException {
        boolean isEnabled = this.isEnabled();
        if (bEnable && isEnabled) {
            Object[] args = new Object[]{this.m_spName};
            throw new DatabaseException(s_opsMsgBundle.getMessage("1016", true, args));
        }
        if (!bEnable && !isEnabled) {
            Object[] args = new Object[]{this.m_spName};
            throw new DatabaseException(s_opsMsgBundle.getMessage("1019", true, args));
        }
        try {
            String oracleHome = this.m_ocrTree.getKeyValue(this.m_ocrTree.getTreeDefinition().getDBOHomeKey(this.m_spName));
            new Util().checkOracleUser(oracleHome);
        }
        catch (OCRException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        catch (UtilException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        Boolean enableDisable = new Boolean(bEnable);
        try {
            this.m_ocrTree.setDBEnableDisable(this.m_spName, enableDisable);
        }
        catch (OCRException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
    }

    @Override
    public void enable(String instanceName) throws InstanceException {
        this.enableDisable(new String[]{instanceName}, true);
    }

    @Override
    public void enable(String[] instanceNames) throws InstanceException {
        this.enableDisable(instanceNames, true);
    }

    @Override
    public void disable(String instanceName) throws InstanceException {
        this.enableDisable(new String[]{instanceName}, false);
    }

    @Override
    public void disable(String[] instanceNames) throws InstanceException {
        this.enableDisable(instanceNames, false);
    }

    @Override
    public boolean isEnabled() throws DatabaseException {
        try {
            if (!this.m_ocrTree.keyExists(this.m_ocrTree.getTreeDefinition().getDBKey(this.m_spName))) {
                Object[] args = new String[]{this.m_spName};
                throw new DatabaseException(s_rawMsgBundle.getMessage("1001", true, args));
            }
            String enabled = this.m_ocrTree.getKeyValue(this.m_ocrTree.getTreeDefinition().getDBEnabledKey(this.m_spName));
            Trace.out("isEnabled=" + enabled);
            return Boolean.valueOf(enabled);
        }
        catch (OCRException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isEnabled(String instanceName) throws InstanceException {
        try {
            this.validateName(instanceName, true);
            if (!this.m_ocrTree.keyExists(this.m_ocrTree.getTreeDefinition().getDBInstanceNameKey(this.m_spName, instanceName))) {
                Object[] args = new String[]{instanceName, this.m_spName};
                throw new InstanceException(s_opsMsgBundle.getMessage("1082", true, args));
            }
            String enabled = this.m_ocrTree.getKeyValue(this.m_ocrTree.getTreeDefinition().getInstanceEnabledKey(this.m_spName, instanceName));
            Trace.out("isEnabled=" + enabled);
            return Boolean.valueOf(enabled);
        }
        catch (ConfigurationException e) {
            throw new InstanceException(e.getMessage(), e);
        }
        catch (OCRException e) {
            throw new InstanceException(e.getMessage(), e);
        }
    }

    private void enableDisable(String[] instanceNames, boolean bEnable) throws InstanceException {
        StringBuffer sb = null;
        if (instanceNames == null || instanceNames.length == 0) {
            throw new InstanceException(s_opsMsgBundle.getMessage("1076", true));
        }
        for (int i = 0; i < instanceNames.length; ++i) {
            if (bEnable) {
                if (!this.isEnabled(instanceNames[i])) continue;
                if (sb != null) {
                    sb.append(", " + instanceNames[i]);
                    continue;
                }
                sb = new StringBuffer(instanceNames[i]);
                continue;
            }
            if (this.isEnabled(instanceNames[i])) continue;
            if (sb != null) {
                sb.append(", " + instanceNames[i]);
                continue;
            }
            sb = new StringBuffer(instanceNames[i]);
        }
        if (sb != null) {
            Object[] args = new Object[]{sb.toString()};
            throw new InstanceException(s_opsMsgBundle.getMessage(bEnable ? "1017" : "1020", true, args));
        }
        try {
            String oracleHome = this.m_ocrTree.getKeyValue(this.m_ocrTree.getTreeDefinition().getDBOHomeKey(this.m_spName));
            new Util().checkOracleUser(oracleHome);
        }
        catch (OCRException e) {
            throw new InstanceException(e.getMessage(), e);
        }
        catch (UtilException e) {
            throw new InstanceException(e.getMessage(), e);
        }
        ParallelServerConfig config = null;
        String ohome = null;
        try {
            config = this.getConfiguration();
            ohome = config.getOracleHome();
        }
        catch (ConfigurationException ce) {
            Object[] args = new Object[]{this.m_spName};
            throw new InstanceException(s_opsMsgBundle.getMessage("1088", true, args), ce);
        }
        Vector instances = config.getInstances();
        int count = 0;
        for (int i = 0; i < instances.size(); ++i) {
            String instName = ((Instance)instances.elementAt(i)).getName();
            if (bEnable) {
                if (!this.isEnabled(instName)) continue;
                ++count;
                continue;
            }
            if (this.isEnabled(instName)) continue;
            ++count;
        }
        Trace.out("INFO:bEnable: " + bEnable + " count: " + count + " instanceNames.length " + instanceNames.length + "instances.size " + instances.size());
        if (bEnable && count == 0 || !bEnable && count + instanceNames.length == instances.size()) {
            String policy = null;
            boolean dbEnableDisable = false;
            if (bEnable) {
                Trace.out("enabling database");
                policy = config.getPriorManagementPolicy();
                if (policy == null) {
                    policy = "AUTOMATIC";
                }
                dbEnableDisable = true;
            } else {
                Trace.out("disabling database");
                config.setPriorManagementPolicy(config.getManagementPolicy());
                policy = "MANUAL";
                dbEnableDisable = false;
            }
            try {
                this.updateStartValues(config, ohome, policy);
            }
            catch (DatabaseException ex) {
                throw new InstanceException(ex.getMessage(), ex);
            }
            config.setManagementPolicy(policy);
            config.setEnabled(dbEnableDisable);
            try {
                this.setConfiguration(config);
            }
            catch (ConfigurationException e) {
                throw new InstanceException(e.getMessage(), e);
            }
        }
        Boolean enableDisable = new Boolean(bEnable);
        for (int i = 0; i < instanceNames.length; ++i) {
            try {
                this.m_ocrTree.setInstanceEnableDisable(this.m_spName, instanceNames[i], enableDisable);
                continue;
            }
            catch (OCRException e) {
                throw new InstanceException(e.getMessage(), e);
            }
        }
    }

    private String getDBResourceName(String dbName, ParallelServerConfig config) {
        if (config == null) {
            return "ora." + dbName + ".db";
        }
        return "ora." + config.getName() + ".db";
    }

    public static String getInstResourceName(String dbName, String instName, ParallelServerConfig config) {
        Trace.out("dbName=" + dbName + " instName=" + instName + " config=" + config);
        if (config == null) {
            Trace.out("resname is ora." + dbName + "." + instName + ".inst");
            return "ora." + dbName + "." + instName + ".inst";
        }
        String[] instNames = config.enumerateInstances();
        if (instNames != null) {
            String realInstname = instName;
            for (int i = 0; i < instNames.length; ++i) {
                if (!instName.equalsIgnoreCase(instNames[i])) continue;
                Trace.out("found this instName in config");
                realInstname = instNames[i];
                break;
            }
            Trace.out("resname is ora." + config.getName() + "." + realInstname + ".inst");
            return "ora." + config.getName() + "." + realInstname + ".inst";
        }
        Trace.out("resname is ora." + config.getName() + "." + instName + ".inst");
        return "ora." + config.getName() + "." + instName + ".inst";
    }

    protected void removeResources(String[] resNames, String oracleHome) throws DatabaseException {
        HAOperationResult result;
        LocalCommand localCommand;
        if (resNames.length == 0) {
            return;
        }
        try {
            HAGetPermOperation operation = new HAGetPermOperation(resNames[0], this.m_version);
            localCommand = new LocalCommand(operation);
            localCommand.execute();
            result = (HAOperationResult)localCommand.getOperationResult();
            if (result.getStatus() == 0) {
                new Util().checkOracleUser(oracleHome, operation.getUserName());
            } else {
                new Util().checkOracleUser(oracleHome);
            }
        }
        catch (UtilException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        catch (HAOperationException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        StringBuffer stagedExceptionMesgs = new StringBuffer();
        try {
            String msg;
            localCommand = new LocalCommand(new HAStopOperation(resNames, this.m_version));
            localCommand.execute();
            result = (HAOperationResult)localCommand.getOperationResult();
            if (result.getStatus() != 0) {
                Trace.out("Stop operation failed");
                msg = result.getOutputSingle() + s_newline + result.getError();
                stagedExceptionMesgs.append(msg);
            }
            localCommand = new LocalCommand(new HAUnregisterOperation(resNames, this.m_version));
            localCommand.execute();
            result = (HAOperationResult)localCommand.getOperationResult();
            if (result.getStatus() != 0) {
                Trace.out("Unregister operation failed");
                msg = result.getOutputSingle() + s_newline + result.getError();
                stagedExceptionMesgs.append(msg);
            }
        }
        catch (HAOperationException haoe) {
            stagedExceptionMesgs.append(haoe.getMessage());
        }
        if (stagedExceptionMesgs.length() > 0) {
            throw new DatabaseException(stagedExceptionMesgs.toString());
        }
    }

    private String getInstResourceNameUsingDBName(String spName, String instName, ParallelServerConfig config) {
        String dbName = null;
        try {
            dbName = this.m_ocrTree.getKeyValue(this.m_ocrTree.getTreeDefinition().getDBKey(spName));
        }
        catch (OCRException e) {
            Trace.out("Could not get the db name from OCR: " + e.getMessage());
            Trace.out("Use the DB case perserved name: " + spName);
        }
        if (dbName == null) {
            dbName = spName;
        }
        return ParallelServerHA.getInstResourceName(dbName, instName, config);
    }
}

