/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.database;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import oracle.ops.mgmt.database.Instance;
import oracle.ops.mgmt.database.ServiceComposite;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.operation.ha.HALiterals;

public class ParallelServerConfig
implements HALiterals,
Serializable {
    static final long serialVersionUID = -3978031128330243030L;
    private String m_opsName;
    private String m_oracleHome;
    private String m_spFilename = null;
    private Vector m_instances;
    private String[] m_env;
    private VIPAddress m_vip;
    private Vector m_services;
    private String m_domain;
    private String m_policy = "AUTOMATIC";
    private String m_oldPolicy = "AUTOMATIC";
    private boolean m_enabled;
    private String m_dbName;
    private String m_role;
    private String m_startOpt;

    public ParallelServerConfig(String dbName, Vector instances, String[] env, String oracleHome) {
        this.m_opsName = dbName;
        this.m_instances = instances;
        this.m_env = env;
        this.m_oracleHome = oracleHome;
        this.m_services = new Vector();
        this.m_enabled = true;
        this.m_domain = null;
        this.m_vip = null;
    }

    public ParallelServerConfig(String dbName, Vector instances, String[] env, String oracleHome, String spFile) {
        this(dbName, instances, env, oracleHome);
        this.m_spFilename = spFile;
    }

    public ParallelServerConfig(String dbUniqName, String domain, Vector instances, String[] env, String oracleHome, String spFile) {
        this(dbUniqName, instances, env, oracleHome, spFile);
        this.m_domain = domain;
    }

    public ParallelServerConfig(String dbUniqName, String domain, Vector instances, Vector services, VIPAddress vip, String[] env, String oracleHome, String spFile, boolean enabled) {
        this(dbUniqName, instances, env, oracleHome, spFile);
        this.m_domain = domain;
        this.m_services = services;
        this.m_vip = vip;
        this.m_enabled = enabled;
    }

    public ParallelServerConfig(String dbUniqName, String domain, Vector instances, Vector services, VIPAddress vip, String[] env, String oracleHome, String spFile, String dbName, String role, String startOpt, boolean enabled) {
        this(dbUniqName, instances, env, oracleHome, spFile);
        this.m_domain = domain;
        this.m_services = services;
        this.m_vip = vip;
        this.m_dbName = dbName;
        this.m_role = role;
        this.m_startOpt = startOpt;
        this.m_enabled = enabled;
    }

    public ParallelServerConfig(String dbUniqName, String domain, Vector instances, Vector services, VIPAddress vip, String[] env, String oracleHome, String spFile, String dbName, String role, String startOpt, boolean enabled, String policy, String oldPolicy) {
        this(dbUniqName, domain, instances, services, vip, env, oracleHome, spFile, dbName, role, startOpt, enabled);
        this.m_policy = policy;
        this.m_oldPolicy = oldPolicy;
    }

    public String getOracleHome() {
        return this.m_oracleHome;
    }

    public void setOracleHome(String home) {
        this.m_oracleHome = home;
    }

    public String getSPFile() {
        return this.m_spFilename;
    }

    public void setSPFile(String spfile) {
        this.m_spFilename = spfile;
    }

    public VIPAddress getVIPAddress() {
        return this.m_vip;
    }

    public void setVIPAddress(VIPAddress vip) {
        this.m_vip = vip;
    }

    public String getDBName() {
        return this.m_dbName;
    }

    void setDBName(String dbName) {
        this.m_dbName = dbName;
    }

    public String getRole() {
        return this.m_role;
    }

    void setRole(String role) {
        this.m_role = role;
    }

    public String getStartOpt() {
        return this.m_startOpt;
    }

    public void setStartOpt(String startOpt) {
        this.m_startOpt = startOpt;
    }

    public String[] getEnvironment() {
        return this.m_env;
    }

    public void setEnvironment(String[] env) {
        this.m_env = env;
    }

    public String getName() {
        return this.m_opsName;
    }

    public void setName(String dbUniqName) {
        this.m_opsName = dbUniqName;
    }

    public String getDomain() {
        return this.m_domain;
    }

    public void setDomain(String domain) {
        this.m_domain = domain;
    }

    public String getManagementPolicy() {
        return this.m_policy;
    }

    public void setManagementPolicy(String policy) {
        this.m_policy = policy;
    }

    public String getPriorManagementPolicy() {
        return this.m_oldPolicy;
    }

    public void setPriorManagementPolicy(String oldPolicy) {
        this.m_oldPolicy = oldPolicy;
    }

    public void enable() {
        this.m_enabled = true;
    }

    void disable() {
        this.m_enabled = false;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public Vector getInstances() {
        return this.m_instances;
    }

    public void setInstances(Vector instances) {
        this.m_instances = instances;
    }

    public Vector getServices() {
        return this.m_services;
    }

    public void setServices(Vector services) {
        this.m_services = services;
    }

    public void addService(ServiceComposite sc) {
        this.m_services.addElement(sc);
    }

    public void removeService(ServiceComposite sc) {
        this.m_services.removeElement(sc);
    }

    public void setEnv(String[] envList) {
        this.m_env = envList;
    }

    public void setEnabled(boolean enableFlag) {
        this.m_enabled = enableFlag;
    }

    public String[] enumerateInstances() {
        String[] result = new String[this.m_instances.size()];
        for (int i = 0; i < this.m_instances.size(); ++i) {
            result[i] = ((Instance)this.m_instances.elementAt(i)).getName();
        }
        return result;
    }

    public String[] enumerateServices() {
        String[] result = new String[this.m_services.size()];
        for (int i = 0; i < this.m_services.size(); ++i) {
            result[i] = ((ServiceComposite)this.m_services.elementAt(i)).getName();
        }
        return result;
    }

    public String[] enumerateNodes() {
        String[] nodeList = new String[this.m_instances.size()];
        for (int i = 0; i < this.m_instances.size(); ++i) {
            nodeList[i] = ((Instance)this.m_instances.elementAt(i)).getNode();
        }
        return nodeList;
    }

    public Enumeration getInstanceEnumerator() {
        return this.m_instances.elements();
    }

    public int getInstanceCount() {
        return this.m_instances.size();
    }

    public String getInstanceName(String node) {
        for (int i = 0; i < this.m_instances.size(); ++i) {
            if (!node.equalsIgnoreCase(((Instance)this.m_instances.elementAt(i)).getNode())) continue;
            return ((Instance)this.m_instances.elementAt(i)).getName();
        }
        return null;
    }

    public String getNode(String instance) {
        for (int i = 0; i < this.m_instances.size(); ++i) {
            if (!instance.equalsIgnoreCase(((Instance)this.m_instances.elementAt(i)).getName())) continue;
            return ((Instance)this.m_instances.elementAt(i)).getNode();
        }
        return null;
    }

    public int getIndexOf(String instName) {
        String[] instList = this.enumerateInstances();
        for (int index = 0; index < instList.length; ++index) {
            if (!instList[index].equalsIgnoreCase(instName)) continue;
            return index;
        }
        return -1;
    }

    public Instance getInstance(String instName) {
        int index = this.getIndexOf(instName);
        if (index < 0) {
            return null;
        }
        return (Instance)this.m_instances.elementAt(index);
    }

    public void setInstance(Instance instance) {
        int index = this.getIndexOf(instance.getName());
        if (index < 0) {
            this.m_instances.addElement(instance);
        } else {
            this.m_instances.setElementAt(instance, index);
        }
    }

    public ServiceComposite getService(String servName) {
        String[] servList = this.enumerateServices();
        for (int i = 0; i < servList.length; ++i) {
            if (!servList[i].equalsIgnoreCase(servName)) continue;
            return (ServiceComposite)this.m_services.elementAt(i);
        }
        return null;
    }

    public void setService(ServiceComposite serv) {
        String[] servList = this.enumerateServices();
        for (int i = 0; i < servList.length; ++i) {
            if (!servList[i].equalsIgnoreCase(serv.getName())) continue;
            this.m_services.setElementAt(serv, i);
            return;
        }
        this.m_services.addElement(serv);
    }
}

