/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.database;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.GetActiveNodes;
import oracle.ops.mgmt.cluster.RemoteResponseEventMulticaster;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.LocalCommand;
import oracle.ops.mgmt.command.RemoteCommand;
import oracle.ops.mgmt.database.ActionEvent;
import oracle.ops.mgmt.database.ActionListener;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.database.Credentials;
import oracle.ops.mgmt.database.DatabaseException;
import oracle.ops.mgmt.database.Instance;
import oracle.ops.mgmt.database.InstanceException;
import oracle.ops.mgmt.database.InstanceFailure;
import oracle.ops.mgmt.database.ListenerException;
import oracle.ops.mgmt.database.OracleServiceException;
import oracle.ops.mgmt.database.ParallelServerConfig;
import oracle.ops.mgmt.database.ParallelServerHA;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.operation.AddConfigurationOperation;
import oracle.ops.mgmt.operation.CheckListenerOperation;
import oracle.ops.mgmt.operation.CheckListenerResult;
import oracle.ops.mgmt.operation.ConfigurationResult;
import oracle.ops.mgmt.operation.CreateOracleServiceOperation;
import oracle.ops.mgmt.operation.DeleteOracleServiceOperation;
import oracle.ops.mgmt.operation.GetConfigurationOperation;
import oracle.ops.mgmt.operation.GetConfigurationResult;
import oracle.ops.mgmt.operation.GetEnvOperation;
import oracle.ops.mgmt.operation.GetEnvResult;
import oracle.ops.mgmt.operation.GetListenerOperation;
import oracle.ops.mgmt.operation.GetListenerResult;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.operation.ReloadListenerOperation;
import oracle.ops.mgmt.operation.ReloadListenerResult;
import oracle.ops.mgmt.operation.StartInstanceOperation;
import oracle.ops.mgmt.operation.StartInstanceResult;
import oracle.ops.mgmt.operation.StartListenerOperation;
import oracle.ops.mgmt.operation.StartListenerResult;
import oracle.ops.mgmt.operation.StopInstanceOperation;
import oracle.ops.mgmt.operation.StopInstanceResult;
import oracle.ops.mgmt.operation.StopListenerOperation;
import oracle.ops.mgmt.operation.StopListenerResult;
import oracle.ops.mgmt.operation.ha.HALiterals;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.rawdevice.OCRTree;
import oracle.ops.mgmt.rawdevice.OCRTreeDefinitionHA;
import oracle.ops.mgmt.trace.Trace;

public class ParallelServer
implements Constants,
HALiterals {
    public static final int ROLE_NONE = 0;
    public static final int ROLE_SYSDBA = 1;
    public static final int ROLE_SYSOPER = 2;
    public static final int ALL_RUNNING = 1;
    public static final int NONE_RUNNING = -1;
    public static final int SOME_RUNNING = 0;
    static MessageBundle s_opsMsgBundle = MessageBundle.getMessageBundle("Prkp");
    static MessageBundle s_rawMsgBundle = MessageBundle.getMessageBundle("Prkr");
    protected String m_spName;
    protected String m_dbDomain;
    protected Credentials m_credentials = null;
    protected Version m_version = null;
    protected ActionListener m_actionEventListener = null;
    protected static Version s_version = new Version();
    protected static String s_newline = System.getProperty("line.separator");
    protected OCRTree m_ocrTree = null;

    protected ParallelServer(String name, Version v) throws ConfigurationException {
        this(name, null, v);
    }

    protected ParallelServer(String name, String domain, Version v) throws ConfigurationException {
        this.validateName(name, false);
        this.m_spName = name;
        this.m_dbDomain = domain;
        this.m_version = v;
        this.m_credentials = null;
        this.initOCRTree(v);
    }

    protected void validateName(String name, boolean isInstance) throws ConfigurationException {
        if (name == null || name.trim().length() == 0) {
            throw new ConfigurationException(s_opsMsgBundle.getMessage(isInstance ? "1076" : "1081", true));
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i == 0) {
                if (!isInstance && !Character.isLetter(c)) {
                    sb.append(c);
                    continue;
                }
                if (isInstance && (c == '_' || c == '-')) {
                    sb.append(c);
                    continue;
                }
            }
            if (Character.isLetterOrDigit(c) || c == '_' || (!isInstance || c == '-') && (isInstance || c == '$' || c == '#')) continue;
            sb.append(c);
        }
        if (sb.length() > 0) {
            Object[] args = new String[]{name, sb.toString()};
            throw new ConfigurationException(s_opsMsgBundle.getMessage("1071", true, args));
        }
    }

    private void initOCRTree(Version version) throws ConfigurationException {
        try {
            this.m_ocrTree = OCRTree.init(version);
        }
        catch (OCRException e) {
            throw new ConfigurationException(e.getMessage());
        }
    }

    public static ParallelServer init(String name, Version version) throws ConfigurationException {
        return ParallelServer.init(name, null, version);
    }

    public static ParallelServer init(String name, String domain, Version version) throws ConfigurationException {
        ParallelServer ps = !Version.isPre10i(version) ? new ParallelServerHA(name, domain, version) : new ParallelServer(name, domain, version);
        return ps;
    }

    protected Version getVersion() {
        return this.m_version;
    }

    public boolean isRunning() throws DatabaseException {
        ParallelServerConfig config = null;
        GetActiveNodes activeNodes = null;
        Trace.out("enter isRunning()");
        try {
            config = this.getConfiguration();
        }
        catch (ConfigurationException ce) {
            Trace.out(ce);
        }
        if (config == null) {
            Trace.out("isRunning(): config is null");
            return false;
        }
        Trace.out("isRunning(): config is ok");
        String dbGroupName = "DB" + this.m_spName.toUpperCase();
        Trace.out("isRunning(): dbGroupName=" + dbGroupName);
        try {
            activeNodes = GetActiveNodes.create();
            boolean isRunning = Version.isPre10i(this.m_version) ? activeNodes.checkOPS(dbGroupName, true) : activeNodes.checkOPS(dbGroupName, false);
            return isRunning;
        }
        catch (ClusterException ce) {
            throw new DatabaseException(ce.getMessage());
        }
    }

    public boolean isRunning(String inst) throws DatabaseException {
        ParallelServerConfig config = null;
        GetActiveNodes activeNodes = null;
        try {
            config = this.getConfiguration();
        }
        catch (Exception e) {
            Trace.out(e);
        }
        if (config == null) {
            Trace.out("isRunning(" + inst + "): config is null");
            return false;
        }
        Trace.out("isRunning(" + inst + "): config is ok");
        String dbGroupName = "DB" + this.m_spName.toUpperCase();
        Trace.out("isRunning(" + inst + "): dbGroupName=" + dbGroupName);
        try {
            activeNodes = GetActiveNodes.create();
            boolean isRunning = Version.isPre10i(this.m_version) ? activeNodes.checkInstance(dbGroupName, inst, true) : activeNodes.checkInstance(dbGroupName, inst, false);
            Trace.out("isRunning(" + inst + ") returning " + isRunning);
            return isRunning;
        }
        catch (ClusterException ce) {
            throw new DatabaseException(ce.getMessage());
        }
    }

    public boolean isConfigured(String node) throws ConfigurationException {
        ParallelServerConfig config = this.getConfiguration();
        if (config == null) {
            return false;
        }
        Enumeration instances = config.getInstanceEnumerator();
        while (instances.hasMoreElements()) {
            Instance thisInst = (Instance)instances.nextElement();
            if (!thisInst.getNode().equalsIgnoreCase(node)) continue;
            return true;
        }
        return false;
    }

    public boolean isConfigured(String inst, String node) throws ConfigurationException {
        ParallelServerConfig config = this.getConfiguration();
        if (config == null) {
            return false;
        }
        Enumeration instances = config.getInstanceEnumerator();
        while (instances.hasMoreElements()) {
            Instance thisInst = (Instance)instances.nextElement();
            if (!thisInst.getNode().equalsIgnoreCase(node) || !thisInst.getName().equalsIgnoreCase(inst)) continue;
            return true;
        }
        return false;
    }

    public ParallelServerConfig getConfiguration() throws ConfigurationException {
        GetConfigurationOperation getConfigOperation = new GetConfigurationOperation(this.m_spName, this.m_version);
        GetConfigurationResult result = null;
        LocalCommand localCommand = new LocalCommand(getConfigOperation);
        localCommand.execute();
        result = (GetConfigurationResult)localCommand.getOperationResult();
        if (result == null) {
            this.notifyEvent(new ActionEvent(this, 4));
            Object[] args = new Object[]{this.m_spName, s_opsMsgBundle.getMessage("1039", false)};
            String msg = s_rawMsgBundle.getMessage("1007", true, args);
            throw new ConfigurationException(msg);
        }
        if (result.getStatus() == 0) {
            ParallelServerConfig config = result.getResult();
            if (this.isDomainMatch(config.getDomain())) {
                return config;
            }
            Object[] args = new Object[]{this.m_spName, s_rawMsgBundle.getMessage("1066", false)};
            String msg = s_rawMsgBundle.getMessage("1007", true, args);
            throw new ConfigurationException(msg);
        }
        this.notifyEvent(new ActionEvent(this, 5));
        Exception exp = result.getException();
        if (exp == null) {
            Object[] args = new Object[]{this.m_spName, result.getErrorMessage()};
            String msg = s_rawMsgBundle.getMessage("1007", true, args);
            throw new ConfigurationException(msg);
        }
        Object[] args = new Object[]{this.m_spName};
        String msg = s_opsMsgBundle.getMessage("1088", true, args);
        throw new ConfigurationException(msg, exp);
    }

    public void addConfiguration(ParallelServerConfig psConfig) throws ConfigurationException {
        AddConfigurationOperation addConfigOperation = new AddConfigurationOperation(psConfig, this.m_version);
        ConfigurationResult result = null;
        LocalCommand localCommand = new LocalCommand(addConfigOperation);
        localCommand.execute();
        result = (ConfigurationResult)localCommand.getOperationResult();
        if (result == null) {
            Object[] args = new Object[]{this.m_spName, s_opsMsgBundle.getMessage("1039", false)};
            String msg = s_rawMsgBundle.getMessage("1005", true, args);
            throw new ConfigurationException(msg);
        }
        if (result.getStatus() != 0) {
            Object[] args = new Object[]{this.m_spName, result.getErrorMessage()};
            String msg = s_rawMsgBundle.getMessage("1005", true, args);
            throw new ConfigurationException(msg);
        }
    }

    protected void setConfiguration(ParallelServerConfig psConfig) throws ConfigurationException {
        Trace.out("in setConfiguration, version = " + s_version.toString());
        try {
            this.m_ocrTree.setDatabaseConfiguration(psConfig);
        }
        catch (OCRException oe) {
            throw new ConfigurationException(oe.getMessage());
        }
    }

    public void create(String oracleHome) throws ConfigurationException, DatabaseException {
        this.create(oracleHome, (String)null);
    }

    public void create(String oracleHome, String spfileName) throws DatabaseException, ConfigurationException {
        try {
            if (this.m_ocrTree.isDatabaseConfigured(this.m_spName, this.m_dbDomain)) {
                Object[] args = new Object[]{this.m_spName};
                throw new ConfigurationException(s_rawMsgBundle.getMessage("1002", true, args));
            }
        }
        catch (OCRException args) {
            // empty catch block
        }
        ParallelServerConfig config = this.m_dbDomain == null ? new ParallelServerConfig(this.m_spName, new Vector(10), new String[0], oracleHome, spfileName) : new ParallelServerConfig(this.m_spName, this.m_dbDomain, new Vector(10), new String[0], oracleHome, spfileName);
        this.addConfiguration(config);
    }

    public void create(String oracleHome, VIPAddress addr) throws DatabaseException {
        this.create(oracleHome, null, addr, null, null, null);
    }

    public void create(String oracleHome, String spfileName, VIPAddress addr, String dbName, String role, String startOpt) throws DatabaseException {
        this.create(oracleHome, spfileName, addr, dbName, role, startOpt, "AUTOMATIC");
    }

    public void create(String oracleHome, String spfileName, VIPAddress addr, String dbName, String role, String startOpt, String policy) throws DatabaseException {
        try {
            if (!this.validatePolicy(policy)) {
                Object[] args = new Object[]{policy, "create"};
                throw new DatabaseException(s_rawMsgBundle.getMessage("1077", true, args));
            }
            if (this.m_ocrTree.isDatabaseConfigured(this.m_spName, this.m_dbDomain)) {
                Object[] args = new Object[]{this.m_spName};
                throw new DatabaseException(s_rawMsgBundle.getMessage("1002", true, args));
            }
        }
        catch (OCRException args) {
            // empty catch block
        }
        ParallelServerConfig config = new ParallelServerConfig(this.m_spName, this.m_dbDomain, new Vector(), new Vector(), addr, null, oracleHome, spfileName, dbName, role, startOpt, true, policy, policy);
        try {
            this.addConfiguration(config);
        }
        catch (ConfigurationException e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    protected boolean validatePolicy(String policy) throws DatabaseException {
        return policy != null && (policy.equalsIgnoreCase("AUTOMATIC") || policy.equalsIgnoreCase("MANUAL"));
    }

    public void setCredentials(String user, String password, int role) {
        this.m_credentials = new Credentials(user, password, role);
    }

    private String[] instEnviron(ParallelServerConfig config, String instName) {
        int i;
        String[] initEnv = new String[]{"ORACLE_HOME=" + config.getOracleHome(), "ORACLE_SID=" + instName};
        String[] opsenv = config.getEnvironment();
        if (opsenv == null) {
            opsenv = new String[]{};
        }
        Trace.out("opsenv.length = " + opsenv.length);
        String[] instenv = null;
        Instance instance = config.getInstance(instName);
        if (instance != null) {
            instenv = instance.getEnv();
        }
        if (instance == null || instenv == null) {
            instenv = new String[]{};
        }
        Trace.out("instenv.length = " + instenv.length);
        block0: for (i = 0; i < opsenv.length; ++i) {
            Trace.out("opsenv[" + i + "] = " + opsenv[i]);
            int opsenvIndex = opsenv[i].indexOf("=");
            if (opsenvIndex < 0) continue;
            String ovar = opsenv[i].substring(0, opsenvIndex);
            for (int j = 0; j < instenv.length; ++j) {
                String ivar;
                Trace.out("instenv[" + j + "] = " + instenv[j]);
                int instenvIndex = instenv[j].indexOf("=");
                if (instenvIndex < 0 || ovar.compareTo(ivar = instenv[j].substring(0, instenvIndex)) != 0) continue;
                Trace.out("instance " + instance + " env " + ivar + " ovverriding OPS env");
                opsenv[i] = null;
                continue block0;
            }
        }
        String[] finalEnv = null;
        int envlen = initEnv.length + opsenv.length + instenv.length;
        Trace.out("final envlen = " + envlen);
        int envpos = 0;
        finalEnv = new String[envlen];
        for (i = 0; i < initEnv.length; ++i) {
            finalEnv[envpos++] = initEnv[i];
        }
        for (i = 0; i < opsenv.length; ++i) {
            if (opsenv[i] == null) continue;
            finalEnv[envpos++] = opsenv[i];
        }
        for (i = 0; i < instenv.length; ++i) {
            finalEnv[envpos++] = instenv[i];
        }
        Trace.out("instEnviron: finalEnv len=" + finalEnv.length);
        for (i = 0; i < finalEnv.length; ++i) {
            Trace.out("instEnviron: finalEnv[" + i + "]=" + finalEnv[i]);
        }
        return finalEnv;
    }

    public boolean start() throws DatabaseException {
        this.start("parallel");
        return true;
    }

    public void start(String startupOptions) throws DatabaseException {
        ParallelServerConfig config;
        try {
            Trace.out("getting configuration for the db");
            config = this.getConfiguration();
        }
        catch (ConfigurationException e) {
            throw new DatabaseException(e.getMessage());
        }
        Trace.out("got configuration for the db: config=" + config);
        Vector<String> toNotify = new Vector<String>();
        Vector<RemoteCommand> startOps = new Vector<RemoteCommand>(config.getInstanceCount());
        Vector<String> instNames = new Vector<String>(config.getInstanceCount());
        String orahome = config.getOracleHome();
        String[] oraenv = config.getEnvironment();
        boolean forceStart = this.isForceWithYou(startupOptions);
        Vector instances = config.getInstances();
        for (int i = 0; i < instances.size(); ++i) {
            Instance thisInst = (Instance)instances.elementAt(i);
            String node = thisInst.getNode();
            toNotify.addElement(node);
            this.notifyEvent(new ActionEvent(this, 2003, node, i));
            if (forceStart || !this.isRunning(thisInst.getName())) {
                String[] env = this.instEnviron(config, thisInst.getName());
                StartInstanceOperation startInstanceOperation = startupOptions == null ? new StartInstanceOperation(thisInst.getName(), "parallel", env, this.m_version) : new StartInstanceOperation(thisInst.getName(), startupOptions, env, this.m_version);
                startInstanceOperation.setOracleHome(orahome);
                if (this.m_credentials != null) {
                    startInstanceOperation.setCredentials(this.m_credentials);
                }
                RemoteCommand remoteCommand = null;
                try {
                    remoteCommand = new RemoteCommand(node, startInstanceOperation);
                }
                catch (ClusterException e) {
                    Trace.out("start: cannot create remote command on " + node);
                    Trace.out(e);
                    this.notifyEventAll(toNotify, 2007, 4);
                    throw new DatabaseException(e.getMessage());
                }
                startOps.addElement(remoteCommand);
                instNames.addElement(thisInst.getName());
                continue;
            }
            toNotify.removeElement(node);
            this.notifyEvent(new ActionEvent(this, 2005, node, i, 2006, 1));
        }
        if (startOps.isEmpty()) {
            return;
        }
        int startCount = startOps.size();
        Command[] commands = new RemoteCommand[startCount];
        for (int i = 0; i < startCount; ++i) {
            commands[i] = (RemoteCommand)startOps.elementAt(i);
        }
        ClusterCmd clusterCmd = new ClusterCmd();
        try {
            clusterCmd.submit(commands);
        }
        catch (ClusterException e) {
            Trace.out("Could not submit" + e.getMessage());
            Trace.out(e);
            this.notifyEventAll(toNotify, 2007, 4);
            throw new DatabaseException(e.getMessage());
        }
        boolean allGood = true;
        Vector<InstanceFailure> failures = new Vector<InstanceFailure>(startCount);
        for (int i = 0; i < startCount; ++i) {
            StartInstanceResult result = null;
            String node = ((RemoteCommand)commands[i]).getNode();
            try {
                result = (StartInstanceResult)((RemoteCommand)commands[i]).getOperationResult();
            }
            catch (ClusterException e) {
                Trace.out("cannot get operation result");
                Trace.out(e);
                this.notifyEventAll(toNotify, 2007, 4);
                throw new DatabaseException(e.getMessage());
            }
            if (result.getStatus() != 0) {
                allGood = false;
                String name = (String)instNames.elementAt(i);
                Trace.out("Failed to start " + name + " on node " + node);
                String[] out = result.getOutput();
                for (int o = 0; o < out.length; ++o) {
                    Trace.out(out[o]);
                }
                InstanceFailure fail = new InstanceFailure(name, node, out);
                failures.addElement(fail);
                toNotify.removeElement(node);
                this.notifyEvent(new ActionEvent(this, 2005, node, i, 2007, 4));
                continue;
            }
            toNotify.removeElement(node);
            this.notifyEvent(new ActionEvent(this, 2005, node, i, 2006, 1));
        }
        if (!allGood) {
            String msg;
            if (failures.size() < startCount) {
                msg = s_opsMsgBundle.getMessage("1003", true);
            } else {
                Object[] args = new Object[]{this.m_spName};
                msg = s_opsMsgBundle.getMessage("1005", true, args);
            }
            throw new DatabaseException(msg, failures);
        }
    }

    public boolean stop() throws DatabaseException {
        return this.stop("immediate");
    }

    public boolean stop(String mode) throws DatabaseException {
        ParallelServerConfig config;
        try {
            config = this.getConfiguration();
        }
        catch (ConfigurationException e) {
            throw new DatabaseException(e.getMessage());
        }
        Vector<RemoteCommand> stopOps = new Vector<RemoteCommand>(config.getInstanceCount());
        Vector<String> instNames = new Vector<String>(config.getInstanceCount());
        String orahome = config.getOracleHome();
        String[] oraenv = config.getEnvironment();
        Vector<String> toNotify = new Vector<String>();
        Enumeration instances = config.getInstanceEnumerator();
        int nodeIdx = 0;
        while (instances.hasMoreElements()) {
            Instance thisInst = (Instance)instances.nextElement();
            String node = thisInst.getNode();
            toNotify.addElement(node);
            this.notifyEvent(new ActionEvent(this, 2004, node, nodeIdx));
            if (this.isRunning(thisInst.getName())) {
                String[] env = this.instEnviron(config, thisInst.getName());
                StopInstanceOperation stopInstanceOperation = new StopInstanceOperation(thisInst.getName(), mode, env, this.m_version);
                stopInstanceOperation.setOracleHome(orahome);
                if (this.m_credentials != null) {
                    stopInstanceOperation.setCredentials(this.m_credentials);
                }
                RemoteCommand remoteCommand = null;
                try {
                    remoteCommand = new RemoteCommand(node, stopInstanceOperation);
                }
                catch (ClusterException e) {
                    Trace.out("stop: cannot create remote command on " + node);
                    Trace.out(e);
                    this.notifyEventAll(toNotify, 2007, 4);
                    throw new DatabaseException(e.getMessage());
                }
                stopOps.addElement(remoteCommand);
                instNames.addElement(thisInst.getName());
            } else {
                toNotify.removeElement(node);
                this.notifyEvent(new ActionEvent(this, 2005, node, nodeIdx, 2006, 3));
            }
            ++nodeIdx;
        }
        if (stopOps.isEmpty()) {
            return true;
        }
        int stopCount = stopOps.size();
        Command[] commands = new RemoteCommand[stopCount];
        for (int i = 0; i < stopCount; ++i) {
            commands[i] = (RemoteCommand)stopOps.elementAt(i);
        }
        ClusterCmd clusterCmd = new ClusterCmd();
        try {
            clusterCmd.submit(commands);
        }
        catch (ClusterException e) {
            Trace.out("Could not submit" + e.getMessage());
        }
        boolean allGood = true;
        Vector<InstanceFailure> failures = new Vector<InstanceFailure>(stopCount);
        for (int i = 0; i < stopCount; ++i) {
            StopInstanceResult result = null;
            String node = ((RemoteCommand)commands[i]).getNode();
            try {
                result = (StopInstanceResult)((RemoteCommand)commands[i]).getOperationResult();
            }
            catch (ClusterException e) {
                Trace.out("cannot get operation result");
                Trace.out(e);
                this.notifyEventAll(toNotify, 2007, 4);
                throw new DatabaseException(e.getMessage());
            }
            if (result.getStatus() != 0) {
                allGood = false;
                String name = (String)instNames.elementAt(i);
                Trace.out("Failed to stop " + name + " on node " + node);
                String[] out = result.getOutput();
                for (int o = 0; o < out.length; ++o) {
                    Trace.out(out[o]);
                }
                InstanceFailure fail = new InstanceFailure(name, node, out);
                failures.addElement(fail);
                toNotify.removeElement(node);
                this.notifyEvent(new ActionEvent(this, 2005, node, i, 2007, 4));
                continue;
            }
            toNotify.removeElement(node);
            this.notifyEvent(new ActionEvent(this, 2005, node, i, 2006, 3));
        }
        if (!allGood) {
            String msg;
            if (failures.size() < stopCount) {
                msg = s_opsMsgBundle.getMessage("1004", true);
            } else {
                Object[] args = new Object[]{this.m_spName};
                msg = s_opsMsgBundle.getMessage("1006", true, args);
            }
            throw new DatabaseException(msg, failures);
        }
        return true;
    }

    public boolean startInstance(String instance) throws InstanceException {
        return this.startInstance(instance, "");
    }

    public boolean startInstance(String instance, String options) throws InstanceException {
        String[] instances = new String[]{instance};
        this.startInstance(instances, options);
        return true;
    }

    public void startInstance(String[] instances, String startupOptions) throws InstanceException {
        Vector<RemoteCommand> instOperationToStart = new Vector<RemoteCommand>();
        StartInstanceOperation startInstanceOperation = null;
        ParallelServerConfig config = null;
        String node = null;
        Vector<String> toNotify = new Vector<String>();
        try {
            config = this.getConfiguration();
        }
        catch (ConfigurationException e) {
            throw new InstanceException(e.getMessage());
        }
        String openMode = null;
        String pFileName = null;
        Trace.out("open mode = " + openMode + ", pfile = " + pFileName);
        boolean forceStart = this.isForceWithYou(startupOptions);
        for (int i = 0; i < instances.length; ++i) {
            try {
                if (this.instanceExists(config, instances[i])) {
                    node = config.getNode(instances[i]);
                }
            }
            catch (ConfigurationException ce) {
                this.notifyEventAll(toNotify, 2007, 4);
                throw new InstanceException(ce.getMessage());
            }
            toNotify.addElement(node);
            this.notifyEvent(new ActionEvent(this, 2003, node, i));
            String orahome = config.getOracleHome();
            if (!forceStart) {
                try {
                    if (this.isRunning(instances[i])) {
                        Trace.out("skipping running inst " + instances[i]);
                        toNotify.removeElement(node);
                        this.notifyEvent(new ActionEvent(this, 2005, node, i, 2006, 1));
                        continue;
                    }
                }
                catch (DatabaseException de) {
                    this.notifyEventAll(toNotify, 2007, 4);
                    throw new InstanceException(de.getMessage());
                }
            }
            String[] env = this.instEnviron(config, instances[i]);
            startInstanceOperation = new StartInstanceOperation(instances[i], startupOptions, env, this.m_version);
            startInstanceOperation.setOracleHome(orahome);
            if (this.m_credentials != null) {
                startInstanceOperation.setCredentials(this.m_credentials);
            }
            try {
                instOperationToStart.addElement(new RemoteCommand(node, startInstanceOperation));
                continue;
            }
            catch (ClusterException ce) {
                Trace.out("Could not create remote cmd " + ce.getMessage());
                this.notifyEventAll(toNotify, 2007, 4);
                throw new InstanceException(ce.getMessage());
            }
        }
        if (instOperationToStart.size() == 0) {
            Trace.out("there is nothing to start");
            return;
        }
        ClusterCmd clusterCmd = new ClusterCmd();
        try {
            Trace.out("submitting startinstance command");
            clusterCmd.submit(instOperationToStart);
        }
        catch (ClusterException ce) {
            Trace.out("Could not submit" + ce.getMessage());
            this.notifyEventAll(toNotify, 2007, 4);
            throw new InstanceException(ce.getMessage());
        }
        StartInstanceResult instResult = null;
        for (int i = 0; i < instOperationToStart.size(); ++i) {
            StartInstanceResult result;
            String instanceName;
            try {
                RemoteCommand rCommand = (RemoteCommand)instOperationToStart.elementAt(i);
                instResult = (StartInstanceResult)rCommand.getOperationResult();
                node = rCommand.getNode();
                instanceName = ((StartInstanceOperation)rCommand.getOperation()).getInstanceName();
                result = instResult;
            }
            catch (ClusterException e) {
                Trace.out("ps.start(options): cannot get operation result");
                this.notifyEventAll(toNotify, 2007, 4);
                throw new InstanceException(e.getMessage());
            }
            if (result.getStatus() != 0) {
                Trace.out("ps.start(options): operation failed");
                Object[] args = new Object[]{instanceName, node};
                String msg = s_opsMsgBundle.getMessage("1001", true, args);
                this.notifyEventAll(toNotify, 2007, 4);
                InstanceFailure fail = new InstanceFailure(instanceName, node, instResult.getOutput());
                throw new InstanceException(msg, fail);
            }
            toNotify.removeElement(node);
            this.notifyEvent(new ActionEvent(this, 2005, node, i, 2006, 1));
        }
    }

    public boolean stopInstance(String instance) throws InstanceException {
        return this.stopInstance(instance, "immediate");
    }

    public boolean stopInstance(String instance, String options) throws InstanceException {
        ParallelServerConfig config;
        try {
            config = this.getConfiguration();
        }
        catch (ConfigurationException e) {
            throw new InstanceException(e.getMessage());
        }
        String node = null;
        try {
            if (this.instanceExists(config, instance)) {
                node = config.getNode(instance);
            }
        }
        catch (ConfigurationException ce) {
            throw new InstanceException(ce.getMessage());
        }
        Trace.out("ParallelServer: stopInstance==> node=" + node);
        String orahome = config.getOracleHome();
        Trace.out("ParallelServer: stopInstance==> oracleHome=" + orahome);
        String[] env = this.instEnviron(config, instance);
        Trace.out("stopInstance env length = " + env.length);
        try {
            if (!this.isRunning(instance)) {
                return true;
            }
        }
        catch (DatabaseException de) {
            throw new InstanceException(de.getMessage());
        }
        StopInstanceOperation stopInstanceOperation = new StopInstanceOperation(instance, options, env, this.m_version);
        stopInstanceOperation.setOracleHome(orahome);
        if (this.m_credentials != null) {
            stopInstanceOperation.setCredentials(this.m_credentials);
        }
        RemoteCommand remoteCommand = null;
        try {
            remoteCommand = new RemoteCommand(node, stopInstanceOperation);
        }
        catch (ClusterException e) {
            Trace.out("unable to create remote command on " + node);
            Trace.out(e);
            throw new InstanceException(e.getMessage());
        }
        remoteCommand.execute();
        StopInstanceResult stopInstanceResult = null;
        try {
            stopInstanceResult = (StopInstanceResult)remoteCommand.getOperationResult();
        }
        catch (ClusterException e) {
            Trace.out("unable to get stop instance result");
            Trace.out(e);
            throw new InstanceException(e.getMessage());
        }
        if (stopInstanceResult.getStatus() != 0) {
            Object[] args = new Object[]{instance, node};
            String msg = s_opsMsgBundle.getMessage("1002", true, args);
            InstanceFailure fail = new InstanceFailure(instance, node, stopInstanceResult.getOutput());
            throw new InstanceException(msg, fail);
        }
        return true;
    }

    public void stopInstance(String[] instances) throws InstanceException {
        this.stopInstance(instances, "immediate");
    }

    public void stopInstance(String[] instances, String stopOptions) throws InstanceException {
        Vector<RemoteCommand> instOperationToStop = new Vector<RemoteCommand>();
        StopInstanceOperation stopInstanceOperation = null;
        ParallelServerConfig config = null;
        String node = null;
        Vector<String> toNotify = new Vector<String>();
        try {
            config = this.getConfiguration();
        }
        catch (ConfigurationException e) {
            throw new InstanceException(e.getMessage());
        }
        for (int i = 0; i < instances.length; ++i) {
            try {
                if (this.instanceExists(config, instances[i])) {
                    node = config.getNode(instances[i]);
                }
            }
            catch (ConfigurationException ce) {
                this.notifyEventAll(toNotify, 2007, 4);
                throw new InstanceException(ce.getMessage());
            }
            toNotify.addElement(node);
            this.notifyEvent(new ActionEvent(this, 2004, node, i));
            Trace.out("ParallelServer: stopInstance==> node=" + node);
            String orahome = config.getOracleHome();
            Trace.out("ParallelServer: stopInstance==> oracleHome=" + orahome);
            String[] env = this.instEnviron(config, instances[i]);
            Trace.out("stopInstance env length = " + env.length);
            try {
                if (!this.isRunning(instances[i])) {
                    toNotify.removeElement(node);
                    this.notifyEvent(new ActionEvent(this, 2005, node, i, 2006, 3));
                    continue;
                }
            }
            catch (DatabaseException de) {
                this.notifyEventAll(toNotify, 2007, 4);
                throw new InstanceException(de.getMessage());
            }
            stopInstanceOperation = new StopInstanceOperation(instances[i], stopOptions, env, this.m_version);
            stopInstanceOperation.setOracleHome(orahome);
            if (this.m_credentials != null) {
                stopInstanceOperation.setCredentials(this.m_credentials);
            }
            try {
                instOperationToStop.addElement(new RemoteCommand(node, stopInstanceOperation));
                continue;
            }
            catch (ClusterException ce) {
                Trace.out("Could not create remote cmd " + ce.getMessage());
                this.notifyEventAll(toNotify, 2007, 4);
                throw new InstanceException(ce.getMessage());
            }
        }
        if (instOperationToStop.size() == 0) {
            Trace.out("there is nothing to stop");
            return;
        }
        ClusterCmd clusterCmd = new ClusterCmd();
        try {
            clusterCmd.submit(instOperationToStop);
        }
        catch (ClusterException ce) {
            Trace.out("Could not submit" + ce.getMessage());
            this.notifyEventAll(toNotify, 2007, 4);
            throw new InstanceException(ce.getMessage());
        }
        StopInstanceResult instResult = null;
        for (int i = 0; i < instOperationToStop.size(); ++i) {
            StopInstanceResult result;
            String instanceName;
            try {
                RemoteCommand rCommand = (RemoteCommand)instOperationToStop.elementAt(i);
                instResult = (StopInstanceResult)rCommand.getOperationResult();
                node = rCommand.getNode();
                instanceName = ((StopInstanceOperation)rCommand.getOperation()).getInstanceName();
                result = instResult;
            }
            catch (ClusterException e) {
                Trace.out("ps.stop(options): cannot get operation result");
                this.notifyEventAll(toNotify, 2007, 4);
                throw new InstanceException(e.getMessage());
            }
            if (result.getStatus() != 0) {
                Trace.out("ps.stop(options): operation failed");
                Object[] args = new Object[]{instanceName, node};
                String msg = s_opsMsgBundle.getMessage("1002", true, args);
                this.notifyEventAll(toNotify, 2007, 4);
                InstanceFailure fail = new InstanceFailure(instanceName, node, instResult.getOutput());
                throw new InstanceException(msg, fail);
            }
            toNotify.removeElement(node);
            this.notifyEvent(new ActionEvent(this, 2005, node, i, 2006, 3));
        }
    }

    protected boolean isForceWithYou(String startupOptions) {
        boolean found = false;
        if (startupOptions != null) {
            StringTokenizer tokens = new StringTokenizer(startupOptions);
            while (tokens.hasMoreTokens()) {
                String thisToken = tokens.nextToken();
                Trace.out("processing start options: this token = " + thisToken);
                if (!thisToken.equalsIgnoreCase("force")) continue;
                found = true;
            }
        }
        Trace.out("found = " + found);
        return found;
    }

    public boolean isCoordinator(String node) {
        return true;
    }

    public void addInstance(String instName, String nodeName) throws ConfigurationException {
        try {
            this.createInstance(instName, nodeName);
        }
        catch (InstanceException e) {
            throw new ConfigurationException(e.getMessage());
        }
    }

    public void createInstance(String instName, String nodeName) throws InstanceException {
        if (instName == null || instName.trim().length() == 0) {
            throw new InstanceException(s_opsMsgBundle.getMessage("1076", true));
        }
        if (nodeName == null || nodeName.trim().length() == 0) {
            throw new InstanceException(MessageBundle.getMessageBundle("Prkc").getMessage("1045", true));
        }
        try {
            if (!this.isDomainMatch()) {
                Object[] args = new Object[]{instName, nodeName, this.m_spName};
                String msg = s_rawMsgBundle.getMessage("1008", true, args) + s_newline + s_rawMsgBundle.getMessage("1066", false);
                Trace.out("addInstance: msg=" + msg);
                throw new InstanceException(msg);
            }
            if (Version.isPre10i(this.m_version) && this.m_ocrTree.keyExists(this.m_ocrTree.getTreeDefinition().getDBInstanceNameKey(this.m_spName, instName))) {
                Object[] args = new String[]{instName};
                throw new InstanceException(s_rawMsgBundle.getMessage("1008", true, args));
            }
            this.m_ocrTree.addInstance(this.m_spName, instName, nodeName);
        }
        catch (ConfigurationException ce) {
            Object[] args = new Object[]{instName, nodeName, this.m_spName};
            String msg = s_rawMsgBundle.getMessage("1008", true, args) + s_newline + ce.getMessage();
            throw new InstanceException(msg);
        }
        catch (OCRException oe) {
            Object[] args = new Object[]{instName, nodeName, this.m_spName};
            String msg = s_rawMsgBundle.getMessage("1008", true, args) + s_newline + oe.getMessage();
            throw new InstanceException(msg);
        }
    }

    public void removeInstance(String instName) throws ConfigurationException, InstanceException {
        this.removeInstance(instName, false);
    }

    public void renameInstance(String oldInstance, String newInstance) throws ConfigurationException {
        if (!this.isDomainMatch()) {
            Object[] args = new Object[]{oldInstance, this.m_spName, s_rawMsgBundle.getMessage("1066", false)};
            String msg = s_rawMsgBundle.getMessage("1011", true, args);
            Trace.out("renameInstance: msg=" + msg);
            throw new ConfigurationException(msg);
        }
        this.validateName(newInstance, true);
        try {
            if (oldInstance == null || oldInstance.trim().length() == 0 || !this.m_ocrTree.keyExists(this.m_ocrTree.getTreeDefinition().getDBInstanceNameKey(this.m_spName, oldInstance))) {
                Object[] args = new String[]{oldInstance, this.m_spName};
                throw new ConfigurationException(s_opsMsgBundle.getMessage("1082", true, args));
            }
            this.m_ocrTree.renameInstance(this.m_spName, oldInstance, newInstance);
        }
        catch (OCRException oe) {
            Object[] args = new Object[]{oldInstance, newInstance, this.m_spName, oe.getMessage()};
            String msg = s_rawMsgBundle.getMessage("1011", true, args);
            throw new ConfigurationException(msg);
        }
    }

    public void moveInstance(String instName, String newNode) throws ConfigurationException {
        if (!this.isDomainMatch()) {
            Object[] args = new Object[]{instName, this.m_spName, s_rawMsgBundle.getMessage("1066", false)};
            String msg = s_rawMsgBundle.getMessage("1010", true, args);
            Trace.out("moveInstance: msg=" + msg);
            throw new ConfigurationException(msg);
        }
        if (newNode == null || newNode.trim().length() == 0) {
            throw new ConfigurationException(MessageBundle.getMessageBundle("Prkc").getMessage("1045", true));
        }
        try {
            if (instName == null || instName.trim().length() == 0 || !this.m_ocrTree.keyExists(this.m_ocrTree.getTreeDefinition().getDBInstanceNameKey(this.m_spName, instName))) {
                Object[] args = new String[]{instName, this.m_spName};
                throw new ConfigurationException(s_opsMsgBundle.getMessage("1082", true, args));
            }
            this.m_ocrTree.moveInstance(this.m_spName, instName, newNode);
        }
        catch (OCRException oe) {
            Object[] args = new Object[]{instName, newNode, this.m_spName, oe.getMessage()};
            String msg = s_rawMsgBundle.getMessage("1010", true, args);
            throw new ConfigurationException(msg);
        }
    }

    public void delete() throws ConfigurationException {
        try {
            this.remove(false);
        }
        catch (DatabaseException e) {
            throw new ConfigurationException(e.getMessage());
        }
    }

    public void remove() throws DatabaseException {
        this.remove(false);
    }

    public void setEnv(String name, String value) throws ConfigurationException {
        String[] envName = new String[]{name};
        String[] envValue = new String[]{value};
        this.setEnv(envName, envValue);
    }

    public void setEnv(String[] envName, String[] envValue) throws ConfigurationException {
        if (!this.isDomainMatch()) {
            Object[] args = new Object[]{this.m_spName, s_rawMsgBundle.getMessage("1066", false)};
            String msg = s_rawMsgBundle.getMessage("1069", true, args);
            Trace.out("setEnv: msg=" + msg);
            throw new ConfigurationException(msg);
        }
        StringBuffer buffer = new StringBuffer();
        String tempValue = null;
        Hashtable<String, String> table = new Hashtable<String, String>();
        for (int i = 0; i < envName.length; ++i) {
            tempValue = table.put(envName[i], envValue[i]);
            if (tempValue == null) continue;
            buffer.append(envName[i] + " ");
            tempValue = null;
        }
        if (table.size() != envName.length) {
            Object[] args = new Object[]{buffer};
            throw new ConfigurationException(s_rawMsgBundle.getMessage("1080", true, args));
        }
        try {
            this.m_ocrTree.setDBEnvironment(this.m_spName, envName, envValue);
        }
        catch (OCRException oe) {
            Object[] args = new Object[]{this.m_spName, oe.getMessage()};
            String msg = s_rawMsgBundle.getMessage("1069", true, args);
            throw new ConfigurationException(msg);
        }
    }

    public void setEnv(String instName, String name, String value) throws ConfigurationException {
        String[] envName = new String[]{name};
        String[] envValue = new String[]{value};
        this.setEnv(instName, envName, envValue);
    }

    public void setEnv(String instName, String[] envName, String[] envValue) throws ConfigurationException {
        if (!this.isDomainMatch()) {
            Object[] args = new Object[]{this.m_spName, instName, s_rawMsgBundle.getMessage("1066", false)};
            String msg = s_rawMsgBundle.getMessage("1070", true, args);
            Trace.out("setEnv: msg=" + msg);
            throw new ConfigurationException(msg);
        }
        StringBuffer buffer = new StringBuffer();
        String tempValue = null;
        Hashtable<String, String> table = new Hashtable<String, String>();
        for (int i = 0; i < envName.length; ++i) {
            tempValue = table.put(envName[i], envValue[i]);
            if (tempValue == null) continue;
            buffer.append(envName[i] + " ");
            tempValue = null;
        }
        if (table.size() != envName.length) {
            Object[] args = new Object[]{buffer};
            throw new ConfigurationException(s_rawMsgBundle.getMessage("1080", true, args));
        }
        try {
            this.m_ocrTree.setInstanceEnvironment(this.m_spName, instName, envName, envValue);
        }
        catch (OCRException oe) {
            Object[] args = new Object[]{this.m_spName, instName, oe.getMessage()};
            String msg = s_rawMsgBundle.getMessage("1070", true, args);
            throw new ConfigurationException(msg);
        }
    }

    public String[] getEnv(String name) throws ConfigurationException {
        String[] envName = new String[]{name};
        return this.getEnv(envName);
    }

    public String[] getEnv(String[] envName) throws ConfigurationException {
        if (!this.isDomainMatch()) {
            Object[] args = new Object[]{this.m_spName, s_rawMsgBundle.getMessage("1066", false)};
            String msg = s_rawMsgBundle.getMessage("1067", true, args);
            Trace.out("getEnv: msg=" + msg);
            throw new ConfigurationException(msg);
        }
        GetEnvOperation getEnvOperation = new GetEnvOperation(this.m_spName, envName, this.m_version);
        GetEnvResult result = null;
        LocalCommand localCommand = new LocalCommand(getEnvOperation);
        localCommand.execute();
        result = (GetEnvResult)localCommand.getOperationResult();
        if (result == null) {
            Trace.out("result is null");
            Object[] args = new Object[]{this.m_spName, s_opsMsgBundle.getMessage("1039", false)};
            String msg = s_rawMsgBundle.getMessage("1067", true, args);
            throw new ConfigurationException(msg);
        }
        if (result.getStatus() != 0) {
            Trace.out("operation not ok");
            Object[] args = new Object[]{this.m_spName, result.getErrorMessage()};
            String msg = s_rawMsgBundle.getMessage("1067", true, args);
            throw new ConfigurationException(msg);
        }
        return result.getEnvValue();
    }

    public String[] getEnv() throws ConfigurationException {
        if (!this.isDomainMatch()) {
            Object[] args = new Object[]{this.m_spName, s_rawMsgBundle.getMessage("1066", false)};
            String msg = s_rawMsgBundle.getMessage("1067", true, args);
            Trace.out("getEnv: msg=" + msg);
            throw new ConfigurationException(msg);
        }
        GetEnvOperation getEnvOperation = new GetEnvOperation(this.m_spName, this.m_version);
        GetEnvResult result = null;
        LocalCommand localCommand = new LocalCommand(getEnvOperation);
        localCommand.execute();
        result = (GetEnvResult)localCommand.getOperationResult();
        if (result == null) {
            Object[] args = new Object[]{this.m_spName, s_opsMsgBundle.getMessage("1039", false)};
            String msg = s_rawMsgBundle.getMessage("1067", true, args);
            throw new ConfigurationException(msg);
        }
        if (result.getStatus() != 0) {
            Object[] args = new Object[]{this.m_spName, result.getErrorMessage()};
            String msg = s_rawMsgBundle.getMessage("1067", true, args);
            throw new ConfigurationException(msg);
        }
        return result.getEnvValue();
    }

    public String[] getEnv(String instName, String name) throws ConfigurationException {
        String[] envName = new String[]{name};
        return this.getEnv(instName, envName);
    }

    public String[] getEnv(String instName, String[] envName) throws ConfigurationException {
        if (!this.isDomainMatch()) {
            Object[] args = new Object[]{this.m_spName, instName, s_rawMsgBundle.getMessage("1066", false)};
            String msg = s_rawMsgBundle.getMessage("1068", true, args);
            Trace.out("getEnv: msg=" + msg);
            throw new ConfigurationException(msg);
        }
        GetEnvOperation getEnvOperation = envName == null ? new GetEnvOperation(this.m_spName, instName, 101, this.m_version) : new GetEnvOperation(this.m_spName, instName, 101, envName, this.m_version);
        GetEnvResult result = null;
        LocalCommand localCommand = new LocalCommand(getEnvOperation);
        localCommand.execute();
        result = (GetEnvResult)localCommand.getOperationResult();
        if (result == null) {
            Object[] args = new Object[]{this.m_spName, instName, s_opsMsgBundle.getMessage("1039", false)};
            String msg = s_rawMsgBundle.getMessage("1068", true, args);
            throw new ConfigurationException(msg);
        }
        if (result.getStatus() != 0) {
            Object[] args = new Object[]{this.m_spName, instName, result.getErrorMessage()};
            String msg = s_rawMsgBundle.getMessage("1068", true, args);
            throw new ConfigurationException(msg);
        }
        return result.getEnvValue();
    }

    public void unsetEnv(String name) throws ConfigurationException {
        String[] envName = new String[]{name};
        this.unsetEnv(envName);
    }

    public void unsetEnv(String[] envName) throws ConfigurationException {
        if (!this.isDomainMatch()) {
            Object[] args = new Object[]{this.m_spName, s_rawMsgBundle.getMessage("1066", false)};
            String msg = s_rawMsgBundle.getMessage("1071", true, args);
            Trace.out("unsetEnv: msg=" + msg);
            throw new ConfigurationException(msg);
        }
        try {
            this.m_ocrTree.unsetDBEnvironment(this.m_spName, envName);
        }
        catch (OCRException oe) {
            Object[] args = new Object[]{this.m_spName, oe.getMessage()};
            String msg = s_rawMsgBundle.getMessage("1071", true, args);
            throw new ConfigurationException(msg);
        }
    }

    public void unsetEnv(String instName, String name) throws ConfigurationException {
        String[] envName = new String[]{name};
        this.unsetEnv(instName, envName);
    }

    public void unsetEnv(String instName, String[] envName) throws ConfigurationException {
        if (!this.isDomainMatch()) {
            Object[] args = new Object[]{this.m_spName, instName, s_rawMsgBundle.getMessage("1066", false)};
            String msg = s_rawMsgBundle.getMessage("1072", true, args);
            Trace.out("unsetEnv: msg=" + msg);
            throw new ConfigurationException(msg);
        }
        try {
            this.m_ocrTree.unsetInstanceEnvironment(this.m_spName, instName, envName);
        }
        catch (OCRException oe) {
            Object[] args = new Object[]{this.m_spName, instName, oe.getMessage()};
            String msg = s_rawMsgBundle.getMessage("1072", true, args);
            throw new ConfigurationException(msg);
        }
    }

    public int isListenerRunning(String instance) throws ListenerException, ConfigurationException {
        ParallelServerConfig config = null;
        try {
            config = this.getConfiguration();
        }
        catch (ConfigurationException e) {
            Trace.out("isListenerRunning: Could not get configuration");
            Trace.out(e);
            throw e;
        }
        String nodeName = null;
        if (this.instanceExists(config, instance)) {
            nodeName = config.getNode(instance);
        }
        Command[] remoteCommands = new RemoteCommand[1];
        Trace.out("isListenerRunning: oracle home is " + config.getOracleHome());
        String[] env = this.instEnviron(config, instance);
        CheckListenerOperation checkListenerOperation = new CheckListenerOperation(instance, config.getOracleHome(), env, this.m_version);
        try {
            remoteCommands[0] = new RemoteCommand(nodeName, checkListenerOperation);
        }
        catch (ClusterException e) {
            Object[] args = new Object[]{instance, nodeName};
            String msg = s_opsMsgBundle.getMessage("1040", true, args);
            throw new ListenerException(msg, e.getMessage());
        }
        ClusterCmd clusterCmd = new ClusterCmd();
        try {
            Trace.out("isListenerRunning: submitting remote commands");
            clusterCmd.submit(remoteCommands);
            Trace.out("isListenerRunning: submited");
        }
        catch (ClusterException ce) {
            Trace.out("Could not submit" + ce.getMessage());
        }
        boolean status = true;
        StringBuffer s = new StringBuffer();
        CheckListenerResult listenerResult = null;
        try {
            listenerResult = (CheckListenerResult)((RemoteCommand)remoteCommands[0]).getOperationResult();
        }
        catch (ClusterException e) {
            Object[] args = new Object[]{instance, nodeName};
            String msg = s_opsMsgBundle.getMessage("1040", true, args);
            throw new ListenerException(msg, e.getMessage());
        }
        if (listenerResult.getStatus() != 0) {
            status = false;
        }
        s.append(listenerResult.getErrorMsg() + " ");
        if (!status) {
            Object[] args = new Object[]{instance, nodeName};
            String msg = s_opsMsgBundle.getMessage("1040", true, args);
            throw new ListenerException(msg, s.toString());
        }
        return listenerResult.getRunningStatus();
    }

    private boolean startListener(String instance, boolean forceFlag, boolean forceSpecified) throws ConfigurationException, ListenerException {
        String nodeName = null;
        String[] listenerNames = null;
        ParallelServerConfig config = this.getConfiguration();
        if (config == null) {
            return false;
        }
        if (instance == null) {
            Trace.out("instance name passed was null");
            throw new ConfigurationException();
        }
        nodeName = null;
        if (this.instanceExists(config, instance)) {
            nodeName = config.getNode(instance);
        }
        if (nodeName == null) {
            throw new ConfigurationException();
        }
        if (!forceFlag && this.isListenerRunning(instance) == 1) {
            Trace.out("listener for instance " + instance + " is already running");
            return true;
        }
        String[] env = this.instEnviron(config, instance);
        try {
            listenerNames = this.getListeners(instance);
        }
        catch (Exception e) {
            Trace.out(e);
            Object[] args = new Object[]{instance, nodeName};
            String msg = s_opsMsgBundle.getMessage("1011", true, args);
            throw new ListenerException(msg);
        }
        Command[] remoteCommands = new RemoteCommand[listenerNames.length];
        try {
            for (int i = 0; i < listenerNames.length; ++i) {
                StartListenerOperation startListenerOperation = null;
                startListenerOperation = forceSpecified ? new StartListenerOperation(listenerNames[i], config.getOracleHome(), forceFlag, this.m_version) : new StartListenerOperation(listenerNames[i], config.getOracleHome(), this.m_version);
                startListenerOperation.setEnvironment(env);
                remoteCommands[i] = new RemoteCommand(nodeName, startListenerOperation);
            }
        }
        catch (ClusterException e) {
            Trace.out("startListener: cannot create cmd for node " + nodeName);
            Trace.out(e);
            Object[] args = new Object[]{instance, nodeName};
            String msg = s_opsMsgBundle.getMessage("1008", true, args);
            throw new ListenerException(msg, e.getMessage());
        }
        ClusterCmd clusterCmd = new ClusterCmd();
        try {
            clusterCmd.submit(remoteCommands);
        }
        catch (ClusterException ce) {
            Trace.out("Could not submit" + ce.getMessage());
        }
        boolean status = true;
        StringBuffer s = new StringBuffer();
        for (int j = 0; j < remoteCommands.length; ++j) {
            String[] outputs;
            StartListenerResult listenerResult = null;
            try {
                listenerResult = (StartListenerResult)((RemoteCommand)remoteCommands[j]).getOperationResult();
            }
            catch (ClusterException e) {
                Trace.out("startListener: cannot get result");
                Trace.out(e);
                Object[] args = new Object[]{instance, nodeName};
                String msg = s_opsMsgBundle.getMessage("1008", true, args);
                throw new ListenerException(msg, e.getMessage());
            }
            if (listenerResult.getStatus() != 0) {
                status = false;
            }
            if ((outputs = listenerResult.getOutput()) == null) continue;
            for (int k = 0; k < outputs.length; ++k) {
                if (!outputs[k].trim().startsWith("TNS-")) continue;
                s.append(outputs[k].trim() + s_newline);
            }
        }
        if (!status) {
            Object[] args = new Object[]{instance, nodeName};
            String msg = s_opsMsgBundle.getMessage("1008", true, args);
            throw new ListenerException(msg, s.toString().trim());
        }
        return true;
    }

    public boolean startListener(String instance) throws ConfigurationException, ListenerException {
        return this.startListener(instance, false, false);
    }

    public boolean reloadListener() throws ConfigurationException, ListenerException {
        Trace.out("ParallelServer.java:Inside ReloadListener");
        ParallelServerConfig config = this.getConfiguration();
        if (config == null) {
            return false;
        }
        Vector instanceVector = config.getInstances();
        int count = 0;
        String[] instanceNames = config.enumerateInstances();
        String[][] listeners = new String[instanceNames.length][];
        for (int i = 0; i < instanceNames.length; ++i) {
            Trace.out("ParallelServer.java:StartListener: trying to get listeners for instance " + instanceNames[i]);
            listeners[i] = this.getListeners(instanceNames[i]);
            Trace.out("ParallelServer.java:StartListener: count = " + (count += listeners[i].length));
        }
        Command[] remoteCommands = new RemoteCommand[count];
        String nodeName = null;
        try {
            int k = 0;
            for (int i = 0; i < instanceNames.length; ++i) {
                if (this.instanceExists(config, instanceNames[i])) {
                    nodeName = config.getNode(instanceNames[i]);
                }
                for (int j = 0; j < listeners[i].length; ++j) {
                    Trace.out("Creating StartListenerOperation  i = " + i + " for listener  :" + listeners[i][j]);
                    ReloadListenerOperation op = new ReloadListenerOperation(listeners[i][j], config.getOracleHome(), this.m_version);
                    op.setEnvironment(this.instEnviron(config, instanceNames[i]));
                    remoteCommands[k++] = new RemoteCommand(nodeName, op);
                }
            }
            Trace.out("ParallelServer.startListener: Created StartListener Objects");
        }
        catch (ClusterException e) {
            Trace.out("startListener: cannot create cmd for node " + nodeName);
            Trace.out(e);
            Object[] args = new Object[]{this.m_spName};
            String msg = s_opsMsgBundle.getMessage("1007", true, args);
            throw new ListenerException(msg, e.getMessage());
        }
        Trace.out("Submitting startListener Commands");
        ClusterCmd clusterCmd = new ClusterCmd();
        try {
            clusterCmd.submit(remoteCommands);
        }
        catch (ClusterException ce) {
            Trace.out("Could not submit" + ce.getMessage());
        }
        boolean status = true;
        StringBuffer s = new StringBuffer();
        for (int j = 0; j < remoteCommands.length; ++j) {
            ReloadListenerResult listenerResult = null;
            try {
                listenerResult = (ReloadListenerResult)((RemoteCommand)remoteCommands[j]).getOperationResult();
            }
            catch (ClusterException e) {
                Trace.out("startListener: cannot get result");
                Trace.out(e);
                Object[] args = new Object[]{this.m_spName};
                String msg = s_opsMsgBundle.getMessage("1007", true, args);
                throw new ListenerException(msg, e.getMessage());
            }
            if (listenerResult.getStatus() != 0) {
                status = false;
            }
            s.append(listenerResult.getOutput() + " ");
        }
        if (!status) {
            Object[] args = new Object[]{this.m_spName};
            String msg = s_opsMsgBundle.getMessage("1007", true, args);
            throw new ListenerException(msg, s.toString());
        }
        return true;
    }

    protected boolean instanceExists(ParallelServerConfig config, String instance) throws ConfigurationException {
        boolean instanceExist = false;
        if (instance == null) {
            Trace.out("instance name passed was null");
            throw new ConfigurationException(s_opsMsgBundle.getMessage("1076", true));
        }
        if (config == null) {
            Trace.out("config passed was null");
            Object[] args = new String[]{this.m_spName};
            throw new ConfigurationException(s_opsMsgBundle.getMessage("1000", true, args));
        }
        String[] existingInstances = config.enumerateInstances();
        for (int i = 0; i < existingInstances.length; ++i) {
            if (!instance.equalsIgnoreCase(existingInstances[i])) continue;
            instanceExist = true;
        }
        if (!instanceExist) {
            Object[] args = new Object[]{instance};
            String msg = s_opsMsgBundle.getMessage("1003", true, args);
            Trace.out("The instance " + instance + " does not exist in the configuration");
            throw new ConfigurationException(msg);
        }
        return instanceExist;
    }

    public boolean reloadListener(String instance) throws ConfigurationException, ListenerException {
        String nodeName = null;
        String[] listenerNames = null;
        ParallelServerConfig config = this.getConfiguration();
        if (config == null) {
            throw new ConfigurationException();
        }
        if (instance == null) {
            Trace.out("reloadListener: cannot start a listener for instance named null");
            Object[] args = new Object[]{instance, nodeName};
            String msg = s_opsMsgBundle.getMessage("1008", true, args);
            throw new ListenerException(msg);
        }
        if (this.instanceExists(config, instance)) {
            nodeName = config.getNode(instance);
        }
        String[] env = this.instEnviron(config, instance);
        try {
            listenerNames = this.getListeners(instance);
        }
        catch (ListenerException e) {
            Trace.out(e);
            Object[] args = new Object[]{instance, nodeName};
            String msg = s_opsMsgBundle.getMessage("1011", true, args);
            throw new ListenerException(msg);
        }
        Command[] remoteCommands = new RemoteCommand[listenerNames.length];
        try {
            for (int i = 0; i < listenerNames.length; ++i) {
                ReloadListenerOperation reloadListenerOperation = null;
                reloadListenerOperation = new ReloadListenerOperation(listenerNames[i], config.getOracleHome(), this.m_version);
                reloadListenerOperation.setEnvironment(env);
                remoteCommands[i] = new RemoteCommand(nodeName, reloadListenerOperation);
            }
        }
        catch (ClusterException e) {
            Trace.out("reloadListener: cannot create cmd for node " + nodeName);
            Trace.out(e);
            Object[] args = new Object[]{instance, nodeName};
            String msg = s_opsMsgBundle.getMessage("1008", true, args);
            throw new ListenerException(msg, e.getMessage());
        }
        ClusterCmd clusterCmd = new ClusterCmd();
        try {
            clusterCmd.submit(remoteCommands);
        }
        catch (ClusterException ce) {
            Trace.out("Could not submit" + ce.getMessage());
        }
        boolean status = true;
        StringBuffer s = new StringBuffer();
        for (int j = 0; j < remoteCommands.length; ++j) {
            ReloadListenerResult listenerResult = null;
            try {
                listenerResult = (ReloadListenerResult)((RemoteCommand)remoteCommands[j]).getOperationResult();
            }
            catch (ClusterException e) {
                Trace.out("reloadListener: cannot get result");
                Trace.out(e);
                Object[] args = new Object[]{instance, nodeName};
                String msg = s_opsMsgBundle.getMessage("1008", true, args);
                throw new ListenerException(msg, e.getMessage());
            }
            if (listenerResult.getStatus() != 0) {
                status = false;
            }
            s.append(listenerResult.getOutput() + " ");
        }
        if (!status) {
            Object[] args = new Object[]{instance, nodeName};
            String msg = s_opsMsgBundle.getMessage("1008", true, args);
            throw new ListenerException(msg, s.toString());
        }
        return true;
    }

    public boolean startListener(String instance, boolean forceFlag) throws ConfigurationException, ListenerException {
        return this.startListener(instance, forceFlag, true);
    }

    private boolean stopListener(String instance, boolean forceFlag, boolean forceSpecified) throws ConfigurationException, ListenerException {
        Trace.out("Instance Name passed to stopListener is " + instance);
        ParallelServerConfig config = this.getConfiguration();
        if (config == null) {
            return false;
        }
        String nodeName = null;
        if (this.instanceExists(config, instance)) {
            nodeName = config.getNode(instance);
        }
        Trace.out("ParallelServer.stopListener: The nodeName for instance " + instance + " is " + nodeName);
        if (nodeName == null) {
            Trace.out("ParallelServer.stopListener: Null Node obtained from ParallelServerConfig for instance " + instance);
            Trace.out("Please check whether the instance name exists in the raw device configuration");
            throw new ConfigurationException();
        }
        String[] env = this.instEnviron(config, instance);
        String[] listenerNames = this.getListeners(instance);
        Command[] remoteCommands = new RemoteCommand[listenerNames.length];
        try {
            for (int i = 0; i < listenerNames.length; ++i) {
                StopListenerOperation stopListenerOperation = null;
                stopListenerOperation = forceSpecified ? new StopListenerOperation(listenerNames[i], forceFlag, this.m_version) : new StopListenerOperation(listenerNames[i], this.m_version);
                stopListenerOperation.setOracleHome(config.getOracleHome());
                stopListenerOperation.setEnvironment(env);
                remoteCommands[i] = new RemoteCommand(nodeName, stopListenerOperation);
            }
        }
        catch (ClusterException e) {
            Trace.out("stopListener: cannot create cmd for node " + nodeName);
            Trace.out(e);
            Object[] args = new Object[]{instance, nodeName};
            String msg = s_opsMsgBundle.getMessage("1010", true, args);
            throw new ListenerException(msg, e.getMessage());
        }
        ClusterCmd clusterCmd = new ClusterCmd();
        try {
            clusterCmd.submit(remoteCommands);
        }
        catch (ClusterException ce) {
            Trace.out("Could not submit" + ce.getMessage());
        }
        boolean status = false;
        StringBuffer s = new StringBuffer();
        for (int j = 0; j < remoteCommands.length; ++j) {
            StopListenerResult listenerResult = null;
            try {
                listenerResult = (StopListenerResult)((RemoteCommand)remoteCommands[j]).getOperationResult();
            }
            catch (ClusterException e) {
                Trace.out("stopListener: cannot get result");
                Trace.out(e);
                Object[] args = new Object[]{instance, nodeName};
                String msg = s_opsMsgBundle.getMessage("1010", true, args);
                throw new ListenerException(msg, e.getMessage());
            }
            if (listenerResult.getStatus() == 0) {
                status = true;
            }
            s.append(listenerResult.getOutput() + " ");
        }
        if (!status) {
            Object[] args = new Object[]{instance, nodeName};
            String msg = s_opsMsgBundle.getMessage("1010", true, args);
            throw new ListenerException(msg, s.toString());
        }
        return true;
    }

    public boolean stopListener(String instance, boolean forceFlag) throws ConfigurationException, ListenerException {
        if (instance == null) {
            Trace.out("ParallelServer.stopListener:Passed instance name is null..ERROR");
            throw new ListenerException();
        }
        return this.stopListener(instance, forceFlag, true);
    }

    public boolean stopListener(String instance) throws ConfigurationException, ListenerException {
        if (instance == null) {
            Trace.out("ParallelServer.stopListener:Passed instance name is null..ERROR");
            throw new ListenerException();
        }
        return this.stopListener(instance, false, false);
    }

    public boolean startListener() throws ConfigurationException, ListenerException {
        Trace.out("ParallelServer.java:StarListener...NEW...Inside StartListener");
        ParallelServerConfig config = this.getConfiguration();
        if (config == null) {
            return false;
        }
        Vector instanceVector = config.getInstances();
        int count = 0;
        String[] instanceNames = config.enumerateInstances();
        String[][] listeners = new String[instanceNames.length][];
        Vector<String> toNotify = new Vector<String>();
        String node = null;
        for (int i = 0; i < instanceNames.length; ++i) {
            int lsnrRunning;
            if (this.instanceExists(config, instanceNames[i])) {
                node = config.getNode(instanceNames[i]);
            }
            toNotify.addElement(node);
            this.notifyEvent(new ActionEvent(this, 2003, node, i));
            try {
                lsnrRunning = this.isListenerRunning(instanceNames[i]);
            }
            catch (ListenerException e) {
                this.notifyEventAll(toNotify, 2007, 4);
                throw e;
            }
            if (lsnrRunning == 1) {
                Trace.out("listener for instance " + instanceNames[i] + " is already running. continue to the next instance ..");
                listeners[i] = null;
                toNotify.removeElement(node);
                this.notifyEvent(new ActionEvent(this, 2005, node, i, 2006, 1));
                continue;
            }
            Trace.out("ParallelServer.java:StartListener: trying to get listeners for instance " + instanceNames[i]);
            listeners[i] = this.getListeners(instanceNames[i]);
            Trace.out("ParallelServer.java:StartListener: count = " + (count += listeners[i].length));
        }
        Command[] remoteCommands = new RemoteCommand[count];
        String nodeName = null;
        try {
            int k = 0;
            for (int i = 0; i < instanceNames.length; ++i) {
                if (this.instanceExists(config, instanceNames[i])) {
                    nodeName = config.getNode(instanceNames[i]);
                }
                if (listeners[i] == null) continue;
                for (int j = 0; j < listeners[i].length; ++j) {
                    Trace.out("Creating StartListenerOperation  i = " + i + " for listener  :" + listeners[i][j]);
                    StartListenerOperation op = new StartListenerOperation(listeners[i][j], config.getOracleHome(), this.m_version);
                    op.setEnvironment(this.instEnviron(config, instanceNames[i]));
                    remoteCommands[k++] = new RemoteCommand(nodeName, op);
                }
            }
            Trace.out("ParallelServer.startListener: Created StartListener Objects");
        }
        catch (ClusterException e) {
            Trace.out("startListener: cannot create cmd for node " + nodeName);
            Trace.out(e);
            this.notifyEventAll(toNotify, 2007, 4);
            Object[] args = new Object[]{this.m_spName};
            String msg = s_opsMsgBundle.getMessage("1007", true, args);
            throw new ListenerException(msg, e.getMessage());
        }
        if (count == 0) {
            Trace.out("Nothing to submit");
            return true;
        }
        Trace.out("Submitting startListener Commands");
        ClusterCmd clusterCmd = new ClusterCmd();
        try {
            clusterCmd.submit(remoteCommands);
        }
        catch (ClusterException ce) {
            Trace.out("Could not submit" + ce.getMessage());
        }
        boolean status = true;
        StringBuffer s = new StringBuffer();
        for (int j = 0; j < remoteCommands.length; ++j) {
            String[] outputs;
            StartListenerResult listenerResult = null;
            try {
                listenerResult = (StartListenerResult)((RemoteCommand)remoteCommands[j]).getOperationResult();
            }
            catch (ClusterException e) {
                Trace.out("startListener: cannot get result");
                Trace.out(e);
                this.notifyEventAll(toNotify, 2007, 4);
                Object[] args = new Object[]{this.m_spName};
                String msg = s_opsMsgBundle.getMessage("1007", true, args);
                throw new ListenerException(msg, e.getMessage());
            }
            if (listenerResult.getStatus() != 0) {
                status = false;
            }
            if ((outputs = listenerResult.getOutput()) == null) continue;
            for (int k = 0; k < outputs.length; ++k) {
                if (!outputs[k].trim().startsWith("TNS-")) continue;
                s.append(outputs[k].trim() + s_newline);
            }
        }
        if (!status) {
            this.notifyEventAll(toNotify, 2007, 4);
            Object[] args = new Object[]{this.m_spName};
            String msg = s_opsMsgBundle.getMessage("1007", true, args);
            throw new ListenerException(msg, s.toString().trim());
        }
        this.notifyEventAll(toNotify, 2006, 1);
        return true;
    }

    public boolean stopListener() throws ConfigurationException, ListenerException {
        ParallelServerConfig config = this.getConfiguration();
        if (config == null) {
            return false;
        }
        Vector instanceVector = config.getInstances();
        int count = 0;
        String[] instanceNames = config.enumerateInstances();
        String[][] listeners = new String[instanceNames.length][];
        for (int i = 0; i < instanceNames.length; ++i) {
            Trace.out("ParallelServer.java:StopListener: trying to get listeners for instance " + instanceNames[i]);
            listeners[i] = this.getListeners(instanceNames[i]);
            Trace.out("ParallelServer.java:StopListener: count = " + (count += listeners[i].length));
        }
        Command[] remoteCommands = new RemoteCommand[count];
        String nodeName = null;
        try {
            int k = 0;
            for (int i = 0; i < instanceNames.length; ++i) {
                if (this.instanceExists(config, instanceNames[i])) {
                    nodeName = config.getNode(instanceNames[i]);
                }
                for (int j = 0; j < listeners[i].length; ++j) {
                    Trace.out("Creating StopListenerOperation for listener :" + listeners[i][j]);
                    StopListenerOperation op = new StopListenerOperation(listeners[i][j], this.m_version);
                    op.setOracleHome(config.getOracleHome());
                    op.setEnvironment(this.instEnviron(config, instanceNames[i]));
                    remoteCommands[k++] = new RemoteCommand(nodeName, op);
                }
            }
        }
        catch (ClusterException e) {
            Trace.out("stopListener: cannot create cmd for node " + nodeName);
            Trace.out(e);
            Object[] args = new Object[]{this.m_spName};
            String msg = s_opsMsgBundle.getMessage("1009", true, args);
            throw new ListenerException(msg, e.getMessage());
        }
        ClusterCmd clusterCmd = new ClusterCmd();
        try {
            clusterCmd.submit(remoteCommands);
        }
        catch (ClusterException ce) {
            Trace.out("Could not submit" + ce.getMessage());
        }
        boolean status = true;
        StringBuffer s = new StringBuffer();
        for (int j = 0; j < remoteCommands.length; ++j) {
            StopListenerResult listenerResult = null;
            try {
                listenerResult = (StopListenerResult)((RemoteCommand)remoteCommands[j]).getOperationResult();
            }
            catch (ClusterException e) {
                Trace.out("stopListener: cannot get result");
                Trace.out(e);
                Object[] args = new Object[]{this.m_spName};
                String msg = s_opsMsgBundle.getMessage("1009", true, args);
                throw new ListenerException(msg, e.getMessage());
            }
            if (listenerResult.getStatus() != 0) {
                status = false;
            }
            s.append(listenerResult.getOutput() + " ");
        }
        if (!status) {
            Object[] args = new Object[]{this.m_spName};
            String msg = s_opsMsgBundle.getMessage("1009", true, args);
            throw new ListenerException(msg, s.toString());
        }
        return true;
    }

    public String[] getListeners(String instanceName) throws ListenerException {
        ParallelServerConfig parallelServerConfig = null;
        try {
            parallelServerConfig = this.getConfiguration();
        }
        catch (Exception e) {
            Trace.out("Could not get OPS config " + e.getMessage());
            return null;
        }
        Command[] remoteCommand = new RemoteCommand[1];
        String nodeName = null;
        try {
            if (this.instanceExists(parallelServerConfig, instanceName)) {
                nodeName = parallelServerConfig.getNode(instanceName);
            }
        }
        catch (ConfigurationException ce) {
            throw new ListenerException(ce.getMessage());
        }
        if (nodeName == null) {
            Trace.out("ParallelServer.getListener: Error getting the node name from ParallelServerConfig " + nodeName);
            Trace.out("ParallelServer.getListeners: The nodename associated with instance " + instanceName + "is null, please make sure that raw device configuration information has this instance name in there");
            throw new ListenerException();
        }
        try {
            remoteCommand[0] = new RemoteCommand(nodeName, new GetListenerOperation(instanceName, parallelServerConfig.getOracleHome(), this.m_version));
        }
        catch (ClusterException e) {
            Trace.out("getListeners: cannot create cmd for node " + nodeName);
            Trace.out(e);
            Object[] args = new Object[]{instanceName, nodeName};
            String msg = s_opsMsgBundle.getMessage("1011", true, args);
            throw new ListenerException(msg);
        }
        ClusterCmd clusterCmd = new ClusterCmd();
        try {
            clusterCmd.submit(remoteCommand);
        }
        catch (ClusterException ce) {
            Trace.out("Could not submit" + ce.getMessage());
        }
        boolean status = true;
        GetListenerResult listenerResult = null;
        try {
            listenerResult = (GetListenerResult)((RemoteCommand)remoteCommand[0]).getOperationResult();
        }
        catch (ClusterException e) {
            Trace.out("getListeners: cannot get result");
            Trace.out(e);
            Object[] args = new Object[]{instanceName, nodeName};
            String msg = s_opsMsgBundle.getMessage("1011", true, args);
            throw new ListenerException(msg);
        }
        if (listenerResult.getStatus() != 0) {
            Object[] args = new Object[]{instanceName, nodeName};
            String msg = s_opsMsgBundle.getMessage("1011", true, args);
            throw new ListenerException(msg);
        }
        String[] listenerNames = listenerResult.getListenerNames();
        if (listenerNames == null || listenerNames.length == 0) {
            Object[] args = new Object[]{instanceName, nodeName};
            String msg = s_opsMsgBundle.getMessage("1011", true, args);
            throw new ListenerException(msg);
        }
        return listenerNames;
    }

    public String getDefaultServiceName() throws DatabaseException {
        try {
            String svcName = this.m_ocrTree.getKeyValue(this.m_ocrTree.getTreeDefinition().getDBKey(this.m_spName));
            String dbDomain = this.m_ocrTree.getKeyValue(this.m_ocrTree.getTreeDefinition().getDBDomainKey(this.m_spName));
            if (svcName == null) {
                svcName = this.m_ocrTree.getKeyValue(((OCRTreeDefinitionHA)this.m_ocrTree.getTreeDefinition()).getDBNameKey(this.m_spName));
            }
            if (dbDomain != null && dbDomain.length() > 0) {
                svcName = svcName + "." + dbDomain;
            }
            Trace.out("default service name is " + svcName);
            return svcName;
        }
        catch (OCRException e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    public String getNode(String instanceName) throws InstanceException {
        try {
            String node = this.m_ocrTree.getKeyValue(this.m_ocrTree.getTreeDefinition().getInstanceNodeKey(this.m_spName, instanceName));
            Trace.out("instance=" + instanceName + " node=" + node);
            return node;
        }
        catch (OCRException e) {
            throw new InstanceException(e.getMessage());
        }
    }

    public void removeServiceAttractors() throws DatabaseException {
    }

    public boolean createOracleService(String sid, String nodeName) throws OracleServiceException {
        ParallelServerConfig config;
        boolean retValue = false;
        if (new SystemFactory().CreateSystem().isUnixSystem()) {
            return false;
        }
        if (nodeName == null || nodeName.trim().length() == 0) {
            Trace.out("ParallelServer.createOracleService: Null passed for nodename");
            throw new OracleServiceException(MessageBundle.getMessageBundle("Prkc").getMessage("1045", true));
        }
        if (sid == null || sid.trim().length() == 0) {
            Trace.out("ParallelServer.createOracleService: Null passed for sid");
            throw new OracleServiceException(s_opsMsgBundle.getMessage("1076", true));
        }
        try {
            config = this.getConfiguration();
        }
        catch (ConfigurationException e) {
            throw new OracleServiceException(e.getMessage());
        }
        String oracleHome = config.getOracleHome();
        if (oracleHome == null) {
            Trace.out("ParallelServer.createOracleService: oracleHome is null for the cluster database " + this.m_spName);
            Object[] args = new String[]{this.m_spName};
            throw new OracleServiceException(s_opsMsgBundle.getMessage("1077", true, args));
        }
        CreateOracleServiceOperation createOperation = new CreateOracleServiceOperation(oracleHome, sid);
        RemoteCommand remoteCommand = null;
        try {
            remoteCommand = new RemoteCommand(nodeName, createOperation);
        }
        catch (ClusterException e) {
            Trace.out("ParallelServer.createOracleService: Couldnt create new remoteCommand");
            Trace.out(e);
            throw new OracleServiceException(e.getMessage());
        }
        remoteCommand.execute();
        OperationResult result = null;
        try {
            result = remoteCommand.getOperationResult();
        }
        catch (ClusterException e) {
            Trace.out("ParallelServer.createOracleService: can't get result");
            Trace.out(e);
            throw new OracleServiceException(e.getMessage());
        }
        if (result.getStatus() != 0) {
            Trace.out("ParallelServer.createOracleService failed: " + result.getStatus());
            retValue = false;
        } else {
            retValue = true;
        }
        return retValue;
    }

    public boolean deleteOracleService(String sid, String nodeName) throws OracleServiceException {
        ParallelServerConfig config;
        boolean retValue = false;
        if (new SystemFactory().CreateSystem().isUnixSystem()) {
            return false;
        }
        if (nodeName == null || nodeName.trim().length() == 0) {
            Trace.out("ParallelServer.deleteOracleService: Null passed for nodename");
            throw new OracleServiceException(MessageBundle.getMessageBundle("Prkc").getMessage("1045", true));
        }
        if (sid == null || sid.trim().length() == 0) {
            Trace.out("ParallelServer.deleteOracleService: Null passed for sid");
            throw new OracleServiceException(s_opsMsgBundle.getMessage("1076", true));
        }
        try {
            config = this.getConfiguration();
        }
        catch (ConfigurationException e) {
            throw new OracleServiceException(e.getMessage());
        }
        String oracleHome = config.getOracleHome();
        if (oracleHome == null) {
            Trace.out("ParallelServer.deleteOracleService: oracleHome is null for the cluster database " + this.m_spName);
            Object[] args = new String[]{this.m_spName};
            throw new OracleServiceException(s_opsMsgBundle.getMessage("1077", true, args));
        }
        DeleteOracleServiceOperation deleteOperation = new DeleteOracleServiceOperation(oracleHome, sid);
        RemoteCommand remoteCommand = null;
        try {
            remoteCommand = new RemoteCommand(nodeName, deleteOperation);
        }
        catch (ClusterException e) {
            Trace.out("ParallelServer.deleteOracleService: Couldnt create new remoteCommand");
            Trace.out(e);
            throw new OracleServiceException(e.getMessage());
        }
        remoteCommand.execute();
        OperationResult result = null;
        try {
            result = remoteCommand.getOperationResult();
        }
        catch (ClusterException e) {
            Trace.out("ParallelServer.deleteOracleService: can't get result");
            Trace.out(e);
            throw new OracleServiceException(e.getMessage());
        }
        if (result.getStatus() != 0) {
            Trace.out("ParallelServer.deleteOracleService failed: " + result.getStatus());
            retValue = false;
        } else {
            retValue = true;
        }
        return retValue;
    }

    public void modifyDatabase(String dbName, String ohome, String domain, String spfile, String role, String startOpt) throws DatabaseException {
    }

    public void modifyDatabase(String dbName, String ohome, String domain, String spfile, String role, String startOpt, String policy) throws DatabaseException {
    }

    public void enable() throws DatabaseException {
    }

    public void enable(String instanceName) throws InstanceException {
    }

    public void enable(String[] instanceNames) throws InstanceException {
    }

    public void disable() throws DatabaseException {
    }

    public void disable(String instanceName) throws InstanceException {
    }

    public void disable(String[] instanceNames) throws InstanceException {
    }

    public boolean isEnabled() throws DatabaseException {
        return false;
    }

    public boolean isEnabled(String instanceName) throws InstanceException {
        return true;
    }

    public void removeInstance(String instName, boolean force) throws ConfigurationException, InstanceException {
        String msg;
        Object[] args;
        StringBuffer stagedExceptionMesg = new StringBuffer();
        if (!this.isDomainMatch()) {
            args = new Object[]{instName, this.m_spName, s_rawMsgBundle.getMessage("1066", false)};
            msg = s_rawMsgBundle.getMessage("1009", true, args);
            Trace.out("deleteInstance: msg=" + msg);
            if (force) {
                stagedExceptionMesg.append(msg);
            } else {
                throw new ConfigurationException(msg);
            }
        }
        try {
            if (instName == null || instName.trim().length() == 0 || !this.m_ocrTree.keyExists(this.m_ocrTree.getTreeDefinition().getDBInstanceNameKey(this.m_spName, instName))) {
                args = new String[]{instName, this.m_spName};
                msg = s_opsMsgBundle.getMessage("1082", true, args);
                if (stagedExceptionMesg.length() > 0) {
                    msg = msg + s_newline + stagedExceptionMesg.toString();
                }
                throw new ConfigurationException(msg);
            }
            this.m_ocrTree.removeInstance(this.m_spName, instName);
        }
        catch (OCRException oe) {
            Object[] args2 = new Object[]{instName, this.m_spName, oe.getMessage()};
            String msg2 = s_rawMsgBundle.getMessage("1009", true, args2);
            if (stagedExceptionMesg.length() > 0) {
                msg2 = msg2 + s_newline + stagedExceptionMesg.toString();
            }
            throw new ConfigurationException(msg2);
        }
    }

    public void remove(boolean force) throws DatabaseException {
        StringBuffer stagedExceptionMesg;
        block7: {
            stagedExceptionMesg = new StringBuffer();
            try {
                if (this.isDomainMatch()) break block7;
                Object[] args = new Object[]{this.m_spName, s_rawMsgBundle.getMessage("1066", false)};
                String msg = s_rawMsgBundle.getMessage("1006", true, args);
                Trace.out("delete: msg=" + msg);
                if (force) {
                    stagedExceptionMesg.append(msg);
                    break block7;
                }
                throw new DatabaseException(msg);
            }
            catch (ConfigurationException e) {
                if (force) {
                    stagedExceptionMesg.append(s_newline + e.getMessage());
                }
                throw new DatabaseException(e.getMessage());
            }
        }
        try {
            this.m_ocrTree.removeDBConfiguration(this.m_spName);
        }
        catch (OCRException oe) {
            Object[] args = new Object[]{this.m_spName, oe.getMessage()};
            String msg = s_rawMsgBundle.getMessage("1006", true, args);
            if (stagedExceptionMesg.length() > 0) {
                msg = msg + s_newline + stagedExceptionMesg.toString();
            }
            throw new DatabaseException(msg);
        }
    }

    public String[] isRunningInstances(String[] insts, boolean displayDisabled) throws DatabaseException {
        return new String[0];
    }

    protected boolean isDomainMatch() throws ConfigurationException {
        return true;
    }

    protected boolean isDomainMatch(String savedDomain) {
        return true;
    }

    public void addEventListener(ActionListener evLsnr) {
        this.m_actionEventListener = (ActionListener)RemoteResponseEventMulticaster.add(evLsnr, this.m_actionEventListener);
        if (this.m_actionEventListener == null) {
            Trace.out("register srvctl event listener");
            this.m_actionEventListener = evLsnr;
        } else {
            Trace.out("srvctl event listener already registered");
        }
    }

    protected void notifyEvent(ActionEvent ev) {
        if (this.m_actionEventListener == null) {
            Trace.out("no registered srvctl event listener. do nothing.");
            return;
        }
        this.m_actionEventListener.performEvent(ev);
    }

    protected void notifyEventAll(Vector nodes, int opResult, int stageState) {
        Trace.out("notify all events");
        for (int k = 0; k < nodes.size(); ++k) {
            this.notifyEvent(new ActionEvent(this, 2005, (String)nodes.elementAt(k), k, opResult, stageState));
        }
        nodes.removeAllElements();
    }
}

