/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.daemon;

import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.GetActiveNodes;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.daemon.OPSMDaemonI;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.monitor.MonitorFactory;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.operation.Operation;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.rawdevice.OCRTree;
import oracle.ops.mgmt.security.DaemonSecurityManager;
import oracle.ops.mgmt.security.NullSecurityManager;
import oracle.ops.mgmt.security.SecurityHelper;
import oracle.ops.mgmt.synchronize.BinarySemaphore;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

class OPSMDaemon
extends UnicastRemoteObject
implements OPSMDaemonI {
    public static String s_nodeName = null;
    public static int s_portNum = Integer.parseInt("2006");
    private static final int CHECKING_INTERVAL = 10000;
    private static final int CHECKER_TIMEOUT = 1000;
    private static final int BIND_RETRY_ATTEMPTS = 10;
    private static final int MAX_GROUPNAME_LEN = 13;
    private static String s_traceFileName = null;
    private static String s_groupName = "opsm";
    private static String s_9coordGroupName = "opsmCoord";
    private static String s_bindString = null;
    private static boolean s_tracingOn = false;
    private static MessageBundle s_msgBundle = MessageBundle.getMessageBundle("Prkn");
    private Version m_myVersion = Version.get92Version();
    private Hashtable m_executorThreadTable = new Hashtable();
    private ClusterUtil m_clusterUtil;
    private MonitorFactory m_monitorFactory = null;
    private boolean m_stopDaemonSignal = false;
    private GetActiveNodes m_activeNodes = null;
    private Thread m_coordinatorChecker;
    private OCRTree m_ocrTree = null;

    public OPSMDaemon() throws RemoteException {
        try {
            this.m_clusterUtil = new ClusterUtil();
        }
        catch (ClusterUtilException cue) {
            throw new RemoteException(cue.getMessage());
        }
        try {
            this.m_activeNodes = GetActiveNodes.create();
        }
        catch (ClusterException ce) {
            Trace.out(ce.getMessage());
            throw new RemoteException(ce.getMessage());
        }
        try {
            s_nodeName = this.m_clusterUtil.getLocalNodeName();
        }
        catch (ClusterUtilException cue) {
            throw new RemoteException(cue.getMessage());
        }
        this.stop9iDaemons();
        try {
            this.m_ocrTree = OCRTree.init(this.m_myVersion);
        }
        catch (OCRException oe) {
            Trace.out("\n Could not initialize with OCR..This  is a fatal error");
            System.exit(1);
        }
        Trace.out("\n node name obtained is " + s_nodeName);
    }

    public void initializeWithCluster() throws ClusterException {
        try {
            this.m_clusterUtil.regInGroup(s_groupName, s_portNum);
        }
        catch (ClusterUtilException cue) {
            throw new ClusterException(cue.getMessage());
        }
        this.m_coordinatorChecker = new Thread((Runnable)new CoordinatorChecker(), "coordinator checker thread");
        this.m_coordinatorChecker.setDaemon(true);
    }

    public void startCoordinator() {
        this.m_coordinatorChecker.start();
    }

    public void createMonitor() {
        Trace.out("Creating Monitors");
        this.m_monitorFactory = new MonitorFactory();
    }

    public void startMonitor(String monitorName) {
        if (monitorName == null) {
            Trace.out("The monitorName is Null");
        }
        this.m_monitorFactory.startMonitor(monitorName);
    }

    @Override
    public String getCoordinator() throws RemoteException {
        return s_nodeName;
    }

    @Override
    public String getHostName() throws RemoteException {
        Trace.out("Received a getHostName request from client");
        Object status = null;
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
            Trace.out("Got hostname as " + hostName);
        }
        catch (Exception e) {
            Trace.out("Got exception " + e + " while trying to get local host name");
        }
        return hostName;
    }

    @Override
    public void stopDaemon() throws RemoteException {
        this.m_stopDaemonSignal = true;
        Trace.out("Killing self");
        System.exit(1);
    }

    @Override
    public OperationResult execute(Operation op) throws RemoteException, InterruptedException {
        String opName = op.getClass().getName();
        Trace.out("Execute Called");
        Trace.out("Executing the operation " + opName);
        OperationResult operationResult = null;
        Trace.out("My Version is :" + this.m_myVersion.toString());
        Trace.out("Version of the Operation is" + op.getVersion().toString());
        if (this.m_stopDaemonSignal) {
            operationResult = new OperationResult(2);
            Trace.out("Daemon is stopping. Could not run the operation");
            throw new RemoteException("Daemon is stopping.  Cannot execute the operation now");
        }
        try {
            operationResult = op.run();
        }
        catch (Exception e) {
            operationResult = new OperationResult(2);
            operationResult.setException(e);
            Trace.out("Could not run the operation");
            Trace.out(e);
            throw new RemoteException("Exception occurred while  trying to execute operation", e);
        }
        return operationResult;
    }

    private boolean isAnyRunningExecutorAlive() {
        Enumeration e = this.m_executorThreadTable.elements();
        while (e.hasMoreElements()) {
            Thread t = (Thread)e.nextElement();
            if (t.isAlive()) {
                Trace.out("In isAlive: " + t.getName());
                return true;
            }
            Trace.out(t.getName() + " IS DEAD");
        }
        return false;
    }

    private void acquire(BinarySemaphore s) {
        try {
            s.acquire();
        }
        catch (InterruptedException e) {
            Trace.out("\n Interrupted Exception caught in checker thread while trying to acquire semaphore");
        }
    }

    private void acquire(BinarySemaphore s, long msec) {
        try {
            s.acquire(msec);
        }
        catch (InterruptedException e) {
            Trace.out("\n Interrupted Exception caught in checker  thread while trying to acquire semaphore");
        }
    }

    private void release(BinarySemaphore s) {
        s.release();
    }

    private void stop9iDaemons() {
        Trace.out("Detecting and stopping 9i daemons");
        try {
            String[] old_daemons = this.m_clusterUtil.get9iDaemons(s_9coordGroupName);
            if (old_daemons != null) {
                for (int i = 0; i < old_daemons.length; ++i) {
                    Trace.out("FOUND LIVE 9i DAEMON" + old_daemons[i]);
                    OPSMDaemonI opsmDaemon = this.m_activeNodes.getReference(old_daemons[i]);
                    Trace.out("OPSMDaemonStopper: handle to 9i daemon" + old_daemons[i]);
                    try {
                        if (opsmDaemon == null) continue;
                        Trace.out("OPSMDaemonStopper: going to send stop signal  to daemon");
                        opsmDaemon.stopDaemon();
                        this.m_activeNodes.removeReference(old_daemons[i]);
                        Trace.out("OPSMDaemonStopper: Stopped OPSM daemon");
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception cue) {
            Trace.out(cue);
            System.exit(1);
        }
    }

    private static void getGSDEnv() {
        s_groupName = new String(System.getProperty("srvm.daemon.groupname", "opsm"));
        if (s_groupName.length() >= 13) {
            Trace.out(s_msgBundle.getMessage("1001", false));
            Trace.out("The groupname can have maximum of 11 characters, currently it has " + s_groupName.length() + " characters.");
            System.exit(1);
        }
    }

    private static void setTracing(String oracleHome) {
        s_tracingOn = Boolean.getBoolean("TRACING.ENABLED");
        int tracingLvl = Integer.parseInt(System.getProperty("TRACING.LEVEL", "16"), 10);
        String netNodeName = null;
        try {
            netNodeName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        Trace.out("got node name from the network: " + netNodeName);
        s_traceFileName = new String(System.getProperty("srvm.daemon.tracefile", oracleHome + File.separator + TRACE_FILE_LOC + File.separator + "gsdaemon" + "_" + netNodeName + ".log"));
        String packageNames = System.getProperty("TRACING.PACKAGE");
        Trace.out("tracing is " + s_tracingOn + "; at level " + tracingLvl);
        Trace.enableDebugTracing();
        if (s_tracingOn) {
            Trace.out("trace file is " + s_traceFileName);
            boolean succ = Trace.configure(true, true, false, true, s_traceFileName, true);
            if (!succ) {
                String fallBackTraceFile = File.separator + "tmp" + File.separator + "gsdaemon";
                Trace.out("fallback trace file is " + fallBackTraceFile);
                Trace.configure(true, true, false, true, fallBackTraceFile, true);
            }
        }
        Trace.traceEnabled(s_tracingOn);
        Trace.setTraceLevel(tracingLvl);
        boolean packageTracing = false;
        if (packageNames != null) {
            System.out.println("Package name is not null");
            packageTracing = true;
        }
        Trace.setPackageTracing(packageNames, packageTracing);
    }

    public static void main(String[] args) {
        OPSMDaemon opsmDaemon = null;
        String oracleHome = null;
        boolean bound = false;
        if (args.length == 1) {
            Trace.out("Daemon: argument is " + args[0]);
            oracleHome = args[0];
        }
        OPSMDaemon.getGSDEnv();
        OPSMDaemon.setTracing(oracleHome);
        Trace.out("Setting the security manager to Daemon Security manager");
        if (!new SystemFactory().CreateSystem().isUnixSystem()) {
            NullSecurityManager daemonSecurity = new NullSecurityManager();
            System.setSecurityManager(daemonSecurity);
        } else {
            SecurityHelper securityHelper = new SecurityHelper(oracleHome);
            DaemonSecurityManager daemonSecurity = new DaemonSecurityManager();
            daemonSecurity.setSecurityHelper(securityHelper);
            System.setSecurityManager(daemonSecurity);
        }
        try {
            opsmDaemon = new OPSMDaemon();
        }
        catch (Exception e) {
            Trace.out(e);
            Trace.out("Exiting from main..no point trying to start the daemon");
            System.exit(1);
        }
        Trace.out("Trying to bind the object now ");
        if (opsmDaemon != null) {
            Trace.out(" Object is not null");
            for (int i = 0; i < 10; ++i) {
                Trace.out(" Attempt no " + i);
                s_portNum += i;
                try {
                    if (Utils.isDevelopmentEnv()) {
                        s_nodeName = Utils.getLocalHost();
                    }
                }
                catch (UnknownHostException e) {
                    Trace.out(e);
                }
                s_bindString = "//" + s_nodeName + ":" + s_portNum + "/OPSMDaemon";
                try {
                    Trace.out("Binding: " + s_bindString);
                    Trace.out("Locating local registry server");
                    LocateRegistry.createRegistry(s_portNum);
                    Trace.out("\n  Created local registry ");
                    if (s_nodeName != null) {
                        Naming.bind(s_bindString, opsmDaemon);
                    }
                    Trace.out("\n Bound to local registry ");
                    bound = true;
                }
                catch (Exception e) {
                    Trace.out(e);
                }
                if (!bound) continue;
                try {
                    Trace.out("Calling initializeWithCluster");
                    opsmDaemon.initializeWithCluster();
                }
                catch (ClusterException ce) {
                    try {
                        Naming.unbind(s_bindString);
                    }
                    catch (NotBoundException nb) {
                        Trace.out("could not unbind the object");
                    }
                    catch (RemoteException rex) {
                        Trace.out("could not unbind the object");
                    }
                    catch (MalformedURLException me) {
                        Trace.out("could not unbind the object");
                    }
                    System.exit(1);
                }
                Trace.traceToStdOut("READY");
                Trace.traceToStdOut(System.getProperty("line.separator"));
                opsmDaemon.startCoordinator();
                Trace.out("Ready to receive client requests");
                break;
            }
        } else {
            System.exit(1);
        }
    }

    private class CoordinatorChecker
    implements Runnable {
        CoordinatorChecker() {
        }

        @Override
        public void run() {
            try {
                OPSMDaemon.this.m_clusterUtil.pollCSSGroup(s_groupName);
            }
            catch (ClusterUtilException cue) {
                Trace.out((Exception)((Object)cue));
                System.exit(1);
            }
            while (true) {
                OPSMDaemon.this.stop9iDaemons();
                try {
                    Thread.currentThread();
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    Trace.out("Caught Interrupted Exception while sleeping");
                }
                try {
                    OPSMDaemon.this.m_clusterUtil.pollCSSGroup(s_groupName);
                    continue;
                }
                catch (ClusterUtilException cue) {
                    Trace.out((Exception)((Object)cue));
                    System.exit(1);
                    continue;
                }
                break;
            }
        }
    }
}

