/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.daemon;

import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.GetActiveNodes;
import oracle.ops.mgmt.daemon.Constants;
import oracle.ops.mgmt.daemon.OPSMDaemonStopper;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nativesystem.WindowsSystem;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.DaemonException;
import oracle.ops.mgmt.security.NullSecurityManager;
import oracle.ops.mgmt.trace.Trace;

public class GSDCTLDriver
implements Constants {
    private static final int STOP_SLEEP_TIME = 1000;
    private static final int RETRY_ATTEMPTS = 30;
    private static MessageBundle m_rawMesgBdle = MessageBundle.getMessageBundle("Prke");
    private static String m_command;
    private static String m_oracleHome;
    private static final String GSDSERVICE = "OracleGSDService";
    GetActiveNodes m_activeNodes = null;

    public GSDCTLDriver() throws DaemonException {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new NullSecurityManager());
            Trace.out("NullSecurityManager is set");
        }
        try {
            this.m_activeNodes = GetActiveNodes.create();
        }
        catch (ClusterException ce) {
            Trace.out(ce.getMessage());
            System.out.println(ce.getMessage());
            System.out.println(m_rawMesgBdle.getMessage("1008", false));
            throw new DaemonException(ce.getMessage());
        }
    }

    private void execute() throws DaemonException {
        boolean retVal = true;
        if (m_command.equalsIgnoreCase("start")) {
            Trace.out("Going to start Daemon");
            try {
                if (this.m_activeNodes.isDaemonRunning(this.m_activeNodes.getNodeName())) {
                    System.out.println(m_rawMesgBdle.getMessage("1006", false));
                    return;
                }
            }
            catch (ClusterException ce) {
                Trace.out(ce);
                throw new DaemonException(ce.getMessage());
            }
            this.startDaemon();
            retVal = this.checkStartStop(true);
            if (retVal) {
                System.out.println(m_rawMesgBdle.getMessage("1004", false));
            } else {
                System.out.println(m_rawMesgBdle.getMessage("1009", false));
                System.exit(1);
            }
        } else if (m_command.equalsIgnoreCase("stop")) {
            try {
                if (!this.m_activeNodes.isDaemonRunning(this.m_activeNodes.getNodeName())) {
                    System.out.println(m_rawMesgBdle.getMessage("1007", false));
                    return;
                }
            }
            catch (ClusterException ce) {
                Trace.out(ce);
                throw new DaemonException(ce.getMessage());
            }
            this.stopDaemon();
            retVal = this.checkStartStop(false);
            if (!retVal) {
                System.out.println(m_rawMesgBdle.getMessage("1010", false));
                System.exit(1);
            } else {
                System.out.println(m_rawMesgBdle.getMessage("1005", false));
            }
        } else if (m_command.equalsIgnoreCase("stat")) {
            retVal = this.statDaemon();
            if (retVal) {
                System.out.println(m_rawMesgBdle.getMessage("1006", false));
            } else {
                System.out.println(m_rawMesgBdle.getMessage("1007", false));
                System.exit(1);
            }
        }
    }

    private void startDaemon() throws DaemonException {
        try {
            this.m_activeNodes.startDaemon("localnode", m_oracleHome);
        }
        catch (ClusterException ce) {
            Trace.out("Could not start the daemon on localnode");
            Trace.out(ce.getMessage());
            System.out.println(ce.getMessage());
            System.out.println(m_rawMesgBdle.getMessage("1009", false));
            throw new DaemonException(ce.getMessage());
        }
    }

    private void stopDaemon() throws DaemonException {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (!nativeSystem.isUnixSystem()) {
            Trace.out("\n Attempting to stop OracleGSDService on node " + this.m_activeNodes.getNodeName());
            WindowsSystem windowsSystem = (WindowsSystem)nativeSystem;
            String result = windowsSystem.stopService(GSDSERVICE, this.m_activeNodes.getNodeName());
            NativeResult nativeResult = new NativeResult(result);
            Trace.out("Attempted to stop Oracle GSDService");
            if (!nativeResult.getStatus()) {
                System.out.println(m_rawMesgBdle.getMessage("1010", false));
            }
            return;
        }
        OPSMDaemonStopper daemonStopper = null;
        try {
            daemonStopper = new OPSMDaemonStopper(m_oracleHome);
        }
        catch (ClusterException ce) {
            Trace.out("Could not stop the daemon");
            Trace.out(ce.getMessage());
            System.out.println(ce.getMessage());
            System.out.println(m_rawMesgBdle.getMessage("1010", false));
            throw new DaemonException(ce.getMessage());
        }
    }

    private boolean statDaemon() throws DaemonException {
        boolean retVal = false;
        String nodeName = this.m_activeNodes.getNodeName();
        try {
            retVal = this.m_activeNodes.isDaemonRunning(nodeName);
        }
        catch (ClusterException ce) {
            Trace.out("Could not check the status of the daemon on " + nodeName);
            Trace.out(ce.getMessage());
            System.out.println(ce.getMessage());
            System.out.println(m_rawMesgBdle.getMessage("1011", false));
            throw new DaemonException(ce.getMessage());
        }
        return retVal;
    }

    private static void validateArgs(String[] args) throws IllegalArgumentException {
        Trace.out("validateArgs");
        if (args.length != 2) {
            Trace.out("Incorrect number of arguments: " + args.length);
            System.out.println(m_rawMesgBdle.getMessage("1001", false));
            throw new IllegalArgumentException(m_rawMesgBdle.getMessage("1002", true, args));
        }
        if (args[0].equalsIgnoreCase("start")) {
            m_command = "start";
        } else if (args[0].equalsIgnoreCase("stop")) {
            m_command = "stop";
        } else if (args[0].equalsIgnoreCase("stat")) {
            m_command = "stat";
        } else {
            Trace.out("Incorrect argument passed: " + args[0]);
            System.out.println(m_rawMesgBdle.getMessage("1001", false));
            Object[] msgArgs = new String[]{args[0]};
            throw new IllegalArgumentException(m_rawMesgBdle.getMessage("1003", true, msgArgs));
        }
        m_oracleHome = args[1];
    }

    private boolean checkStartStop(boolean start) throws DaemonException {
        boolean retVal = false;
        for (int i = 0; i < 30; ++i) {
            retVal = this.statDaemon();
            Trace.out("stopDaemon: RETRY_ATTEMPTS=" + i);
            if (!start ? !retVal : start && retVal) break;
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                Trace.out("Caught Interrupted Exception while sleeping");
            }
        }
        return start && retVal || !start && !retVal;
    }

    public static void main(String[] args) {
        GSDCTLDriver gsdctl = null;
        try {
            gsdctl = new GSDCTLDriver();
        }
        catch (DaemonException e) {
            Trace.out(e.getMessage());
            System.exit(1);
        }
        try {
            GSDCTLDriver.validateArgs(args);
        }
        catch (IllegalArgumentException e) {
            Trace.out(e.getMessage());
            Trace.out("exiting abnormally due to DaemonException");
            System.exit(1);
        }
        try {
            gsdctl.execute();
        }
        catch (DaemonException e) {
            Trace.out(e.getMessage());
            Trace.out("exiting abnormally due to FrameworkException");
            System.exit(1);
        }
        System.exit(0);
    }
}

