/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.RemoteDirException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;

public class RemoteExecCommand
extends Command {
    protected static MessageBundle s_msgBundle = MessageBundle.getMessageBundle("Prkc");
    private static final boolean s_isUnixSystem = new SystemFactory().CreateSystem().isUnixSystem();
    protected String m_cmd;
    protected String[] m_args;
    protected String[] m_env;
    protected String[] m_stdin = null;
    protected String m_node;
    protected String[] m_cmdFiles;
    protected String m_srcLoc = null;
    protected String[] m_remoteExecServerFiles = null;
    protected String m_dllLoc;
    protected String m_destLoc;
    protected String m_subDir;
    protected String m_group;
    private String[] m_leafFileNames = null;
    private boolean m_serverNeeded;
    private ClusterCmd m_clusterCmd;
    private boolean m_valid;
    private boolean m_localExecution;
    private boolean m_chkException;
    private static final int MAX_ARRAYSIZE = 64;
    private static final int MAX_CMD_ARRAYSIZE = 1024;
    private static final int MAX_BUFSIZE = 1024;
    private static final HashMap s_remExecLockTable = new HashMap();
    private static final int REM_EXEC_COMMUNICATION_SUCCESS = 0;
    private Map<String, Set<String>> m_createdFiles = new HashMap<String, Set<String>>();

    public RemoteExecCommand(String cmd, String[] args, String[] env, String node, String[] cmdFiles, String srcLoc, String destLoc, NativeResult result) {
        this(cmd, args, env, node, cmdFiles, srcLoc, destLoc);
        this.commandResult = (CommandResult)result;
        Trace.out("End of constructor call: RemoteExecCommand(String cmd, String[] args, String[] env, String node, String[] cmdFiles, String srcLoc, String destLoc, NativeResult result");
    }

    public RemoteExecCommand(String cmd, String[] args, String[] env, String node, String[] cmdFiles, String srcLoc, String destLoc, NativeResult result, boolean chkException) {
        this(cmd, args, env, node, cmdFiles, srcLoc, destLoc, chkException);
        this.commandResult = (CommandResult)result;
        Trace.out("End of constructor call: RemoteExecCommand(String cmd, String[] args, String[] env, String node, String[] cmdFiles, String srcLoc, String destLoc, NativeResult result, boolean chkException");
    }

    public RemoteExecCommand(String cmd, String[] args, String[] env, String node, String[] cmdFiles, String srcLoc, String destLoc) {
        this(cmd, args, env, node, false, cmdFiles, srcLoc, destLoc);
        Trace.out("End of constructor call: RemoteExecCommand(String cmd, String[] args, String[] env, String node, String[] cmdFiles, String srcLoc, String destLoc");
    }

    public RemoteExecCommand(String cmd, String[] args, String[] env, String node, String[] cmdFiles, String srcLoc, String destLoc, boolean chkException) {
        this(cmd, args, env, node, false, cmdFiles, srcLoc, destLoc, chkException);
        Trace.out("End of constructor call: RemoteExecCommand(String cmd, String[] args, String[] env, String node, String[] cmdFiles, String srcLoc, String destLoc, boolean chkException");
    }

    public RemoteExecCommand(String cmd, String[] args, String[] env, String node, boolean localExecution, String[] cmdFiles, String srcLoc, String destLoc) {
        this(cmd, args, env, node, localExecution, cmdFiles, srcLoc, destLoc, false);
        Trace.out("End of constructor call: RemoteExecCommand(String cmd, String[] args, String[] env, String node, boolean localExecution, String[] cmdFiles, String srcLoc, String destLoc");
    }

    public RemoteExecCommand(String cmd, String[] args, String[] env, String node, boolean localExecution, String[] cmdFiles, String srcLoc, String destLoc, boolean chkException) {
        this(cmd, args, env, node, localExecution, cmdFiles, srcLoc, srcLoc, destLoc, chkException);
    }

    public RemoteExecCommand(String cmd, String[] args, String[] env, String node, boolean localExecution, String[] cmdFiles, String srcLoc, String dllLoc, String destLoc, boolean chkException) {
        this.m_cmd = cmd;
        this.m_args = args;
        this.m_env = env;
        this.m_node = node;
        this.m_localExecution = localExecution;
        if (cmdFiles != null) {
            ArrayList<String> cmdFilesList = new ArrayList<String>();
            for (String cmdFile : cmdFiles) {
                if (srcLoc != null) {
                    cmdFile = srcLoc + File.separator + cmdFile;
                }
                cmdFilesList.add(cmdFile);
            }
            this.m_cmdFiles = cmdFilesList.toArray(new String[0]);
        }
        this.m_srcLoc = srcLoc;
        this.m_dllLoc = dllLoc;
        this.m_destLoc = destLoc;
        this.m_chkException = chkException;
        this.m_clusterCmd = new ClusterCmd();
        this.commandResult = new CommandResult("0");
        if (this.m_cmdFiles != null) {
            this.m_leafFileNames = new String[this.m_cmdFiles.length];
            for (int i = 0; i < this.m_cmdFiles.length; ++i) {
                this.m_leafFileNames[i] = new File(this.m_cmdFiles[i]).getName();
            }
        }
        this.printIvarValues();
        Trace.out("End of constructor call (called by many other constructors internally): RemoteExecCommand(String cmd, String[] args, String[] env, String node, boolean localExecution, String[] cmdFiles, String srcLoc, String destLoc, boolean chkException");
    }

    public RemoteExecCommand(String cmd, String[] args, String[] env, String node, String[] cmdFiles, String[] remExecServerFiles, String destLoc, NativeResult result) {
        this(cmd, args, env, node, cmdFiles, remExecServerFiles, destLoc);
        this.commandResult = (CommandResult)result;
        Trace.out("End of constructor call: RemoteExecCommand(String cmd, String[] args, String[] env, String node, String[] cmdFiles, String[] remExecFiles, String destLoc, NativeResult result");
    }

    public RemoteExecCommand(String cmd, String[] args, String[] env, String node, String[] cmdFiles, String[] remExecServerFiles, String destLoc, NativeResult result, boolean chkException) {
        this(cmd, args, env, node, cmdFiles, remExecServerFiles, destLoc, chkException);
        this.commandResult = (CommandResult)result;
        Trace.out("End of constructor call: RemoteExecCommand(String cmd, String[] args, String[] env, String node, String[] cmdFiles, String[] remExecFiles, String destLoc, NativeResult result, boolean chkException");
    }

    public RemoteExecCommand(String cmd, String[] args, String[] env, String node, String[] cmdFiles, String[] remExecServerFiles, String destLoc) {
        this(cmd, args, env, node, false, cmdFiles, remExecServerFiles, destLoc);
        Trace.out("End of constructor call: RemoteExecCommand(String cmd, String[] args, String[] env, String node, String[] cmdFiles, String[] remExecFiles, String destLoc");
    }

    public RemoteExecCommand(String cmd, String[] args, String[] env, String node, String[] cmdFiles, String[] remExecServerFiles, String destLoc, boolean chkException) {
        this(cmd, args, env, node, false, cmdFiles, remExecServerFiles, destLoc, chkException);
        Trace.out("End of constructor call: RemoteExecCommand(String cmd, String[] args, String[] env, String node, String[] cmdFiles, String[] remExecFiles, String destLoc, boolean chkException");
    }

    public RemoteExecCommand(String cmd, String[] args, String[] env, String node, boolean localExecution, String[] cmdFiles, String[] remExecServerFiles, String destLoc) {
        this(cmd, args, env, node, localExecution, cmdFiles, remExecServerFiles, destLoc, false);
        Trace.out("End of constructor call: RemoteExecCommand(String cmd, String[] args, String[] env, String node, boolean localExecution, String[] cmdFiles, String[] remExecFiles, String destLoc");
    }

    public RemoteExecCommand(String cmd, String[] args, String[] env, String node, boolean localExecution, String[] cmdFiles, String[] remExecServerFiles, String srcLoc, String destLoc) {
        this(cmd, args, env, node, localExecution, cmdFiles, remExecServerFiles, destLoc);
        this.m_srcLoc = srcLoc;
    }

    public RemoteExecCommand(String cmd, String[] args, String[] env, String node, boolean localExecution, String[] cmdFiles, String[] remExecServerFiles, String destLoc, boolean chkException) {
        this.m_cmd = cmd;
        this.m_args = args;
        this.m_env = env;
        this.m_node = node;
        this.m_localExecution = localExecution;
        this.m_cmdFiles = cmdFiles;
        this.m_remoteExecServerFiles = remExecServerFiles;
        this.m_destLoc = destLoc;
        this.m_chkException = chkException;
        this.m_clusterCmd = new ClusterCmd();
        this.commandResult = new CommandResult("0");
        if (null != this.m_cmdFiles) {
            this.m_leafFileNames = new String[this.m_cmdFiles.length];
            for (int i = 0; i < this.m_cmdFiles.length; ++i) {
                this.m_leafFileNames[i] = new File(this.m_cmdFiles[i]).getName();
            }
        }
        this.printIvarValues();
        Trace.out("End of constructor call (called by many other constructors internally): RemoteExecCommand(String cmd, String[] args, String[] env, String node, boolean  localExecution, String[] cmdFiles, String srcLoc, String[] remExecServerFiles, String destLoc, boolean chkException");
    }

    public RemoteExecCommand(String cmd, String[] args, String[] env, String[] stdin, String node, String[] cmdFiles, String srcLoc, String destLoc, NativeResult result) {
        this(cmd, args, env, node, cmdFiles, srcLoc, destLoc, result);
        this.m_stdin = stdin;
        Trace.out("End of constructor call: RemoteExecCommand(String cmd, String[] args, String[] env, String[] stdin, String node, String[] cmdFiles, String srcLoc, String destLoc, NativeResult result");
    }

    private void printIvarValues() {
        int i;
        Trace.out(1, "Ivar values:");
        Trace.out(1, "       m_cmd -->" + this.m_cmd);
        if (this.m_args == null) {
            Trace.out(1, "       m_args -->null");
        } else {
            for (i = 0; i < this.m_args.length; ++i) {
                Trace.out(1, "       m_args[" + i + "]  -->" + this.m_args[i]);
            }
        }
        if (this.m_env == null) {
            Trace.out(1, "       m_env -->null");
        } else {
            for (i = 0; i < this.m_env.length; ++i) {
                Trace.out(1, "       m_env[" + i + "]  -->" + this.m_env[i]);
            }
        }
        Trace.out(1, "       m_node -->" + this.m_node);
        Trace.out(1, "       m_localExecution -->" + this.m_localExecution);
        if (this.m_cmdFiles == null) {
            Trace.out(1, "       m_cmdFiles -->null");
        } else {
            for (i = 0; i < this.m_cmdFiles.length; ++i) {
                Trace.out(1, "       m_cmdFiles[" + i + "]  -->" + this.m_cmdFiles[i]);
            }
        }
        if (this.m_leafFileNames == null) {
            Trace.out(1, "       m_leafFileNames -->null");
        } else {
            for (i = 0; i < this.m_leafFileNames.length; ++i) {
                Trace.out(1, "       m_leafFileNames[" + i + "]  -->" + this.m_leafFileNames[i]);
            }
        }
        if (this.m_remoteExecServerFiles == null) {
            Trace.out(1, "       m_remoteExecServerFiles -->null");
        } else {
            for (i = 0; i < this.m_remoteExecServerFiles.length; ++i) {
                Trace.out(1, "       m_remoteExecServerFiles[" + i + "]  -->" + this.m_remoteExecServerFiles[i]);
            }
        }
        Trace.out(1, "       m_srcLoc -->" + this.m_srcLoc);
        Trace.out(1, "       m_dllLoc -->" + this.m_dllLoc);
        Trace.out(1, "       m_destLoc -->" + this.m_destLoc);
        Trace.out(1, "       m_chkException -->" + this.m_chkException);
        if (this.m_stdin == null) {
            Trace.out(1, "       m_stdin -->null");
        } else {
            Trace.out(1, "       m_stdin.length -->%d", this.m_stdin.length);
        }
    }

    private void printIvarArrayValue(String[] ivar, String ivarName) {
        if (ivar == null) {
            Trace.out("       " + ivarName + " -->null");
        } else {
            for (int i = 0; i < ivar.length; ++i) {
                Trace.out("       " + ivarName + "[" + i + "]  -->" + ivar[i]);
            }
        }
    }

    public String getErrorString() {
        return this.commandResult.getErrorString();
    }

    @Override
    public synchronized boolean execute() {
        boolean cmdSuccess = true;
        if (!this.validateCmdArgs()) {
            Trace.out("invalid arguments. throwing ClusterException");
            String errMsg = s_msgBundle.getMessage("1164", true);
            ClusterException ex = new ClusterException(errMsg);
            this.commandResult.setStatus(false);
            this.commandResult.setException(ex);
            return false;
        }
        this.executeInternal();
        if (!this.commandResult.getStatus()) {
            RemExecHelperRetValues remRetval = this.remExecServiceSetupHelper(false);
            if (remRetval == RemExecHelperRetValues.SETUP_FAILED) {
                return false;
            }
            if (remRetval == RemExecHelperRetValues.SETUP_ALREADY_EXISTS) {
                return true;
            }
            Trace.out("Running the command again");
            this.commandResult.setStatus(true);
            this.commandResult.setOSString((String)null);
            this.commandResult.setException(null);
            this.commandResult.setBooleanResult(true);
            this.commandResult.setOSErrCode(0);
            this.commandResult.setResultString(null);
            this.executeInternal();
            Trace.out("Second attempt to run the command '" + this.m_cmd + "'  status: " + this.commandResult.getStatus());
        }
        cmdSuccess = this.commandResult.getStatus() && this.commandResult.getBooleanResult();
        this.commandResult.setStatus(cmdSuccess);
        Trace.out("cmdSuccess status: " + cmdSuccess);
        this.getStatusLogger().log((Command)this, String.valueOf(cmdSuccess));
        return cmdSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemExecHelperRetValues remExecServiceSetupHelper(boolean isPreFirstExec) {
        boolean setupRemExec = true;
        if (isPreFirstExec && s_isUnixSystem) {
            Trace.out("Before first exec on Linux/Unix");
            return RemExecHelperRetValues.SETUP_ALREADY_EXISTS;
        }
        try {
            boolean isRemExecRunning = this.nativeSystem.isRemExecServiceRunning(this.m_node, this.commandResult);
            if (isPreFirstExec && isRemExecRunning) {
                Trace.out("Before first exec on NT and rem exec service is running");
                return RemExecHelperRetValues.SETUP_ALREADY_EXISTS;
            }
            if (!isPreFirstExec && !s_isUnixSystem && isRemExecRunning) {
                Trace.out("After execute on NT, rem exec service is not the problem");
                setupRemExec = false;
            }
            if (setupRemExec) {
                Trace.out("trying to start rem exec service");
                try {
                    this.setupRemoteExecService(false);
                }
                catch (NativeException ne) {
                    this.commandResult.setStatus(false);
                    this.commandResult.setException(ne);
                    Trace.out("NativeException occured while setting up RemoteExecService. err msg:" + ne.getMessage());
                    return RemExecHelperRetValues.SETUP_FAILED;
                }
            }
            ClusterException ex = null;
            boolean skipCopy = this.m_destLoc == null || this.m_srcLoc == null && (this.m_cmdFiles == null || this.m_cmdFiles.length == 0 || !new File(this.m_cmdFiles[0]).isAbsolute());
            Trace.out("skipCopy ->" + skipCopy);
            if (!skipCopy) {
                try {
                    this.copyToolAndDeps();
                }
                catch (RemoteDirException re) {
                    ex = re;
                    Trace.out("RemoteDirException occured while copying tool. err msg:" + re.getMessage());
                }
                catch (ClusterException ce) {
                    ex = ce;
                    Trace.out("ClusterException occured while copying tool. err msg:" + ce.getMessage());
                }
                finally {
                    if (null != ex) {
                        this.commandResult.setStatus(false);
                        this.commandResult.setException(ex);
                        return RemExecHelperRetValues.SETUP_FAILED;
                    }
                }
            }
        }
        catch (NativeException ne) {
            this.commandResult.setStatus(false);
            this.commandResult.setException(ne);
            Trace.out("NativeException occured while setting up RemoteExecService. err msg:" + ne.getMessage());
            return RemExecHelperRetValues.SETUP_FAILED;
        }
        return RemExecHelperRetValues.SETUP_SUCCESSFUL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean execute(boolean bCopy) throws ClusterException {
        block13: {
            Trace.out("Entry point for method RemoteExecCommand.execute(boolean bCopy) with 'bCopy=" + bCopy + "'");
            if (!bCopy) {
                return this.execute();
            }
            if (!this.validateCmdArgs()) {
                Trace.out("invalid arguments. throwing ClusterException");
                throw new ClusterException(s_msgBundle.getMessage("1164", true));
            }
            if (bCopy) {
                try {
                    this.setupRemoteExecService(false);
                }
                catch (NativeException nex) {
                    this.commandResult.setStatus(false);
                    this.commandResult.setException(nex);
                    Trace.out("NativeException occured while setting up RemoteExecService. err msg:" + nex.getMessage());
                    String errMsg = s_msgBundle.getMessage("1165", true, new String[]{this.m_localExecution ? "localnode" : this.m_node});
                    throw new ClusterException(errMsg, nex);
                }
                ClusterException ex = null;
                this.printIvarValues();
                boolean skipCopy = this.m_destLoc == null || this.m_srcLoc == null && (this.m_cmdFiles == null || this.m_cmdFiles.length == 0 || !new File(this.m_cmdFiles[0]).isAbsolute());
                Trace.out("skipCopy ->" + skipCopy);
                if (!skipCopy) {
                    try {
                        this.copyToolAndDeps();
                    }
                    catch (RemoteDirException rde) {
                        ex = rde;
                        Trace.out("RemoteDirException occured while copying tool. err msg:" + rde.getMessage());
                    }
                    catch (ClusterException ce) {
                        ex = ce;
                        Trace.out("ClusterException occured while copying tool. err msg:" + ce.getMessage());
                    }
                    finally {
                        if (ex == null) break block13;
                        this.commandResult.setStatus(false);
                        this.commandResult.setException(ex);
                        throw new ClusterException(s_msgBundle.getMessage("1004", true), ex);
                    }
                }
            }
        }
        boolean retVal = this.executeInternal();
        this.commandResult.setStatus(retVal);
        return retVal;
    }

    private boolean executeInternal() {
        Trace.out("Calling executeInternal()");
        boolean cmdSuccess = true;
        String args = "";
        if (this.m_args != null) {
            for (int j = 0; j < this.m_args.length; ++j) {
                args = args + this.m_args[j] + " ";
            }
        }
        Trace.out("executing the command: '" + this.m_cmd + "' with args '" + args + "', 'm_stdin == null ->" + (this.m_stdin == null) + "', 'm_localExecution ->" + this.m_localExecution + "', 'm_chkException ->" + this.m_chkException + "'");
        if (this.m_stdin != null) {
            if (this.m_localExecution) {
                this.nativeSystem.runRemoteExecCmd(this.m_cmd, this.m_args, this.m_env, this.m_stdin, (NativeResult)this.commandResult, this.m_chkException);
            } else {
                this.nativeSystem.runRemoteExecCmd(this.m_cmd, this.m_args, this.m_env, this.m_stdin, this.m_node, this.commandResult, this.m_chkException);
            }
        } else if (this.m_localExecution) {
            this.nativeSystem.runRemoteExecCmd(this.m_cmd, this.m_args, this.m_env, this.commandResult, this.m_chkException);
        } else {
            this.nativeSystem.runRemoteExecCmd(this.m_cmd, this.m_args, this.m_env, this.m_node, (NativeResult)this.commandResult, this.m_chkException);
        }
        cmdSuccess = this.commandResult.getStatus() && this.commandResult.getBooleanResult();
        Trace.out("cmdSuccess status: " + cmdSuccess);
        this.getStatusLogger().log((Command)this, String.valueOf(cmdSuccess));
        return cmdSuccess;
    }

    private boolean validateCmdArgs() {
        Trace.out("Calling validateCmdArgs");
        this.printIvarValues();
        int i = 0;
        this.m_valid = true;
        Trace.out("Checking for arguments validity");
        if (this.m_cmd != null && this.m_cmd.length() > 1024 || this.m_cmdFiles != null && this.m_cmdFiles.length > 1024) {
            Trace.out("returning false");
            this.m_valid = false;
        }
        if (this.m_valid && this.m_leafFileNames != null) {
            for (i = 0; i < this.m_leafFileNames.length; ++i) {
                if (this.m_leafFileNames[i].length() <= 1024) continue;
                this.m_valid = false;
                Trace.out("leaf file " + i + " is longer than bufsize");
                break;
            }
        }
        return this.m_valid;
    }

    protected void setupRemoteExecServiceForce() throws NativeException {
        this.setupRemoteExecService(true);
    }

    private void setupRemoteExecService(boolean isForce) throws NativeException {
        String execNode;
        Trace.out("setting up RemoteExecServer if sever is needed");
        this.m_serverNeeded = this.nativeSystem.isRemoteExecServerNeeded();
        if (!this.m_serverNeeded) {
            Trace.out("RemoteExecService setup is not required. skipping setup...");
            return;
        }
        if (this.m_localExecution) {
            execNode = "localnode";
            Trace.out("m_localExecution ->" + this.m_localExecution);
        } else {
            execNode = this.m_node;
            Trace.out("executing on node -> " + this.m_node);
        }
        int osErrCode = this.commandResult.getOSErrCode();
        if (0 != osErrCode || isForce) {
            if (!isForce) {
                if (osErrCode == 128) {
                    Trace.out("Incompatible client server version detected, stopping the service to force copying of the latest remote exec server. Error returned is:" + this.commandResult.getOSString());
                } else {
                    Trace.out("Remote exec service could not be contacted. Error returned from native code is: " + this.commandResult.getOSString());
                }
            } else {
                Trace.out("it is forced service creation");
            }
            int retryCount = 2;
            do {
                --retryCount;
                this.nativeSystem.stopService("OracleRemExecServiceV2", execNode);
                this.nativeSystem.deleteService(true, "OracleRemExecServiceV2", execNode);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    Trace.out("Sleep interrupted");
                }
            } while (retryCount > 0 && this.nativeSystem.isRemExecServiceRunning(this.m_node, this.commandResult));
        }
        if (this.nativeSystem.isRemExecServiceRunning(execNode, this.commandResult)) {
            return;
        }
        this.commandResult.setStatus(true);
        this.commandResult.setOSString((String)null);
        this.commandResult.setException(null);
        this.commandResult.setBooleanResult(true);
        Trace.out("Server is not running, create it if needed");
        boolean isServerStarted = true;
        try {
            Trace.out("start the remote exec service");
            if (this.m_localExecution) {
                if (this.m_remoteExecServerFiles == null) {
                    Trace.out("Local execution: m_remoteExecServerFiles == null, m_dllLoc ->" + this.m_dllLoc + ", m_destLoc ->" + this.m_destLoc);
                    this.nativeSystem.startRemoteExecServer(this.m_dllLoc, this.m_destLoc);
                } else {
                    StringBuilder remoteExecServerFiles = new StringBuilder("");
                    for (int i = 0; i < this.m_remoteExecServerFiles.length - 1; ++i) {
                        remoteExecServerFiles.append(this.m_remoteExecServerFiles[i] + ", ");
                    }
                    if (this.m_remoteExecServerFiles.length > 0) {
                        remoteExecServerFiles.append(this.m_remoteExecServerFiles[this.m_remoteExecServerFiles.length - 1]);
                    }
                    Trace.out("Local execution: m_remoteExecServerFiles == null, m_remoteExecServerFiles = " + remoteExecServerFiles.toString() + ", m_destLoc ->" + this.m_destLoc);
                    this.nativeSystem.startRemoteExecServer(this.m_remoteExecServerFiles, this.m_destLoc);
                }
            } else if (this.m_remoteExecServerFiles == null) {
                Trace.out(" m_node ->" + this.m_node + ", m_remoteExecServerFiles == null, m_dllLoc ->" + this.m_dllLoc + ", m_destLoc ->" + this.m_destLoc);
                this.nativeSystem.startRemoteExecServer(this.m_node, this.m_dllLoc, this.m_destLoc);
            } else {
                StringBuilder remoteExecServerFiles = new StringBuilder("");
                for (int i = 0; i < this.m_remoteExecServerFiles.length - 1; ++i) {
                    remoteExecServerFiles.append(this.m_remoteExecServerFiles[i] + ", ");
                }
                if (this.m_remoteExecServerFiles.length > 0) {
                    remoteExecServerFiles.append(this.m_remoteExecServerFiles[this.m_remoteExecServerFiles.length - 1]);
                }
                Trace.out(" m_node ->" + this.m_node + ", m_remoteExecServerFiles = " + remoteExecServerFiles.toString() + ", m_destLoc ->" + this.m_destLoc);
                this.nativeSystem.startRemoteExecServer(this.m_node, this.m_remoteExecServerFiles, this.m_destLoc);
            }
        }
        catch (NativeException ne2) {
            Trace.out("Start remoteExecServer failed with Execption" + ne2);
            this.commandResult.setStatus(false);
            this.commandResult.setException(ne2);
            isServerStarted = false;
            throw ne2;
        }
    }

    private void copyToolAndDeps() throws RemoteDirException, ClusterException {
        String retStr;
        Trace.out("Calling copyToolAndDeps()");
        this.printIvarValues();
        boolean destLocExists = true;
        String destPath = this.m_destLoc;
        Trace.out("check to see node:m_destLoc exists & is writeable");
        try {
            destLocExists = this.nativeSystem.pathExists(this.m_localExecution ? "localnode" : this.m_node, this.m_destLoc, 4);
            Trace.out("destLocExists ->" + destLocExists);
        }
        catch (RemoteDirException rde) {
            destLocExists = false;
            Trace.out("Exception while checking for existance of dir " + this.m_node + ":" + this.m_destLoc);
            Trace.out(rde);
            throw rde;
        }
        if (!destLocExists) {
            Trace.out("DestLoc doesn't exist, trying to create " + this.m_node + ":" + destPath);
            retStr = this.nativeSystem.createDir(this.m_localExecution ? "localnode" : this.m_node, this.m_destLoc);
            boolean mkdirSucc = new NativeResult(retStr).getStatus();
            Trace.out("mkdirSucc ->" + mkdirSucc);
            if (mkdirSucc) {
                this.updateCreatedFiles(this.m_localExecution ? "localnode" : this.m_node, this.m_destLoc);
                destLocExists = true;
            } else {
                Trace.out("Unable to create destLoc " + this.m_node + ":" + destPath);
                Trace.out("retStr=" + retStr);
                this.commandResult.setStatus(false);
                String errMsg = s_msgBundle.getMessage("1110", true, new String[]{this.m_destLoc, this.m_localExecution ? "localnode" : this.m_node});
                throw new ClusterException(errMsg);
            }
        }
        Trace.out("mkdirSucc == null ->" + (this.m_subDir == null));
        if (this.m_subDir != null) {
            Trace.out("Setting up subdirectory " + this.m_subDir + " on node " + (this.m_localExecution ? "localnode" : this.m_node));
            destPath = this.m_destLoc + File.separator + this.m_subDir;
            retStr = this.nativeSystem.removeDirRecurse(this.m_localExecution ? "localnode" : this.m_node, destPath);
            boolean rmdirSucc = new NativeResult(retStr).getStatus();
            Trace.out("rmdirSucc ->" + rmdirSucc);
            if (!rmdirSucc) {
                Trace.out("failed to remove dir " + this.m_node + ":" + destPath);
                Trace.out("retStr = " + retStr);
                this.commandResult.setStatus(false);
                String errMsg = s_msgBundle.getMessage("1111", true, new String[]{this.m_destLoc, this.m_localExecution ? "localnode" : this.m_node});
                throw new ClusterException(errMsg);
            }
            String dirResult = this.nativeSystem.createDirWithModeRecurse(this.m_localExecution ? "localnode" : this.m_node, destPath);
            boolean mkdirSucc = new NativeResult(dirResult).getStatus();
            Trace.out("mkdirSucc ->" + mkdirSucc);
            if (!mkdirSucc) {
                Trace.out("failed to create dir " + this.m_node + ":" + destPath);
                Trace.out("retStr" + retStr);
                this.commandResult.setStatus(false);
                String errMsg = s_msgBundle.getMessage("1110", true, new String[]{this.m_destLoc, this.m_localExecution ? "localnode" : this.m_node});
                throw new ClusterException(errMsg);
            }
            this.updateCreatedFiles(this.m_localExecution ? "localnode" : this.m_node, destPath);
        }
        int numFiles = 0;
        if (this.m_cmdFiles != null) {
            numFiles = this.m_cmdFiles.length;
        }
        Trace.out("numFiles ->" + numFiles);
        String strSrcFile = null;
        String strDestFile = null;
        String copyResult = null;
        boolean fileCopied = false;
        for (int i = 0; i < numFiles; ++i) {
            strSrcFile = this.m_cmdFiles[i];
            strDestFile = destPath + File.separator + this.m_leafFileNames[i];
            Trace.out("Copying file " + strSrcFile + " ...");
            copyResult = this.nativeSystem.copyFile("localnode", strSrcFile, this.m_localExecution ? "localnode" : this.m_node, strDestFile);
            Trace.out("copyResult= " + copyResult);
            CommandResult cmdResult = new CommandResult(copyResult);
            fileCopied = cmdResult.getStatus();
            if (fileCopied) continue;
            this.commandResult.setStatus(false);
            Trace.out("Failed to copy from " + strSrcFile + " to " + strDestFile + " on " + (this.m_localExecution ? "localnode" : this.m_node));
            String errMsg = s_msgBundle.getMessage("1108", true, new String[]{this.m_cmdFiles[i], "localnode", this.m_leafFileNames[i], this.m_localExecution ? "localnode" : this.m_node, cmdResult.getErrorString()});
            throw new ClusterException(errMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRemoteExecServer(String node, String srcLoc, String destLoc) throws NativeException {
        Trace.out("Calling startRemoteExecServer() with 'node = " + node + "', 'srcLoc = " + srcLoc + "', 'destLoc = " + destLoc + "'");
        Object nodeLock = null;
        Object object = s_remExecLockTable;
        synchronized (object) {
            nodeLock = s_remExecLockTable.get(node);
            if (nodeLock == null) {
                nodeLock = new Object();
                s_remExecLockTable.put(node, nodeLock);
            }
        }
        object = nodeLock;
        synchronized (object) {
            Trace.out("start the remote exec service");
            this.nativeSystem.startRemoteExecServer(node, srcLoc, destLoc);
        }
    }

    protected void setArgs(String[] args) {
        Trace.out("Setting value for ivar 'm_args'");
        this.m_args = new String[args.length];
        System.arraycopy(args, 0, this.m_args, 0, args.length);
        this.printIvarValues();
    }

    protected void setEnv(String[] env) {
        Trace.out("Setting value for ivar 'm_env'");
        this.m_env = new String[env.length];
        System.arraycopy(env, 0, this.m_env, 0, env.length);
        this.printIvarValues();
    }

    public void setNode(String node) {
        Trace.out("Setting value for ivar 'm_node ->'" + this.m_node + " and 'm_localExecution -> false'");
        this.m_node = node;
        this.m_localExecution = false;
        this.printIvarValues();
    }

    @Override
    public String getNode() {
        return this.m_node;
    }

    public void setLocalExecution(boolean localExecution) {
        this.m_localExecution = localExecution;
        Trace.out("Changed ivar value for m_localExecution to " + this.m_localExecution);
        this.printIvarValues();
    }

    public void setSubDirAndGroup(String subDir, String group) {
        Trace.out("Calling setSubDirAndGroup(String subDir, String group) with 'subDir ='" + subDir + "' and 'group = '" + group);
        this.m_subDir = subDir;
        this.m_group = group;
    }

    public void clean() {
        for (String node : this.m_createdFiles.keySet()) {
            Set<String> fileSet = this.m_createdFiles.get(node);
            for (String file : fileSet) {
                Trace.out("Removing recursiverly \"" + file + "\" from node \"" + node + "\"");
                this.nativeSystem.removeDirRecurse(node, file);
                fileSet.remove(file);
            }
        }
    }

    private void updateCreatedFiles(String node, String fileName) {
        Set<String> fileSet = this.m_createdFiles.get(node);
        if (fileSet == null) {
            fileSet = new HashSet<String>();
            this.m_createdFiles.put(node, fileSet);
        }
        Trace.out("adding (" + node + "," + fileName + ") to m_createdFiles");
        fileSet.add(fileName);
    }

    public static int getMaxArraysize() {
        return 64;
    }

    public static int getMaxCmdArraysize() {
        return 1024;
    }

    public static int getMaxBufsize() {
        return 1024;
    }

    private static enum RemExecHelperRetValues {
        SETUP_FAILED,
        SETUP_SUCCESSFUL,
        SETUP_ALREADY_EXISTS;

    }
}

