/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.transfer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import oracle.ops.mgmt.command.transfer.DataBuffer;
import oracle.ops.mgmt.command.transfer.TransferQueues;
import oracle.ops.mgmt.trace.Trace;

public class TransferReader
extends Thread {
    private TransferQueues m_transferQueues;
    private String m_inclFileName;
    private String m_exclFileName;
    private Vector m_errorLog;
    private String[] m_excludeFiles;
    private FileInputStream m_fileStream;
    private int m_nFileSize;
    private int m_nReadSize;

    public TransferReader(TransferQueues transferQueues, String inclFileName, String exclFileName) {
        this.m_transferQueues = transferQueues;
        this.m_inclFileName = inclFileName;
        this.m_exclFileName = exclFileName;
        this.m_errorLog = new Vector();
    }

    @Override
    public void run() {
        Trace.out("Reader started ....");
        try {
            BufferedReader fileReader = null;
            String fileName = null;
            DataBuffer dataBuffer = null;
            File file = null;
            fileReader = this.getInclFileReader();
            if (fileReader == null) {
                Trace.out("Error opening the copy file list");
                return;
            }
            while (true) {
                if (this.m_fileStream == null) {
                    Trace.out("Reading the next file to transfer");
                    try {
                        fileName = fileReader.readLine();
                    }
                    catch (IOException ie) {
                        Trace.out("Error reading include file to block copy");
                        this.m_errorLog.add(ie.getMessage());
                        continue;
                    }
                    this.m_nFileSize = 0;
                    this.m_nReadSize = 0;
                    if (fileName == null) {
                        this.m_transferQueues.setReaderDone();
                        dataBuffer = this.m_transferQueues.getFreeBuffer();
                        dataBuffer.setFileStatus(DataBuffer.NO_OP);
                        this.m_transferQueues.putDataBuffer(dataBuffer);
                        break;
                    }
                }
                Trace.out("Processing file: " + fileName);
                if (this.isExcludeFile(fileName)) continue;
                Trace.out("File: " + fileName + " not be excluded");
                dataBuffer = this.m_transferQueues.getFreeBuffer();
                dataBuffer.setFileName(fileName);
                file = new File(fileName);
                if (file.isDirectory()) {
                    Trace.out("Processing directory: " + fileName);
                    dataBuffer.setFileStatus(DataBuffer.CREATE_DIR);
                    dataBuffer.setLastModified(file.lastModified());
                    this.m_transferQueues.putDataBuffer(dataBuffer);
                } else {
                    Trace.out("Processing file: " + fileName);
                    if (!this.readFile(dataBuffer)) {
                        Trace.out("File: " + fileName + " will not be transferred");
                        this.m_transferQueues.putFreeBuffer(dataBuffer);
                    } else {
                        this.m_transferQueues.putDataBuffer(dataBuffer);
                    }
                }
                file = null;
            }
        }
        catch (InterruptedException ie) {
            Trace.out(ie.getMessage());
        }
    }

    private BufferedReader getInclFileReader() {
        Trace.out("Opening include file for block copy");
        BufferedReader fileReader = null;
        try {
            fileReader = new BufferedReader(new FileReader(this.m_inclFileName));
        }
        catch (FileNotFoundException fnfe) {
            this.m_errorLog.add(fnfe.getMessage());
            fileReader = null;
        }
        return fileReader;
    }

    private boolean isExcludeFile(String fileName) {
        if (this.m_exclFileName == null) {
            return false;
        }
        if (this.m_excludeFiles == null) {
            this.readExcludeFiles();
        }
        boolean bExcluded = false;
        File inclFile = new File(fileName);
        String inclFilePath = inclFile.getAbsolutePath().toLowerCase();
        File exclFile = null;
        String exclFilePath = null;
        for (int i = 0; i < this.m_excludeFiles.length; ++i) {
            Trace.out("Verifying with : " + this.m_excludeFiles[i]);
            exclFile = new File(this.m_excludeFiles[i]);
            exclFilePath = exclFile.getAbsolutePath().toLowerCase();
            if (inclFilePath.equals(exclFilePath)) {
                bExcluded = true;
                break;
            }
            if (!exclFile.isDirectory() || !inclFilePath.startsWith(exclFilePath + File.separator)) continue;
            bExcluded = true;
            break;
        }
        if (bExcluded) {
            Trace.out("File: " + fileName + " is excluded");
        }
        return bExcluded;
    }

    private void readExcludeFiles() {
        BufferedReader buffReader = null;
        String fileName = null;
        Vector<String> exclFilesV = new Vector<String>();
        try {
            buffReader = new BufferedReader(new FileReader(this.m_exclFileName));
            while ((fileName = buffReader.readLine()) != null) {
                exclFilesV.addElement(fileName);
            }
        }
        catch (FileNotFoundException fnfe) {
            Trace.out(fnfe.getMessage());
        }
        catch (IOException ie) {
            Trace.out(ie.getMessage());
        }
        this.m_excludeFiles = new String[exclFilesV.size()];
        exclFilesV.copyInto(this.m_excludeFiles);
    }

    private boolean readFile(DataBuffer dataBuffer) {
        boolean bError;
        block15: {
            String fileName = dataBuffer.getFileName();
            Trace.out("Reading file: " + fileName);
            bError = false;
            boolean bCloseFile = false;
            int status = 0;
            dataBuffer.setFileStatus(status);
            dataBuffer.setFileType(DataBuffer.ARCHIVE);
            try {
                if (this.m_fileStream == null) {
                    Trace.out("Opening file: " + fileName + " for reading");
                    this.m_fileStream = new FileInputStream(fileName);
                    status = dataBuffer.getFileStatus() | DataBuffer.CREATE_FILE;
                    dataBuffer.setFileStatus(status);
                    this.m_nFileSize += this.m_fileStream.available();
                }
                byte[] buffer = dataBuffer.getBuffer();
                Trace.out("Reading the file: " + fileName);
                int nRead = this.m_fileStream.read(buffer);
                Trace.out("Current read size : " + nRead);
                this.m_nReadSize += nRead != -1 ? nRead : 0;
                status = dataBuffer.getFileStatus() | DataBuffer.WRITE_FILE;
                dataBuffer.setFileStatus(status);
                Trace.out("FileSize = " + this.m_nFileSize);
                Trace.out("Read size = " + this.m_nReadSize);
                if (nRead != -1) {
                    Trace.out("Data read into data buffer");
                    if (nRead <= buffer.length && this.m_nFileSize == this.m_nReadSize) {
                        bCloseFile = true;
                    }
                } else {
                    bCloseFile = true;
                    Trace.out("No more data.. should close the file");
                    nRead = this.m_nFileSize - this.m_nReadSize;
                }
                dataBuffer.setNumBytes(nRead);
                if (!bCloseFile) break block15;
                Trace.out("Closing the file: " + fileName);
                try {
                    this.m_fileStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                status = dataBuffer.getFileStatus() | DataBuffer.CLOSE_FILE;
                dataBuffer.setFileStatus(status);
                File file = new File(fileName);
                if (file.isHidden()) {
                    Trace.out("Setting file type HIDDEN");
                    dataBuffer.setFileType(DataBuffer.HIDDEN);
                } else if (!file.canWrite()) {
                    Trace.out("Setting file type READ_ONLY");
                    dataBuffer.setFileType(DataBuffer.READ_ONLY);
                } else {
                    dataBuffer.setFileType(DataBuffer.ARCHIVE);
                }
                dataBuffer.setLastModified(file.lastModified());
                this.m_fileStream = null;
                Trace.out("m_fileStream = " + this.m_fileStream);
            }
            catch (IOException ie) {
                bError = true;
                if (this.m_fileStream != null) {
                    try {
                        this.m_fileStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.m_fileStream = null;
                }
                this.m_errorLog.add(ie.getMessage());
                Trace.out(ie.getMessage());
            }
        }
        return !bError;
    }

    public String[] getErrors() {
        Object[] errors = new String[this.m_errorLog.size()];
        this.m_errorLog.copyInto(errors);
        return errors;
    }
}

