/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.transfer;

import oracle.ops.mgmt.command.transfer.DataBuffer;
import oracle.ops.mgmt.synchronize.SyncBuffer;
import oracle.ops.mgmt.trace.Trace;

public class TransferQueues {
    private static final int QUEUE_SIZE = 5;
    private SyncBuffer m_dataQueue;
    private SyncBuffer m_freeQueue;
    private boolean m_readerDone;

    public TransferQueues() {
        this(5);
    }

    public TransferQueues(int size) {
        Trace.out("SyncBuffer size = " + size);
        this.m_dataQueue = new SyncBuffer(size);
        this.m_freeQueue = new SyncBuffer(size);
        this.addFreeBuffers(size);
        this.m_readerDone = false;
    }

    private void addFreeBuffers(int size) {
        Trace.out("Adding free buffers for block transfer");
        DataBuffer dataBuffer = null;
        try {
            for (int i = 0; i < size; ++i) {
                dataBuffer = new DataBuffer();
                this.m_freeQueue.put(dataBuffer);
            }
        }
        catch (InterruptedException ie) {
            Trace.out(ie.getMessage());
        }
    }

    public void putDataBuffer(DataBuffer dataBuffer) throws InterruptedException {
        Trace.out("Adding a data buffer");
        this.m_dataQueue.put(dataBuffer);
        Trace.out("Added a data buffer");
    }

    public DataBuffer getDataBuffer() throws InterruptedException {
        Trace.out("Removing one data buffer");
        DataBuffer dataBuffer = (DataBuffer)this.m_dataQueue.get();
        Trace.out("Removed one data buffer");
        return dataBuffer;
    }

    public DataBuffer getFreeBuffer() throws InterruptedException {
        Trace.out("Removing a free buffer");
        DataBuffer freeBuffer = (DataBuffer)this.m_freeQueue.get();
        Trace.out("Removed a free buffer");
        return freeBuffer;
    }

    public void putFreeBuffer(DataBuffer freeBuffer) throws InterruptedException {
        Trace.out("Adding a free buffer");
        this.m_freeQueue.put(freeBuffer);
        Trace.out("Added a free buffer");
    }

    public void setReaderDone() {
        this.m_readerDone = true;
    }

    public boolean isReaderDone() {
        return this.m_readerDone;
    }

    public int getNumDataBuffers() {
        return this.m_dataQueue.getFillCount();
    }
}

