/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.transfer;

import java.util.concurrent.Semaphore;
import oracle.cluster.deployment.ractrans.RACTransfer;
import oracle.cluster.deployment.ractrans.RapidTransfer;
import oracle.cluster.deployment.ractrans.RemoteFileOpException;
import oracle.cluster.remote.RemoteUserInfo;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.trace.Trace;

public class RapidTransferCommand
extends Command {
    private static final Semaphore s_canUpdateProperty = new Semaphore(1);
    private final RapidTransfer m_transferProgressMonitor;
    private final String m_oracleHome;
    private final String[] m_remoteNodeNames;
    private final String m_topLevelDir;
    private final String m_includeListFile;
    private final boolean m_includePathnamesCanBeRegex;
    private final String m_excludeListFile;
    private final boolean m_excludePathnamesCanBeRegex;
    private final String m_remoteNodeTempDir;
    private final String[] m_remoteNodeDestDirs;
    private final RemoteUserInfo m_remoteUserInfo;
    private final String m_asUser;
    private RemoteFileOpException m_remoteFileOpException;
    private ClusterException m_clusterException;

    public RapidTransferCommand(RapidTransfer transferProgressMonitor, String oracleHome, String[] remoteNodeNames, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir, String[] remoteNodeDestDirs, RemoteUserInfo remoteUserInfo, String asUser, String nodeID) {
        this.m_transferProgressMonitor = transferProgressMonitor;
        this.m_oracleHome = oracleHome;
        this.m_remoteNodeNames = remoteNodeNames;
        this.m_topLevelDir = topLevelDir;
        this.m_includeListFile = includeListFile;
        this.m_includePathnamesCanBeRegex = includePathnamesCanBeRegex;
        this.m_excludeListFile = excludeListFile;
        this.m_excludePathnamesCanBeRegex = excludePathnamesCanBeRegex;
        this.m_remoteNodeTempDir = remoteNodeTempDir;
        this.m_remoteNodeDestDirs = remoteNodeDestDirs;
        this.m_remoteUserInfo = remoteUserInfo;
        this.m_asUser = asUser;
        this.commandResult = new CommandResult();
        this.m_node = nodeID;
        this.m_remoteFileOpException = null;
        this.m_clusterException = null;
    }

    @Override
    public boolean execute() {
        long startTime = System.currentTimeMillis();
        String threadName = Thread.currentThread().getName();
        try {
            s_canUpdateProperty.acquire();
            String value = System.getProperty("SRVM_PARALLEL_TRANSFER");
            if (value != null) {
                value = value + (value.length() > 0 ? "," + threadName : threadName);
                System.setProperty("SRVM_PARALLEL_TRANSFER", value);
            }
            s_canUpdateProperty.release();
        }
        catch (InterruptedException value) {
            // empty catch block
        }
        RACTransfer racTransfer = new RACTransfer(false, this.m_transferProgressMonitor);
        try {
            racTransfer.transferDirStructureToNodes(this.m_oracleHome, this.m_remoteNodeNames, this.m_topLevelDir, this.m_includeListFile, this.m_includePathnamesCanBeRegex, this.m_excludeListFile, this.m_excludePathnamesCanBeRegex, this.m_remoteNodeTempDir, this.m_remoteNodeDestDirs, this.m_remoteUserInfo, this.m_asUser);
            this.commandResult.setStatus(true);
            this.setStatus(true);
            long totalTime = System.currentTimeMillis() - startTime;
            Trace.out("Total time to transfer files in " + this.m_includeListFile + " = " + totalTime + " ms");
        }
        catch (RemoteFileOpException rfoe) {
            Trace.out("RemoteFileOperationException thrown while transferring the dir structure using rapidtrans. Details:\n" + rfoe.getMessage());
            this.commandResult.setStatus(false);
            this.setStatus(false);
            this.m_remoteFileOpException = rfoe;
        }
        catch (ClusterException ce) {
            Trace.out("ClusterException thrown while transferring the dir structure using rapidtrans. Details:\n" + ce.getMessage());
            this.commandResult.setStatus(false);
            this.setStatus(false);
            this.m_clusterException = ce;
        }
        try {
            s_canUpdateProperty.acquire();
            String value = System.getProperty("SRVM_PARALLEL_TRANSFER");
            if (value != null) {
                int index = value.indexOf(threadName);
                if (index != -1) {
                    value = index == 0 ? value.substring(threadName.length()) : value.substring(0, index - 1) + value.substring(index + threadName.length());
                } else {
                    Trace.out("Internal error: Did not find thread name \"" + threadName + "\" in property \"SRVM_PARALLEL_TRANSFER\"");
                }
                System.setProperty("SRVM_PARALLEL_TRANSFER", value);
            }
            s_canUpdateProperty.release();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.commandResult.getStatus();
    }

    public String getIncludeListFile() {
        return this.m_includeListFile;
    }

    public RemoteFileOpException getRemoteFileOpException() {
        return this.m_remoteFileOpException;
    }

    public ClusterException getClusterException() {
        return this.m_clusterException;
    }
}

