/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.transfer;

public class DataBuffer {
    private static int BUFFER_SIZE = 4096;
    public static int CREATE_FILE = 1;
    public static int WRITE_FILE = 2;
    public static int CLOSE_FILE = 4;
    public static int CREATE_DIR = 8;
    public static int NO_OP = 99;
    public static int ARCHIVE = 10;
    public static int READ_ONLY = 11;
    public static int HIDDEN = 12;
    private byte[] m_buffer;
    private int m_nBytes;
    private String m_fileName;
    private int m_fileStatus;
    private int m_fileType;
    private long m_lastModified;

    DataBuffer() {
        this(BUFFER_SIZE);
    }

    DataBuffer(int bufferSize) {
        String propBuffSize = System.getProperty("TRANSFER_BUFFER_SIZE");
        int buffSize = propBuffSize != null ? Integer.parseInt(propBuffSize) : bufferSize;
        this.m_buffer = new byte[buffSize];
    }

    public byte[] getBuffer() {
        return this.m_buffer;
    }

    public void setNumBytes(int nBytes) {
        this.m_nBytes = nBytes;
    }

    public void setFileName(String fileName) {
        this.m_fileName = fileName;
    }

    public void setFileStatus(int fileStatus) {
        this.m_fileStatus = fileStatus;
    }

    public void setFileType(int fileType) {
        this.m_fileType = fileType;
    }

    public void setLastModified(long lastModified) {
        this.m_lastModified = lastModified;
    }

    public int getNumBytes() {
        return this.m_nBytes;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public int getFileStatus() {
        return this.m_fileStatus;
    }

    public int getFileType() {
        return this.m_fileType;
    }

    public long getLastModified() {
        return this.m_lastModified;
    }
}

