/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.service;

import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.service.ServiceCommand;
import oracle.ops.mgmt.command.service.ServiceData;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.trace.Trace;

public class StopServiceCommand
extends ServiceCommand {
    private boolean m_bypassStopAttemptIfNotRunning;

    public StopServiceCommand(String service, String node) {
        this(service, node, false);
    }

    public StopServiceCommand(String service, String node, boolean bypassStopAttemptIfNotRunning) {
        this.serviceName = service;
        this.nodeName = node;
        this.m_bypassStopAttemptIfNotRunning = bypassStopAttemptIfNotRunning;
    }

    @Override
    public boolean execute() {
        Trace.out("Inside execute of StopService");
        if (this.m_bypassStopAttemptIfNotRunning) {
            try {
                boolean serviceIsRunning = this.nativeSystem.checkService(this.serviceName, this.nodeName, new ServiceData(6), new NativeResult());
                if (!serviceIsRunning) {
                    this.commandResult = new CommandResult("0|SUCCESSFUL");
                    return true;
                }
            }
            catch (Exception e) {
                Trace.out("Exception occurred while checking if service is running. Details: " + e.getMessage());
            }
        }
        try {
            String ret = this.nativeSystem.stopService(this.serviceName, this.nodeName);
            Trace.out("StopService.execute:String returned from Native: " + ret);
            this.commandResult = new CommandResult(ret);
            this.getStatusLogger().log((Command)this, ret);
        }
        catch (Exception e) {
            Trace.out("Exception occurred while calling nativesystem");
        }
        if (this.commandResult == null) {
            return false;
        }
        return this.commandResult.getStatus();
    }
}

