/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.service;

import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.service.ServiceCommand;
import oracle.ops.mgmt.trace.Trace;

public class StartServiceCommand
extends ServiceCommand {
    public StartServiceCommand(String service, String node) {
        this.serviceName = service;
        this.nodeName = node;
        Trace.out("Creating a StartService command");
    }

    @Override
    public boolean execute() {
        Trace.out("StartServiceCommand: Inside execute of StartService");
        try {
            Trace.out("StartServiceCommand: Calling nativeSystem.startService");
            Trace.out("StartServiceCommand: with serviceName=" + this.serviceName + " and nodeName=" + this.nodeName);
            Trace.out("StartServiceCommand: Going to access nativeSystem");
            Trace.out("StartServiceCommand: nativeSystem is " + this.nativeSystem);
            String ret = this.nativeSystem.startService(this.serviceName, this.nodeName);
            Trace.out("StartService.execute:String returned from Native: " + ret);
            this.commandResult = new CommandResult(ret);
            this.getStatusLogger().log((Command)this, ret);
        }
        catch (Exception e) {
            Trace.out("Exception occurred while calling nativesystem");
        }
        if (this.commandResult == null) {
            return false;
        }
        return this.commandResult.getStatus();
    }
}

