/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.service;

import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.service.ServiceCommand;
import oracle.ops.mgmt.trace.Trace;

public class RemoveServiceDepCommand
extends ServiceCommand {
    private String[] m_dependencyList = null;

    public RemoveServiceDepCommand(String service, String[] dependentNames, String node) {
        this.serviceName = service;
        this.nodeName = node;
        this.m_dependencyList = dependentNames;
        this.commandResult = new CommandResult();
        Trace.out("Creating a RemoveServiceDep command");
    }

    @Override
    public boolean execute() {
        Trace.out("RemoveServiceDepCommand: Inside execute of RemoveServiceDepCommand");
        try {
            Trace.out("RemoveServiceDepCommand: calling nativeSystem.removeServiceDep with serviceName=" + this.serviceName + " and nodeName=" + this.nodeName);
            String ret = this.nativeSystem.removeServiceDep(this.serviceName, this.m_dependencyList, this.nodeName);
            Trace.out("RemoveServiceDepCommand.execute:String returned from Native: " + ret);
            this.commandResult = new CommandResult(ret);
            this.getStatusLogger().log((Command)this, ret);
        }
        catch (Exception e) {
            Trace.out("Exception occurred while calling nativesystem");
            this.commandResult.setStatus(false);
            this.commandResult.setException(e);
        }
        if (this.commandResult == null) {
            Trace.out("commandResult is NULL");
            return false;
        }
        if (this.commandResult.getStatus()) {
            Trace.out("Result is true");
            return true;
        }
        Trace.out("Result is false");
        return false;
    }
}

