/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.service;

import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.service.ServiceCommand;
import oracle.ops.mgmt.trace.Trace;

public class CreateServiceDepCommand
extends ServiceCommand {
    private String[] m_dependencyList = null;

    public CreateServiceDepCommand(String service, String[] dependentNames, String node) {
        this.serviceName = service;
        this.nodeName = node;
        this.m_dependencyList = dependentNames;
        Trace.out("Creating a StartService command");
    }

    @Override
    public boolean execute() {
        Trace.out("CreateServiceDepCommand: Inside execute of StartService");
        try {
            Trace.out("CreateServiceDepCommand: calling nativeSystem.createServiceDep with serviceName=" + this.serviceName + " and nodeName=" + this.nodeName);
            String ret = this.nativeSystem.createServiceDep(this.serviceName, this.m_dependencyList, this.nodeName);
            Trace.out("StartService.execute:String returned from Native: " + ret);
            this.commandResult = new CommandResult(ret);
            this.getStatusLogger().log((Command)this, ret);
        }
        catch (Exception e) {
            Trace.out("Exception occurred while calling nativesystem");
        }
        if (this.commandResult == null) {
            return false;
        }
        return this.commandResult.getStatus();
    }
}

