/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.registry;

import oracle.ops.mgmt.command.registry.RegistryCommand;
import oracle.ops.mgmt.command.registry.RegistryKeyData;
import oracle.ops.mgmt.trace.Trace;

public class SetRegValueCommand
extends RegistryCommand {
    private String m_value;
    private RegistryKeyData m_data;

    public SetRegValueCommand(String node, String k, String value) {
        super(node, k);
        this.m_value = value;
        this.m_data = new RegistryKeyData(k, value);
    }

    public SetRegValueCommand(String node, String k, String value, String data) {
        this(node, k, value);
        this.m_data.setData(data, 10);
    }

    public SetRegValueCommand(String node, String k, String value, String[] data) {
        this(node, k, value);
        this.m_data.setData(data, 11);
    }

    public SetRegValueCommand(String node, String k, String value, Integer data) {
        this(node, k, value);
        this.m_data.setData(data, 12);
    }

    public SetRegValueCommand(String node, String k, String value, Byte data) {
        this(node, k, value);
        this.m_data.setData(data, 13);
    }

    public RegistryKeyData getDataObject() {
        return this.m_data;
    }

    @Override
    public boolean execute() {
        Trace.out("In Execute function of SetRegValueCommand");
        try {
            this.nativeSystem.regSetValue(this.m_destNode, this.m_key, this.m_value, this.m_data, this.m_result);
        }
        catch (Exception e) {
            Trace.out("SetRegValue.execute:Exception calling native system");
            this.m_result.setStatus(false);
            this.m_result.setResultString(e.getMessage());
        }
        return this.m_result.getStatus();
    }
}

