/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.registry;

import java.util.StringTokenizer;
import oracle.ops.mgmt.trace.Trace;

public class RegistryKeyData {
    public static final int STRING_TYPE = 10;
    public static final int STRING_ARRAY_TYPE = 11;
    public static final int INTEGER_TYPE = 12;
    public static final int BINARY_TYPE = 13;
    public static final int STRING_EXPAND_TYPE = 14;
    private String m_registryKey;
    private String m_registryKeyValue;
    private int m_dataType = 10;
    private String m_stringData;
    private String[] m_stringArrayData;
    private Integer m_integerData;
    private Byte m_binaryData;

    public RegistryKeyData(String key, String value) {
        this.m_registryKey = key;
        this.m_registryKeyValue = value;
    }

    public RegistryKeyData(String key, int dataType) {
        this.m_registryKey = key;
        this.m_dataType = dataType;
    }

    public String getRegistryKey() {
        return this.m_registryKey;
    }

    public String getRegistryKeyValue() {
        return this.m_registryKeyValue;
    }

    public void setDataType(int dataType) {
        this.m_dataType = dataType;
        Trace.out("Data type of the registry key data is '" + dataType + "'");
    }

    public int getDataType() {
        return this.m_dataType;
    }

    public void setData(String strData) {
        if (this.m_dataType == 10 || this.m_dataType == 14) {
            if (strData != null) {
                this.m_stringData = strData;
            }
        } else {
            this.m_stringData = null;
        }
    }

    public void setData(String dataStr, int dataType) {
        this.setDataType(dataType);
        this.setData(dataStr);
    }

    public void setData(Integer intData) {
        this.m_integerData = this.m_dataType == 12 ? intData : null;
    }

    public void setData(int intData) {
        this.m_integerData = this.m_dataType == 12 ? new Integer(intData) : null;
    }

    public void setData(Integer intData, int dataType) {
        this.setDataType(dataType);
        this.setData(intData);
    }

    public void setData(Byte binData) {
        this.m_binaryData = this.m_dataType == 13 ? binData : null;
    }

    public void setData(Byte binData, int dataType) {
        this.setDataType(dataType);
        this.setData(binData);
    }

    public void setData(String[] arrayData) {
        if (this.m_dataType == 11) {
            if (arrayData == null) {
                this.m_stringArrayData = null;
            } else {
                this.m_stringArrayData = new String[arrayData.length];
                for (int i = 0; i < arrayData.length; ++i) {
                    this.m_stringArrayData[i] = arrayData[i];
                }
            }
        } else {
            this.m_stringArrayData = null;
        }
    }

    public void setData(String[] arrayData, int dataType) {
        this.setDataType(dataType);
        this.setData(arrayData);
    }

    public boolean processString(String processStr, int dType) {
        boolean bStatus = false;
        if (dType == 11) {
            Trace.out("processStr = " + processStr);
            if (processStr != null) {
                StringTokenizer st = new StringTokenizer(processStr, "\n");
                Trace.out("No. of elements = " + st.countTokens());
                this.m_stringArrayData = st.countTokens() > 0 ? new String[st.countTokens()] : new String[0];
                int j = 0;
                if (st.countTokens() > 0) {
                    while (st.hasMoreTokens()) {
                        this.m_stringArrayData[j] = new String(st.nextToken());
                        Trace.out("m_stringArrayData[" + j + "] = " + this.m_stringArrayData[j]);
                        ++j;
                    }
                }
                bStatus = true;
            } else {
                Trace.out("processStr = null");
                bStatus = false;
            }
        } else if (dType == 12) {
            try {
                this.m_integerData = new Integer(processStr);
                bStatus = true;
            }
            catch (NumberFormatException e) {
                Trace.out(e);
                bStatus = false;
            }
        } else if (dType == 13) {
            try {
                this.m_binaryData = new Byte(processStr);
                bStatus = true;
            }
            catch (NumberFormatException e) {
                Trace.out(e);
                bStatus = false;
            }
        }
        return bStatus;
    }

    public String getStringData() {
        if (this.m_dataType == 10 || this.m_dataType == 14) {
            return this.m_stringData;
        }
        return null;
    }

    public String[] getStringArrayData() {
        if (this.m_dataType == 11) {
            return this.m_stringArrayData;
        }
        return null;
    }

    public Integer getIntegerData() {
        if (this.m_dataType == 12) {
            return this.m_integerData;
        }
        return null;
    }

    public String getStringIntegerData() {
        if (this.m_dataType == 12) {
            return this.m_integerData.toString();
        }
        return null;
    }

    public Byte getBinaryData() {
        if (this.m_dataType == 13) {
            return this.m_binaryData;
        }
        return null;
    }

    public String getStringBinaryData() {
        if (this.m_dataType == 13) {
            return this.m_binaryData.toString();
        }
        return null;
    }
}

