/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.file;

import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.RemoteDirException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.trace.Trace;

public class PathExistCommand
extends Command
implements Constants {
    protected String m_node;
    protected String m_path;
    protected int m_pathType;
    protected boolean m_isShared = false;

    public PathExistCommand(String node, String path) {
        this.m_node = node;
        this.m_path = path;
        this.m_isShared = true;
        this.commandResult = new CommandResult();
        this.commandResult.setNodeName(this.m_node);
    }

    public PathExistCommand(String node, String path, int pathType) {
        this.m_node = node;
        this.m_path = path;
        this.m_pathType = pathType;
        this.commandResult = new CommandResult();
        this.commandResult.setNodeName(this.m_node);
    }

    @Override
    public boolean execute() {
        boolean succ;
        try {
            Trace.out(5, "Checking path: '" + this.m_path + "' on node: '" + this.m_node + "'");
            succ = this.m_isShared ? this.nativeSystem.pathExists(this.m_node, this.m_path) : this.nativeSystem.pathExists(this.m_node, this.m_path, this.m_pathType);
            Trace.out(5, "NativeSystem status returned: '" + succ + "'");
        }
        catch (RemoteDirException rde) {
            Trace.out("REMOTEDIREXCEPTION: " + rde.getMessage());
            succ = false;
            this.commandResult.setException(rde);
        }
        this.commandResult.setStatus(succ);
        return succ;
    }
}

