/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.file;

import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.file.FileCommand;
import oracle.ops.mgmt.trace.Trace;

public class DirRemoveCommand
extends FileCommand {
    private boolean m_recurseFlag;
    private boolean m_dirPathRemove;

    public DirRemoveCommand(String node, String path, boolean isRecurse) {
        this(node, path, isRecurse, true);
    }

    public DirRemoveCommand(String node, String path, boolean isRecurse, boolean dirPathRemoveParam) {
        this.m_node = node;
        this.destNode = node;
        this.destFile = path;
        this.m_recurseFlag = isRecurse;
        this.m_dirPathRemove = dirPathRemoveParam;
    }

    @Override
    public boolean execute() {
        Trace.out("In Execute function of DirRemoveCommand" + this.m_recurseFlag);
        String ret = null;
        try {
            ret = !this.m_recurseFlag ? this.nativeSystem.removeDir(this.destNode, this.destFile, this.m_dirPathRemove) : this.nativeSystem.removeDirRecurse(this.destNode, this.destFile);
        }
        catch (Exception e) {
            Trace.out("DirRemoveCommand.execute:Exception calling native system");
        }
        this.commandResult = new CommandResult(ret);
        return this.commandResult.getStatus();
    }
}

