/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.file;

import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.file.FileCommand;
import oracle.ops.mgmt.trace.Trace;

public class DirCreateCommand
extends FileCommand {
    boolean recurseFlag;
    boolean modeFlag = false;
    String permissions = null;

    public DirCreateCommand(String node, String path, boolean isRecurse) {
        this(node, path, isRecurse, false, null);
    }

    public DirCreateCommand(String node, String path, boolean isRecurse, boolean useMode) {
        this(node, path, isRecurse, useMode, null);
    }

    public DirCreateCommand(String node, String path, boolean isRecurse, String perm) {
        this(node, path, isRecurse, false, perm);
    }

    public DirCreateCommand(String node, String path, boolean isRecurse, boolean useMode, String perm) {
        this.destNode = node;
        this.destFile = path;
        this.recurseFlag = isRecurse;
        this.modeFlag = useMode;
        this.permissions = perm;
    }

    @Override
    public boolean execute() {
        Trace.out("In DirCreateCommand.execute, recurseFlag=" + this.recurseFlag + ", modeFlag=" + this.modeFlag);
        try {
            String result = null;
            result = this.permissions != null ? this.nativeSystem.createDirWithPermissions(this.destNode, this.destFile, this.permissions) : (!this.recurseFlag ? (this.modeFlag ? this.nativeSystem.createDirWithMode(this.destNode, this.destFile) : this.nativeSystem.createDir(this.destNode, this.destFile)) : (this.modeFlag ? this.nativeSystem.createDirWithModeRecurse(this.destNode, this.destFile) : this.nativeSystem.createDirRecurse(this.destNode, this.destFile)));
            this.getStatusLogger().log((Command)this, result);
            this.commandResult = new CommandResult(result);
            this.commandResult.setNodeName(this.destNode);
        }
        catch (Exception e) {
            Trace.out("DirCreateCommand.execute got Exception calling native system:" + e);
            this.commandResult = new CommandResult("0|" + e.getMessage());
            this.commandResult.setNodeName(this.destNode);
            this.commandResult.setException(e);
        }
        return this.commandResult.getStatus();
    }
}

