/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.file;

import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.file.FileCommand;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;

public class CopyCommand
extends FileCommand {
    private String temp1;
    private String temp2;
    private boolean m_noPreserve = false;
    private String m_sourceDirPathname;
    private String m_destDirPathname;
    private String m_fileNamesToCopy;
    private String m_errorString;

    public CopyCommand(String sourceDirPathname, String destDirPathname, String fileNamesToCopy, boolean noPreserve) {
        this.m_sourceDirPathname = sourceDirPathname;
        this.m_destDirPathname = destDirPathname;
        this.m_fileNamesToCopy = fileNamesToCopy;
        this.m_noPreserve = noPreserve;
        this.m_errorString = null;
    }

    public CopyCommand(String node1, String file1, String node2, String file2) {
        this.sourceNode = node1;
        this.sourceFile = file1;
        this.destNode = node2;
        this.destFile = file2;
        this.m_fileNamesToCopy = null;
        this.m_noPreserve = false;
    }

    public CopyCommand(String node1, String file1, String node2, String file2, boolean noPreserve) {
        this.sourceNode = node1;
        this.sourceFile = file1;
        this.destNode = node2;
        this.destFile = file2;
        this.m_fileNamesToCopy = null;
        this.m_noPreserve = noPreserve;
    }

    @Override
    public boolean execute() {
        String ret = null;
        try {
            ret = this.m_fileNamesToCopy != null ? this.nativeSystem.copyFilesLocally(this.m_fileNamesToCopy, this.m_sourceDirPathname, this.m_destDirPathname, !this.m_noPreserve) : this.nativeSystem.copyFile(this.sourceNode, this.sourceFile, this.destNode, this.destFile, this.m_noPreserve);
            this.getStatusLogger().log((Command)this, ret);
        }
        catch (Exception e) {
            Trace.out("CopyCommand.execute:Exception occured while calling native system. Details:\n" + e.getMessage());
            this.m_errorString = MessageBundle.getMessageBundle("Prkc").getMessage("1004", true) + ": " + e.getMessage();
            return false;
        }
        Trace.out("CopyCommand.execute: native copyFile returns `" + ret + "'");
        this.commandResult = new CommandResult(ret);
        if (this.commandResult == null) {
            return false;
        }
        if (this.commandResult.getStatus()) {
            this.m_errorString = this.commandResult.getErrorString();
            Trace.out("The copy command failed. Details:\n" + this.m_errorString);
        }
        return this.commandResult.getStatus();
    }

    public String getError() {
        return this.m_errorString;
    }

    @Override
    protected boolean prepare() {
        Trace.out("In the prepare phase of copy");
        this.temp1 = this.destFile + ".tmp1" + this.getOwnerThread().getName();
        this.temp2 = this.sourceFile + ".tmp2" + this.getOwnerThread().getName();
        String ret = null;
        ret = this.nativeSystem.moveFile(this.destNode, this.destFile, this.temp1);
        this.getStatusLogger().log((Command)this, "Prepare Phase: Copying file " + this.sourceNode + ": " + this.sourceFile + " " + this.destNode + ": " + this.temp2);
        String ret1 = null;
        try {
            ret1 = this.nativeSystem.copyFile(this.sourceNode, this.sourceFile, this.destNode, this.temp2, this.m_noPreserve);
        }
        catch (Exception e) {
            Trace.out("CopyCommand.prepare: Exception while calling copy");
            return false;
        }
        this.getStatusLogger().log((Command)this, ret1);
        this.commandResult = new CommandResult(ret);
        if (this.commandResult == null) {
            return false;
        }
        return this.commandResult.getStatus();
    }

    @Override
    protected boolean commit() {
        String ret = null;
        try {
            Trace.out("CopyCommand.commit:Trying to move file");
            ret = this.nativeSystem.moveFile(this.destNode, this.temp2, this.destFile);
        }
        catch (Exception e) {
            Trace.out("CopyCommand.commit:Execption in moving file in Commit Phase");
            return false;
        }
        this.getStatusLogger().log((Command)this, ret);
        this.commandResult = new CommandResult(ret);
        if (!this.commandResult.getStatus()) {
            Trace.out("Commit Failed..sending false");
            return false;
        }
        String ret1 = null;
        try {
            ret1 = this.nativeSystem.removeFile(this.destNode, this.temp1);
            this.getStatusLogger().log((Command)this, ret1);
        }
        catch (Exception e) {
            Trace.out("CopyCommand.commit: Exception in removing file");
            return false;
        }
        Trace.out("Successfully finished commit");
        this.commandResult = new CommandResult(ret1);
        if (this.commandResult == null) {
            return false;
        }
        return this.commandResult.getStatus();
    }

    @Override
    protected boolean abort() {
        Trace.out("Abort phase of copy");
        try {
            this.getStatusLogger().log((Command)this, this.nativeSystem.moveFile(this.destNode, this.temp1, this.destFile));
            this.getStatusLogger().log((Command)this, this.nativeSystem.removeFile(this.destNode, this.temp2));
        }
        catch (Exception e) {
            Trace.out("CopyCommand.abort: Exception occurred in abort");
            return false;
        }
        Trace.out("Returning true in Abort");
        return true;
    }
}

