/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.file;

import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.file.FileCommand;
import oracle.ops.mgmt.trace.Trace;

public class ChangeFilePermissionsCommand
extends FileCommand {
    String permissions = null;
    String listPaths = null;

    public ChangeFilePermissionsCommand(String node, String paths, String perm) {
        this.destNode = node;
        this.listPaths = paths;
        this.permissions = perm;
    }

    @Override
    public boolean execute() {
        Trace.out("In ChangeFileCommand.execute ");
        try {
            String result = null;
            result = this.nativeSystem.changeModePermissions(this.destNode, this.listPaths, this.permissions);
            this.getStatusLogger().log((Command)this, result);
            this.commandResult = new CommandResult(result);
            this.commandResult.setNodeName(this.destNode);
        }
        catch (Exception e) {
            Trace.out("ChangeFilePermissionsCommand.execute got Exception calling native system:" + e);
            this.commandResult = new CommandResult(e.getMessage());
            this.commandResult.setNodeName(this.destNode);
            this.commandResult.setException(e);
        }
        return this.commandResult.getStatus();
    }
}

